import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleFirebaseWebAppConfigAConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/d/google_firebase_web_app_config#id DataGoogleFirebaseWebAppConfigA#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The project id of the Firebase web App.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/d/google_firebase_web_app_config#project DataGoogleFirebaseWebAppConfigA#project}
    */
    readonly project?: string;
    /**
    * The id of the Firebase web App.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/d/google_firebase_web_app_config#web_app_id DataGoogleFirebaseWebAppConfigA#web_app_id}
    */
    readonly webAppId: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google-beta/d/google_firebase_web_app_config google_firebase_web_app_config}
*/
export declare class DataGoogleFirebaseWebAppConfigA extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "google_firebase_web_app_config";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google-beta/d/google_firebase_web_app_config google_firebase_web_app_config} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataGoogleFirebaseWebAppConfigAConfig
    */
    constructor(scope: Construct, id: string, config: DataGoogleFirebaseWebAppConfigAConfig);
    get apiKey(): string;
    get authDomain(): string;
    get databaseUrl(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get locationId(): string;
    get measurementId(): string;
    get messagingSenderId(): string;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    get storageBucket(): string;
    private _webAppId?;
    get webAppId(): string;
    set webAppId(value: string);
    get webAppIdInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
