import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleGameServicesGameServerDeploymentRolloutConfig extends cdktf.TerraformMetaArguments {
    /**
    * The deployment to rollout the new config to. Only 1 rollout must be associated with each deployment.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/d/google_game_services_game_server_deployment_rollout#deployment_id DataGoogleGameServicesGameServerDeploymentRollout#deployment_id}
    */
    readonly deploymentId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/d/google_game_services_game_server_deployment_rollout#id DataGoogleGameServicesGameServerDeploymentRollout#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
}
export interface DataGoogleGameServicesGameServerDeploymentRolloutGameServerConfigOverridesRealmsSelector {
}
export declare function dataGoogleGameServicesGameServerDeploymentRolloutGameServerConfigOverridesRealmsSelectorToTerraform(struct?: DataGoogleGameServicesGameServerDeploymentRolloutGameServerConfigOverridesRealmsSelector): any;
export declare class DataGoogleGameServicesGameServerDeploymentRolloutGameServerConfigOverridesRealmsSelectorOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleGameServicesGameServerDeploymentRolloutGameServerConfigOverridesRealmsSelector | undefined;
    set internalValue(value: DataGoogleGameServicesGameServerDeploymentRolloutGameServerConfigOverridesRealmsSelector | undefined);
    get realms(): string[];
}
export declare class DataGoogleGameServicesGameServerDeploymentRolloutGameServerConfigOverridesRealmsSelectorList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleGameServicesGameServerDeploymentRolloutGameServerConfigOverridesRealmsSelectorOutputReference;
}
export interface DataGoogleGameServicesGameServerDeploymentRolloutGameServerConfigOverrides {
}
export declare function dataGoogleGameServicesGameServerDeploymentRolloutGameServerConfigOverridesToTerraform(struct?: DataGoogleGameServicesGameServerDeploymentRolloutGameServerConfigOverrides): any;
export declare class DataGoogleGameServicesGameServerDeploymentRolloutGameServerConfigOverridesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleGameServicesGameServerDeploymentRolloutGameServerConfigOverrides | undefined;
    set internalValue(value: DataGoogleGameServicesGameServerDeploymentRolloutGameServerConfigOverrides | undefined);
    get configVersion(): string;
    private _realmsSelector;
    get realmsSelector(): DataGoogleGameServicesGameServerDeploymentRolloutGameServerConfigOverridesRealmsSelectorList;
}
export declare class DataGoogleGameServicesGameServerDeploymentRolloutGameServerConfigOverridesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleGameServicesGameServerDeploymentRolloutGameServerConfigOverridesOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google-beta/d/google_game_services_game_server_deployment_rollout google_game_services_game_server_deployment_rollout}
*/
export declare class DataGoogleGameServicesGameServerDeploymentRollout extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "google_game_services_game_server_deployment_rollout";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google-beta/d/google_game_services_game_server_deployment_rollout google_game_services_game_server_deployment_rollout} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataGoogleGameServicesGameServerDeploymentRolloutConfig
    */
    constructor(scope: Construct, id: string, config: DataGoogleGameServicesGameServerDeploymentRolloutConfig);
    get defaultGameServerConfig(): string;
    private _deploymentId?;
    get deploymentId(): string;
    set deploymentId(value: string);
    get deploymentIdInput(): string | undefined;
    private _gameServerConfigOverrides;
    get gameServerConfigOverrides(): DataGoogleGameServicesGameServerDeploymentRolloutGameServerConfigOverridesList;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get name(): string;
    get project(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
