import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleKmsKeyRingConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/d/google_kms_key_ring#id DataGoogleKmsKeyRing#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The location for the KeyRing.
  A full list of valid locations can be found by running 'gcloud kms locations list'.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/d/google_kms_key_ring#location DataGoogleKmsKeyRing#location}
    */
    readonly location: string;
    /**
    * The resource name for the KeyRing.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/d/google_kms_key_ring#name DataGoogleKmsKeyRing#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/d/google_kms_key_ring#project DataGoogleKmsKeyRing#project}
    */
    readonly project?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google-beta/d/google_kms_key_ring google_kms_key_ring}
*/
export declare class DataGoogleKmsKeyRing extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "google_kms_key_ring";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google-beta/d/google_kms_key_ring google_kms_key_ring} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataGoogleKmsKeyRingConfig
    */
    constructor(scope: Construct, id: string, config: DataGoogleKmsKeyRingConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
