import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleKmsSecretConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/d/google_kms_secret#additional_authenticated_data DataGoogleKmsSecret#additional_authenticated_data}
    */
    readonly additionalAuthenticatedData?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/d/google_kms_secret#ciphertext DataGoogleKmsSecret#ciphertext}
    */
    readonly ciphertext: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/d/google_kms_secret#crypto_key DataGoogleKmsSecret#crypto_key}
    */
    readonly cryptoKey: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/d/google_kms_secret#id DataGoogleKmsSecret#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google-beta/d/google_kms_secret google_kms_secret}
*/
export declare class DataGoogleKmsSecret extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "google_kms_secret";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google-beta/d/google_kms_secret google_kms_secret} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataGoogleKmsSecretConfig
    */
    constructor(scope: Construct, id: string, config: DataGoogleKmsSecretConfig);
    private _additionalAuthenticatedData?;
    get additionalAuthenticatedData(): string;
    set additionalAuthenticatedData(value: string);
    resetAdditionalAuthenticatedData(): void;
    get additionalAuthenticatedDataInput(): string | undefined;
    private _ciphertext?;
    get ciphertext(): string;
    set ciphertext(value: string);
    get ciphertextInput(): string | undefined;
    private _cryptoKey?;
    get cryptoKey(): string;
    set cryptoKey(value: string);
    get cryptoKeyInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get plaintext(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
