import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleServiceAccountConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/d/google_service_account#account_id DataGoogleServiceAccount#account_id}
    */
    readonly accountId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/d/google_service_account#id DataGoogleServiceAccount#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/d/google_service_account#project DataGoogleServiceAccount#project}
    */
    readonly project?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google-beta/d/google_service_account google_service_account}
*/
export declare class DataGoogleServiceAccount extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "google_service_account";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google-beta/d/google_service_account google_service_account} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataGoogleServiceAccountConfig
    */
    constructor(scope: Construct, id: string, config: DataGoogleServiceAccountConfig);
    private _accountId?;
    get accountId(): string;
    set accountId(value: string);
    get accountIdInput(): string | undefined;
    get displayName(): string;
    get email(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get name(): string;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    get uniqueId(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
