import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleSqlCaCertsConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/d/google_sql_ca_certs#id DataGoogleSqlCaCerts#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/d/google_sql_ca_certs#instance DataGoogleSqlCaCerts#instance}
    */
    readonly instance: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/d/google_sql_ca_certs#project DataGoogleSqlCaCerts#project}
    */
    readonly project?: string;
}
export interface DataGoogleSqlCaCertsCerts {
}
export declare function dataGoogleSqlCaCertsCertsToTerraform(struct?: DataGoogleSqlCaCertsCerts): any;
export declare class DataGoogleSqlCaCertsCertsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleSqlCaCertsCerts | undefined;
    set internalValue(value: DataGoogleSqlCaCertsCerts | undefined);
    get cert(): string;
    get commonName(): string;
    get createTime(): string;
    get expirationTime(): string;
    get sha1Fingerprint(): string;
}
export declare class DataGoogleSqlCaCertsCertsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleSqlCaCertsCertsOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google-beta/d/google_sql_ca_certs google_sql_ca_certs}
*/
export declare class DataGoogleSqlCaCerts extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "google_sql_ca_certs";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google-beta/d/google_sql_ca_certs google_sql_ca_certs} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataGoogleSqlCaCertsConfig
    */
    constructor(scope: Construct, id: string, config: DataGoogleSqlCaCertsConfig);
    get activeVersion(): string;
    private _certs;
    get certs(): DataGoogleSqlCaCertsCertsList;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _instance?;
    get instance(): string;
    set instance(value: string);
    get instanceInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
