import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleStorageObjectSignedUrlConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/d/google_storage_object_signed_url#bucket DataGoogleStorageObjectSignedUrl#bucket}
    */
    readonly bucket: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/d/google_storage_object_signed_url#content_md5 DataGoogleStorageObjectSignedUrl#content_md5}
    */
    readonly contentMd5?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/d/google_storage_object_signed_url#content_type DataGoogleStorageObjectSignedUrl#content_type}
    */
    readonly contentType?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/d/google_storage_object_signed_url#credentials DataGoogleStorageObjectSignedUrl#credentials}
    */
    readonly credentials?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/d/google_storage_object_signed_url#duration DataGoogleStorageObjectSignedUrl#duration}
    */
    readonly duration?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/d/google_storage_object_signed_url#extension_headers DataGoogleStorageObjectSignedUrl#extension_headers}
    */
    readonly extensionHeaders?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/d/google_storage_object_signed_url#http_method DataGoogleStorageObjectSignedUrl#http_method}
    */
    readonly httpMethod?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/d/google_storage_object_signed_url#id DataGoogleStorageObjectSignedUrl#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/d/google_storage_object_signed_url#path DataGoogleStorageObjectSignedUrl#path}
    */
    readonly path: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google-beta/d/google_storage_object_signed_url google_storage_object_signed_url}
*/
export declare class DataGoogleStorageObjectSignedUrl extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "google_storage_object_signed_url";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google-beta/d/google_storage_object_signed_url google_storage_object_signed_url} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataGoogleStorageObjectSignedUrlConfig
    */
    constructor(scope: Construct, id: string, config: DataGoogleStorageObjectSignedUrlConfig);
    private _bucket?;
    get bucket(): string;
    set bucket(value: string);
    get bucketInput(): string | undefined;
    private _contentMd5?;
    get contentMd5(): string;
    set contentMd5(value: string);
    resetContentMd5(): void;
    get contentMd5Input(): string | undefined;
    private _contentType?;
    get contentType(): string;
    set contentType(value: string);
    resetContentType(): void;
    get contentTypeInput(): string | undefined;
    private _credentials?;
    get credentials(): string;
    set credentials(value: string);
    resetCredentials(): void;
    get credentialsInput(): string | undefined;
    private _duration?;
    get duration(): string;
    set duration(value: string);
    resetDuration(): void;
    get durationInput(): string | undefined;
    private _extensionHeaders?;
    get extensionHeaders(): {
        [key: string]: string;
    };
    set extensionHeaders(value: {
        [key: string]: string;
    });
    resetExtensionHeaders(): void;
    get extensionHeadersInput(): {
        [key: string]: string;
    } | undefined;
    private _httpMethod?;
    get httpMethod(): string;
    set httpMethod(value: string);
    resetHttpMethod(): void;
    get httpMethodInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    get pathInput(): string | undefined;
    get signedUrl(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
