import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleAccessContextManagerAccessLevelConditionConfig extends cdktf.TerraformMetaArguments {
    /**
    * The name of the Access Level to add this condition to.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_access_context_manager_access_level_condition#access_level GoogleAccessContextManagerAccessLevelCondition#access_level}
    */
    readonly accessLevel: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_access_context_manager_access_level_condition#id GoogleAccessContextManagerAccessLevelCondition#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * A list of CIDR block IP subnetwork specification. May be IPv4
  or IPv6.
  Note that for a CIDR IP address block, the specified IP address
  portion must be properly truncated (i.e. all the host bits must
  be zero) or the input is considered malformed. For example,
  "192.0.2.0/24" is accepted but "192.0.2.1/24" is not. Similarly,
  for IPv6, "2001:db8::/32" is accepted whereas "2001:db8::1/32"
  is not. The originating IP of a request must be in one of the
  listed subnets in order for this Condition to be true.
  If empty, all IP addresses are allowed.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_access_context_manager_access_level_condition#ip_subnetworks GoogleAccessContextManagerAccessLevelCondition#ip_subnetworks}
    */
    readonly ipSubnetworks?: string[];
    /**
    * An allowed list of members (users, service accounts).
  Using groups is not supported yet.
  
  The signed-in user originating the request must be a part of one
  of the provided members. If not specified, a request may come
  from any user (logged in/not logged in, not present in any
  groups, etc.).
  Formats: 'user:{emailid}', 'serviceAccount:{emailid}'
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_access_context_manager_access_level_condition#members GoogleAccessContextManagerAccessLevelCondition#members}
    */
    readonly members?: string[];
    /**
    * Whether to negate the Condition. If true, the Condition becomes
  a NAND over its non-empty fields, each field must be false for
  the Condition overall to be satisfied. Defaults to false.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_access_context_manager_access_level_condition#negate GoogleAccessContextManagerAccessLevelCondition#negate}
    */
    readonly negate?: boolean | cdktf.IResolvable;
    /**
    * The request must originate from one of the provided
  countries/regions.
  Format: A valid ISO 3166-1 alpha-2 code.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_access_context_manager_access_level_condition#regions GoogleAccessContextManagerAccessLevelCondition#regions}
    */
    readonly regions?: string[];
    /**
    * A list of other access levels defined in the same Policy,
  referenced by resource name. Referencing an AccessLevel which
  does not exist is an error. All access levels listed must be
  granted for the Condition to be true.
  Format: accessPolicies/{policy_id}/accessLevels/{short_name}
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_access_context_manager_access_level_condition#required_access_levels GoogleAccessContextManagerAccessLevelCondition#required_access_levels}
    */
    readonly requiredAccessLevels?: string[];
    /**
    * device_policy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_access_context_manager_access_level_condition#device_policy GoogleAccessContextManagerAccessLevelCondition#device_policy}
    */
    readonly devicePolicy?: GoogleAccessContextManagerAccessLevelConditionDevicePolicy;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_access_context_manager_access_level_condition#timeouts GoogleAccessContextManagerAccessLevelCondition#timeouts}
    */
    readonly timeouts?: GoogleAccessContextManagerAccessLevelConditionTimeouts;
}
export interface GoogleAccessContextManagerAccessLevelConditionDevicePolicyOsConstraints {
    /**
    * The minimum allowed OS version. If not set, any version
  of this OS satisfies the constraint.
  Format: "major.minor.patch" such as "10.5.301", "9.2.1".
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_access_context_manager_access_level_condition#minimum_version GoogleAccessContextManagerAccessLevelCondition#minimum_version}
    */
    readonly minimumVersion?: string;
    /**
    * The operating system type of the device. Possible values: ["OS_UNSPECIFIED", "DESKTOP_MAC", "DESKTOP_WINDOWS", "DESKTOP_LINUX", "DESKTOP_CHROME_OS", "ANDROID", "IOS"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_access_context_manager_access_level_condition#os_type GoogleAccessContextManagerAccessLevelCondition#os_type}
    */
    readonly osType: string;
}
export declare function googleAccessContextManagerAccessLevelConditionDevicePolicyOsConstraintsToTerraform(struct?: GoogleAccessContextManagerAccessLevelConditionDevicePolicyOsConstraints | cdktf.IResolvable): any;
export declare class GoogleAccessContextManagerAccessLevelConditionDevicePolicyOsConstraintsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleAccessContextManagerAccessLevelConditionDevicePolicyOsConstraints | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleAccessContextManagerAccessLevelConditionDevicePolicyOsConstraints | cdktf.IResolvable | undefined);
    private _minimumVersion?;
    get minimumVersion(): string;
    set minimumVersion(value: string);
    resetMinimumVersion(): void;
    get minimumVersionInput(): string | undefined;
    private _osType?;
    get osType(): string;
    set osType(value: string);
    get osTypeInput(): string | undefined;
}
export declare class GoogleAccessContextManagerAccessLevelConditionDevicePolicyOsConstraintsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleAccessContextManagerAccessLevelConditionDevicePolicyOsConstraints[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleAccessContextManagerAccessLevelConditionDevicePolicyOsConstraintsOutputReference;
}
export interface GoogleAccessContextManagerAccessLevelConditionDevicePolicy {
    /**
    * A list of allowed device management levels.
  An empty list allows all management levels. Possible values: ["MANAGEMENT_UNSPECIFIED", "NONE", "BASIC", "COMPLETE"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_access_context_manager_access_level_condition#allowed_device_management_levels GoogleAccessContextManagerAccessLevelCondition#allowed_device_management_levels}
    */
    readonly allowedDeviceManagementLevels?: string[];
    /**
    * A list of allowed encryptions statuses.
  An empty list allows all statuses. Possible values: ["ENCRYPTION_UNSPECIFIED", "ENCRYPTION_UNSUPPORTED", "UNENCRYPTED", "ENCRYPTED"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_access_context_manager_access_level_condition#allowed_encryption_statuses GoogleAccessContextManagerAccessLevelCondition#allowed_encryption_statuses}
    */
    readonly allowedEncryptionStatuses?: string[];
    /**
    * Whether the device needs to be approved by the customer admin.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_access_context_manager_access_level_condition#require_admin_approval GoogleAccessContextManagerAccessLevelCondition#require_admin_approval}
    */
    readonly requireAdminApproval?: boolean | cdktf.IResolvable;
    /**
    * Whether the device needs to be corp owned.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_access_context_manager_access_level_condition#require_corp_owned GoogleAccessContextManagerAccessLevelCondition#require_corp_owned}
    */
    readonly requireCorpOwned?: boolean | cdktf.IResolvable;
    /**
    * Whether or not screenlock is required for the DevicePolicy
  to be true. Defaults to false.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_access_context_manager_access_level_condition#require_screen_lock GoogleAccessContextManagerAccessLevelCondition#require_screen_lock}
    */
    readonly requireScreenLock?: boolean | cdktf.IResolvable;
    /**
    * os_constraints block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_access_context_manager_access_level_condition#os_constraints GoogleAccessContextManagerAccessLevelCondition#os_constraints}
    */
    readonly osConstraints?: GoogleAccessContextManagerAccessLevelConditionDevicePolicyOsConstraints[] | cdktf.IResolvable;
}
export declare function googleAccessContextManagerAccessLevelConditionDevicePolicyToTerraform(struct?: GoogleAccessContextManagerAccessLevelConditionDevicePolicyOutputReference | GoogleAccessContextManagerAccessLevelConditionDevicePolicy): any;
export declare class GoogleAccessContextManagerAccessLevelConditionDevicePolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleAccessContextManagerAccessLevelConditionDevicePolicy | undefined;
    set internalValue(value: GoogleAccessContextManagerAccessLevelConditionDevicePolicy | undefined);
    private _allowedDeviceManagementLevels?;
    get allowedDeviceManagementLevels(): string[];
    set allowedDeviceManagementLevels(value: string[]);
    resetAllowedDeviceManagementLevels(): void;
    get allowedDeviceManagementLevelsInput(): string[] | undefined;
    private _allowedEncryptionStatuses?;
    get allowedEncryptionStatuses(): string[];
    set allowedEncryptionStatuses(value: string[]);
    resetAllowedEncryptionStatuses(): void;
    get allowedEncryptionStatusesInput(): string[] | undefined;
    private _requireAdminApproval?;
    get requireAdminApproval(): boolean | cdktf.IResolvable;
    set requireAdminApproval(value: boolean | cdktf.IResolvable);
    resetRequireAdminApproval(): void;
    get requireAdminApprovalInput(): boolean | cdktf.IResolvable | undefined;
    private _requireCorpOwned?;
    get requireCorpOwned(): boolean | cdktf.IResolvable;
    set requireCorpOwned(value: boolean | cdktf.IResolvable);
    resetRequireCorpOwned(): void;
    get requireCorpOwnedInput(): boolean | cdktf.IResolvable | undefined;
    private _requireScreenLock?;
    get requireScreenLock(): boolean | cdktf.IResolvable;
    set requireScreenLock(value: boolean | cdktf.IResolvable);
    resetRequireScreenLock(): void;
    get requireScreenLockInput(): boolean | cdktf.IResolvable | undefined;
    private _osConstraints;
    get osConstraints(): GoogleAccessContextManagerAccessLevelConditionDevicePolicyOsConstraintsList;
    putOsConstraints(value: GoogleAccessContextManagerAccessLevelConditionDevicePolicyOsConstraints[] | cdktf.IResolvable): void;
    resetOsConstraints(): void;
    get osConstraintsInput(): cdktf.IResolvable | GoogleAccessContextManagerAccessLevelConditionDevicePolicyOsConstraints[] | undefined;
}
export interface GoogleAccessContextManagerAccessLevelConditionTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_access_context_manager_access_level_condition#create GoogleAccessContextManagerAccessLevelCondition#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_access_context_manager_access_level_condition#delete GoogleAccessContextManagerAccessLevelCondition#delete}
    */
    readonly delete?: string;
}
export declare function googleAccessContextManagerAccessLevelConditionTimeoutsToTerraform(struct?: GoogleAccessContextManagerAccessLevelConditionTimeoutsOutputReference | GoogleAccessContextManagerAccessLevelConditionTimeouts | cdktf.IResolvable): any;
export declare class GoogleAccessContextManagerAccessLevelConditionTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleAccessContextManagerAccessLevelConditionTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleAccessContextManagerAccessLevelConditionTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google-beta/r/google_access_context_manager_access_level_condition google_access_context_manager_access_level_condition}
*/
export declare class GoogleAccessContextManagerAccessLevelCondition extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_access_context_manager_access_level_condition";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google-beta/r/google_access_context_manager_access_level_condition google_access_context_manager_access_level_condition} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleAccessContextManagerAccessLevelConditionConfig
    */
    constructor(scope: Construct, id: string, config: GoogleAccessContextManagerAccessLevelConditionConfig);
    private _accessLevel?;
    get accessLevel(): string;
    set accessLevel(value: string);
    get accessLevelInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _ipSubnetworks?;
    get ipSubnetworks(): string[];
    set ipSubnetworks(value: string[]);
    resetIpSubnetworks(): void;
    get ipSubnetworksInput(): string[] | undefined;
    private _members?;
    get members(): string[];
    set members(value: string[]);
    resetMembers(): void;
    get membersInput(): string[] | undefined;
    private _negate?;
    get negate(): boolean | cdktf.IResolvable;
    set negate(value: boolean | cdktf.IResolvable);
    resetNegate(): void;
    get negateInput(): boolean | cdktf.IResolvable | undefined;
    private _regions?;
    get regions(): string[];
    set regions(value: string[]);
    resetRegions(): void;
    get regionsInput(): string[] | undefined;
    private _requiredAccessLevels?;
    get requiredAccessLevels(): string[];
    set requiredAccessLevels(value: string[]);
    resetRequiredAccessLevels(): void;
    get requiredAccessLevelsInput(): string[] | undefined;
    private _devicePolicy;
    get devicePolicy(): GoogleAccessContextManagerAccessLevelConditionDevicePolicyOutputReference;
    putDevicePolicy(value: GoogleAccessContextManagerAccessLevelConditionDevicePolicy): void;
    resetDevicePolicy(): void;
    get devicePolicyInput(): GoogleAccessContextManagerAccessLevelConditionDevicePolicy | undefined;
    private _timeouts;
    get timeouts(): GoogleAccessContextManagerAccessLevelConditionTimeoutsOutputReference;
    putTimeouts(value: GoogleAccessContextManagerAccessLevelConditionTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleAccessContextManagerAccessLevelConditionTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
