import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleAccessContextManagerAccessLevelsConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_access_context_manager_access_levels#id GoogleAccessContextManagerAccessLevels#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The AccessPolicy this AccessLevel lives in.
  Format: accessPolicies/{policy_id}
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_access_context_manager_access_levels#parent GoogleAccessContextManagerAccessLevels#parent}
    */
    readonly parent: string;
    /**
    * access_levels block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_access_context_manager_access_levels#access_levels GoogleAccessContextManagerAccessLevels#access_levels}
    */
    readonly accessLevels?: GoogleAccessContextManagerAccessLevelsAccessLevels[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_access_context_manager_access_levels#timeouts GoogleAccessContextManagerAccessLevels#timeouts}
    */
    readonly timeouts?: GoogleAccessContextManagerAccessLevelsTimeouts;
}
export interface GoogleAccessContextManagerAccessLevelsAccessLevelsBasicConditionsDevicePolicyOsConstraints {
    /**
    * The minimum allowed OS version. If not set, any version
  of this OS satisfies the constraint.
  Format: "major.minor.patch" such as "10.5.301", "9.2.1".
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_access_context_manager_access_levels#minimum_version GoogleAccessContextManagerAccessLevels#minimum_version}
    */
    readonly minimumVersion?: string;
    /**
    * The operating system type of the device. Possible values: ["OS_UNSPECIFIED", "DESKTOP_MAC", "DESKTOP_WINDOWS", "DESKTOP_LINUX", "DESKTOP_CHROME_OS", "ANDROID", "IOS"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_access_context_manager_access_levels#os_type GoogleAccessContextManagerAccessLevels#os_type}
    */
    readonly osType: string;
}
export declare function googleAccessContextManagerAccessLevelsAccessLevelsBasicConditionsDevicePolicyOsConstraintsToTerraform(struct?: GoogleAccessContextManagerAccessLevelsAccessLevelsBasicConditionsDevicePolicyOsConstraints | cdktf.IResolvable): any;
export declare class GoogleAccessContextManagerAccessLevelsAccessLevelsBasicConditionsDevicePolicyOsConstraintsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleAccessContextManagerAccessLevelsAccessLevelsBasicConditionsDevicePolicyOsConstraints | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleAccessContextManagerAccessLevelsAccessLevelsBasicConditionsDevicePolicyOsConstraints | cdktf.IResolvable | undefined);
    private _minimumVersion?;
    get minimumVersion(): string;
    set minimumVersion(value: string);
    resetMinimumVersion(): void;
    get minimumVersionInput(): string | undefined;
    private _osType?;
    get osType(): string;
    set osType(value: string);
    get osTypeInput(): string | undefined;
}
export declare class GoogleAccessContextManagerAccessLevelsAccessLevelsBasicConditionsDevicePolicyOsConstraintsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleAccessContextManagerAccessLevelsAccessLevelsBasicConditionsDevicePolicyOsConstraints[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleAccessContextManagerAccessLevelsAccessLevelsBasicConditionsDevicePolicyOsConstraintsOutputReference;
}
export interface GoogleAccessContextManagerAccessLevelsAccessLevelsBasicConditionsDevicePolicy {
    /**
    * A list of allowed device management levels.
  An empty list allows all management levels. Possible values: ["MANAGEMENT_UNSPECIFIED", "NONE", "BASIC", "COMPLETE"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_access_context_manager_access_levels#allowed_device_management_levels GoogleAccessContextManagerAccessLevels#allowed_device_management_levels}
    */
    readonly allowedDeviceManagementLevels?: string[];
    /**
    * A list of allowed encryptions statuses.
  An empty list allows all statuses. Possible values: ["ENCRYPTION_UNSPECIFIED", "ENCRYPTION_UNSUPPORTED", "UNENCRYPTED", "ENCRYPTED"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_access_context_manager_access_levels#allowed_encryption_statuses GoogleAccessContextManagerAccessLevels#allowed_encryption_statuses}
    */
    readonly allowedEncryptionStatuses?: string[];
    /**
    * Whether the device needs to be approved by the customer admin.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_access_context_manager_access_levels#require_admin_approval GoogleAccessContextManagerAccessLevels#require_admin_approval}
    */
    readonly requireAdminApproval?: boolean | cdktf.IResolvable;
    /**
    * Whether the device needs to be corp owned.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_access_context_manager_access_levels#require_corp_owned GoogleAccessContextManagerAccessLevels#require_corp_owned}
    */
    readonly requireCorpOwned?: boolean | cdktf.IResolvable;
    /**
    * Whether or not screenlock is required for the DevicePolicy
  to be true. Defaults to false.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_access_context_manager_access_levels#require_screen_lock GoogleAccessContextManagerAccessLevels#require_screen_lock}
    */
    readonly requireScreenLock?: boolean | cdktf.IResolvable;
    /**
    * os_constraints block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_access_context_manager_access_levels#os_constraints GoogleAccessContextManagerAccessLevels#os_constraints}
    */
    readonly osConstraints?: GoogleAccessContextManagerAccessLevelsAccessLevelsBasicConditionsDevicePolicyOsConstraints[] | cdktf.IResolvable;
}
export declare function googleAccessContextManagerAccessLevelsAccessLevelsBasicConditionsDevicePolicyToTerraform(struct?: GoogleAccessContextManagerAccessLevelsAccessLevelsBasicConditionsDevicePolicyOutputReference | GoogleAccessContextManagerAccessLevelsAccessLevelsBasicConditionsDevicePolicy): any;
export declare class GoogleAccessContextManagerAccessLevelsAccessLevelsBasicConditionsDevicePolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleAccessContextManagerAccessLevelsAccessLevelsBasicConditionsDevicePolicy | undefined;
    set internalValue(value: GoogleAccessContextManagerAccessLevelsAccessLevelsBasicConditionsDevicePolicy | undefined);
    private _allowedDeviceManagementLevels?;
    get allowedDeviceManagementLevels(): string[];
    set allowedDeviceManagementLevels(value: string[]);
    resetAllowedDeviceManagementLevels(): void;
    get allowedDeviceManagementLevelsInput(): string[] | undefined;
    private _allowedEncryptionStatuses?;
    get allowedEncryptionStatuses(): string[];
    set allowedEncryptionStatuses(value: string[]);
    resetAllowedEncryptionStatuses(): void;
    get allowedEncryptionStatusesInput(): string[] | undefined;
    private _requireAdminApproval?;
    get requireAdminApproval(): boolean | cdktf.IResolvable;
    set requireAdminApproval(value: boolean | cdktf.IResolvable);
    resetRequireAdminApproval(): void;
    get requireAdminApprovalInput(): boolean | cdktf.IResolvable | undefined;
    private _requireCorpOwned?;
    get requireCorpOwned(): boolean | cdktf.IResolvable;
    set requireCorpOwned(value: boolean | cdktf.IResolvable);
    resetRequireCorpOwned(): void;
    get requireCorpOwnedInput(): boolean | cdktf.IResolvable | undefined;
    private _requireScreenLock?;
    get requireScreenLock(): boolean | cdktf.IResolvable;
    set requireScreenLock(value: boolean | cdktf.IResolvable);
    resetRequireScreenLock(): void;
    get requireScreenLockInput(): boolean | cdktf.IResolvable | undefined;
    private _osConstraints;
    get osConstraints(): GoogleAccessContextManagerAccessLevelsAccessLevelsBasicConditionsDevicePolicyOsConstraintsList;
    putOsConstraints(value: GoogleAccessContextManagerAccessLevelsAccessLevelsBasicConditionsDevicePolicyOsConstraints[] | cdktf.IResolvable): void;
    resetOsConstraints(): void;
    get osConstraintsInput(): cdktf.IResolvable | GoogleAccessContextManagerAccessLevelsAccessLevelsBasicConditionsDevicePolicyOsConstraints[] | undefined;
}
export interface GoogleAccessContextManagerAccessLevelsAccessLevelsBasicConditions {
    /**
    * A list of CIDR block IP subnetwork specification. May be IPv4
  or IPv6.
  Note that for a CIDR IP address block, the specified IP address
  portion must be properly truncated (i.e. all the host bits must
  be zero) or the input is considered malformed. For example,
  "192.0.2.0/24" is accepted but "192.0.2.1/24" is not. Similarly,
  for IPv6, "2001:db8::/32" is accepted whereas "2001:db8::1/32"
  is not. The originating IP of a request must be in one of the
  listed subnets in order for this Condition to be true.
  If empty, all IP addresses are allowed.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_access_context_manager_access_levels#ip_subnetworks GoogleAccessContextManagerAccessLevels#ip_subnetworks}
    */
    readonly ipSubnetworks?: string[];
    /**
    * An allowed list of members (users, service accounts).
  Using groups is not supported yet.
  
  The signed-in user originating the request must be a part of one
  of the provided members. If not specified, a request may come
  from any user (logged in/not logged in, not present in any
  groups, etc.).
  Formats: 'user:{emailid}', 'serviceAccount:{emailid}'
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_access_context_manager_access_levels#members GoogleAccessContextManagerAccessLevels#members}
    */
    readonly members?: string[];
    /**
    * Whether to negate the Condition. If true, the Condition becomes
  a NAND over its non-empty fields, each field must be false for
  the Condition overall to be satisfied. Defaults to false.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_access_context_manager_access_levels#negate GoogleAccessContextManagerAccessLevels#negate}
    */
    readonly negate?: boolean | cdktf.IResolvable;
    /**
    * The request must originate from one of the provided
  countries/regions.
  Format: A valid ISO 3166-1 alpha-2 code.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_access_context_manager_access_levels#regions GoogleAccessContextManagerAccessLevels#regions}
    */
    readonly regions?: string[];
    /**
    * A list of other access levels defined in the same Policy,
  referenced by resource name. Referencing an AccessLevel which
  does not exist is an error. All access levels listed must be
  granted for the Condition to be true.
  Format: accessPolicies/{policy_id}/accessLevels/{short_name}
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_access_context_manager_access_levels#required_access_levels GoogleAccessContextManagerAccessLevels#required_access_levels}
    */
    readonly requiredAccessLevels?: string[];
    /**
    * device_policy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_access_context_manager_access_levels#device_policy GoogleAccessContextManagerAccessLevels#device_policy}
    */
    readonly devicePolicy?: GoogleAccessContextManagerAccessLevelsAccessLevelsBasicConditionsDevicePolicy;
}
export declare function googleAccessContextManagerAccessLevelsAccessLevelsBasicConditionsToTerraform(struct?: GoogleAccessContextManagerAccessLevelsAccessLevelsBasicConditions | cdktf.IResolvable): any;
export declare class GoogleAccessContextManagerAccessLevelsAccessLevelsBasicConditionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleAccessContextManagerAccessLevelsAccessLevelsBasicConditions | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleAccessContextManagerAccessLevelsAccessLevelsBasicConditions | cdktf.IResolvable | undefined);
    private _ipSubnetworks?;
    get ipSubnetworks(): string[];
    set ipSubnetworks(value: string[]);
    resetIpSubnetworks(): void;
    get ipSubnetworksInput(): string[] | undefined;
    private _members?;
    get members(): string[];
    set members(value: string[]);
    resetMembers(): void;
    get membersInput(): string[] | undefined;
    private _negate?;
    get negate(): boolean | cdktf.IResolvable;
    set negate(value: boolean | cdktf.IResolvable);
    resetNegate(): void;
    get negateInput(): boolean | cdktf.IResolvable | undefined;
    private _regions?;
    get regions(): string[];
    set regions(value: string[]);
    resetRegions(): void;
    get regionsInput(): string[] | undefined;
    private _requiredAccessLevels?;
    get requiredAccessLevels(): string[];
    set requiredAccessLevels(value: string[]);
    resetRequiredAccessLevels(): void;
    get requiredAccessLevelsInput(): string[] | undefined;
    private _devicePolicy;
    get devicePolicy(): GoogleAccessContextManagerAccessLevelsAccessLevelsBasicConditionsDevicePolicyOutputReference;
    putDevicePolicy(value: GoogleAccessContextManagerAccessLevelsAccessLevelsBasicConditionsDevicePolicy): void;
    resetDevicePolicy(): void;
    get devicePolicyInput(): GoogleAccessContextManagerAccessLevelsAccessLevelsBasicConditionsDevicePolicy | undefined;
}
export declare class GoogleAccessContextManagerAccessLevelsAccessLevelsBasicConditionsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleAccessContextManagerAccessLevelsAccessLevelsBasicConditions[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleAccessContextManagerAccessLevelsAccessLevelsBasicConditionsOutputReference;
}
export interface GoogleAccessContextManagerAccessLevelsAccessLevelsBasic {
    /**
    * How the conditions list should be combined to determine if a request
  is granted this AccessLevel. If AND is used, each Condition in
  conditions must be satisfied for the AccessLevel to be applied. If
  OR is used, at least one Condition in conditions must be satisfied
  for the AccessLevel to be applied. Default value: "AND" Possible values: ["AND", "OR"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_access_context_manager_access_levels#combining_function GoogleAccessContextManagerAccessLevels#combining_function}
    */
    readonly combiningFunction?: string;
    /**
    * conditions block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_access_context_manager_access_levels#conditions GoogleAccessContextManagerAccessLevels#conditions}
    */
    readonly conditions: GoogleAccessContextManagerAccessLevelsAccessLevelsBasicConditions[] | cdktf.IResolvable;
}
export declare function googleAccessContextManagerAccessLevelsAccessLevelsBasicToTerraform(struct?: GoogleAccessContextManagerAccessLevelsAccessLevelsBasicOutputReference | GoogleAccessContextManagerAccessLevelsAccessLevelsBasic): any;
export declare class GoogleAccessContextManagerAccessLevelsAccessLevelsBasicOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleAccessContextManagerAccessLevelsAccessLevelsBasic | undefined;
    set internalValue(value: GoogleAccessContextManagerAccessLevelsAccessLevelsBasic | undefined);
    private _combiningFunction?;
    get combiningFunction(): string;
    set combiningFunction(value: string);
    resetCombiningFunction(): void;
    get combiningFunctionInput(): string | undefined;
    private _conditions;
    get conditions(): GoogleAccessContextManagerAccessLevelsAccessLevelsBasicConditionsList;
    putConditions(value: GoogleAccessContextManagerAccessLevelsAccessLevelsBasicConditions[] | cdktf.IResolvable): void;
    get conditionsInput(): cdktf.IResolvable | GoogleAccessContextManagerAccessLevelsAccessLevelsBasicConditions[] | undefined;
}
export interface GoogleAccessContextManagerAccessLevelsAccessLevelsCustomExpr {
    /**
    * Description of the expression
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_access_context_manager_access_levels#description GoogleAccessContextManagerAccessLevels#description}
    */
    readonly description?: string;
    /**
    * Textual representation of an expression in Common Expression Language syntax.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_access_context_manager_access_levels#expression GoogleAccessContextManagerAccessLevels#expression}
    */
    readonly expression: string;
    /**
    * String indicating the location of the expression for error reporting, e.g. a file name and a position in the file
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_access_context_manager_access_levels#location GoogleAccessContextManagerAccessLevels#location}
    */
    readonly location?: string;
    /**
    * Title for the expression, i.e. a short string describing its purpose.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_access_context_manager_access_levels#title GoogleAccessContextManagerAccessLevels#title}
    */
    readonly title?: string;
}
export declare function googleAccessContextManagerAccessLevelsAccessLevelsCustomExprToTerraform(struct?: GoogleAccessContextManagerAccessLevelsAccessLevelsCustomExprOutputReference | GoogleAccessContextManagerAccessLevelsAccessLevelsCustomExpr): any;
export declare class GoogleAccessContextManagerAccessLevelsAccessLevelsCustomExprOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleAccessContextManagerAccessLevelsAccessLevelsCustomExpr | undefined;
    set internalValue(value: GoogleAccessContextManagerAccessLevelsAccessLevelsCustomExpr | undefined);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _expression?;
    get expression(): string;
    set expression(value: string);
    get expressionInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    resetLocation(): void;
    get locationInput(): string | undefined;
    private _title?;
    get title(): string;
    set title(value: string);
    resetTitle(): void;
    get titleInput(): string | undefined;
}
export interface GoogleAccessContextManagerAccessLevelsAccessLevelsCustom {
    /**
    * expr block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_access_context_manager_access_levels#expr GoogleAccessContextManagerAccessLevels#expr}
    */
    readonly expr: GoogleAccessContextManagerAccessLevelsAccessLevelsCustomExpr;
}
export declare function googleAccessContextManagerAccessLevelsAccessLevelsCustomToTerraform(struct?: GoogleAccessContextManagerAccessLevelsAccessLevelsCustomOutputReference | GoogleAccessContextManagerAccessLevelsAccessLevelsCustom): any;
export declare class GoogleAccessContextManagerAccessLevelsAccessLevelsCustomOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleAccessContextManagerAccessLevelsAccessLevelsCustom | undefined;
    set internalValue(value: GoogleAccessContextManagerAccessLevelsAccessLevelsCustom | undefined);
    private _expr;
    get expr(): GoogleAccessContextManagerAccessLevelsAccessLevelsCustomExprOutputReference;
    putExpr(value: GoogleAccessContextManagerAccessLevelsAccessLevelsCustomExpr): void;
    get exprInput(): GoogleAccessContextManagerAccessLevelsAccessLevelsCustomExpr | undefined;
}
export interface GoogleAccessContextManagerAccessLevelsAccessLevels {
    /**
    * Description of the AccessLevel and its use. Does not affect behavior.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_access_context_manager_access_levels#description GoogleAccessContextManagerAccessLevels#description}
    */
    readonly description?: string;
    /**
    * Resource name for the Access Level. The short_name component must begin
  with a letter and only include alphanumeric and '_'.
  Format: accessPolicies/{policy_id}/accessLevels/{short_name}
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_access_context_manager_access_levels#name GoogleAccessContextManagerAccessLevels#name}
    */
    readonly name: string;
    /**
    * Human readable title. Must be unique within the Policy.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_access_context_manager_access_levels#title GoogleAccessContextManagerAccessLevels#title}
    */
    readonly title: string;
    /**
    * basic block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_access_context_manager_access_levels#basic GoogleAccessContextManagerAccessLevels#basic}
    */
    readonly basic?: GoogleAccessContextManagerAccessLevelsAccessLevelsBasic;
    /**
    * custom block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_access_context_manager_access_levels#custom GoogleAccessContextManagerAccessLevels#custom}
    */
    readonly custom?: GoogleAccessContextManagerAccessLevelsAccessLevelsCustom;
}
export declare function googleAccessContextManagerAccessLevelsAccessLevelsToTerraform(struct?: GoogleAccessContextManagerAccessLevelsAccessLevels | cdktf.IResolvable): any;
export declare class GoogleAccessContextManagerAccessLevelsAccessLevelsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleAccessContextManagerAccessLevelsAccessLevels | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleAccessContextManagerAccessLevelsAccessLevels | cdktf.IResolvable | undefined);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _title?;
    get title(): string;
    set title(value: string);
    get titleInput(): string | undefined;
    private _basic;
    get basic(): GoogleAccessContextManagerAccessLevelsAccessLevelsBasicOutputReference;
    putBasic(value: GoogleAccessContextManagerAccessLevelsAccessLevelsBasic): void;
    resetBasic(): void;
    get basicInput(): GoogleAccessContextManagerAccessLevelsAccessLevelsBasic | undefined;
    private _custom;
    get custom(): GoogleAccessContextManagerAccessLevelsAccessLevelsCustomOutputReference;
    putCustom(value: GoogleAccessContextManagerAccessLevelsAccessLevelsCustom): void;
    resetCustom(): void;
    get customInput(): GoogleAccessContextManagerAccessLevelsAccessLevelsCustom | undefined;
}
export declare class GoogleAccessContextManagerAccessLevelsAccessLevelsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleAccessContextManagerAccessLevelsAccessLevels[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleAccessContextManagerAccessLevelsAccessLevelsOutputReference;
}
export interface GoogleAccessContextManagerAccessLevelsTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_access_context_manager_access_levels#create GoogleAccessContextManagerAccessLevels#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_access_context_manager_access_levels#delete GoogleAccessContextManagerAccessLevels#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_access_context_manager_access_levels#update GoogleAccessContextManagerAccessLevels#update}
    */
    readonly update?: string;
}
export declare function googleAccessContextManagerAccessLevelsTimeoutsToTerraform(struct?: GoogleAccessContextManagerAccessLevelsTimeoutsOutputReference | GoogleAccessContextManagerAccessLevelsTimeouts | cdktf.IResolvable): any;
export declare class GoogleAccessContextManagerAccessLevelsTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleAccessContextManagerAccessLevelsTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleAccessContextManagerAccessLevelsTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google-beta/r/google_access_context_manager_access_levels google_access_context_manager_access_levels}
*/
export declare class GoogleAccessContextManagerAccessLevels extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_access_context_manager_access_levels";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google-beta/r/google_access_context_manager_access_levels google_access_context_manager_access_levels} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleAccessContextManagerAccessLevelsConfig
    */
    constructor(scope: Construct, id: string, config: GoogleAccessContextManagerAccessLevelsConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _parent?;
    get parent(): string;
    set parent(value: string);
    get parentInput(): string | undefined;
    private _accessLevels;
    get accessLevels(): GoogleAccessContextManagerAccessLevelsAccessLevelsList;
    putAccessLevels(value: GoogleAccessContextManagerAccessLevelsAccessLevels[] | cdktf.IResolvable): void;
    resetAccessLevels(): void;
    get accessLevelsInput(): cdktf.IResolvable | GoogleAccessContextManagerAccessLevelsAccessLevels[] | undefined;
    private _timeouts;
    get timeouts(): GoogleAccessContextManagerAccessLevelsTimeoutsOutputReference;
    putTimeouts(value: GoogleAccessContextManagerAccessLevelsTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleAccessContextManagerAccessLevelsTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
