import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleAccessContextManagerServicePerimeterResourceConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_access_context_manager_service_perimeter_resource#id GoogleAccessContextManagerServicePerimeterResource#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The name of the Service Perimeter to add this resource to.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_access_context_manager_service_perimeter_resource#perimeter_name GoogleAccessContextManagerServicePerimeterResource#perimeter_name}
    */
    readonly perimeterName: string;
    /**
    * A GCP resource that is inside of the service perimeter.
  Currently only projects are allowed.
  Format: projects/{project_number}
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_access_context_manager_service_perimeter_resource#resource GoogleAccessContextManagerServicePerimeterResource#resource}
    */
    readonly resource: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_access_context_manager_service_perimeter_resource#timeouts GoogleAccessContextManagerServicePerimeterResource#timeouts}
    */
    readonly timeouts?: GoogleAccessContextManagerServicePerimeterResourceTimeouts;
}
export interface GoogleAccessContextManagerServicePerimeterResourceTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_access_context_manager_service_perimeter_resource#create GoogleAccessContextManagerServicePerimeterResource#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_access_context_manager_service_perimeter_resource#delete GoogleAccessContextManagerServicePerimeterResource#delete}
    */
    readonly delete?: string;
}
export declare function googleAccessContextManagerServicePerimeterResourceTimeoutsToTerraform(struct?: GoogleAccessContextManagerServicePerimeterResourceTimeoutsOutputReference | GoogleAccessContextManagerServicePerimeterResourceTimeouts | cdktf.IResolvable): any;
export declare class GoogleAccessContextManagerServicePerimeterResourceTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleAccessContextManagerServicePerimeterResourceTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleAccessContextManagerServicePerimeterResourceTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google-beta/r/google_access_context_manager_service_perimeter_resource google_access_context_manager_service_perimeter_resource}
*/
export declare class GoogleAccessContextManagerServicePerimeterResource extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_access_context_manager_service_perimeter_resource";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google-beta/r/google_access_context_manager_service_perimeter_resource google_access_context_manager_service_perimeter_resource} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleAccessContextManagerServicePerimeterResourceConfig
    */
    constructor(scope: Construct, id: string, config: GoogleAccessContextManagerServicePerimeterResourceConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _perimeterName?;
    get perimeterName(): string;
    set perimeterName(value: string);
    get perimeterNameInput(): string | undefined;
    private _resource?;
    get resource(): string;
    set resource(value: string);
    get resourceInput(): string | undefined;
    private _timeouts;
    get timeouts(): GoogleAccessContextManagerServicePerimeterResourceTimeoutsOutputReference;
    putTimeouts(value: GoogleAccessContextManagerServicePerimeterResourceTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleAccessContextManagerServicePerimeterResourceTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
