import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleAccessContextManagerServicePerimeterConfig extends cdktf.TerraformMetaArguments {
    /**
    * Description of the ServicePerimeter and its use. Does not affect
  behavior.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_access_context_manager_service_perimeter#description GoogleAccessContextManagerServicePerimeter#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_access_context_manager_service_perimeter#id GoogleAccessContextManagerServicePerimeter#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Resource name for the ServicePerimeter. The short_name component must
  begin with a letter and only include alphanumeric and '_'.
  Format: accessPolicies/{policy_id}/servicePerimeters/{short_name}
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_access_context_manager_service_perimeter#name GoogleAccessContextManagerServicePerimeter#name}
    */
    readonly name: string;
    /**
    * The AccessPolicy this ServicePerimeter lives in.
  Format: accessPolicies/{policy_id}
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_access_context_manager_service_perimeter#parent GoogleAccessContextManagerServicePerimeter#parent}
    */
    readonly parent: string;
    /**
    * Specifies the type of the Perimeter. There are two types: regular and
  bridge. Regular Service Perimeter contains resources, access levels,
  and restricted services. Every resource can be in at most
  ONE regular Service Perimeter.
  
  In addition to being in a regular service perimeter, a resource can also
  be in zero or more perimeter bridges. A perimeter bridge only contains
  resources. Cross project operations are permitted if all effected
  resources share some perimeter (whether bridge or regular). Perimeter
  Bridge does not contain access levels or services: those are governed
  entirely by the regular perimeter that resource is in.
  
  Perimeter Bridges are typically useful when building more complex
  topologies with many independent perimeters that need to share some data
  with a common perimeter, but should not be able to share data among
  themselves. Default value: "PERIMETER_TYPE_REGULAR" Possible values: ["PERIMETER_TYPE_REGULAR", "PERIMETER_TYPE_BRIDGE"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_access_context_manager_service_perimeter#perimeter_type GoogleAccessContextManagerServicePerimeter#perimeter_type}
    */
    readonly perimeterType?: string;
    /**
    * Human readable title. Must be unique within the Policy.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_access_context_manager_service_perimeter#title GoogleAccessContextManagerServicePerimeter#title}
    */
    readonly title: string;
    /**
    * Use explicit dry run spec flag. Ordinarily, a dry-run spec implicitly exists
  for all Service Perimeters, and that spec is identical to the status for those
  Service Perimeters. When this flag is set, it inhibits the generation of the
  implicit spec, thereby allowing the user to explicitly provide a
  configuration ("spec") to use in a dry-run version of the Service Perimeter.
  This allows the user to test changes to the enforced config ("status") without
  actually enforcing them. This testing is done through analyzing the differences
  between currently enforced and suggested restrictions. useExplicitDryRunSpec must
  bet set to True if any of the fields in the spec are set to non-default values.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_access_context_manager_service_perimeter#use_explicit_dry_run_spec GoogleAccessContextManagerServicePerimeter#use_explicit_dry_run_spec}
    */
    readonly useExplicitDryRunSpec?: boolean | cdktf.IResolvable;
    /**
    * spec block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_access_context_manager_service_perimeter#spec GoogleAccessContextManagerServicePerimeter#spec}
    */
    readonly spec?: GoogleAccessContextManagerServicePerimeterSpec;
    /**
    * status block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_access_context_manager_service_perimeter#status GoogleAccessContextManagerServicePerimeter#status}
    */
    readonly status?: GoogleAccessContextManagerServicePerimeterStatus;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_access_context_manager_service_perimeter#timeouts GoogleAccessContextManagerServicePerimeter#timeouts}
    */
    readonly timeouts?: GoogleAccessContextManagerServicePerimeterTimeouts;
}
export interface GoogleAccessContextManagerServicePerimeterSpecEgressPoliciesEgressFrom {
    /**
    * A list of identities that are allowed access through this 'EgressPolicy'.
  Should be in the format of email address. The email address should
  represent individual user or service account only.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_access_context_manager_service_perimeter#identities GoogleAccessContextManagerServicePerimeter#identities}
    */
    readonly identities?: string[];
    /**
    * Specifies the type of identities that are allowed access to outside the
  perimeter. If left unspecified, then members of 'identities' field will
  be allowed access. Possible values: ["IDENTITY_TYPE_UNSPECIFIED", "ANY_IDENTITY", "ANY_USER_ACCOUNT", "ANY_SERVICE_ACCOUNT"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_access_context_manager_service_perimeter#identity_type GoogleAccessContextManagerServicePerimeter#identity_type}
    */
    readonly identityType?: string;
}
export declare function googleAccessContextManagerServicePerimeterSpecEgressPoliciesEgressFromToTerraform(struct?: GoogleAccessContextManagerServicePerimeterSpecEgressPoliciesEgressFromOutputReference | GoogleAccessContextManagerServicePerimeterSpecEgressPoliciesEgressFrom): any;
export declare class GoogleAccessContextManagerServicePerimeterSpecEgressPoliciesEgressFromOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleAccessContextManagerServicePerimeterSpecEgressPoliciesEgressFrom | undefined;
    set internalValue(value: GoogleAccessContextManagerServicePerimeterSpecEgressPoliciesEgressFrom | undefined);
    private _identities?;
    get identities(): string[];
    set identities(value: string[]);
    resetIdentities(): void;
    get identitiesInput(): string[] | undefined;
    private _identityType?;
    get identityType(): string;
    set identityType(value: string);
    resetIdentityType(): void;
    get identityTypeInput(): string | undefined;
}
export interface GoogleAccessContextManagerServicePerimeterSpecEgressPoliciesEgressToOperationsMethodSelectors {
    /**
    * Value for 'method' should be a valid method name for the corresponding
  'serviceName' in 'ApiOperation'. If '*' used as value for method,
  then ALL methods and permissions are allowed.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_access_context_manager_service_perimeter#method GoogleAccessContextManagerServicePerimeter#method}
    */
    readonly method?: string;
    /**
    * Value for permission should be a valid Cloud IAM permission for the
  corresponding 'serviceName' in 'ApiOperation'.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_access_context_manager_service_perimeter#permission GoogleAccessContextManagerServicePerimeter#permission}
    */
    readonly permission?: string;
}
export declare function googleAccessContextManagerServicePerimeterSpecEgressPoliciesEgressToOperationsMethodSelectorsToTerraform(struct?: GoogleAccessContextManagerServicePerimeterSpecEgressPoliciesEgressToOperationsMethodSelectors | cdktf.IResolvable): any;
export declare class GoogleAccessContextManagerServicePerimeterSpecEgressPoliciesEgressToOperationsMethodSelectorsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleAccessContextManagerServicePerimeterSpecEgressPoliciesEgressToOperationsMethodSelectors | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleAccessContextManagerServicePerimeterSpecEgressPoliciesEgressToOperationsMethodSelectors | cdktf.IResolvable | undefined);
    private _method?;
    get method(): string;
    set method(value: string);
    resetMethod(): void;
    get methodInput(): string | undefined;
    private _permission?;
    get permission(): string;
    set permission(value: string);
    resetPermission(): void;
    get permissionInput(): string | undefined;
}
export declare class GoogleAccessContextManagerServicePerimeterSpecEgressPoliciesEgressToOperationsMethodSelectorsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleAccessContextManagerServicePerimeterSpecEgressPoliciesEgressToOperationsMethodSelectors[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleAccessContextManagerServicePerimeterSpecEgressPoliciesEgressToOperationsMethodSelectorsOutputReference;
}
export interface GoogleAccessContextManagerServicePerimeterSpecEgressPoliciesEgressToOperations {
    /**
    * The name of the API whose methods or permissions the 'IngressPolicy' or
  'EgressPolicy' want to allow. A single 'ApiOperation' with serviceName
  field set to '*' will allow all methods AND permissions for all services.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_access_context_manager_service_perimeter#service_name GoogleAccessContextManagerServicePerimeter#service_name}
    */
    readonly serviceName?: string;
    /**
    * method_selectors block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_access_context_manager_service_perimeter#method_selectors GoogleAccessContextManagerServicePerimeter#method_selectors}
    */
    readonly methodSelectors?: GoogleAccessContextManagerServicePerimeterSpecEgressPoliciesEgressToOperationsMethodSelectors[] | cdktf.IResolvable;
}
export declare function googleAccessContextManagerServicePerimeterSpecEgressPoliciesEgressToOperationsToTerraform(struct?: GoogleAccessContextManagerServicePerimeterSpecEgressPoliciesEgressToOperations | cdktf.IResolvable): any;
export declare class GoogleAccessContextManagerServicePerimeterSpecEgressPoliciesEgressToOperationsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleAccessContextManagerServicePerimeterSpecEgressPoliciesEgressToOperations | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleAccessContextManagerServicePerimeterSpecEgressPoliciesEgressToOperations | cdktf.IResolvable | undefined);
    private _serviceName?;
    get serviceName(): string;
    set serviceName(value: string);
    resetServiceName(): void;
    get serviceNameInput(): string | undefined;
    private _methodSelectors;
    get methodSelectors(): GoogleAccessContextManagerServicePerimeterSpecEgressPoliciesEgressToOperationsMethodSelectorsList;
    putMethodSelectors(value: GoogleAccessContextManagerServicePerimeterSpecEgressPoliciesEgressToOperationsMethodSelectors[] | cdktf.IResolvable): void;
    resetMethodSelectors(): void;
    get methodSelectorsInput(): cdktf.IResolvable | GoogleAccessContextManagerServicePerimeterSpecEgressPoliciesEgressToOperationsMethodSelectors[] | undefined;
}
export declare class GoogleAccessContextManagerServicePerimeterSpecEgressPoliciesEgressToOperationsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleAccessContextManagerServicePerimeterSpecEgressPoliciesEgressToOperations[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleAccessContextManagerServicePerimeterSpecEgressPoliciesEgressToOperationsOutputReference;
}
export interface GoogleAccessContextManagerServicePerimeterSpecEgressPoliciesEgressTo {
    /**
    * A list of external resources that are allowed to be accessed. A request
  matches if it contains an external resource in this list (Example:
  s3://bucket/path). Currently '*' is not allowed.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_access_context_manager_service_perimeter#external_resources GoogleAccessContextManagerServicePerimeter#external_resources}
    */
    readonly externalResources?: string[];
    /**
    * A list of resources, currently only projects in the form
  'projects/<projectnumber>', that match this to stanza. A request matches
  if it contains a resource in this list. If * is specified for resources,
  then this 'EgressTo' rule will authorize access to all resources outside
  the perimeter.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_access_context_manager_service_perimeter#resources GoogleAccessContextManagerServicePerimeter#resources}
    */
    readonly resources?: string[];
    /**
    * operations block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_access_context_manager_service_perimeter#operations GoogleAccessContextManagerServicePerimeter#operations}
    */
    readonly operations?: GoogleAccessContextManagerServicePerimeterSpecEgressPoliciesEgressToOperations[] | cdktf.IResolvable;
}
export declare function googleAccessContextManagerServicePerimeterSpecEgressPoliciesEgressToToTerraform(struct?: GoogleAccessContextManagerServicePerimeterSpecEgressPoliciesEgressToOutputReference | GoogleAccessContextManagerServicePerimeterSpecEgressPoliciesEgressTo): any;
export declare class GoogleAccessContextManagerServicePerimeterSpecEgressPoliciesEgressToOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleAccessContextManagerServicePerimeterSpecEgressPoliciesEgressTo | undefined;
    set internalValue(value: GoogleAccessContextManagerServicePerimeterSpecEgressPoliciesEgressTo | undefined);
    private _externalResources?;
    get externalResources(): string[];
    set externalResources(value: string[]);
    resetExternalResources(): void;
    get externalResourcesInput(): string[] | undefined;
    private _resources?;
    get resources(): string[];
    set resources(value: string[]);
    resetResources(): void;
    get resourcesInput(): string[] | undefined;
    private _operations;
    get operations(): GoogleAccessContextManagerServicePerimeterSpecEgressPoliciesEgressToOperationsList;
    putOperations(value: GoogleAccessContextManagerServicePerimeterSpecEgressPoliciesEgressToOperations[] | cdktf.IResolvable): void;
    resetOperations(): void;
    get operationsInput(): cdktf.IResolvable | GoogleAccessContextManagerServicePerimeterSpecEgressPoliciesEgressToOperations[] | undefined;
}
export interface GoogleAccessContextManagerServicePerimeterSpecEgressPolicies {
    /**
    * egress_from block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_access_context_manager_service_perimeter#egress_from GoogleAccessContextManagerServicePerimeter#egress_from}
    */
    readonly egressFrom?: GoogleAccessContextManagerServicePerimeterSpecEgressPoliciesEgressFrom;
    /**
    * egress_to block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_access_context_manager_service_perimeter#egress_to GoogleAccessContextManagerServicePerimeter#egress_to}
    */
    readonly egressTo?: GoogleAccessContextManagerServicePerimeterSpecEgressPoliciesEgressTo;
}
export declare function googleAccessContextManagerServicePerimeterSpecEgressPoliciesToTerraform(struct?: GoogleAccessContextManagerServicePerimeterSpecEgressPolicies | cdktf.IResolvable): any;
export declare class GoogleAccessContextManagerServicePerimeterSpecEgressPoliciesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleAccessContextManagerServicePerimeterSpecEgressPolicies | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleAccessContextManagerServicePerimeterSpecEgressPolicies | cdktf.IResolvable | undefined);
    private _egressFrom;
    get egressFrom(): GoogleAccessContextManagerServicePerimeterSpecEgressPoliciesEgressFromOutputReference;
    putEgressFrom(value: GoogleAccessContextManagerServicePerimeterSpecEgressPoliciesEgressFrom): void;
    resetEgressFrom(): void;
    get egressFromInput(): GoogleAccessContextManagerServicePerimeterSpecEgressPoliciesEgressFrom | undefined;
    private _egressTo;
    get egressTo(): GoogleAccessContextManagerServicePerimeterSpecEgressPoliciesEgressToOutputReference;
    putEgressTo(value: GoogleAccessContextManagerServicePerimeterSpecEgressPoliciesEgressTo): void;
    resetEgressTo(): void;
    get egressToInput(): GoogleAccessContextManagerServicePerimeterSpecEgressPoliciesEgressTo | undefined;
}
export declare class GoogleAccessContextManagerServicePerimeterSpecEgressPoliciesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleAccessContextManagerServicePerimeterSpecEgressPolicies[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleAccessContextManagerServicePerimeterSpecEgressPoliciesOutputReference;
}
export interface GoogleAccessContextManagerServicePerimeterSpecIngressPoliciesIngressFromSources {
    /**
    * An 'AccessLevel' resource name that allow resources within the
  'ServicePerimeters' to be accessed from the internet. 'AccessLevels' listed
  must be in the same policy as this 'ServicePerimeter'. Referencing a nonexistent
  'AccessLevel' will cause an error. If no 'AccessLevel' names are listed,
  resources within the perimeter can only be accessed via Google Cloud calls
  with request origins within the perimeter.
  Example 'accessPolicies/MY_POLICY/accessLevels/MY_LEVEL.'
  If * is specified, then all IngressSources will be allowed.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_access_context_manager_service_perimeter#access_level GoogleAccessContextManagerServicePerimeter#access_level}
    */
    readonly accessLevel?: string;
    /**
    * A Google Cloud resource that is allowed to ingress the perimeter.
  Requests from these resources will be allowed to access perimeter data.
  Currently only projects are allowed. Format 'projects/{project_number}'
  The project may be in any Google Cloud organization, not just the
  organization that the perimeter is defined in. '*' is not allowed, the case
  of allowing all Google Cloud resources only is not supported.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_access_context_manager_service_perimeter#resource GoogleAccessContextManagerServicePerimeter#resource}
    */
    readonly resource?: string;
}
export declare function googleAccessContextManagerServicePerimeterSpecIngressPoliciesIngressFromSourcesToTerraform(struct?: GoogleAccessContextManagerServicePerimeterSpecIngressPoliciesIngressFromSources | cdktf.IResolvable): any;
export declare class GoogleAccessContextManagerServicePerimeterSpecIngressPoliciesIngressFromSourcesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleAccessContextManagerServicePerimeterSpecIngressPoliciesIngressFromSources | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleAccessContextManagerServicePerimeterSpecIngressPoliciesIngressFromSources | cdktf.IResolvable | undefined);
    private _accessLevel?;
    get accessLevel(): string;
    set accessLevel(value: string);
    resetAccessLevel(): void;
    get accessLevelInput(): string | undefined;
    private _resource?;
    get resource(): string;
    set resource(value: string);
    resetResource(): void;
    get resourceInput(): string | undefined;
}
export declare class GoogleAccessContextManagerServicePerimeterSpecIngressPoliciesIngressFromSourcesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleAccessContextManagerServicePerimeterSpecIngressPoliciesIngressFromSources[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleAccessContextManagerServicePerimeterSpecIngressPoliciesIngressFromSourcesOutputReference;
}
export interface GoogleAccessContextManagerServicePerimeterSpecIngressPoliciesIngressFrom {
    /**
    * A list of identities that are allowed access through this ingress policy.
  Should be in the format of email address. The email address should represent
  individual user or service account only.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_access_context_manager_service_perimeter#identities GoogleAccessContextManagerServicePerimeter#identities}
    */
    readonly identities?: string[];
    /**
    * Specifies the type of identities that are allowed access from outside the
  perimeter. If left unspecified, then members of 'identities' field will be
  allowed access. Possible values: ["IDENTITY_TYPE_UNSPECIFIED", "ANY_IDENTITY", "ANY_USER_ACCOUNT", "ANY_SERVICE_ACCOUNT"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_access_context_manager_service_perimeter#identity_type GoogleAccessContextManagerServicePerimeter#identity_type}
    */
    readonly identityType?: string;
    /**
    * sources block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_access_context_manager_service_perimeter#sources GoogleAccessContextManagerServicePerimeter#sources}
    */
    readonly sources?: GoogleAccessContextManagerServicePerimeterSpecIngressPoliciesIngressFromSources[] | cdktf.IResolvable;
}
export declare function googleAccessContextManagerServicePerimeterSpecIngressPoliciesIngressFromToTerraform(struct?: GoogleAccessContextManagerServicePerimeterSpecIngressPoliciesIngressFromOutputReference | GoogleAccessContextManagerServicePerimeterSpecIngressPoliciesIngressFrom): any;
export declare class GoogleAccessContextManagerServicePerimeterSpecIngressPoliciesIngressFromOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleAccessContextManagerServicePerimeterSpecIngressPoliciesIngressFrom | undefined;
    set internalValue(value: GoogleAccessContextManagerServicePerimeterSpecIngressPoliciesIngressFrom | undefined);
    private _identities?;
    get identities(): string[];
    set identities(value: string[]);
    resetIdentities(): void;
    get identitiesInput(): string[] | undefined;
    private _identityType?;
    get identityType(): string;
    set identityType(value: string);
    resetIdentityType(): void;
    get identityTypeInput(): string | undefined;
    private _sources;
    get sources(): GoogleAccessContextManagerServicePerimeterSpecIngressPoliciesIngressFromSourcesList;
    putSources(value: GoogleAccessContextManagerServicePerimeterSpecIngressPoliciesIngressFromSources[] | cdktf.IResolvable): void;
    resetSources(): void;
    get sourcesInput(): cdktf.IResolvable | GoogleAccessContextManagerServicePerimeterSpecIngressPoliciesIngressFromSources[] | undefined;
}
export interface GoogleAccessContextManagerServicePerimeterSpecIngressPoliciesIngressToOperationsMethodSelectors {
    /**
    * Value for method should be a valid method name for the corresponding
  serviceName in 'ApiOperation'. If '*' used as value for 'method', then
  ALL methods and permissions are allowed.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_access_context_manager_service_perimeter#method GoogleAccessContextManagerServicePerimeter#method}
    */
    readonly method?: string;
    /**
    * Value for permission should be a valid Cloud IAM permission for the
  corresponding 'serviceName' in 'ApiOperation'.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_access_context_manager_service_perimeter#permission GoogleAccessContextManagerServicePerimeter#permission}
    */
    readonly permission?: string;
}
export declare function googleAccessContextManagerServicePerimeterSpecIngressPoliciesIngressToOperationsMethodSelectorsToTerraform(struct?: GoogleAccessContextManagerServicePerimeterSpecIngressPoliciesIngressToOperationsMethodSelectors | cdktf.IResolvable): any;
export declare class GoogleAccessContextManagerServicePerimeterSpecIngressPoliciesIngressToOperationsMethodSelectorsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleAccessContextManagerServicePerimeterSpecIngressPoliciesIngressToOperationsMethodSelectors | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleAccessContextManagerServicePerimeterSpecIngressPoliciesIngressToOperationsMethodSelectors | cdktf.IResolvable | undefined);
    private _method?;
    get method(): string;
    set method(value: string);
    resetMethod(): void;
    get methodInput(): string | undefined;
    private _permission?;
    get permission(): string;
    set permission(value: string);
    resetPermission(): void;
    get permissionInput(): string | undefined;
}
export declare class GoogleAccessContextManagerServicePerimeterSpecIngressPoliciesIngressToOperationsMethodSelectorsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleAccessContextManagerServicePerimeterSpecIngressPoliciesIngressToOperationsMethodSelectors[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleAccessContextManagerServicePerimeterSpecIngressPoliciesIngressToOperationsMethodSelectorsOutputReference;
}
export interface GoogleAccessContextManagerServicePerimeterSpecIngressPoliciesIngressToOperations {
    /**
    * The name of the API whose methods or permissions the 'IngressPolicy' or
  'EgressPolicy' want to allow. A single 'ApiOperation' with 'serviceName'
  field set to '*' will allow all methods AND permissions for all services.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_access_context_manager_service_perimeter#service_name GoogleAccessContextManagerServicePerimeter#service_name}
    */
    readonly serviceName?: string;
    /**
    * method_selectors block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_access_context_manager_service_perimeter#method_selectors GoogleAccessContextManagerServicePerimeter#method_selectors}
    */
    readonly methodSelectors?: GoogleAccessContextManagerServicePerimeterSpecIngressPoliciesIngressToOperationsMethodSelectors[] | cdktf.IResolvable;
}
export declare function googleAccessContextManagerServicePerimeterSpecIngressPoliciesIngressToOperationsToTerraform(struct?: GoogleAccessContextManagerServicePerimeterSpecIngressPoliciesIngressToOperations | cdktf.IResolvable): any;
export declare class GoogleAccessContextManagerServicePerimeterSpecIngressPoliciesIngressToOperationsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleAccessContextManagerServicePerimeterSpecIngressPoliciesIngressToOperations | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleAccessContextManagerServicePerimeterSpecIngressPoliciesIngressToOperations | cdktf.IResolvable | undefined);
    private _serviceName?;
    get serviceName(): string;
    set serviceName(value: string);
    resetServiceName(): void;
    get serviceNameInput(): string | undefined;
    private _methodSelectors;
    get methodSelectors(): GoogleAccessContextManagerServicePerimeterSpecIngressPoliciesIngressToOperationsMethodSelectorsList;
    putMethodSelectors(value: GoogleAccessContextManagerServicePerimeterSpecIngressPoliciesIngressToOperationsMethodSelectors[] | cdktf.IResolvable): void;
    resetMethodSelectors(): void;
    get methodSelectorsInput(): cdktf.IResolvable | GoogleAccessContextManagerServicePerimeterSpecIngressPoliciesIngressToOperationsMethodSelectors[] | undefined;
}
export declare class GoogleAccessContextManagerServicePerimeterSpecIngressPoliciesIngressToOperationsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleAccessContextManagerServicePerimeterSpecIngressPoliciesIngressToOperations[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleAccessContextManagerServicePerimeterSpecIngressPoliciesIngressToOperationsOutputReference;
}
export interface GoogleAccessContextManagerServicePerimeterSpecIngressPoliciesIngressTo {
    /**
    * A list of resources, currently only projects in the form
  'projects/<projectnumber>', protected by this 'ServicePerimeter'
  that are allowed to be accessed by sources defined in the
  corresponding 'IngressFrom'. A request matches if it contains
  a resource in this list. If '*' is specified for resources,
  then this 'IngressTo' rule will authorize access to all
  resources inside the perimeter, provided that the request
  also matches the 'operations' field.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_access_context_manager_service_perimeter#resources GoogleAccessContextManagerServicePerimeter#resources}
    */
    readonly resources?: string[];
    /**
    * operations block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_access_context_manager_service_perimeter#operations GoogleAccessContextManagerServicePerimeter#operations}
    */
    readonly operations?: GoogleAccessContextManagerServicePerimeterSpecIngressPoliciesIngressToOperations[] | cdktf.IResolvable;
}
export declare function googleAccessContextManagerServicePerimeterSpecIngressPoliciesIngressToToTerraform(struct?: GoogleAccessContextManagerServicePerimeterSpecIngressPoliciesIngressToOutputReference | GoogleAccessContextManagerServicePerimeterSpecIngressPoliciesIngressTo): any;
export declare class GoogleAccessContextManagerServicePerimeterSpecIngressPoliciesIngressToOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleAccessContextManagerServicePerimeterSpecIngressPoliciesIngressTo | undefined;
    set internalValue(value: GoogleAccessContextManagerServicePerimeterSpecIngressPoliciesIngressTo | undefined);
    private _resources?;
    get resources(): string[];
    set resources(value: string[]);
    resetResources(): void;
    get resourcesInput(): string[] | undefined;
    private _operations;
    get operations(): GoogleAccessContextManagerServicePerimeterSpecIngressPoliciesIngressToOperationsList;
    putOperations(value: GoogleAccessContextManagerServicePerimeterSpecIngressPoliciesIngressToOperations[] | cdktf.IResolvable): void;
    resetOperations(): void;
    get operationsInput(): cdktf.IResolvable | GoogleAccessContextManagerServicePerimeterSpecIngressPoliciesIngressToOperations[] | undefined;
}
export interface GoogleAccessContextManagerServicePerimeterSpecIngressPolicies {
    /**
    * ingress_from block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_access_context_manager_service_perimeter#ingress_from GoogleAccessContextManagerServicePerimeter#ingress_from}
    */
    readonly ingressFrom?: GoogleAccessContextManagerServicePerimeterSpecIngressPoliciesIngressFrom;
    /**
    * ingress_to block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_access_context_manager_service_perimeter#ingress_to GoogleAccessContextManagerServicePerimeter#ingress_to}
    */
    readonly ingressTo?: GoogleAccessContextManagerServicePerimeterSpecIngressPoliciesIngressTo;
}
export declare function googleAccessContextManagerServicePerimeterSpecIngressPoliciesToTerraform(struct?: GoogleAccessContextManagerServicePerimeterSpecIngressPolicies | cdktf.IResolvable): any;
export declare class GoogleAccessContextManagerServicePerimeterSpecIngressPoliciesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleAccessContextManagerServicePerimeterSpecIngressPolicies | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleAccessContextManagerServicePerimeterSpecIngressPolicies | cdktf.IResolvable | undefined);
    private _ingressFrom;
    get ingressFrom(): GoogleAccessContextManagerServicePerimeterSpecIngressPoliciesIngressFromOutputReference;
    putIngressFrom(value: GoogleAccessContextManagerServicePerimeterSpecIngressPoliciesIngressFrom): void;
    resetIngressFrom(): void;
    get ingressFromInput(): GoogleAccessContextManagerServicePerimeterSpecIngressPoliciesIngressFrom | undefined;
    private _ingressTo;
    get ingressTo(): GoogleAccessContextManagerServicePerimeterSpecIngressPoliciesIngressToOutputReference;
    putIngressTo(value: GoogleAccessContextManagerServicePerimeterSpecIngressPoliciesIngressTo): void;
    resetIngressTo(): void;
    get ingressToInput(): GoogleAccessContextManagerServicePerimeterSpecIngressPoliciesIngressTo | undefined;
}
export declare class GoogleAccessContextManagerServicePerimeterSpecIngressPoliciesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleAccessContextManagerServicePerimeterSpecIngressPolicies[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleAccessContextManagerServicePerimeterSpecIngressPoliciesOutputReference;
}
export interface GoogleAccessContextManagerServicePerimeterSpecVpcAccessibleServices {
    /**
    * The list of APIs usable within the Service Perimeter.
  Must be empty unless 'enableRestriction' is True.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_access_context_manager_service_perimeter#allowed_services GoogleAccessContextManagerServicePerimeter#allowed_services}
    */
    readonly allowedServices?: string[];
    /**
    * Whether to restrict API calls within the Service Perimeter to the
  list of APIs specified in 'allowedServices'.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_access_context_manager_service_perimeter#enable_restriction GoogleAccessContextManagerServicePerimeter#enable_restriction}
    */
    readonly enableRestriction?: boolean | cdktf.IResolvable;
}
export declare function googleAccessContextManagerServicePerimeterSpecVpcAccessibleServicesToTerraform(struct?: GoogleAccessContextManagerServicePerimeterSpecVpcAccessibleServicesOutputReference | GoogleAccessContextManagerServicePerimeterSpecVpcAccessibleServices): any;
export declare class GoogleAccessContextManagerServicePerimeterSpecVpcAccessibleServicesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleAccessContextManagerServicePerimeterSpecVpcAccessibleServices | undefined;
    set internalValue(value: GoogleAccessContextManagerServicePerimeterSpecVpcAccessibleServices | undefined);
    private _allowedServices?;
    get allowedServices(): string[];
    set allowedServices(value: string[]);
    resetAllowedServices(): void;
    get allowedServicesInput(): string[] | undefined;
    private _enableRestriction?;
    get enableRestriction(): boolean | cdktf.IResolvable;
    set enableRestriction(value: boolean | cdktf.IResolvable);
    resetEnableRestriction(): void;
    get enableRestrictionInput(): boolean | cdktf.IResolvable | undefined;
}
export interface GoogleAccessContextManagerServicePerimeterSpec {
    /**
    * A list of AccessLevel resource names that allow resources within
  the ServicePerimeter to be accessed from the internet.
  AccessLevels listed must be in the same policy as this
  ServicePerimeter. Referencing a nonexistent AccessLevel is a
  syntax error. If no AccessLevel names are listed, resources within
  the perimeter can only be accessed via GCP calls with request
  origins within the perimeter. For Service Perimeter Bridge, must
  be empty.
  
  Format: accessPolicies/{policy_id}/accessLevels/{access_level_name}
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_access_context_manager_service_perimeter#access_levels GoogleAccessContextManagerServicePerimeter#access_levels}
    */
    readonly accessLevels?: string[];
    /**
    * A list of GCP resources that are inside of the service perimeter.
  Currently only projects are allowed.
  Format: projects/{project_number}
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_access_context_manager_service_perimeter#resources GoogleAccessContextManagerServicePerimeter#resources}
    */
    readonly resources?: string[];
    /**
    * GCP services that are subject to the Service Perimeter
  restrictions. Must contain a list of services. For example, if
  'storage.googleapis.com' is specified, access to the storage
  buckets inside the perimeter must meet the perimeter's access
  restrictions.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_access_context_manager_service_perimeter#restricted_services GoogleAccessContextManagerServicePerimeter#restricted_services}
    */
    readonly restrictedServices?: string[];
    /**
    * egress_policies block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_access_context_manager_service_perimeter#egress_policies GoogleAccessContextManagerServicePerimeter#egress_policies}
    */
    readonly egressPolicies?: GoogleAccessContextManagerServicePerimeterSpecEgressPolicies[] | cdktf.IResolvable;
    /**
    * ingress_policies block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_access_context_manager_service_perimeter#ingress_policies GoogleAccessContextManagerServicePerimeter#ingress_policies}
    */
    readonly ingressPolicies?: GoogleAccessContextManagerServicePerimeterSpecIngressPolicies[] | cdktf.IResolvable;
    /**
    * vpc_accessible_services block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_access_context_manager_service_perimeter#vpc_accessible_services GoogleAccessContextManagerServicePerimeter#vpc_accessible_services}
    */
    readonly vpcAccessibleServices?: GoogleAccessContextManagerServicePerimeterSpecVpcAccessibleServices;
}
export declare function googleAccessContextManagerServicePerimeterSpecToTerraform(struct?: GoogleAccessContextManagerServicePerimeterSpecOutputReference | GoogleAccessContextManagerServicePerimeterSpec): any;
export declare class GoogleAccessContextManagerServicePerimeterSpecOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleAccessContextManagerServicePerimeterSpec | undefined;
    set internalValue(value: GoogleAccessContextManagerServicePerimeterSpec | undefined);
    private _accessLevels?;
    get accessLevels(): string[];
    set accessLevels(value: string[]);
    resetAccessLevels(): void;
    get accessLevelsInput(): string[] | undefined;
    private _resources?;
    get resources(): string[];
    set resources(value: string[]);
    resetResources(): void;
    get resourcesInput(): string[] | undefined;
    private _restrictedServices?;
    get restrictedServices(): string[];
    set restrictedServices(value: string[]);
    resetRestrictedServices(): void;
    get restrictedServicesInput(): string[] | undefined;
    private _egressPolicies;
    get egressPolicies(): GoogleAccessContextManagerServicePerimeterSpecEgressPoliciesList;
    putEgressPolicies(value: GoogleAccessContextManagerServicePerimeterSpecEgressPolicies[] | cdktf.IResolvable): void;
    resetEgressPolicies(): void;
    get egressPoliciesInput(): cdktf.IResolvable | GoogleAccessContextManagerServicePerimeterSpecEgressPolicies[] | undefined;
    private _ingressPolicies;
    get ingressPolicies(): GoogleAccessContextManagerServicePerimeterSpecIngressPoliciesList;
    putIngressPolicies(value: GoogleAccessContextManagerServicePerimeterSpecIngressPolicies[] | cdktf.IResolvable): void;
    resetIngressPolicies(): void;
    get ingressPoliciesInput(): cdktf.IResolvable | GoogleAccessContextManagerServicePerimeterSpecIngressPolicies[] | undefined;
    private _vpcAccessibleServices;
    get vpcAccessibleServices(): GoogleAccessContextManagerServicePerimeterSpecVpcAccessibleServicesOutputReference;
    putVpcAccessibleServices(value: GoogleAccessContextManagerServicePerimeterSpecVpcAccessibleServices): void;
    resetVpcAccessibleServices(): void;
    get vpcAccessibleServicesInput(): GoogleAccessContextManagerServicePerimeterSpecVpcAccessibleServices | undefined;
}
export interface GoogleAccessContextManagerServicePerimeterStatusEgressPoliciesEgressFrom {
    /**
    * A list of identities that are allowed access through this 'EgressPolicy'.
  Should be in the format of email address. The email address should
  represent individual user or service account only.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_access_context_manager_service_perimeter#identities GoogleAccessContextManagerServicePerimeter#identities}
    */
    readonly identities?: string[];
    /**
    * Specifies the type of identities that are allowed access to outside the
  perimeter. If left unspecified, then members of 'identities' field will
  be allowed access. Possible values: ["IDENTITY_TYPE_UNSPECIFIED", "ANY_IDENTITY", "ANY_USER_ACCOUNT", "ANY_SERVICE_ACCOUNT"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_access_context_manager_service_perimeter#identity_type GoogleAccessContextManagerServicePerimeter#identity_type}
    */
    readonly identityType?: string;
}
export declare function googleAccessContextManagerServicePerimeterStatusEgressPoliciesEgressFromToTerraform(struct?: GoogleAccessContextManagerServicePerimeterStatusEgressPoliciesEgressFromOutputReference | GoogleAccessContextManagerServicePerimeterStatusEgressPoliciesEgressFrom): any;
export declare class GoogleAccessContextManagerServicePerimeterStatusEgressPoliciesEgressFromOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleAccessContextManagerServicePerimeterStatusEgressPoliciesEgressFrom | undefined;
    set internalValue(value: GoogleAccessContextManagerServicePerimeterStatusEgressPoliciesEgressFrom | undefined);
    private _identities?;
    get identities(): string[];
    set identities(value: string[]);
    resetIdentities(): void;
    get identitiesInput(): string[] | undefined;
    private _identityType?;
    get identityType(): string;
    set identityType(value: string);
    resetIdentityType(): void;
    get identityTypeInput(): string | undefined;
}
export interface GoogleAccessContextManagerServicePerimeterStatusEgressPoliciesEgressToOperationsMethodSelectors {
    /**
    * Value for 'method' should be a valid method name for the corresponding
  'serviceName' in 'ApiOperation'. If '*' used as value for method,
  then ALL methods and permissions are allowed.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_access_context_manager_service_perimeter#method GoogleAccessContextManagerServicePerimeter#method}
    */
    readonly method?: string;
    /**
    * Value for permission should be a valid Cloud IAM permission for the
  corresponding 'serviceName' in 'ApiOperation'.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_access_context_manager_service_perimeter#permission GoogleAccessContextManagerServicePerimeter#permission}
    */
    readonly permission?: string;
}
export declare function googleAccessContextManagerServicePerimeterStatusEgressPoliciesEgressToOperationsMethodSelectorsToTerraform(struct?: GoogleAccessContextManagerServicePerimeterStatusEgressPoliciesEgressToOperationsMethodSelectors | cdktf.IResolvable): any;
export declare class GoogleAccessContextManagerServicePerimeterStatusEgressPoliciesEgressToOperationsMethodSelectorsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleAccessContextManagerServicePerimeterStatusEgressPoliciesEgressToOperationsMethodSelectors | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleAccessContextManagerServicePerimeterStatusEgressPoliciesEgressToOperationsMethodSelectors | cdktf.IResolvable | undefined);
    private _method?;
    get method(): string;
    set method(value: string);
    resetMethod(): void;
    get methodInput(): string | undefined;
    private _permission?;
    get permission(): string;
    set permission(value: string);
    resetPermission(): void;
    get permissionInput(): string | undefined;
}
export declare class GoogleAccessContextManagerServicePerimeterStatusEgressPoliciesEgressToOperationsMethodSelectorsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleAccessContextManagerServicePerimeterStatusEgressPoliciesEgressToOperationsMethodSelectors[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleAccessContextManagerServicePerimeterStatusEgressPoliciesEgressToOperationsMethodSelectorsOutputReference;
}
export interface GoogleAccessContextManagerServicePerimeterStatusEgressPoliciesEgressToOperations {
    /**
    * The name of the API whose methods or permissions the 'IngressPolicy' or
  'EgressPolicy' want to allow. A single 'ApiOperation' with serviceName
  field set to '*' will allow all methods AND permissions for all services.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_access_context_manager_service_perimeter#service_name GoogleAccessContextManagerServicePerimeter#service_name}
    */
    readonly serviceName?: string;
    /**
    * method_selectors block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_access_context_manager_service_perimeter#method_selectors GoogleAccessContextManagerServicePerimeter#method_selectors}
    */
    readonly methodSelectors?: GoogleAccessContextManagerServicePerimeterStatusEgressPoliciesEgressToOperationsMethodSelectors[] | cdktf.IResolvable;
}
export declare function googleAccessContextManagerServicePerimeterStatusEgressPoliciesEgressToOperationsToTerraform(struct?: GoogleAccessContextManagerServicePerimeterStatusEgressPoliciesEgressToOperations | cdktf.IResolvable): any;
export declare class GoogleAccessContextManagerServicePerimeterStatusEgressPoliciesEgressToOperationsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleAccessContextManagerServicePerimeterStatusEgressPoliciesEgressToOperations | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleAccessContextManagerServicePerimeterStatusEgressPoliciesEgressToOperations | cdktf.IResolvable | undefined);
    private _serviceName?;
    get serviceName(): string;
    set serviceName(value: string);
    resetServiceName(): void;
    get serviceNameInput(): string | undefined;
    private _methodSelectors;
    get methodSelectors(): GoogleAccessContextManagerServicePerimeterStatusEgressPoliciesEgressToOperationsMethodSelectorsList;
    putMethodSelectors(value: GoogleAccessContextManagerServicePerimeterStatusEgressPoliciesEgressToOperationsMethodSelectors[] | cdktf.IResolvable): void;
    resetMethodSelectors(): void;
    get methodSelectorsInput(): cdktf.IResolvable | GoogleAccessContextManagerServicePerimeterStatusEgressPoliciesEgressToOperationsMethodSelectors[] | undefined;
}
export declare class GoogleAccessContextManagerServicePerimeterStatusEgressPoliciesEgressToOperationsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleAccessContextManagerServicePerimeterStatusEgressPoliciesEgressToOperations[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleAccessContextManagerServicePerimeterStatusEgressPoliciesEgressToOperationsOutputReference;
}
export interface GoogleAccessContextManagerServicePerimeterStatusEgressPoliciesEgressTo {
    /**
    * A list of external resources that are allowed to be accessed. A request
  matches if it contains an external resource in this list (Example:
  s3://bucket/path). Currently '*' is not allowed.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_access_context_manager_service_perimeter#external_resources GoogleAccessContextManagerServicePerimeter#external_resources}
    */
    readonly externalResources?: string[];
    /**
    * A list of resources, currently only projects in the form
  'projects/<projectnumber>', that match this to stanza. A request matches
  if it contains a resource in this list. If * is specified for resources,
  then this 'EgressTo' rule will authorize access to all resources outside
  the perimeter.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_access_context_manager_service_perimeter#resources GoogleAccessContextManagerServicePerimeter#resources}
    */
    readonly resources?: string[];
    /**
    * operations block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_access_context_manager_service_perimeter#operations GoogleAccessContextManagerServicePerimeter#operations}
    */
    readonly operations?: GoogleAccessContextManagerServicePerimeterStatusEgressPoliciesEgressToOperations[] | cdktf.IResolvable;
}
export declare function googleAccessContextManagerServicePerimeterStatusEgressPoliciesEgressToToTerraform(struct?: GoogleAccessContextManagerServicePerimeterStatusEgressPoliciesEgressToOutputReference | GoogleAccessContextManagerServicePerimeterStatusEgressPoliciesEgressTo): any;
export declare class GoogleAccessContextManagerServicePerimeterStatusEgressPoliciesEgressToOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleAccessContextManagerServicePerimeterStatusEgressPoliciesEgressTo | undefined;
    set internalValue(value: GoogleAccessContextManagerServicePerimeterStatusEgressPoliciesEgressTo | undefined);
    private _externalResources?;
    get externalResources(): string[];
    set externalResources(value: string[]);
    resetExternalResources(): void;
    get externalResourcesInput(): string[] | undefined;
    private _resources?;
    get resources(): string[];
    set resources(value: string[]);
    resetResources(): void;
    get resourcesInput(): string[] | undefined;
    private _operations;
    get operations(): GoogleAccessContextManagerServicePerimeterStatusEgressPoliciesEgressToOperationsList;
    putOperations(value: GoogleAccessContextManagerServicePerimeterStatusEgressPoliciesEgressToOperations[] | cdktf.IResolvable): void;
    resetOperations(): void;
    get operationsInput(): cdktf.IResolvable | GoogleAccessContextManagerServicePerimeterStatusEgressPoliciesEgressToOperations[] | undefined;
}
export interface GoogleAccessContextManagerServicePerimeterStatusEgressPolicies {
    /**
    * egress_from block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_access_context_manager_service_perimeter#egress_from GoogleAccessContextManagerServicePerimeter#egress_from}
    */
    readonly egressFrom?: GoogleAccessContextManagerServicePerimeterStatusEgressPoliciesEgressFrom;
    /**
    * egress_to block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_access_context_manager_service_perimeter#egress_to GoogleAccessContextManagerServicePerimeter#egress_to}
    */
    readonly egressTo?: GoogleAccessContextManagerServicePerimeterStatusEgressPoliciesEgressTo;
}
export declare function googleAccessContextManagerServicePerimeterStatusEgressPoliciesToTerraform(struct?: GoogleAccessContextManagerServicePerimeterStatusEgressPolicies | cdktf.IResolvable): any;
export declare class GoogleAccessContextManagerServicePerimeterStatusEgressPoliciesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleAccessContextManagerServicePerimeterStatusEgressPolicies | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleAccessContextManagerServicePerimeterStatusEgressPolicies | cdktf.IResolvable | undefined);
    private _egressFrom;
    get egressFrom(): GoogleAccessContextManagerServicePerimeterStatusEgressPoliciesEgressFromOutputReference;
    putEgressFrom(value: GoogleAccessContextManagerServicePerimeterStatusEgressPoliciesEgressFrom): void;
    resetEgressFrom(): void;
    get egressFromInput(): GoogleAccessContextManagerServicePerimeterStatusEgressPoliciesEgressFrom | undefined;
    private _egressTo;
    get egressTo(): GoogleAccessContextManagerServicePerimeterStatusEgressPoliciesEgressToOutputReference;
    putEgressTo(value: GoogleAccessContextManagerServicePerimeterStatusEgressPoliciesEgressTo): void;
    resetEgressTo(): void;
    get egressToInput(): GoogleAccessContextManagerServicePerimeterStatusEgressPoliciesEgressTo | undefined;
}
export declare class GoogleAccessContextManagerServicePerimeterStatusEgressPoliciesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleAccessContextManagerServicePerimeterStatusEgressPolicies[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleAccessContextManagerServicePerimeterStatusEgressPoliciesOutputReference;
}
export interface GoogleAccessContextManagerServicePerimeterStatusIngressPoliciesIngressFromSources {
    /**
    * An 'AccessLevel' resource name that allow resources within the
  'ServicePerimeters' to be accessed from the internet. 'AccessLevels' listed
  must be in the same policy as this 'ServicePerimeter'. Referencing a nonexistent
  'AccessLevel' will cause an error. If no 'AccessLevel' names are listed,
  resources within the perimeter can only be accessed via Google Cloud calls
  with request origins within the perimeter.
  Example 'accessPolicies/MY_POLICY/accessLevels/MY_LEVEL.'
  If * is specified, then all IngressSources will be allowed.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_access_context_manager_service_perimeter#access_level GoogleAccessContextManagerServicePerimeter#access_level}
    */
    readonly accessLevel?: string;
    /**
    * A Google Cloud resource that is allowed to ingress the perimeter.
  Requests from these resources will be allowed to access perimeter data.
  Currently only projects are allowed. Format 'projects/{project_number}'
  The project may be in any Google Cloud organization, not just the
  organization that the perimeter is defined in. '*' is not allowed, the case
  of allowing all Google Cloud resources only is not supported.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_access_context_manager_service_perimeter#resource GoogleAccessContextManagerServicePerimeter#resource}
    */
    readonly resource?: string;
}
export declare function googleAccessContextManagerServicePerimeterStatusIngressPoliciesIngressFromSourcesToTerraform(struct?: GoogleAccessContextManagerServicePerimeterStatusIngressPoliciesIngressFromSources | cdktf.IResolvable): any;
export declare class GoogleAccessContextManagerServicePerimeterStatusIngressPoliciesIngressFromSourcesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleAccessContextManagerServicePerimeterStatusIngressPoliciesIngressFromSources | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleAccessContextManagerServicePerimeterStatusIngressPoliciesIngressFromSources | cdktf.IResolvable | undefined);
    private _accessLevel?;
    get accessLevel(): string;
    set accessLevel(value: string);
    resetAccessLevel(): void;
    get accessLevelInput(): string | undefined;
    private _resource?;
    get resource(): string;
    set resource(value: string);
    resetResource(): void;
    get resourceInput(): string | undefined;
}
export declare class GoogleAccessContextManagerServicePerimeterStatusIngressPoliciesIngressFromSourcesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleAccessContextManagerServicePerimeterStatusIngressPoliciesIngressFromSources[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleAccessContextManagerServicePerimeterStatusIngressPoliciesIngressFromSourcesOutputReference;
}
export interface GoogleAccessContextManagerServicePerimeterStatusIngressPoliciesIngressFrom {
    /**
    * A list of identities that are allowed access through this ingress policy.
  Should be in the format of email address. The email address should represent
  individual user or service account only.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_access_context_manager_service_perimeter#identities GoogleAccessContextManagerServicePerimeter#identities}
    */
    readonly identities?: string[];
    /**
    * Specifies the type of identities that are allowed access from outside the
  perimeter. If left unspecified, then members of 'identities' field will be
  allowed access. Possible values: ["IDENTITY_TYPE_UNSPECIFIED", "ANY_IDENTITY", "ANY_USER_ACCOUNT", "ANY_SERVICE_ACCOUNT"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_access_context_manager_service_perimeter#identity_type GoogleAccessContextManagerServicePerimeter#identity_type}
    */
    readonly identityType?: string;
    /**
    * sources block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_access_context_manager_service_perimeter#sources GoogleAccessContextManagerServicePerimeter#sources}
    */
    readonly sources?: GoogleAccessContextManagerServicePerimeterStatusIngressPoliciesIngressFromSources[] | cdktf.IResolvable;
}
export declare function googleAccessContextManagerServicePerimeterStatusIngressPoliciesIngressFromToTerraform(struct?: GoogleAccessContextManagerServicePerimeterStatusIngressPoliciesIngressFromOutputReference | GoogleAccessContextManagerServicePerimeterStatusIngressPoliciesIngressFrom): any;
export declare class GoogleAccessContextManagerServicePerimeterStatusIngressPoliciesIngressFromOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleAccessContextManagerServicePerimeterStatusIngressPoliciesIngressFrom | undefined;
    set internalValue(value: GoogleAccessContextManagerServicePerimeterStatusIngressPoliciesIngressFrom | undefined);
    private _identities?;
    get identities(): string[];
    set identities(value: string[]);
    resetIdentities(): void;
    get identitiesInput(): string[] | undefined;
    private _identityType?;
    get identityType(): string;
    set identityType(value: string);
    resetIdentityType(): void;
    get identityTypeInput(): string | undefined;
    private _sources;
    get sources(): GoogleAccessContextManagerServicePerimeterStatusIngressPoliciesIngressFromSourcesList;
    putSources(value: GoogleAccessContextManagerServicePerimeterStatusIngressPoliciesIngressFromSources[] | cdktf.IResolvable): void;
    resetSources(): void;
    get sourcesInput(): cdktf.IResolvable | GoogleAccessContextManagerServicePerimeterStatusIngressPoliciesIngressFromSources[] | undefined;
}
export interface GoogleAccessContextManagerServicePerimeterStatusIngressPoliciesIngressToOperationsMethodSelectors {
    /**
    * Value for method should be a valid method name for the corresponding
  serviceName in 'ApiOperation'. If '*' used as value for 'method', then
  ALL methods and permissions are allowed.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_access_context_manager_service_perimeter#method GoogleAccessContextManagerServicePerimeter#method}
    */
    readonly method?: string;
    /**
    * Value for permission should be a valid Cloud IAM permission for the
  corresponding 'serviceName' in 'ApiOperation'.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_access_context_manager_service_perimeter#permission GoogleAccessContextManagerServicePerimeter#permission}
    */
    readonly permission?: string;
}
export declare function googleAccessContextManagerServicePerimeterStatusIngressPoliciesIngressToOperationsMethodSelectorsToTerraform(struct?: GoogleAccessContextManagerServicePerimeterStatusIngressPoliciesIngressToOperationsMethodSelectors | cdktf.IResolvable): any;
export declare class GoogleAccessContextManagerServicePerimeterStatusIngressPoliciesIngressToOperationsMethodSelectorsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleAccessContextManagerServicePerimeterStatusIngressPoliciesIngressToOperationsMethodSelectors | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleAccessContextManagerServicePerimeterStatusIngressPoliciesIngressToOperationsMethodSelectors | cdktf.IResolvable | undefined);
    private _method?;
    get method(): string;
    set method(value: string);
    resetMethod(): void;
    get methodInput(): string | undefined;
    private _permission?;
    get permission(): string;
    set permission(value: string);
    resetPermission(): void;
    get permissionInput(): string | undefined;
}
export declare class GoogleAccessContextManagerServicePerimeterStatusIngressPoliciesIngressToOperationsMethodSelectorsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleAccessContextManagerServicePerimeterStatusIngressPoliciesIngressToOperationsMethodSelectors[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleAccessContextManagerServicePerimeterStatusIngressPoliciesIngressToOperationsMethodSelectorsOutputReference;
}
export interface GoogleAccessContextManagerServicePerimeterStatusIngressPoliciesIngressToOperations {
    /**
    * The name of the API whose methods or permissions the 'IngressPolicy' or
  'EgressPolicy' want to allow. A single 'ApiOperation' with 'serviceName'
  field set to '*' will allow all methods AND permissions for all services.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_access_context_manager_service_perimeter#service_name GoogleAccessContextManagerServicePerimeter#service_name}
    */
    readonly serviceName?: string;
    /**
    * method_selectors block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_access_context_manager_service_perimeter#method_selectors GoogleAccessContextManagerServicePerimeter#method_selectors}
    */
    readonly methodSelectors?: GoogleAccessContextManagerServicePerimeterStatusIngressPoliciesIngressToOperationsMethodSelectors[] | cdktf.IResolvable;
}
export declare function googleAccessContextManagerServicePerimeterStatusIngressPoliciesIngressToOperationsToTerraform(struct?: GoogleAccessContextManagerServicePerimeterStatusIngressPoliciesIngressToOperations | cdktf.IResolvable): any;
export declare class GoogleAccessContextManagerServicePerimeterStatusIngressPoliciesIngressToOperationsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleAccessContextManagerServicePerimeterStatusIngressPoliciesIngressToOperations | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleAccessContextManagerServicePerimeterStatusIngressPoliciesIngressToOperations | cdktf.IResolvable | undefined);
    private _serviceName?;
    get serviceName(): string;
    set serviceName(value: string);
    resetServiceName(): void;
    get serviceNameInput(): string | undefined;
    private _methodSelectors;
    get methodSelectors(): GoogleAccessContextManagerServicePerimeterStatusIngressPoliciesIngressToOperationsMethodSelectorsList;
    putMethodSelectors(value: GoogleAccessContextManagerServicePerimeterStatusIngressPoliciesIngressToOperationsMethodSelectors[] | cdktf.IResolvable): void;
    resetMethodSelectors(): void;
    get methodSelectorsInput(): cdktf.IResolvable | GoogleAccessContextManagerServicePerimeterStatusIngressPoliciesIngressToOperationsMethodSelectors[] | undefined;
}
export declare class GoogleAccessContextManagerServicePerimeterStatusIngressPoliciesIngressToOperationsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleAccessContextManagerServicePerimeterStatusIngressPoliciesIngressToOperations[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleAccessContextManagerServicePerimeterStatusIngressPoliciesIngressToOperationsOutputReference;
}
export interface GoogleAccessContextManagerServicePerimeterStatusIngressPoliciesIngressTo {
    /**
    * A list of resources, currently only projects in the form
  'projects/<projectnumber>', protected by this 'ServicePerimeter'
  that are allowed to be accessed by sources defined in the
  corresponding 'IngressFrom'. A request matches if it contains
  a resource in this list. If '*' is specified for resources,
  then this 'IngressTo' rule will authorize access to all
  resources inside the perimeter, provided that the request
  also matches the 'operations' field.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_access_context_manager_service_perimeter#resources GoogleAccessContextManagerServicePerimeter#resources}
    */
    readonly resources?: string[];
    /**
    * operations block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_access_context_manager_service_perimeter#operations GoogleAccessContextManagerServicePerimeter#operations}
    */
    readonly operations?: GoogleAccessContextManagerServicePerimeterStatusIngressPoliciesIngressToOperations[] | cdktf.IResolvable;
}
export declare function googleAccessContextManagerServicePerimeterStatusIngressPoliciesIngressToToTerraform(struct?: GoogleAccessContextManagerServicePerimeterStatusIngressPoliciesIngressToOutputReference | GoogleAccessContextManagerServicePerimeterStatusIngressPoliciesIngressTo): any;
export declare class GoogleAccessContextManagerServicePerimeterStatusIngressPoliciesIngressToOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleAccessContextManagerServicePerimeterStatusIngressPoliciesIngressTo | undefined;
    set internalValue(value: GoogleAccessContextManagerServicePerimeterStatusIngressPoliciesIngressTo | undefined);
    private _resources?;
    get resources(): string[];
    set resources(value: string[]);
    resetResources(): void;
    get resourcesInput(): string[] | undefined;
    private _operations;
    get operations(): GoogleAccessContextManagerServicePerimeterStatusIngressPoliciesIngressToOperationsList;
    putOperations(value: GoogleAccessContextManagerServicePerimeterStatusIngressPoliciesIngressToOperations[] | cdktf.IResolvable): void;
    resetOperations(): void;
    get operationsInput(): cdktf.IResolvable | GoogleAccessContextManagerServicePerimeterStatusIngressPoliciesIngressToOperations[] | undefined;
}
export interface GoogleAccessContextManagerServicePerimeterStatusIngressPolicies {
    /**
    * ingress_from block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_access_context_manager_service_perimeter#ingress_from GoogleAccessContextManagerServicePerimeter#ingress_from}
    */
    readonly ingressFrom?: GoogleAccessContextManagerServicePerimeterStatusIngressPoliciesIngressFrom;
    /**
    * ingress_to block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_access_context_manager_service_perimeter#ingress_to GoogleAccessContextManagerServicePerimeter#ingress_to}
    */
    readonly ingressTo?: GoogleAccessContextManagerServicePerimeterStatusIngressPoliciesIngressTo;
}
export declare function googleAccessContextManagerServicePerimeterStatusIngressPoliciesToTerraform(struct?: GoogleAccessContextManagerServicePerimeterStatusIngressPolicies | cdktf.IResolvable): any;
export declare class GoogleAccessContextManagerServicePerimeterStatusIngressPoliciesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleAccessContextManagerServicePerimeterStatusIngressPolicies | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleAccessContextManagerServicePerimeterStatusIngressPolicies | cdktf.IResolvable | undefined);
    private _ingressFrom;
    get ingressFrom(): GoogleAccessContextManagerServicePerimeterStatusIngressPoliciesIngressFromOutputReference;
    putIngressFrom(value: GoogleAccessContextManagerServicePerimeterStatusIngressPoliciesIngressFrom): void;
    resetIngressFrom(): void;
    get ingressFromInput(): GoogleAccessContextManagerServicePerimeterStatusIngressPoliciesIngressFrom | undefined;
    private _ingressTo;
    get ingressTo(): GoogleAccessContextManagerServicePerimeterStatusIngressPoliciesIngressToOutputReference;
    putIngressTo(value: GoogleAccessContextManagerServicePerimeterStatusIngressPoliciesIngressTo): void;
    resetIngressTo(): void;
    get ingressToInput(): GoogleAccessContextManagerServicePerimeterStatusIngressPoliciesIngressTo | undefined;
}
export declare class GoogleAccessContextManagerServicePerimeterStatusIngressPoliciesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleAccessContextManagerServicePerimeterStatusIngressPolicies[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleAccessContextManagerServicePerimeterStatusIngressPoliciesOutputReference;
}
export interface GoogleAccessContextManagerServicePerimeterStatusVpcAccessibleServices {
    /**
    * The list of APIs usable within the Service Perimeter.
  Must be empty unless 'enableRestriction' is True.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_access_context_manager_service_perimeter#allowed_services GoogleAccessContextManagerServicePerimeter#allowed_services}
    */
    readonly allowedServices?: string[];
    /**
    * Whether to restrict API calls within the Service Perimeter to the
  list of APIs specified in 'allowedServices'.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_access_context_manager_service_perimeter#enable_restriction GoogleAccessContextManagerServicePerimeter#enable_restriction}
    */
    readonly enableRestriction?: boolean | cdktf.IResolvable;
}
export declare function googleAccessContextManagerServicePerimeterStatusVpcAccessibleServicesToTerraform(struct?: GoogleAccessContextManagerServicePerimeterStatusVpcAccessibleServicesOutputReference | GoogleAccessContextManagerServicePerimeterStatusVpcAccessibleServices): any;
export declare class GoogleAccessContextManagerServicePerimeterStatusVpcAccessibleServicesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleAccessContextManagerServicePerimeterStatusVpcAccessibleServices | undefined;
    set internalValue(value: GoogleAccessContextManagerServicePerimeterStatusVpcAccessibleServices | undefined);
    private _allowedServices?;
    get allowedServices(): string[];
    set allowedServices(value: string[]);
    resetAllowedServices(): void;
    get allowedServicesInput(): string[] | undefined;
    private _enableRestriction?;
    get enableRestriction(): boolean | cdktf.IResolvable;
    set enableRestriction(value: boolean | cdktf.IResolvable);
    resetEnableRestriction(): void;
    get enableRestrictionInput(): boolean | cdktf.IResolvable | undefined;
}
export interface GoogleAccessContextManagerServicePerimeterStatus {
    /**
    * A list of AccessLevel resource names that allow resources within
  the ServicePerimeter to be accessed from the internet.
  AccessLevels listed must be in the same policy as this
  ServicePerimeter. Referencing a nonexistent AccessLevel is a
  syntax error. If no AccessLevel names are listed, resources within
  the perimeter can only be accessed via GCP calls with request
  origins within the perimeter. For Service Perimeter Bridge, must
  be empty.
  
  Format: accessPolicies/{policy_id}/accessLevels/{access_level_name}
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_access_context_manager_service_perimeter#access_levels GoogleAccessContextManagerServicePerimeter#access_levels}
    */
    readonly accessLevels?: string[];
    /**
    * A list of GCP resources that are inside of the service perimeter.
  Currently only projects are allowed.
  Format: projects/{project_number}
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_access_context_manager_service_perimeter#resources GoogleAccessContextManagerServicePerimeter#resources}
    */
    readonly resources?: string[];
    /**
    * GCP services that are subject to the Service Perimeter
  restrictions. Must contain a list of services. For example, if
  'storage.googleapis.com' is specified, access to the storage
  buckets inside the perimeter must meet the perimeter's access
  restrictions.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_access_context_manager_service_perimeter#restricted_services GoogleAccessContextManagerServicePerimeter#restricted_services}
    */
    readonly restrictedServices?: string[];
    /**
    * egress_policies block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_access_context_manager_service_perimeter#egress_policies GoogleAccessContextManagerServicePerimeter#egress_policies}
    */
    readonly egressPolicies?: GoogleAccessContextManagerServicePerimeterStatusEgressPolicies[] | cdktf.IResolvable;
    /**
    * ingress_policies block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_access_context_manager_service_perimeter#ingress_policies GoogleAccessContextManagerServicePerimeter#ingress_policies}
    */
    readonly ingressPolicies?: GoogleAccessContextManagerServicePerimeterStatusIngressPolicies[] | cdktf.IResolvable;
    /**
    * vpc_accessible_services block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_access_context_manager_service_perimeter#vpc_accessible_services GoogleAccessContextManagerServicePerimeter#vpc_accessible_services}
    */
    readonly vpcAccessibleServices?: GoogleAccessContextManagerServicePerimeterStatusVpcAccessibleServices;
}
export declare function googleAccessContextManagerServicePerimeterStatusToTerraform(struct?: GoogleAccessContextManagerServicePerimeterStatusOutputReference | GoogleAccessContextManagerServicePerimeterStatus): any;
export declare class GoogleAccessContextManagerServicePerimeterStatusOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleAccessContextManagerServicePerimeterStatus | undefined;
    set internalValue(value: GoogleAccessContextManagerServicePerimeterStatus | undefined);
    private _accessLevels?;
    get accessLevels(): string[];
    set accessLevels(value: string[]);
    resetAccessLevels(): void;
    get accessLevelsInput(): string[] | undefined;
    private _resources?;
    get resources(): string[];
    set resources(value: string[]);
    resetResources(): void;
    get resourcesInput(): string[] | undefined;
    private _restrictedServices?;
    get restrictedServices(): string[];
    set restrictedServices(value: string[]);
    resetRestrictedServices(): void;
    get restrictedServicesInput(): string[] | undefined;
    private _egressPolicies;
    get egressPolicies(): GoogleAccessContextManagerServicePerimeterStatusEgressPoliciesList;
    putEgressPolicies(value: GoogleAccessContextManagerServicePerimeterStatusEgressPolicies[] | cdktf.IResolvable): void;
    resetEgressPolicies(): void;
    get egressPoliciesInput(): cdktf.IResolvable | GoogleAccessContextManagerServicePerimeterStatusEgressPolicies[] | undefined;
    private _ingressPolicies;
    get ingressPolicies(): GoogleAccessContextManagerServicePerimeterStatusIngressPoliciesList;
    putIngressPolicies(value: GoogleAccessContextManagerServicePerimeterStatusIngressPolicies[] | cdktf.IResolvable): void;
    resetIngressPolicies(): void;
    get ingressPoliciesInput(): cdktf.IResolvable | GoogleAccessContextManagerServicePerimeterStatusIngressPolicies[] | undefined;
    private _vpcAccessibleServices;
    get vpcAccessibleServices(): GoogleAccessContextManagerServicePerimeterStatusVpcAccessibleServicesOutputReference;
    putVpcAccessibleServices(value: GoogleAccessContextManagerServicePerimeterStatusVpcAccessibleServices): void;
    resetVpcAccessibleServices(): void;
    get vpcAccessibleServicesInput(): GoogleAccessContextManagerServicePerimeterStatusVpcAccessibleServices | undefined;
}
export interface GoogleAccessContextManagerServicePerimeterTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_access_context_manager_service_perimeter#create GoogleAccessContextManagerServicePerimeter#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_access_context_manager_service_perimeter#delete GoogleAccessContextManagerServicePerimeter#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_access_context_manager_service_perimeter#update GoogleAccessContextManagerServicePerimeter#update}
    */
    readonly update?: string;
}
export declare function googleAccessContextManagerServicePerimeterTimeoutsToTerraform(struct?: GoogleAccessContextManagerServicePerimeterTimeoutsOutputReference | GoogleAccessContextManagerServicePerimeterTimeouts | cdktf.IResolvable): any;
export declare class GoogleAccessContextManagerServicePerimeterTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleAccessContextManagerServicePerimeterTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleAccessContextManagerServicePerimeterTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google-beta/r/google_access_context_manager_service_perimeter google_access_context_manager_service_perimeter}
*/
export declare class GoogleAccessContextManagerServicePerimeter extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_access_context_manager_service_perimeter";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google-beta/r/google_access_context_manager_service_perimeter google_access_context_manager_service_perimeter} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleAccessContextManagerServicePerimeterConfig
    */
    constructor(scope: Construct, id: string, config: GoogleAccessContextManagerServicePerimeterConfig);
    get createTime(): string;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _parent?;
    get parent(): string;
    set parent(value: string);
    get parentInput(): string | undefined;
    private _perimeterType?;
    get perimeterType(): string;
    set perimeterType(value: string);
    resetPerimeterType(): void;
    get perimeterTypeInput(): string | undefined;
    private _title?;
    get title(): string;
    set title(value: string);
    get titleInput(): string | undefined;
    get updateTime(): string;
    private _useExplicitDryRunSpec?;
    get useExplicitDryRunSpec(): boolean | cdktf.IResolvable;
    set useExplicitDryRunSpec(value: boolean | cdktf.IResolvable);
    resetUseExplicitDryRunSpec(): void;
    get useExplicitDryRunSpecInput(): boolean | cdktf.IResolvable | undefined;
    private _spec;
    get spec(): GoogleAccessContextManagerServicePerimeterSpecOutputReference;
    putSpec(value: GoogleAccessContextManagerServicePerimeterSpec): void;
    resetSpec(): void;
    get specInput(): GoogleAccessContextManagerServicePerimeterSpec | undefined;
    private _status;
    get status(): GoogleAccessContextManagerServicePerimeterStatusOutputReference;
    putStatus(value: GoogleAccessContextManagerServicePerimeterStatus): void;
    resetStatus(): void;
    get statusInput(): GoogleAccessContextManagerServicePerimeterStatus | undefined;
    private _timeouts;
    get timeouts(): GoogleAccessContextManagerServicePerimeterTimeoutsOutputReference;
    putTimeouts(value: GoogleAccessContextManagerServicePerimeterTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleAccessContextManagerServicePerimeterTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
