import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleApiGatewayApiConfigIamMemberConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_api_gateway_api_config_iam_member#api GoogleApiGatewayApiConfigIamMember#api}
    */
    readonly api: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_api_gateway_api_config_iam_member#api_config GoogleApiGatewayApiConfigIamMember#api_config}
    */
    readonly apiConfig: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_api_gateway_api_config_iam_member#id GoogleApiGatewayApiConfigIamMember#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_api_gateway_api_config_iam_member#member GoogleApiGatewayApiConfigIamMember#member}
    */
    readonly member: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_api_gateway_api_config_iam_member#project GoogleApiGatewayApiConfigIamMember#project}
    */
    readonly project?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_api_gateway_api_config_iam_member#role GoogleApiGatewayApiConfigIamMember#role}
    */
    readonly role: string;
    /**
    * condition block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_api_gateway_api_config_iam_member#condition GoogleApiGatewayApiConfigIamMember#condition}
    */
    readonly condition?: GoogleApiGatewayApiConfigIamMemberCondition;
}
export interface GoogleApiGatewayApiConfigIamMemberCondition {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_api_gateway_api_config_iam_member#description GoogleApiGatewayApiConfigIamMember#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_api_gateway_api_config_iam_member#expression GoogleApiGatewayApiConfigIamMember#expression}
    */
    readonly expression: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_api_gateway_api_config_iam_member#title GoogleApiGatewayApiConfigIamMember#title}
    */
    readonly title: string;
}
export declare function googleApiGatewayApiConfigIamMemberConditionToTerraform(struct?: GoogleApiGatewayApiConfigIamMemberConditionOutputReference | GoogleApiGatewayApiConfigIamMemberCondition): any;
export declare class GoogleApiGatewayApiConfigIamMemberConditionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleApiGatewayApiConfigIamMemberCondition | undefined;
    set internalValue(value: GoogleApiGatewayApiConfigIamMemberCondition | undefined);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _expression?;
    get expression(): string;
    set expression(value: string);
    get expressionInput(): string | undefined;
    private _title?;
    get title(): string;
    set title(value: string);
    get titleInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google-beta/r/google_api_gateway_api_config_iam_member google_api_gateway_api_config_iam_member}
*/
export declare class GoogleApiGatewayApiConfigIamMember extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_api_gateway_api_config_iam_member";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google-beta/r/google_api_gateway_api_config_iam_member google_api_gateway_api_config_iam_member} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleApiGatewayApiConfigIamMemberConfig
    */
    constructor(scope: Construct, id: string, config: GoogleApiGatewayApiConfigIamMemberConfig);
    private _api?;
    get api(): string;
    set api(value: string);
    get apiInput(): string | undefined;
    private _apiConfig?;
    get apiConfig(): string;
    set apiConfig(value: string);
    get apiConfigInput(): string | undefined;
    get etag(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _member?;
    get member(): string;
    set member(value: string);
    get memberInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _role?;
    get role(): string;
    set role(value: string);
    get roleInput(): string | undefined;
    private _condition;
    get condition(): GoogleApiGatewayApiConfigIamMemberConditionOutputReference;
    putCondition(value: GoogleApiGatewayApiConfigIamMemberCondition): void;
    resetCondition(): void;
    get conditionInput(): GoogleApiGatewayApiConfigIamMemberCondition | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
