import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleApigeeEnvgroupAttachmentConfig extends cdktf.TerraformMetaArguments {
    /**
    * The Apigee environment group associated with the Apigee environment,
  in the format 'organizations/{{org_name}}/envgroups/{{envgroup_name}}'.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_apigee_envgroup_attachment#envgroup_id GoogleApigeeEnvgroupAttachment#envgroup_id}
    */
    readonly envgroupId: string;
    /**
    * The resource ID of the environment.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_apigee_envgroup_attachment#environment GoogleApigeeEnvgroupAttachment#environment}
    */
    readonly environment: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_apigee_envgroup_attachment#id GoogleApigeeEnvgroupAttachment#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_apigee_envgroup_attachment#timeouts GoogleApigeeEnvgroupAttachment#timeouts}
    */
    readonly timeouts?: GoogleApigeeEnvgroupAttachmentTimeouts;
}
export interface GoogleApigeeEnvgroupAttachmentTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_apigee_envgroup_attachment#create GoogleApigeeEnvgroupAttachment#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_apigee_envgroup_attachment#delete GoogleApigeeEnvgroupAttachment#delete}
    */
    readonly delete?: string;
}
export declare function googleApigeeEnvgroupAttachmentTimeoutsToTerraform(struct?: GoogleApigeeEnvgroupAttachmentTimeoutsOutputReference | GoogleApigeeEnvgroupAttachmentTimeouts | cdktf.IResolvable): any;
export declare class GoogleApigeeEnvgroupAttachmentTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleApigeeEnvgroupAttachmentTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleApigeeEnvgroupAttachmentTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google-beta/r/google_apigee_envgroup_attachment google_apigee_envgroup_attachment}
*/
export declare class GoogleApigeeEnvgroupAttachment extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_apigee_envgroup_attachment";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google-beta/r/google_apigee_envgroup_attachment google_apigee_envgroup_attachment} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleApigeeEnvgroupAttachmentConfig
    */
    constructor(scope: Construct, id: string, config: GoogleApigeeEnvgroupAttachmentConfig);
    private _envgroupId?;
    get envgroupId(): string;
    set envgroupId(value: string);
    get envgroupIdInput(): string | undefined;
    private _environment?;
    get environment(): string;
    set environment(value: string);
    get environmentInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get name(): string;
    private _timeouts;
    get timeouts(): GoogleApigeeEnvgroupAttachmentTimeoutsOutputReference;
    putTimeouts(value: GoogleApigeeEnvgroupAttachmentTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleApigeeEnvgroupAttachmentTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
