import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleApigeeEnvironmentIamMemberConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_apigee_environment_iam_member#env_id GoogleApigeeEnvironmentIamMember#env_id}
    */
    readonly envId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_apigee_environment_iam_member#id GoogleApigeeEnvironmentIamMember#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_apigee_environment_iam_member#member GoogleApigeeEnvironmentIamMember#member}
    */
    readonly member: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_apigee_environment_iam_member#org_id GoogleApigeeEnvironmentIamMember#org_id}
    */
    readonly orgId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_apigee_environment_iam_member#role GoogleApigeeEnvironmentIamMember#role}
    */
    readonly role: string;
    /**
    * condition block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_apigee_environment_iam_member#condition GoogleApigeeEnvironmentIamMember#condition}
    */
    readonly condition?: GoogleApigeeEnvironmentIamMemberCondition;
}
export interface GoogleApigeeEnvironmentIamMemberCondition {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_apigee_environment_iam_member#description GoogleApigeeEnvironmentIamMember#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_apigee_environment_iam_member#expression GoogleApigeeEnvironmentIamMember#expression}
    */
    readonly expression: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_apigee_environment_iam_member#title GoogleApigeeEnvironmentIamMember#title}
    */
    readonly title: string;
}
export declare function googleApigeeEnvironmentIamMemberConditionToTerraform(struct?: GoogleApigeeEnvironmentIamMemberConditionOutputReference | GoogleApigeeEnvironmentIamMemberCondition): any;
export declare class GoogleApigeeEnvironmentIamMemberConditionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleApigeeEnvironmentIamMemberCondition | undefined;
    set internalValue(value: GoogleApigeeEnvironmentIamMemberCondition | undefined);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _expression?;
    get expression(): string;
    set expression(value: string);
    get expressionInput(): string | undefined;
    private _title?;
    get title(): string;
    set title(value: string);
    get titleInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google-beta/r/google_apigee_environment_iam_member google_apigee_environment_iam_member}
*/
export declare class GoogleApigeeEnvironmentIamMember extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_apigee_environment_iam_member";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google-beta/r/google_apigee_environment_iam_member google_apigee_environment_iam_member} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleApigeeEnvironmentIamMemberConfig
    */
    constructor(scope: Construct, id: string, config: GoogleApigeeEnvironmentIamMemberConfig);
    private _envId?;
    get envId(): string;
    set envId(value: string);
    get envIdInput(): string | undefined;
    get etag(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _member?;
    get member(): string;
    set member(value: string);
    get memberInput(): string | undefined;
    private _orgId?;
    get orgId(): string;
    set orgId(value: string);
    get orgIdInput(): string | undefined;
    private _role?;
    get role(): string;
    set role(value: string);
    get roleInput(): string | undefined;
    private _condition;
    get condition(): GoogleApigeeEnvironmentIamMemberConditionOutputReference;
    putCondition(value: GoogleApigeeEnvironmentIamMemberCondition): void;
    resetCondition(): void;
    get conditionInput(): GoogleApigeeEnvironmentIamMemberCondition | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
