import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleApigeeEnvironmentConfig extends cdktf.TerraformMetaArguments {
    /**
    * Optional. API Proxy type supported by the environment. The type can be set when creating
  the Environment and cannot be changed. Possible values: ["API_PROXY_TYPE_UNSPECIFIED", "PROGRAMMABLE", "CONFIGURABLE"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_apigee_environment#api_proxy_type GoogleApigeeEnvironment#api_proxy_type}
    */
    readonly apiProxyType?: string;
    /**
    * Optional. Deployment type supported by the environment. The deployment type can be
  set when creating the environment and cannot be changed. When you enable archive
  deployment, you will be prevented from performing a subset of actions within the
  environment, including:
  Managing the deployment of API proxy or shared flow revisions;
  Creating, updating, or deleting resource files;
  Creating, updating, or deleting target servers. Possible values: ["DEPLOYMENT_TYPE_UNSPECIFIED", "PROXY", "ARCHIVE"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_apigee_environment#deployment_type GoogleApigeeEnvironment#deployment_type}
    */
    readonly deploymentType?: string;
    /**
    * Description of the environment.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_apigee_environment#description GoogleApigeeEnvironment#description}
    */
    readonly description?: string;
    /**
    * Display name of the environment.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_apigee_environment#display_name GoogleApigeeEnvironment#display_name}
    */
    readonly displayName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_apigee_environment#id GoogleApigeeEnvironment#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The resource ID of the environment.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_apigee_environment#name GoogleApigeeEnvironment#name}
    */
    readonly name: string;
    /**
    * The Apigee Organization associated with the Apigee environment,
  in the format 'organizations/{{org_name}}'.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_apigee_environment#org_id GoogleApigeeEnvironment#org_id}
    */
    readonly orgId: string;
    /**
    * node_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_apigee_environment#node_config GoogleApigeeEnvironment#node_config}
    */
    readonly nodeConfig?: GoogleApigeeEnvironmentNodeConfig;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_apigee_environment#timeouts GoogleApigeeEnvironment#timeouts}
    */
    readonly timeouts?: GoogleApigeeEnvironmentTimeouts;
}
export interface GoogleApigeeEnvironmentNodeConfig {
    /**
    * The maximum total number of gateway nodes that the is reserved for all instances that
  has the specified environment. If not specified, the default is determined by the
  recommended maximum number of nodes for that gateway.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_apigee_environment#max_node_count GoogleApigeeEnvironment#max_node_count}
    */
    readonly maxNodeCount?: string;
    /**
    * The minimum total number of gateway nodes that the is reserved for all instances that
  has the specified environment. If not specified, the default is determined by the
  recommended minimum number of nodes for that gateway.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_apigee_environment#min_node_count GoogleApigeeEnvironment#min_node_count}
    */
    readonly minNodeCount?: string;
}
export declare function googleApigeeEnvironmentNodeConfigToTerraform(struct?: GoogleApigeeEnvironmentNodeConfigOutputReference | GoogleApigeeEnvironmentNodeConfig): any;
export declare class GoogleApigeeEnvironmentNodeConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleApigeeEnvironmentNodeConfig | undefined;
    set internalValue(value: GoogleApigeeEnvironmentNodeConfig | undefined);
    get currentAggregateNodeCount(): string;
    private _maxNodeCount?;
    get maxNodeCount(): string;
    set maxNodeCount(value: string);
    resetMaxNodeCount(): void;
    get maxNodeCountInput(): string | undefined;
    private _minNodeCount?;
    get minNodeCount(): string;
    set minNodeCount(value: string);
    resetMinNodeCount(): void;
    get minNodeCountInput(): string | undefined;
}
export interface GoogleApigeeEnvironmentTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_apigee_environment#create GoogleApigeeEnvironment#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_apigee_environment#delete GoogleApigeeEnvironment#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_apigee_environment#update GoogleApigeeEnvironment#update}
    */
    readonly update?: string;
}
export declare function googleApigeeEnvironmentTimeoutsToTerraform(struct?: GoogleApigeeEnvironmentTimeoutsOutputReference | GoogleApigeeEnvironmentTimeouts | cdktf.IResolvable): any;
export declare class GoogleApigeeEnvironmentTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleApigeeEnvironmentTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleApigeeEnvironmentTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google-beta/r/google_apigee_environment google_apigee_environment}
*/
export declare class GoogleApigeeEnvironment extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_apigee_environment";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google-beta/r/google_apigee_environment google_apigee_environment} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleApigeeEnvironmentConfig
    */
    constructor(scope: Construct, id: string, config: GoogleApigeeEnvironmentConfig);
    private _apiProxyType?;
    get apiProxyType(): string;
    set apiProxyType(value: string);
    resetApiProxyType(): void;
    get apiProxyTypeInput(): string | undefined;
    private _deploymentType?;
    get deploymentType(): string;
    set deploymentType(value: string);
    resetDeploymentType(): void;
    get deploymentTypeInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    resetDisplayName(): void;
    get displayNameInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _orgId?;
    get orgId(): string;
    set orgId(value: string);
    get orgIdInput(): string | undefined;
    private _nodeConfig;
    get nodeConfig(): GoogleApigeeEnvironmentNodeConfigOutputReference;
    putNodeConfig(value: GoogleApigeeEnvironmentNodeConfig): void;
    resetNodeConfig(): void;
    get nodeConfigInput(): GoogleApigeeEnvironmentNodeConfig | undefined;
    private _timeouts;
    get timeouts(): GoogleApigeeEnvironmentTimeoutsOutputReference;
    putTimeouts(value: GoogleApigeeEnvironmentTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleApigeeEnvironmentTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
