import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleApikeysKeyConfig extends cdktf.TerraformMetaArguments {
    /**
    * Human-readable display name of this API key. Modifiable by user.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_apikeys_key#display_name GoogleApikeysKey#display_name}
    */
    readonly displayName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_apikeys_key#id GoogleApikeysKey#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The resource name of the key. The name must be unique within the project, must conform with RFC-1034, is restricted to lower-cased letters, and has a maximum length of 63 characters. In another word, the name must match the regular expression: `[a-z]([a-z0-9-]{0,61}[a-z0-9])?`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_apikeys_key#name GoogleApikeysKey#name}
    */
    readonly name: string;
    /**
    * The project for the resource
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_apikeys_key#project GoogleApikeysKey#project}
    */
    readonly project?: string;
    /**
    * restrictions block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_apikeys_key#restrictions GoogleApikeysKey#restrictions}
    */
    readonly restrictions?: GoogleApikeysKeyRestrictions;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_apikeys_key#timeouts GoogleApikeysKey#timeouts}
    */
    readonly timeouts?: GoogleApikeysKeyTimeouts;
}
export interface GoogleApikeysKeyRestrictionsAndroidKeyRestrictionsAllowedApplications {
    /**
    * The package name of the application.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_apikeys_key#package_name GoogleApikeysKey#package_name}
    */
    readonly packageName: string;
    /**
    * The SHA1 fingerprint of the application. For example, both sha1 formats are acceptable : DA:39:A3:EE:5E:6B:4B:0D:32:55:BF:EF:95:60:18:90:AF:D8:07:09 or DA39A3EE5E6B4B0D3255BFEF95601890AFD80709. Output format is the latter.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_apikeys_key#sha1_fingerprint GoogleApikeysKey#sha1_fingerprint}
    */
    readonly sha1Fingerprint: string;
}
export declare function googleApikeysKeyRestrictionsAndroidKeyRestrictionsAllowedApplicationsToTerraform(struct?: GoogleApikeysKeyRestrictionsAndroidKeyRestrictionsAllowedApplications | cdktf.IResolvable): any;
export declare class GoogleApikeysKeyRestrictionsAndroidKeyRestrictionsAllowedApplicationsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleApikeysKeyRestrictionsAndroidKeyRestrictionsAllowedApplications | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleApikeysKeyRestrictionsAndroidKeyRestrictionsAllowedApplications | cdktf.IResolvable | undefined);
    private _packageName?;
    get packageName(): string;
    set packageName(value: string);
    get packageNameInput(): string | undefined;
    private _sha1Fingerprint?;
    get sha1Fingerprint(): string;
    set sha1Fingerprint(value: string);
    get sha1FingerprintInput(): string | undefined;
}
export declare class GoogleApikeysKeyRestrictionsAndroidKeyRestrictionsAllowedApplicationsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleApikeysKeyRestrictionsAndroidKeyRestrictionsAllowedApplications[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleApikeysKeyRestrictionsAndroidKeyRestrictionsAllowedApplicationsOutputReference;
}
export interface GoogleApikeysKeyRestrictionsAndroidKeyRestrictions {
    /**
    * allowed_applications block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_apikeys_key#allowed_applications GoogleApikeysKey#allowed_applications}
    */
    readonly allowedApplications: GoogleApikeysKeyRestrictionsAndroidKeyRestrictionsAllowedApplications[] | cdktf.IResolvable;
}
export declare function googleApikeysKeyRestrictionsAndroidKeyRestrictionsToTerraform(struct?: GoogleApikeysKeyRestrictionsAndroidKeyRestrictionsOutputReference | GoogleApikeysKeyRestrictionsAndroidKeyRestrictions): any;
export declare class GoogleApikeysKeyRestrictionsAndroidKeyRestrictionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleApikeysKeyRestrictionsAndroidKeyRestrictions | undefined;
    set internalValue(value: GoogleApikeysKeyRestrictionsAndroidKeyRestrictions | undefined);
    private _allowedApplications;
    get allowedApplications(): GoogleApikeysKeyRestrictionsAndroidKeyRestrictionsAllowedApplicationsList;
    putAllowedApplications(value: GoogleApikeysKeyRestrictionsAndroidKeyRestrictionsAllowedApplications[] | cdktf.IResolvable): void;
    get allowedApplicationsInput(): cdktf.IResolvable | GoogleApikeysKeyRestrictionsAndroidKeyRestrictionsAllowedApplications[] | undefined;
}
export interface GoogleApikeysKeyRestrictionsApiTargets {
    /**
    * Optional. List of one or more methods that can be called. If empty, all methods for the service are allowed. A wildcard (*) can be used as the last symbol. Valid examples: `google.cloud.translate.v2.TranslateService.GetSupportedLanguage` `TranslateText` `Get*` `translate.googleapis.com.Get*`
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_apikeys_key#methods GoogleApikeysKey#methods}
    */
    readonly methods?: string[];
    /**
    * The service for this restriction. It should be the canonical service name, for example: `translate.googleapis.com`. You can use `gcloud services list` to get a list of services that are enabled in the project.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_apikeys_key#service GoogleApikeysKey#service}
    */
    readonly service: string;
}
export declare function googleApikeysKeyRestrictionsApiTargetsToTerraform(struct?: GoogleApikeysKeyRestrictionsApiTargets | cdktf.IResolvable): any;
export declare class GoogleApikeysKeyRestrictionsApiTargetsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleApikeysKeyRestrictionsApiTargets | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleApikeysKeyRestrictionsApiTargets | cdktf.IResolvable | undefined);
    private _methods?;
    get methods(): string[];
    set methods(value: string[]);
    resetMethods(): void;
    get methodsInput(): string[] | undefined;
    private _service?;
    get service(): string;
    set service(value: string);
    get serviceInput(): string | undefined;
}
export declare class GoogleApikeysKeyRestrictionsApiTargetsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleApikeysKeyRestrictionsApiTargets[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleApikeysKeyRestrictionsApiTargetsOutputReference;
}
export interface GoogleApikeysKeyRestrictionsBrowserKeyRestrictions {
    /**
    * A list of regular expressions for the referrer URLs that are allowed to make API calls with this key.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_apikeys_key#allowed_referrers GoogleApikeysKey#allowed_referrers}
    */
    readonly allowedReferrers: string[];
}
export declare function googleApikeysKeyRestrictionsBrowserKeyRestrictionsToTerraform(struct?: GoogleApikeysKeyRestrictionsBrowserKeyRestrictionsOutputReference | GoogleApikeysKeyRestrictionsBrowserKeyRestrictions): any;
export declare class GoogleApikeysKeyRestrictionsBrowserKeyRestrictionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleApikeysKeyRestrictionsBrowserKeyRestrictions | undefined;
    set internalValue(value: GoogleApikeysKeyRestrictionsBrowserKeyRestrictions | undefined);
    private _allowedReferrers?;
    get allowedReferrers(): string[];
    set allowedReferrers(value: string[]);
    get allowedReferrersInput(): string[] | undefined;
}
export interface GoogleApikeysKeyRestrictionsIosKeyRestrictions {
    /**
    * A list of bundle IDs that are allowed when making API calls with this key.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_apikeys_key#allowed_bundle_ids GoogleApikeysKey#allowed_bundle_ids}
    */
    readonly allowedBundleIds: string[];
}
export declare function googleApikeysKeyRestrictionsIosKeyRestrictionsToTerraform(struct?: GoogleApikeysKeyRestrictionsIosKeyRestrictionsOutputReference | GoogleApikeysKeyRestrictionsIosKeyRestrictions): any;
export declare class GoogleApikeysKeyRestrictionsIosKeyRestrictionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleApikeysKeyRestrictionsIosKeyRestrictions | undefined;
    set internalValue(value: GoogleApikeysKeyRestrictionsIosKeyRestrictions | undefined);
    private _allowedBundleIds?;
    get allowedBundleIds(): string[];
    set allowedBundleIds(value: string[]);
    get allowedBundleIdsInput(): string[] | undefined;
}
export interface GoogleApikeysKeyRestrictionsServerKeyRestrictions {
    /**
    * A list of the caller IP addresses that are allowed to make API calls with this key.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_apikeys_key#allowed_ips GoogleApikeysKey#allowed_ips}
    */
    readonly allowedIps: string[];
}
export declare function googleApikeysKeyRestrictionsServerKeyRestrictionsToTerraform(struct?: GoogleApikeysKeyRestrictionsServerKeyRestrictionsOutputReference | GoogleApikeysKeyRestrictionsServerKeyRestrictions): any;
export declare class GoogleApikeysKeyRestrictionsServerKeyRestrictionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleApikeysKeyRestrictionsServerKeyRestrictions | undefined;
    set internalValue(value: GoogleApikeysKeyRestrictionsServerKeyRestrictions | undefined);
    private _allowedIps?;
    get allowedIps(): string[];
    set allowedIps(value: string[]);
    get allowedIpsInput(): string[] | undefined;
}
export interface GoogleApikeysKeyRestrictions {
    /**
    * android_key_restrictions block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_apikeys_key#android_key_restrictions GoogleApikeysKey#android_key_restrictions}
    */
    readonly androidKeyRestrictions?: GoogleApikeysKeyRestrictionsAndroidKeyRestrictions;
    /**
    * api_targets block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_apikeys_key#api_targets GoogleApikeysKey#api_targets}
    */
    readonly apiTargets?: GoogleApikeysKeyRestrictionsApiTargets[] | cdktf.IResolvable;
    /**
    * browser_key_restrictions block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_apikeys_key#browser_key_restrictions GoogleApikeysKey#browser_key_restrictions}
    */
    readonly browserKeyRestrictions?: GoogleApikeysKeyRestrictionsBrowserKeyRestrictions;
    /**
    * ios_key_restrictions block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_apikeys_key#ios_key_restrictions GoogleApikeysKey#ios_key_restrictions}
    */
    readonly iosKeyRestrictions?: GoogleApikeysKeyRestrictionsIosKeyRestrictions;
    /**
    * server_key_restrictions block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_apikeys_key#server_key_restrictions GoogleApikeysKey#server_key_restrictions}
    */
    readonly serverKeyRestrictions?: GoogleApikeysKeyRestrictionsServerKeyRestrictions;
}
export declare function googleApikeysKeyRestrictionsToTerraform(struct?: GoogleApikeysKeyRestrictionsOutputReference | GoogleApikeysKeyRestrictions): any;
export declare class GoogleApikeysKeyRestrictionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleApikeysKeyRestrictions | undefined;
    set internalValue(value: GoogleApikeysKeyRestrictions | undefined);
    private _androidKeyRestrictions;
    get androidKeyRestrictions(): GoogleApikeysKeyRestrictionsAndroidKeyRestrictionsOutputReference;
    putAndroidKeyRestrictions(value: GoogleApikeysKeyRestrictionsAndroidKeyRestrictions): void;
    resetAndroidKeyRestrictions(): void;
    get androidKeyRestrictionsInput(): GoogleApikeysKeyRestrictionsAndroidKeyRestrictions | undefined;
    private _apiTargets;
    get apiTargets(): GoogleApikeysKeyRestrictionsApiTargetsList;
    putApiTargets(value: GoogleApikeysKeyRestrictionsApiTargets[] | cdktf.IResolvable): void;
    resetApiTargets(): void;
    get apiTargetsInput(): cdktf.IResolvable | GoogleApikeysKeyRestrictionsApiTargets[] | undefined;
    private _browserKeyRestrictions;
    get browserKeyRestrictions(): GoogleApikeysKeyRestrictionsBrowserKeyRestrictionsOutputReference;
    putBrowserKeyRestrictions(value: GoogleApikeysKeyRestrictionsBrowserKeyRestrictions): void;
    resetBrowserKeyRestrictions(): void;
    get browserKeyRestrictionsInput(): GoogleApikeysKeyRestrictionsBrowserKeyRestrictions | undefined;
    private _iosKeyRestrictions;
    get iosKeyRestrictions(): GoogleApikeysKeyRestrictionsIosKeyRestrictionsOutputReference;
    putIosKeyRestrictions(value: GoogleApikeysKeyRestrictionsIosKeyRestrictions): void;
    resetIosKeyRestrictions(): void;
    get iosKeyRestrictionsInput(): GoogleApikeysKeyRestrictionsIosKeyRestrictions | undefined;
    private _serverKeyRestrictions;
    get serverKeyRestrictions(): GoogleApikeysKeyRestrictionsServerKeyRestrictionsOutputReference;
    putServerKeyRestrictions(value: GoogleApikeysKeyRestrictionsServerKeyRestrictions): void;
    resetServerKeyRestrictions(): void;
    get serverKeyRestrictionsInput(): GoogleApikeysKeyRestrictionsServerKeyRestrictions | undefined;
}
export interface GoogleApikeysKeyTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_apikeys_key#create GoogleApikeysKey#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_apikeys_key#delete GoogleApikeysKey#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_apikeys_key#update GoogleApikeysKey#update}
    */
    readonly update?: string;
}
export declare function googleApikeysKeyTimeoutsToTerraform(struct?: GoogleApikeysKeyTimeoutsOutputReference | GoogleApikeysKeyTimeouts | cdktf.IResolvable): any;
export declare class GoogleApikeysKeyTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleApikeysKeyTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleApikeysKeyTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google-beta/r/google_apikeys_key google_apikeys_key}
*/
export declare class GoogleApikeysKey extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_apikeys_key";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google-beta/r/google_apikeys_key google_apikeys_key} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleApikeysKeyConfig
    */
    constructor(scope: Construct, id: string, config: GoogleApikeysKeyConfig);
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    resetDisplayName(): void;
    get displayNameInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get keyString(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    get uid(): string;
    private _restrictions;
    get restrictions(): GoogleApikeysKeyRestrictionsOutputReference;
    putRestrictions(value: GoogleApikeysKeyRestrictions): void;
    resetRestrictions(): void;
    get restrictionsInput(): GoogleApikeysKeyRestrictions | undefined;
    private _timeouts;
    get timeouts(): GoogleApikeysKeyTimeoutsOutputReference;
    putTimeouts(value: GoogleApikeysKeyTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleApikeysKeyTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
