import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleAppEngineStandardAppVersionConfig extends cdktf.TerraformMetaArguments {
    /**
    * Allows App Engine second generation runtimes to access the legacy bundled services.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_app_engine_standard_app_version#app_engine_apis GoogleAppEngineStandardAppVersion#app_engine_apis}
    */
    readonly appEngineApis?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_app_engine_standard_app_version#delete_service_on_destroy GoogleAppEngineStandardAppVersion#delete_service_on_destroy}
    */
    readonly deleteServiceOnDestroy?: boolean | cdktf.IResolvable;
    /**
    * Environment variables available to the application.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_app_engine_standard_app_version#env_variables GoogleAppEngineStandardAppVersion#env_variables}
    */
    readonly envVariables?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_app_engine_standard_app_version#id GoogleAppEngineStandardAppVersion#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * A list of the types of messages that this application is able to receive. Possible values: ["INBOUND_SERVICE_MAIL", "INBOUND_SERVICE_MAIL_BOUNCE", "INBOUND_SERVICE_XMPP_ERROR", "INBOUND_SERVICE_XMPP_MESSAGE", "INBOUND_SERVICE_XMPP_SUBSCRIBE", "INBOUND_SERVICE_XMPP_PRESENCE", "INBOUND_SERVICE_CHANNEL_PRESENCE", "INBOUND_SERVICE_WARMUP"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_app_engine_standard_app_version#inbound_services GoogleAppEngineStandardAppVersion#inbound_services}
    */
    readonly inboundServices?: string[];
    /**
    * Instance class that is used to run this version. Valid values are
  AutomaticScaling: F1, F2, F4, F4_1G
  BasicScaling or ManualScaling: B1, B2, B4, B4_1G, B8
  Defaults to F1 for AutomaticScaling and B2 for ManualScaling and BasicScaling. If no scaling is specified, AutomaticScaling is chosen.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_app_engine_standard_app_version#instance_class GoogleAppEngineStandardAppVersion#instance_class}
    */
    readonly instanceClass?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_app_engine_standard_app_version#noop_on_destroy GoogleAppEngineStandardAppVersion#noop_on_destroy}
    */
    readonly noopOnDestroy?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_app_engine_standard_app_version#project GoogleAppEngineStandardAppVersion#project}
    */
    readonly project?: string;
    /**
    * Desired runtime. Example python27.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_app_engine_standard_app_version#runtime GoogleAppEngineStandardAppVersion#runtime}
    */
    readonly runtime: string;
    /**
    * The version of the API in the given runtime environment.
  Please see the app.yaml reference for valid values at 'https://cloud.google.com/appengine/docs/standard/<language>/config/appref'\
  Substitute '<language>' with 'python', 'java', 'php', 'ruby', 'go' or 'nodejs'.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_app_engine_standard_app_version#runtime_api_version GoogleAppEngineStandardAppVersion#runtime_api_version}
    */
    readonly runtimeApiVersion?: string;
    /**
    * AppEngine service resource
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_app_engine_standard_app_version#service GoogleAppEngineStandardAppVersion#service}
    */
    readonly service: string;
    /**
    * Whether multiple requests can be dispatched to this version at once.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_app_engine_standard_app_version#threadsafe GoogleAppEngineStandardAppVersion#threadsafe}
    */
    readonly threadsafe?: boolean | cdktf.IResolvable;
    /**
    * Relative name of the version within the service. For example, 'v1'. Version names can contain only lowercase letters, numbers, or hyphens. Reserved names,"default", "latest", and any name with the prefix "ah-".
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_app_engine_standard_app_version#version_id GoogleAppEngineStandardAppVersion#version_id}
    */
    readonly versionId?: string;
    /**
    * automatic_scaling block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_app_engine_standard_app_version#automatic_scaling GoogleAppEngineStandardAppVersion#automatic_scaling}
    */
    readonly automaticScaling?: GoogleAppEngineStandardAppVersionAutomaticScaling;
    /**
    * basic_scaling block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_app_engine_standard_app_version#basic_scaling GoogleAppEngineStandardAppVersion#basic_scaling}
    */
    readonly basicScaling?: GoogleAppEngineStandardAppVersionBasicScaling;
    /**
    * deployment block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_app_engine_standard_app_version#deployment GoogleAppEngineStandardAppVersion#deployment}
    */
    readonly deployment: GoogleAppEngineStandardAppVersionDeployment;
    /**
    * entrypoint block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_app_engine_standard_app_version#entrypoint GoogleAppEngineStandardAppVersion#entrypoint}
    */
    readonly entrypoint: GoogleAppEngineStandardAppVersionEntrypoint;
    /**
    * handlers block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_app_engine_standard_app_version#handlers GoogleAppEngineStandardAppVersion#handlers}
    */
    readonly handlers?: GoogleAppEngineStandardAppVersionHandlers[] | cdktf.IResolvable;
    /**
    * libraries block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_app_engine_standard_app_version#libraries GoogleAppEngineStandardAppVersion#libraries}
    */
    readonly libraries?: GoogleAppEngineStandardAppVersionLibraries[] | cdktf.IResolvable;
    /**
    * manual_scaling block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_app_engine_standard_app_version#manual_scaling GoogleAppEngineStandardAppVersion#manual_scaling}
    */
    readonly manualScaling?: GoogleAppEngineStandardAppVersionManualScaling;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_app_engine_standard_app_version#timeouts GoogleAppEngineStandardAppVersion#timeouts}
    */
    readonly timeouts?: GoogleAppEngineStandardAppVersionTimeouts;
    /**
    * vpc_access_connector block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_app_engine_standard_app_version#vpc_access_connector GoogleAppEngineStandardAppVersion#vpc_access_connector}
    */
    readonly vpcAccessConnector?: GoogleAppEngineStandardAppVersionVpcAccessConnector;
}
export interface GoogleAppEngineStandardAppVersionAutomaticScalingStandardSchedulerSettings {
    /**
    * Maximum number of instances to run for this version. Set to zero to disable maxInstances configuration.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_app_engine_standard_app_version#max_instances GoogleAppEngineStandardAppVersion#max_instances}
    */
    readonly maxInstances?: number;
    /**
    * Minimum number of instances to run for this version. Set to zero to disable minInstances configuration.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_app_engine_standard_app_version#min_instances GoogleAppEngineStandardAppVersion#min_instances}
    */
    readonly minInstances?: number;
    /**
    * Target CPU utilization ratio to maintain when scaling. Should be a value in the range [0.50, 0.95], zero, or a negative value.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_app_engine_standard_app_version#target_cpu_utilization GoogleAppEngineStandardAppVersion#target_cpu_utilization}
    */
    readonly targetCpuUtilization?: number;
    /**
    * Target throughput utilization ratio to maintain when scaling. Should be a value in the range [0.50, 0.95], zero, or a negative value.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_app_engine_standard_app_version#target_throughput_utilization GoogleAppEngineStandardAppVersion#target_throughput_utilization}
    */
    readonly targetThroughputUtilization?: number;
}
export declare function googleAppEngineStandardAppVersionAutomaticScalingStandardSchedulerSettingsToTerraform(struct?: GoogleAppEngineStandardAppVersionAutomaticScalingStandardSchedulerSettingsOutputReference | GoogleAppEngineStandardAppVersionAutomaticScalingStandardSchedulerSettings): any;
export declare class GoogleAppEngineStandardAppVersionAutomaticScalingStandardSchedulerSettingsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleAppEngineStandardAppVersionAutomaticScalingStandardSchedulerSettings | undefined;
    set internalValue(value: GoogleAppEngineStandardAppVersionAutomaticScalingStandardSchedulerSettings | undefined);
    private _maxInstances?;
    get maxInstances(): number;
    set maxInstances(value: number);
    resetMaxInstances(): void;
    get maxInstancesInput(): number | undefined;
    private _minInstances?;
    get minInstances(): number;
    set minInstances(value: number);
    resetMinInstances(): void;
    get minInstancesInput(): number | undefined;
    private _targetCpuUtilization?;
    get targetCpuUtilization(): number;
    set targetCpuUtilization(value: number);
    resetTargetCpuUtilization(): void;
    get targetCpuUtilizationInput(): number | undefined;
    private _targetThroughputUtilization?;
    get targetThroughputUtilization(): number;
    set targetThroughputUtilization(value: number);
    resetTargetThroughputUtilization(): void;
    get targetThroughputUtilizationInput(): number | undefined;
}
export interface GoogleAppEngineStandardAppVersionAutomaticScaling {
    /**
    * Number of concurrent requests an automatic scaling instance can accept before the scheduler spawns a new instance.
  
  Defaults to a runtime-specific value.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_app_engine_standard_app_version#max_concurrent_requests GoogleAppEngineStandardAppVersion#max_concurrent_requests}
    */
    readonly maxConcurrentRequests?: number;
    /**
    * Maximum number of idle instances that should be maintained for this version.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_app_engine_standard_app_version#max_idle_instances GoogleAppEngineStandardAppVersion#max_idle_instances}
    */
    readonly maxIdleInstances?: number;
    /**
    * Maximum amount of time that a request should wait in the pending queue before starting a new instance to handle it.
  A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s".
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_app_engine_standard_app_version#max_pending_latency GoogleAppEngineStandardAppVersion#max_pending_latency}
    */
    readonly maxPendingLatency?: string;
    /**
    * Minimum number of idle instances that should be maintained for this version. Only applicable for the default version of a service.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_app_engine_standard_app_version#min_idle_instances GoogleAppEngineStandardAppVersion#min_idle_instances}
    */
    readonly minIdleInstances?: number;
    /**
    * Minimum amount of time a request should wait in the pending queue before starting a new instance to handle it.
  A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s".
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_app_engine_standard_app_version#min_pending_latency GoogleAppEngineStandardAppVersion#min_pending_latency}
    */
    readonly minPendingLatency?: string;
    /**
    * standard_scheduler_settings block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_app_engine_standard_app_version#standard_scheduler_settings GoogleAppEngineStandardAppVersion#standard_scheduler_settings}
    */
    readonly standardSchedulerSettings?: GoogleAppEngineStandardAppVersionAutomaticScalingStandardSchedulerSettings;
}
export declare function googleAppEngineStandardAppVersionAutomaticScalingToTerraform(struct?: GoogleAppEngineStandardAppVersionAutomaticScalingOutputReference | GoogleAppEngineStandardAppVersionAutomaticScaling): any;
export declare class GoogleAppEngineStandardAppVersionAutomaticScalingOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleAppEngineStandardAppVersionAutomaticScaling | undefined;
    set internalValue(value: GoogleAppEngineStandardAppVersionAutomaticScaling | undefined);
    private _maxConcurrentRequests?;
    get maxConcurrentRequests(): number;
    set maxConcurrentRequests(value: number);
    resetMaxConcurrentRequests(): void;
    get maxConcurrentRequestsInput(): number | undefined;
    private _maxIdleInstances?;
    get maxIdleInstances(): number;
    set maxIdleInstances(value: number);
    resetMaxIdleInstances(): void;
    get maxIdleInstancesInput(): number | undefined;
    private _maxPendingLatency?;
    get maxPendingLatency(): string;
    set maxPendingLatency(value: string);
    resetMaxPendingLatency(): void;
    get maxPendingLatencyInput(): string | undefined;
    private _minIdleInstances?;
    get minIdleInstances(): number;
    set minIdleInstances(value: number);
    resetMinIdleInstances(): void;
    get minIdleInstancesInput(): number | undefined;
    private _minPendingLatency?;
    get minPendingLatency(): string;
    set minPendingLatency(value: string);
    resetMinPendingLatency(): void;
    get minPendingLatencyInput(): string | undefined;
    private _standardSchedulerSettings;
    get standardSchedulerSettings(): GoogleAppEngineStandardAppVersionAutomaticScalingStandardSchedulerSettingsOutputReference;
    putStandardSchedulerSettings(value: GoogleAppEngineStandardAppVersionAutomaticScalingStandardSchedulerSettings): void;
    resetStandardSchedulerSettings(): void;
    get standardSchedulerSettingsInput(): GoogleAppEngineStandardAppVersionAutomaticScalingStandardSchedulerSettings | undefined;
}
export interface GoogleAppEngineStandardAppVersionBasicScaling {
    /**
    * Duration of time after the last request that an instance must wait before the instance is shut down.
  A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s". Defaults to 900s.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_app_engine_standard_app_version#idle_timeout GoogleAppEngineStandardAppVersion#idle_timeout}
    */
    readonly idleTimeout?: string;
    /**
    * Maximum number of instances to create for this version. Must be in the range [1.0, 200.0].
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_app_engine_standard_app_version#max_instances GoogleAppEngineStandardAppVersion#max_instances}
    */
    readonly maxInstances: number;
}
export declare function googleAppEngineStandardAppVersionBasicScalingToTerraform(struct?: GoogleAppEngineStandardAppVersionBasicScalingOutputReference | GoogleAppEngineStandardAppVersionBasicScaling): any;
export declare class GoogleAppEngineStandardAppVersionBasicScalingOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleAppEngineStandardAppVersionBasicScaling | undefined;
    set internalValue(value: GoogleAppEngineStandardAppVersionBasicScaling | undefined);
    private _idleTimeout?;
    get idleTimeout(): string;
    set idleTimeout(value: string);
    resetIdleTimeout(): void;
    get idleTimeoutInput(): string | undefined;
    private _maxInstances?;
    get maxInstances(): number;
    set maxInstances(value: number);
    get maxInstancesInput(): number | undefined;
}
export interface GoogleAppEngineStandardAppVersionDeploymentFiles {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_app_engine_standard_app_version#name GoogleAppEngineStandardAppVersion#name}
    */
    readonly name: string;
    /**
    * SHA1 checksum of the file
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_app_engine_standard_app_version#sha1_sum GoogleAppEngineStandardAppVersion#sha1_sum}
    */
    readonly sha1Sum?: string;
    /**
    * Source URL
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_app_engine_standard_app_version#source_url GoogleAppEngineStandardAppVersion#source_url}
    */
    readonly sourceUrl: string;
}
export declare function googleAppEngineStandardAppVersionDeploymentFilesToTerraform(struct?: GoogleAppEngineStandardAppVersionDeploymentFiles | cdktf.IResolvable): any;
export declare class GoogleAppEngineStandardAppVersionDeploymentFilesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleAppEngineStandardAppVersionDeploymentFiles | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleAppEngineStandardAppVersionDeploymentFiles | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _sha1Sum?;
    get sha1Sum(): string;
    set sha1Sum(value: string);
    resetSha1Sum(): void;
    get sha1SumInput(): string | undefined;
    private _sourceUrl?;
    get sourceUrl(): string;
    set sourceUrl(value: string);
    get sourceUrlInput(): string | undefined;
}
export declare class GoogleAppEngineStandardAppVersionDeploymentFilesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleAppEngineStandardAppVersionDeploymentFiles[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleAppEngineStandardAppVersionDeploymentFilesOutputReference;
}
export interface GoogleAppEngineStandardAppVersionDeploymentZip {
    /**
    * files count
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_app_engine_standard_app_version#files_count GoogleAppEngineStandardAppVersion#files_count}
    */
    readonly filesCount?: number;
    /**
    * Source URL
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_app_engine_standard_app_version#source_url GoogleAppEngineStandardAppVersion#source_url}
    */
    readonly sourceUrl: string;
}
export declare function googleAppEngineStandardAppVersionDeploymentZipToTerraform(struct?: GoogleAppEngineStandardAppVersionDeploymentZipOutputReference | GoogleAppEngineStandardAppVersionDeploymentZip): any;
export declare class GoogleAppEngineStandardAppVersionDeploymentZipOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleAppEngineStandardAppVersionDeploymentZip | undefined;
    set internalValue(value: GoogleAppEngineStandardAppVersionDeploymentZip | undefined);
    private _filesCount?;
    get filesCount(): number;
    set filesCount(value: number);
    resetFilesCount(): void;
    get filesCountInput(): number | undefined;
    private _sourceUrl?;
    get sourceUrl(): string;
    set sourceUrl(value: string);
    get sourceUrlInput(): string | undefined;
}
export interface GoogleAppEngineStandardAppVersionDeployment {
    /**
    * files block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_app_engine_standard_app_version#files GoogleAppEngineStandardAppVersion#files}
    */
    readonly files?: GoogleAppEngineStandardAppVersionDeploymentFiles[] | cdktf.IResolvable;
    /**
    * zip block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_app_engine_standard_app_version#zip GoogleAppEngineStandardAppVersion#zip}
    */
    readonly zip?: GoogleAppEngineStandardAppVersionDeploymentZip;
}
export declare function googleAppEngineStandardAppVersionDeploymentToTerraform(struct?: GoogleAppEngineStandardAppVersionDeploymentOutputReference | GoogleAppEngineStandardAppVersionDeployment): any;
export declare class GoogleAppEngineStandardAppVersionDeploymentOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleAppEngineStandardAppVersionDeployment | undefined;
    set internalValue(value: GoogleAppEngineStandardAppVersionDeployment | undefined);
    private _files;
    get files(): GoogleAppEngineStandardAppVersionDeploymentFilesList;
    putFiles(value: GoogleAppEngineStandardAppVersionDeploymentFiles[] | cdktf.IResolvable): void;
    resetFiles(): void;
    get filesInput(): cdktf.IResolvable | GoogleAppEngineStandardAppVersionDeploymentFiles[] | undefined;
    private _zip;
    get zip(): GoogleAppEngineStandardAppVersionDeploymentZipOutputReference;
    putZip(value: GoogleAppEngineStandardAppVersionDeploymentZip): void;
    resetZip(): void;
    get zipInput(): GoogleAppEngineStandardAppVersionDeploymentZip | undefined;
}
export interface GoogleAppEngineStandardAppVersionEntrypoint {
    /**
    * The format should be a shell command that can be fed to bash -c.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_app_engine_standard_app_version#shell GoogleAppEngineStandardAppVersion#shell}
    */
    readonly shell: string;
}
export declare function googleAppEngineStandardAppVersionEntrypointToTerraform(struct?: GoogleAppEngineStandardAppVersionEntrypointOutputReference | GoogleAppEngineStandardAppVersionEntrypoint): any;
export declare class GoogleAppEngineStandardAppVersionEntrypointOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleAppEngineStandardAppVersionEntrypoint | undefined;
    set internalValue(value: GoogleAppEngineStandardAppVersionEntrypoint | undefined);
    private _shell?;
    get shell(): string;
    set shell(value: string);
    get shellInput(): string | undefined;
}
export interface GoogleAppEngineStandardAppVersionHandlersScript {
    /**
    * Path to the script from the application root directory.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_app_engine_standard_app_version#script_path GoogleAppEngineStandardAppVersion#script_path}
    */
    readonly scriptPath: string;
}
export declare function googleAppEngineStandardAppVersionHandlersScriptToTerraform(struct?: GoogleAppEngineStandardAppVersionHandlersScriptOutputReference | GoogleAppEngineStandardAppVersionHandlersScript): any;
export declare class GoogleAppEngineStandardAppVersionHandlersScriptOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleAppEngineStandardAppVersionHandlersScript | undefined;
    set internalValue(value: GoogleAppEngineStandardAppVersionHandlersScript | undefined);
    private _scriptPath?;
    get scriptPath(): string;
    set scriptPath(value: string);
    get scriptPathInput(): string | undefined;
}
export interface GoogleAppEngineStandardAppVersionHandlersStaticFiles {
    /**
    * Whether files should also be uploaded as code data. By default, files declared in static file handlers are uploaded as
  static data and are only served to end users; they cannot be read by the application. If enabled, uploads are charged
  against both your code and static data storage resource quotas.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_app_engine_standard_app_version#application_readable GoogleAppEngineStandardAppVersion#application_readable}
    */
    readonly applicationReadable?: boolean | cdktf.IResolvable;
    /**
    * Time a static file served by this handler should be cached by web proxies and browsers.
  A duration in seconds with up to nine fractional digits, terminated by 's'. Example "3.5s".
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_app_engine_standard_app_version#expiration GoogleAppEngineStandardAppVersion#expiration}
    */
    readonly expiration?: string;
    /**
    * HTTP headers to use for all responses from these URLs.
  An object containing a list of "key:value" value pairs.".
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_app_engine_standard_app_version#http_headers GoogleAppEngineStandardAppVersion#http_headers}
    */
    readonly httpHeaders?: {
        [key: string]: string;
    };
    /**
    * MIME type used to serve all files served by this handler.
  Defaults to file-specific MIME types, which are derived from each file's filename extension.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_app_engine_standard_app_version#mime_type GoogleAppEngineStandardAppVersion#mime_type}
    */
    readonly mimeType?: string;
    /**
    * Path to the static files matched by the URL pattern, from the application root directory. The path can refer to text matched in groupings in the URL pattern.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_app_engine_standard_app_version#path GoogleAppEngineStandardAppVersion#path}
    */
    readonly path?: string;
    /**
    * Whether this handler should match the request if the file referenced by the handler does not exist.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_app_engine_standard_app_version#require_matching_file GoogleAppEngineStandardAppVersion#require_matching_file}
    */
    readonly requireMatchingFile?: boolean | cdktf.IResolvable;
    /**
    * Regular expression that matches the file paths for all files that should be referenced by this handler.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_app_engine_standard_app_version#upload_path_regex GoogleAppEngineStandardAppVersion#upload_path_regex}
    */
    readonly uploadPathRegex?: string;
}
export declare function googleAppEngineStandardAppVersionHandlersStaticFilesToTerraform(struct?: GoogleAppEngineStandardAppVersionHandlersStaticFilesOutputReference | GoogleAppEngineStandardAppVersionHandlersStaticFiles): any;
export declare class GoogleAppEngineStandardAppVersionHandlersStaticFilesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleAppEngineStandardAppVersionHandlersStaticFiles | undefined;
    set internalValue(value: GoogleAppEngineStandardAppVersionHandlersStaticFiles | undefined);
    private _applicationReadable?;
    get applicationReadable(): boolean | cdktf.IResolvable;
    set applicationReadable(value: boolean | cdktf.IResolvable);
    resetApplicationReadable(): void;
    get applicationReadableInput(): boolean | cdktf.IResolvable | undefined;
    private _expiration?;
    get expiration(): string;
    set expiration(value: string);
    resetExpiration(): void;
    get expirationInput(): string | undefined;
    private _httpHeaders?;
    get httpHeaders(): {
        [key: string]: string;
    };
    set httpHeaders(value: {
        [key: string]: string;
    });
    resetHttpHeaders(): void;
    get httpHeadersInput(): {
        [key: string]: string;
    } | undefined;
    private _mimeType?;
    get mimeType(): string;
    set mimeType(value: string);
    resetMimeType(): void;
    get mimeTypeInput(): string | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    resetPath(): void;
    get pathInput(): string | undefined;
    private _requireMatchingFile?;
    get requireMatchingFile(): boolean | cdktf.IResolvable;
    set requireMatchingFile(value: boolean | cdktf.IResolvable);
    resetRequireMatchingFile(): void;
    get requireMatchingFileInput(): boolean | cdktf.IResolvable | undefined;
    private _uploadPathRegex?;
    get uploadPathRegex(): string;
    set uploadPathRegex(value: string);
    resetUploadPathRegex(): void;
    get uploadPathRegexInput(): string | undefined;
}
export interface GoogleAppEngineStandardAppVersionHandlers {
    /**
    * Actions to take when the user is not logged in. Possible values: ["AUTH_FAIL_ACTION_REDIRECT", "AUTH_FAIL_ACTION_UNAUTHORIZED"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_app_engine_standard_app_version#auth_fail_action GoogleAppEngineStandardAppVersion#auth_fail_action}
    */
    readonly authFailAction?: string;
    /**
    * Methods to restrict access to a URL based on login status. Possible values: ["LOGIN_OPTIONAL", "LOGIN_ADMIN", "LOGIN_REQUIRED"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_app_engine_standard_app_version#login GoogleAppEngineStandardAppVersion#login}
    */
    readonly login?: string;
    /**
    * 30x code to use when performing redirects for the secure field. Possible values: ["REDIRECT_HTTP_RESPONSE_CODE_301", "REDIRECT_HTTP_RESPONSE_CODE_302", "REDIRECT_HTTP_RESPONSE_CODE_303", "REDIRECT_HTTP_RESPONSE_CODE_307"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_app_engine_standard_app_version#redirect_http_response_code GoogleAppEngineStandardAppVersion#redirect_http_response_code}
    */
    readonly redirectHttpResponseCode?: string;
    /**
    * Security (HTTPS) enforcement for this URL. Possible values: ["SECURE_DEFAULT", "SECURE_NEVER", "SECURE_OPTIONAL", "SECURE_ALWAYS"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_app_engine_standard_app_version#security_level GoogleAppEngineStandardAppVersion#security_level}
    */
    readonly securityLevel?: string;
    /**
    * URL prefix. Uses regular expression syntax, which means regexp special characters must be escaped, but should not contain groupings.
  All URLs that begin with this prefix are handled by this handler, using the portion of the URL after the prefix as part of the file path.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_app_engine_standard_app_version#url_regex GoogleAppEngineStandardAppVersion#url_regex}
    */
    readonly urlRegex?: string;
    /**
    * script block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_app_engine_standard_app_version#script GoogleAppEngineStandardAppVersion#script}
    */
    readonly script?: GoogleAppEngineStandardAppVersionHandlersScript;
    /**
    * static_files block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_app_engine_standard_app_version#static_files GoogleAppEngineStandardAppVersion#static_files}
    */
    readonly staticFiles?: GoogleAppEngineStandardAppVersionHandlersStaticFiles;
}
export declare function googleAppEngineStandardAppVersionHandlersToTerraform(struct?: GoogleAppEngineStandardAppVersionHandlers | cdktf.IResolvable): any;
export declare class GoogleAppEngineStandardAppVersionHandlersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleAppEngineStandardAppVersionHandlers | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleAppEngineStandardAppVersionHandlers | cdktf.IResolvable | undefined);
    private _authFailAction?;
    get authFailAction(): string;
    set authFailAction(value: string);
    resetAuthFailAction(): void;
    get authFailActionInput(): string | undefined;
    private _login?;
    get login(): string;
    set login(value: string);
    resetLogin(): void;
    get loginInput(): string | undefined;
    private _redirectHttpResponseCode?;
    get redirectHttpResponseCode(): string;
    set redirectHttpResponseCode(value: string);
    resetRedirectHttpResponseCode(): void;
    get redirectHttpResponseCodeInput(): string | undefined;
    private _securityLevel?;
    get securityLevel(): string;
    set securityLevel(value: string);
    resetSecurityLevel(): void;
    get securityLevelInput(): string | undefined;
    private _urlRegex?;
    get urlRegex(): string;
    set urlRegex(value: string);
    resetUrlRegex(): void;
    get urlRegexInput(): string | undefined;
    private _script;
    get script(): GoogleAppEngineStandardAppVersionHandlersScriptOutputReference;
    putScript(value: GoogleAppEngineStandardAppVersionHandlersScript): void;
    resetScript(): void;
    get scriptInput(): GoogleAppEngineStandardAppVersionHandlersScript | undefined;
    private _staticFiles;
    get staticFiles(): GoogleAppEngineStandardAppVersionHandlersStaticFilesOutputReference;
    putStaticFiles(value: GoogleAppEngineStandardAppVersionHandlersStaticFiles): void;
    resetStaticFiles(): void;
    get staticFilesInput(): GoogleAppEngineStandardAppVersionHandlersStaticFiles | undefined;
}
export declare class GoogleAppEngineStandardAppVersionHandlersList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleAppEngineStandardAppVersionHandlers[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleAppEngineStandardAppVersionHandlersOutputReference;
}
export interface GoogleAppEngineStandardAppVersionLibraries {
    /**
    * Name of the library. Example "django".
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_app_engine_standard_app_version#name GoogleAppEngineStandardAppVersion#name}
    */
    readonly name?: string;
    /**
    * Version of the library to select, or "latest".
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_app_engine_standard_app_version#version GoogleAppEngineStandardAppVersion#version}
    */
    readonly version?: string;
}
export declare function googleAppEngineStandardAppVersionLibrariesToTerraform(struct?: GoogleAppEngineStandardAppVersionLibraries | cdktf.IResolvable): any;
export declare class GoogleAppEngineStandardAppVersionLibrariesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleAppEngineStandardAppVersionLibraries | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleAppEngineStandardAppVersionLibraries | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _version?;
    get version(): string;
    set version(value: string);
    resetVersion(): void;
    get versionInput(): string | undefined;
}
export declare class GoogleAppEngineStandardAppVersionLibrariesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleAppEngineStandardAppVersionLibraries[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleAppEngineStandardAppVersionLibrariesOutputReference;
}
export interface GoogleAppEngineStandardAppVersionManualScaling {
    /**
    * Number of instances to assign to the service at the start.
  
  **Note:** When managing the number of instances at runtime through the App Engine Admin API or the (now deprecated) Python 2
  Modules API set_num_instances() you must use 'lifecycle.ignore_changes = ["manual_scaling"[0].instances]' to prevent drift detection.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_app_engine_standard_app_version#instances GoogleAppEngineStandardAppVersion#instances}
    */
    readonly instances: number;
}
export declare function googleAppEngineStandardAppVersionManualScalingToTerraform(struct?: GoogleAppEngineStandardAppVersionManualScalingOutputReference | GoogleAppEngineStandardAppVersionManualScaling): any;
export declare class GoogleAppEngineStandardAppVersionManualScalingOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleAppEngineStandardAppVersionManualScaling | undefined;
    set internalValue(value: GoogleAppEngineStandardAppVersionManualScaling | undefined);
    private _instances?;
    get instances(): number;
    set instances(value: number);
    get instancesInput(): number | undefined;
}
export interface GoogleAppEngineStandardAppVersionTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_app_engine_standard_app_version#create GoogleAppEngineStandardAppVersion#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_app_engine_standard_app_version#delete GoogleAppEngineStandardAppVersion#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_app_engine_standard_app_version#update GoogleAppEngineStandardAppVersion#update}
    */
    readonly update?: string;
}
export declare function googleAppEngineStandardAppVersionTimeoutsToTerraform(struct?: GoogleAppEngineStandardAppVersionTimeoutsOutputReference | GoogleAppEngineStandardAppVersionTimeouts | cdktf.IResolvable): any;
export declare class GoogleAppEngineStandardAppVersionTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleAppEngineStandardAppVersionTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleAppEngineStandardAppVersionTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
export interface GoogleAppEngineStandardAppVersionVpcAccessConnector {
    /**
    * The egress setting for the connector, controlling what traffic is diverted through it.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_app_engine_standard_app_version#egress_setting GoogleAppEngineStandardAppVersion#egress_setting}
    */
    readonly egressSetting?: string;
    /**
    * Full Serverless VPC Access Connector name e.g. /projects/my-project/locations/us-central1/connectors/c1.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_app_engine_standard_app_version#name GoogleAppEngineStandardAppVersion#name}
    */
    readonly name: string;
}
export declare function googleAppEngineStandardAppVersionVpcAccessConnectorToTerraform(struct?: GoogleAppEngineStandardAppVersionVpcAccessConnectorOutputReference | GoogleAppEngineStandardAppVersionVpcAccessConnector): any;
export declare class GoogleAppEngineStandardAppVersionVpcAccessConnectorOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleAppEngineStandardAppVersionVpcAccessConnector | undefined;
    set internalValue(value: GoogleAppEngineStandardAppVersionVpcAccessConnector | undefined);
    private _egressSetting?;
    get egressSetting(): string;
    set egressSetting(value: string);
    resetEgressSetting(): void;
    get egressSettingInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google-beta/r/google_app_engine_standard_app_version google_app_engine_standard_app_version}
*/
export declare class GoogleAppEngineStandardAppVersion extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_app_engine_standard_app_version";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google-beta/r/google_app_engine_standard_app_version google_app_engine_standard_app_version} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleAppEngineStandardAppVersionConfig
    */
    constructor(scope: Construct, id: string, config: GoogleAppEngineStandardAppVersionConfig);
    private _appEngineApis?;
    get appEngineApis(): boolean | cdktf.IResolvable;
    set appEngineApis(value: boolean | cdktf.IResolvable);
    resetAppEngineApis(): void;
    get appEngineApisInput(): boolean | cdktf.IResolvable | undefined;
    private _deleteServiceOnDestroy?;
    get deleteServiceOnDestroy(): boolean | cdktf.IResolvable;
    set deleteServiceOnDestroy(value: boolean | cdktf.IResolvable);
    resetDeleteServiceOnDestroy(): void;
    get deleteServiceOnDestroyInput(): boolean | cdktf.IResolvable | undefined;
    private _envVariables?;
    get envVariables(): {
        [key: string]: string;
    };
    set envVariables(value: {
        [key: string]: string;
    });
    resetEnvVariables(): void;
    get envVariablesInput(): {
        [key: string]: string;
    } | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _inboundServices?;
    get inboundServices(): string[];
    set inboundServices(value: string[]);
    resetInboundServices(): void;
    get inboundServicesInput(): string[] | undefined;
    private _instanceClass?;
    get instanceClass(): string;
    set instanceClass(value: string);
    resetInstanceClass(): void;
    get instanceClassInput(): string | undefined;
    get name(): string;
    private _noopOnDestroy?;
    get noopOnDestroy(): boolean | cdktf.IResolvable;
    set noopOnDestroy(value: boolean | cdktf.IResolvable);
    resetNoopOnDestroy(): void;
    get noopOnDestroyInput(): boolean | cdktf.IResolvable | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _runtime?;
    get runtime(): string;
    set runtime(value: string);
    get runtimeInput(): string | undefined;
    private _runtimeApiVersion?;
    get runtimeApiVersion(): string;
    set runtimeApiVersion(value: string);
    resetRuntimeApiVersion(): void;
    get runtimeApiVersionInput(): string | undefined;
    private _service?;
    get service(): string;
    set service(value: string);
    get serviceInput(): string | undefined;
    private _threadsafe?;
    get threadsafe(): boolean | cdktf.IResolvable;
    set threadsafe(value: boolean | cdktf.IResolvable);
    resetThreadsafe(): void;
    get threadsafeInput(): boolean | cdktf.IResolvable | undefined;
    private _versionId?;
    get versionId(): string;
    set versionId(value: string);
    resetVersionId(): void;
    get versionIdInput(): string | undefined;
    private _automaticScaling;
    get automaticScaling(): GoogleAppEngineStandardAppVersionAutomaticScalingOutputReference;
    putAutomaticScaling(value: GoogleAppEngineStandardAppVersionAutomaticScaling): void;
    resetAutomaticScaling(): void;
    get automaticScalingInput(): GoogleAppEngineStandardAppVersionAutomaticScaling | undefined;
    private _basicScaling;
    get basicScaling(): GoogleAppEngineStandardAppVersionBasicScalingOutputReference;
    putBasicScaling(value: GoogleAppEngineStandardAppVersionBasicScaling): void;
    resetBasicScaling(): void;
    get basicScalingInput(): GoogleAppEngineStandardAppVersionBasicScaling | undefined;
    private _deployment;
    get deployment(): GoogleAppEngineStandardAppVersionDeploymentOutputReference;
    putDeployment(value: GoogleAppEngineStandardAppVersionDeployment): void;
    get deploymentInput(): GoogleAppEngineStandardAppVersionDeployment | undefined;
    private _entrypoint;
    get entrypoint(): GoogleAppEngineStandardAppVersionEntrypointOutputReference;
    putEntrypoint(value: GoogleAppEngineStandardAppVersionEntrypoint): void;
    get entrypointInput(): GoogleAppEngineStandardAppVersionEntrypoint | undefined;
    private _handlers;
    get handlers(): GoogleAppEngineStandardAppVersionHandlersList;
    putHandlers(value: GoogleAppEngineStandardAppVersionHandlers[] | cdktf.IResolvable): void;
    resetHandlers(): void;
    get handlersInput(): cdktf.IResolvable | GoogleAppEngineStandardAppVersionHandlers[] | undefined;
    private _libraries;
    get libraries(): GoogleAppEngineStandardAppVersionLibrariesList;
    putLibraries(value: GoogleAppEngineStandardAppVersionLibraries[] | cdktf.IResolvable): void;
    resetLibraries(): void;
    get librariesInput(): cdktf.IResolvable | GoogleAppEngineStandardAppVersionLibraries[] | undefined;
    private _manualScaling;
    get manualScaling(): GoogleAppEngineStandardAppVersionManualScalingOutputReference;
    putManualScaling(value: GoogleAppEngineStandardAppVersionManualScaling): void;
    resetManualScaling(): void;
    get manualScalingInput(): GoogleAppEngineStandardAppVersionManualScaling | undefined;
    private _timeouts;
    get timeouts(): GoogleAppEngineStandardAppVersionTimeoutsOutputReference;
    putTimeouts(value: GoogleAppEngineStandardAppVersionTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleAppEngineStandardAppVersionTimeouts | undefined;
    private _vpcAccessConnector;
    get vpcAccessConnector(): GoogleAppEngineStandardAppVersionVpcAccessConnectorOutputReference;
    putVpcAccessConnector(value: GoogleAppEngineStandardAppVersionVpcAccessConnector): void;
    resetVpcAccessConnector(): void;
    get vpcAccessConnectorInput(): GoogleAppEngineStandardAppVersionVpcAccessConnector | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
