import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleArtifactRegistryRepositoryConfig extends cdktf.TerraformMetaArguments {
    /**
    * The user-provided description of the repository.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_artifact_registry_repository#description GoogleArtifactRegistryRepository#description}
    */
    readonly description?: string;
    /**
    * The format of packages that are stored in the repository. Supported formats
  can be found [here](https://cloud.google.com/artifact-registry/docs/supported-formats).
  You can only create alpha formats if you are a member of the
  [alpha user group](https://cloud.google.com/artifact-registry/docs/supported-formats#alpha-access).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_artifact_registry_repository#format GoogleArtifactRegistryRepository#format}
    */
    readonly format: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_artifact_registry_repository#id GoogleArtifactRegistryRepository#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The Cloud KMS resource name of the customer managed encryption key that’s
  used to encrypt the contents of the Repository. Has the form:
  'projects/my-project/locations/my-region/keyRings/my-kr/cryptoKeys/my-key'.
  This value may not be changed after the Repository has been created.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_artifact_registry_repository#kms_key_name GoogleArtifactRegistryRepository#kms_key_name}
    */
    readonly kmsKeyName?: string;
    /**
    * Labels with user-defined metadata.
  This field may contain up to 64 entries. Label keys and values may be no
  longer than 63 characters. Label keys must begin with a lowercase letter
  and may only contain lowercase letters, numeric characters, underscores,
  and dashes.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_artifact_registry_repository#labels GoogleArtifactRegistryRepository#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * The name of the location this repository is located in.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_artifact_registry_repository#location GoogleArtifactRegistryRepository#location}
    */
    readonly location?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_artifact_registry_repository#project GoogleArtifactRegistryRepository#project}
    */
    readonly project?: string;
    /**
    * The last part of the repository name, for example:
  "repo1"
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_artifact_registry_repository#repository_id GoogleArtifactRegistryRepository#repository_id}
    */
    readonly repositoryId: string;
    /**
    * maven_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_artifact_registry_repository#maven_config GoogleArtifactRegistryRepository#maven_config}
    */
    readonly mavenConfig?: GoogleArtifactRegistryRepositoryMavenConfig;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_artifact_registry_repository#timeouts GoogleArtifactRegistryRepository#timeouts}
    */
    readonly timeouts?: GoogleArtifactRegistryRepositoryTimeouts;
}
export interface GoogleArtifactRegistryRepositoryMavenConfig {
    /**
    * The repository with this flag will allow publishing the same
  snapshot versions.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_artifact_registry_repository#allow_snapshot_overwrites GoogleArtifactRegistryRepository#allow_snapshot_overwrites}
    */
    readonly allowSnapshotOverwrites?: boolean | cdktf.IResolvable;
    /**
    * Version policy defines the versions that the registry will accept. Default value: "VERSION_POLICY_UNSPECIFIED" Possible values: ["VERSION_POLICY_UNSPECIFIED", "RELEASE", "SNAPSHOT"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_artifact_registry_repository#version_policy GoogleArtifactRegistryRepository#version_policy}
    */
    readonly versionPolicy?: string;
}
export declare function googleArtifactRegistryRepositoryMavenConfigToTerraform(struct?: GoogleArtifactRegistryRepositoryMavenConfigOutputReference | GoogleArtifactRegistryRepositoryMavenConfig): any;
export declare class GoogleArtifactRegistryRepositoryMavenConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleArtifactRegistryRepositoryMavenConfig | undefined;
    set internalValue(value: GoogleArtifactRegistryRepositoryMavenConfig | undefined);
    private _allowSnapshotOverwrites?;
    get allowSnapshotOverwrites(): boolean | cdktf.IResolvable;
    set allowSnapshotOverwrites(value: boolean | cdktf.IResolvable);
    resetAllowSnapshotOverwrites(): void;
    get allowSnapshotOverwritesInput(): boolean | cdktf.IResolvable | undefined;
    private _versionPolicy?;
    get versionPolicy(): string;
    set versionPolicy(value: string);
    resetVersionPolicy(): void;
    get versionPolicyInput(): string | undefined;
}
export interface GoogleArtifactRegistryRepositoryTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_artifact_registry_repository#create GoogleArtifactRegistryRepository#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_artifact_registry_repository#delete GoogleArtifactRegistryRepository#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_artifact_registry_repository#update GoogleArtifactRegistryRepository#update}
    */
    readonly update?: string;
}
export declare function googleArtifactRegistryRepositoryTimeoutsToTerraform(struct?: GoogleArtifactRegistryRepositoryTimeoutsOutputReference | GoogleArtifactRegistryRepositoryTimeouts | cdktf.IResolvable): any;
export declare class GoogleArtifactRegistryRepositoryTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleArtifactRegistryRepositoryTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleArtifactRegistryRepositoryTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google-beta/r/google_artifact_registry_repository google_artifact_registry_repository}
*/
export declare class GoogleArtifactRegistryRepository extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_artifact_registry_repository";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google-beta/r/google_artifact_registry_repository google_artifact_registry_repository} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleArtifactRegistryRepositoryConfig
    */
    constructor(scope: Construct, id: string, config: GoogleArtifactRegistryRepositoryConfig);
    get createTime(): string;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _format?;
    get format(): string;
    set format(value: string);
    get formatInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _kmsKeyName?;
    get kmsKeyName(): string;
    set kmsKeyName(value: string);
    resetKmsKeyName(): void;
    get kmsKeyNameInput(): string | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    resetLocation(): void;
    get locationInput(): string | undefined;
    get name(): string;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _repositoryId?;
    get repositoryId(): string;
    set repositoryId(value: string);
    get repositoryIdInput(): string | undefined;
    get updateTime(): string;
    private _mavenConfig;
    get mavenConfig(): GoogleArtifactRegistryRepositoryMavenConfigOutputReference;
    putMavenConfig(value: GoogleArtifactRegistryRepositoryMavenConfig): void;
    resetMavenConfig(): void;
    get mavenConfigInput(): GoogleArtifactRegistryRepositoryMavenConfig | undefined;
    private _timeouts;
    get timeouts(): GoogleArtifactRegistryRepositoryTimeoutsOutputReference;
    putTimeouts(value: GoogleArtifactRegistryRepositoryTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleArtifactRegistryRepositoryTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
