import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleBigqueryDatasetAccessAConfig extends cdktf.TerraformMetaArguments {
    /**
    * A unique ID for this dataset, without the project name. The ID
  must contain only letters (a-z, A-Z), numbers (0-9), or
  underscores (_). The maximum length is 1,024 characters.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_bigquery_dataset_access#dataset_id GoogleBigqueryDatasetAccessA#dataset_id}
    */
    readonly datasetId: string;
    /**
    * A domain to grant access to. Any users signed in with the
  domain specified will be granted the specified access
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_bigquery_dataset_access#domain GoogleBigqueryDatasetAccessA#domain}
    */
    readonly domain?: string;
    /**
    * An email address of a Google Group to grant access to.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_bigquery_dataset_access#group_by_email GoogleBigqueryDatasetAccessA#group_by_email}
    */
    readonly groupByEmail?: string;
    /**
    * Some other type of member that appears in the IAM Policy but isn't a user,
  group, domain, or special group. For example: 'allUsers'
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_bigquery_dataset_access#iam_member GoogleBigqueryDatasetAccessA#iam_member}
    */
    readonly iamMember?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_bigquery_dataset_access#id GoogleBigqueryDatasetAccessA#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_bigquery_dataset_access#project GoogleBigqueryDatasetAccessA#project}
    */
    readonly project?: string;
    /**
    * Describes the rights granted to the user specified by the other
  member of the access object. Basic, predefined, and custom roles are
  supported. Predefined roles that have equivalent basic roles are
  swapped by the API to their basic counterparts, and will show a diff
  post-create. See
  [official docs](https://cloud.google.com/bigquery/docs/access-control).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_bigquery_dataset_access#role GoogleBigqueryDatasetAccessA#role}
    */
    readonly role?: string;
    /**
    * A special group to grant access to. Possible values include:
  
  
  * 'projectOwners': Owners of the enclosing project.
  
  
  * 'projectReaders': Readers of the enclosing project.
  
  
  * 'projectWriters': Writers of the enclosing project.
  
  
  * 'allAuthenticatedUsers': All authenticated BigQuery users.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_bigquery_dataset_access#special_group GoogleBigqueryDatasetAccessA#special_group}
    */
    readonly specialGroup?: string;
    /**
    * An email address of a user to grant access to. For example:
  fred@example.com
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_bigquery_dataset_access#user_by_email GoogleBigqueryDatasetAccessA#user_by_email}
    */
    readonly userByEmail?: string;
    /**
    * dataset block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_bigquery_dataset_access#dataset GoogleBigqueryDatasetAccessA#dataset}
    */
    readonly dataset?: GoogleBigqueryDatasetAccessDatasetA;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_bigquery_dataset_access#timeouts GoogleBigqueryDatasetAccessA#timeouts}
    */
    readonly timeouts?: GoogleBigqueryDatasetAccessTimeouts;
    /**
    * view block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_bigquery_dataset_access#view GoogleBigqueryDatasetAccessA#view}
    */
    readonly view?: GoogleBigqueryDatasetAccessViewA;
}
export interface GoogleBigqueryDatasetAccessDatasetDatasetA {
    /**
    * The ID of the dataset containing this table.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_bigquery_dataset_access#dataset_id GoogleBigqueryDatasetAccessA#dataset_id}
    */
    readonly datasetId: string;
    /**
    * The ID of the project containing this table.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_bigquery_dataset_access#project_id GoogleBigqueryDatasetAccessA#project_id}
    */
    readonly projectId: string;
}
export declare function googleBigqueryDatasetAccessDatasetDatasetAToTerraform(struct?: GoogleBigqueryDatasetAccessDatasetDatasetAOutputReference | GoogleBigqueryDatasetAccessDatasetDatasetA): any;
export declare class GoogleBigqueryDatasetAccessDatasetDatasetAOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleBigqueryDatasetAccessDatasetDatasetA | undefined;
    set internalValue(value: GoogleBigqueryDatasetAccessDatasetDatasetA | undefined);
    private _datasetId?;
    get datasetId(): string;
    set datasetId(value: string);
    get datasetIdInput(): string | undefined;
    private _projectId?;
    get projectId(): string;
    set projectId(value: string);
    get projectIdInput(): string | undefined;
}
export interface GoogleBigqueryDatasetAccessDatasetA {
    /**
    * Which resources in the dataset this entry applies to. Currently, only views are supported,
  but additional target types may be added in the future. Possible values: VIEWS
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_bigquery_dataset_access#target_types GoogleBigqueryDatasetAccessA#target_types}
    */
    readonly targetTypes: string[];
    /**
    * dataset block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_bigquery_dataset_access#dataset GoogleBigqueryDatasetAccessA#dataset}
    */
    readonly dataset: GoogleBigqueryDatasetAccessDatasetDatasetA;
}
export declare function googleBigqueryDatasetAccessDatasetAToTerraform(struct?: GoogleBigqueryDatasetAccessDatasetAOutputReference | GoogleBigqueryDatasetAccessDatasetA): any;
export declare class GoogleBigqueryDatasetAccessDatasetAOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleBigqueryDatasetAccessDatasetA | undefined;
    set internalValue(value: GoogleBigqueryDatasetAccessDatasetA | undefined);
    private _targetTypes?;
    get targetTypes(): string[];
    set targetTypes(value: string[]);
    get targetTypesInput(): string[] | undefined;
    private _dataset;
    get dataset(): GoogleBigqueryDatasetAccessDatasetDatasetAOutputReference;
    putDataset(value: GoogleBigqueryDatasetAccessDatasetDatasetA): void;
    get datasetInput(): GoogleBigqueryDatasetAccessDatasetDatasetA | undefined;
}
export interface GoogleBigqueryDatasetAccessTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_bigquery_dataset_access#create GoogleBigqueryDatasetAccessA#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_bigquery_dataset_access#delete GoogleBigqueryDatasetAccessA#delete}
    */
    readonly delete?: string;
}
export declare function googleBigqueryDatasetAccessTimeoutsToTerraform(struct?: GoogleBigqueryDatasetAccessTimeoutsOutputReference | GoogleBigqueryDatasetAccessTimeouts | cdktf.IResolvable): any;
export declare class GoogleBigqueryDatasetAccessTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleBigqueryDatasetAccessTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleBigqueryDatasetAccessTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
export interface GoogleBigqueryDatasetAccessViewA {
    /**
    * The ID of the dataset containing this table.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_bigquery_dataset_access#dataset_id GoogleBigqueryDatasetAccessA#dataset_id}
    */
    readonly datasetId: string;
    /**
    * The ID of the project containing this table.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_bigquery_dataset_access#project_id GoogleBigqueryDatasetAccessA#project_id}
    */
    readonly projectId: string;
    /**
    * The ID of the table. The ID must contain only letters (a-z,
  A-Z), numbers (0-9), or underscores (_). The maximum length
  is 1,024 characters.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_bigquery_dataset_access#table_id GoogleBigqueryDatasetAccessA#table_id}
    */
    readonly tableId: string;
}
export declare function googleBigqueryDatasetAccessViewAToTerraform(struct?: GoogleBigqueryDatasetAccessViewAOutputReference | GoogleBigqueryDatasetAccessViewA): any;
export declare class GoogleBigqueryDatasetAccessViewAOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleBigqueryDatasetAccessViewA | undefined;
    set internalValue(value: GoogleBigqueryDatasetAccessViewA | undefined);
    private _datasetId?;
    get datasetId(): string;
    set datasetId(value: string);
    get datasetIdInput(): string | undefined;
    private _projectId?;
    get projectId(): string;
    set projectId(value: string);
    get projectIdInput(): string | undefined;
    private _tableId?;
    get tableId(): string;
    set tableId(value: string);
    get tableIdInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google-beta/r/google_bigquery_dataset_access google_bigquery_dataset_access}
*/
export declare class GoogleBigqueryDatasetAccessA extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_bigquery_dataset_access";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google-beta/r/google_bigquery_dataset_access google_bigquery_dataset_access} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleBigqueryDatasetAccessAConfig
    */
    constructor(scope: Construct, id: string, config: GoogleBigqueryDatasetAccessAConfig);
    get apiUpdatedMember(): cdktf.IResolvable;
    private _datasetId?;
    get datasetId(): string;
    set datasetId(value: string);
    get datasetIdInput(): string | undefined;
    private _domain?;
    get domain(): string;
    set domain(value: string);
    resetDomain(): void;
    get domainInput(): string | undefined;
    private _groupByEmail?;
    get groupByEmail(): string;
    set groupByEmail(value: string);
    resetGroupByEmail(): void;
    get groupByEmailInput(): string | undefined;
    private _iamMember?;
    get iamMember(): string;
    set iamMember(value: string);
    resetIamMember(): void;
    get iamMemberInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _role?;
    get role(): string;
    set role(value: string);
    resetRole(): void;
    get roleInput(): string | undefined;
    private _specialGroup?;
    get specialGroup(): string;
    set specialGroup(value: string);
    resetSpecialGroup(): void;
    get specialGroupInput(): string | undefined;
    private _userByEmail?;
    get userByEmail(): string;
    set userByEmail(value: string);
    resetUserByEmail(): void;
    get userByEmailInput(): string | undefined;
    private _dataset;
    get dataset(): GoogleBigqueryDatasetAccessDatasetAOutputReference;
    putDataset(value: GoogleBigqueryDatasetAccessDatasetA): void;
    resetDataset(): void;
    get datasetInput(): GoogleBigqueryDatasetAccessDatasetA | undefined;
    private _timeouts;
    get timeouts(): GoogleBigqueryDatasetAccessTimeoutsOutputReference;
    putTimeouts(value: GoogleBigqueryDatasetAccessTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleBigqueryDatasetAccessTimeouts | undefined;
    private _view;
    get view(): GoogleBigqueryDatasetAccessViewAOutputReference;
    putView(value: GoogleBigqueryDatasetAccessViewA): void;
    resetView(): void;
    get viewInput(): GoogleBigqueryDatasetAccessViewA | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
