import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleBigqueryReservationConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_bigquery_reservation#id GoogleBigqueryReservation#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * If false, any query using this reservation will use idle slots from other reservations within
  the same admin project. If true, a query using this reservation will execute with the slot
  capacity specified above at most.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_bigquery_reservation#ignore_idle_slots GoogleBigqueryReservation#ignore_idle_slots}
    */
    readonly ignoreIdleSlots?: boolean | cdktf.IResolvable;
    /**
    * The geographic location where the transfer config should reside.
  Examples: US, EU, asia-northeast1. The default value is US.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_bigquery_reservation#location GoogleBigqueryReservation#location}
    */
    readonly location?: string;
    /**
    * The name of the reservation. This field must only contain alphanumeric characters or dash.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_bigquery_reservation#name GoogleBigqueryReservation#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_bigquery_reservation#project GoogleBigqueryReservation#project}
    */
    readonly project?: string;
    /**
    * Minimum slots available to this reservation. A slot is a unit of computational power in BigQuery, and serves as the
  unit of parallelism. Queries using this reservation might use more slots during runtime if ignoreIdleSlots is set to false.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_bigquery_reservation#slot_capacity GoogleBigqueryReservation#slot_capacity}
    */
    readonly slotCapacity: number;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_bigquery_reservation#timeouts GoogleBigqueryReservation#timeouts}
    */
    readonly timeouts?: GoogleBigqueryReservationTimeouts;
}
export interface GoogleBigqueryReservationTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_bigquery_reservation#create GoogleBigqueryReservation#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_bigquery_reservation#delete GoogleBigqueryReservation#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_bigquery_reservation#update GoogleBigqueryReservation#update}
    */
    readonly update?: string;
}
export declare function googleBigqueryReservationTimeoutsToTerraform(struct?: GoogleBigqueryReservationTimeoutsOutputReference | GoogleBigqueryReservationTimeouts | cdktf.IResolvable): any;
export declare class GoogleBigqueryReservationTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleBigqueryReservationTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleBigqueryReservationTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google-beta/r/google_bigquery_reservation google_bigquery_reservation}
*/
export declare class GoogleBigqueryReservation extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_bigquery_reservation";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google-beta/r/google_bigquery_reservation google_bigquery_reservation} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleBigqueryReservationConfig
    */
    constructor(scope: Construct, id: string, config: GoogleBigqueryReservationConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _ignoreIdleSlots?;
    get ignoreIdleSlots(): boolean | cdktf.IResolvable;
    set ignoreIdleSlots(value: boolean | cdktf.IResolvable);
    resetIgnoreIdleSlots(): void;
    get ignoreIdleSlotsInput(): boolean | cdktf.IResolvable | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    resetLocation(): void;
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _slotCapacity?;
    get slotCapacity(): number;
    set slotCapacity(value: number);
    get slotCapacityInput(): number | undefined;
    private _timeouts;
    get timeouts(): GoogleBigqueryReservationTimeoutsOutputReference;
    putTimeouts(value: GoogleBigqueryReservationTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleBigqueryReservationTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
