import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleBigqueryRoutineConfig extends cdktf.TerraformMetaArguments {
    /**
    * The ID of the dataset containing this routine
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_bigquery_routine#dataset_id GoogleBigqueryRoutine#dataset_id}
    */
    readonly datasetId: string;
    /**
    * The body of the routine. For functions, this is the expression in the AS clause.
  If language=SQL, it is the substring inside (but excluding) the parentheses.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_bigquery_routine#definition_body GoogleBigqueryRoutine#definition_body}
    */
    readonly definitionBody: string;
    /**
    * The description of the routine if defined.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_bigquery_routine#description GoogleBigqueryRoutine#description}
    */
    readonly description?: string;
    /**
    * The determinism level of the JavaScript UDF if defined. Possible values: ["DETERMINISM_LEVEL_UNSPECIFIED", "DETERMINISTIC", "NOT_DETERMINISTIC"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_bigquery_routine#determinism_level GoogleBigqueryRoutine#determinism_level}
    */
    readonly determinismLevel?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_bigquery_routine#id GoogleBigqueryRoutine#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Optional. If language = "JAVASCRIPT", this field stores the path of the
  imported JAVASCRIPT libraries.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_bigquery_routine#imported_libraries GoogleBigqueryRoutine#imported_libraries}
    */
    readonly importedLibraries?: string[];
    /**
    * The language of the routine. Possible values: ["SQL", "JAVASCRIPT"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_bigquery_routine#language GoogleBigqueryRoutine#language}
    */
    readonly language?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_bigquery_routine#project GoogleBigqueryRoutine#project}
    */
    readonly project?: string;
    /**
    * Optional. Can be set only if routineType = "TABLE_VALUED_FUNCTION".
  
  If absent, the return table type is inferred from definitionBody at query time in each query
  that references this routine. If present, then the columns in the evaluated table result will
  be cast to match the column types specificed in return table type, at query time.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_bigquery_routine#return_table_type GoogleBigqueryRoutine#return_table_type}
    */
    readonly returnTableType?: string;
    /**
    * A JSON schema for the return type. Optional if language = "SQL"; required otherwise.
  If absent, the return type is inferred from definitionBody at query time in each query
  that references this routine. If present, then the evaluated result will be cast to
  the specified returned type at query time. ~>**NOTE**: Because this field expects a JSON
  string, any changes to the string will create a diff, even if the JSON itself hasn't
  changed. If the API returns a different value for the same schema, e.g. it switche
  d the order of values or replaced STRUCT field type with RECORD field type, we currently
  cannot suppress the recurring diff this causes. As a workaround, we recommend using
  the schema as returned by the API.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_bigquery_routine#return_type GoogleBigqueryRoutine#return_type}
    */
    readonly returnType?: string;
    /**
    * The ID of the the routine. The ID must contain only letters (a-z, A-Z), numbers (0-9), or underscores (_). The maximum length is 256 characters.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_bigquery_routine#routine_id GoogleBigqueryRoutine#routine_id}
    */
    readonly routineId: string;
    /**
    * The type of routine. Possible values: ["SCALAR_FUNCTION", "PROCEDURE", "TABLE_VALUED_FUNCTION"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_bigquery_routine#routine_type GoogleBigqueryRoutine#routine_type}
    */
    readonly routineType?: string;
    /**
    * arguments block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_bigquery_routine#arguments GoogleBigqueryRoutine#arguments}
    */
    readonly arguments?: GoogleBigqueryRoutineArguments[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_bigquery_routine#timeouts GoogleBigqueryRoutine#timeouts}
    */
    readonly timeouts?: GoogleBigqueryRoutineTimeouts;
}
export interface GoogleBigqueryRoutineArguments {
    /**
    * Defaults to FIXED_TYPE. Default value: "FIXED_TYPE" Possible values: ["FIXED_TYPE", "ANY_TYPE"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_bigquery_routine#argument_kind GoogleBigqueryRoutine#argument_kind}
    */
    readonly argumentKind?: string;
    /**
    * A JSON schema for the data type. Required unless argumentKind = ANY_TYPE.
  ~>**NOTE**: Because this field expects a JSON string, any changes to the string
  will create a diff, even if the JSON itself hasn't changed. If the API returns
  a different value for the same schema, e.g. it switched the order of values
  or replaced STRUCT field type with RECORD field type, we currently cannot
  suppress the recurring diff this causes. As a workaround, we recommend using
  the schema as returned by the API.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_bigquery_routine#data_type GoogleBigqueryRoutine#data_type}
    */
    readonly dataType?: string;
    /**
    * Specifies whether the argument is input or output. Can be set for procedures only. Possible values: ["IN", "OUT", "INOUT"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_bigquery_routine#mode GoogleBigqueryRoutine#mode}
    */
    readonly mode?: string;
    /**
    * The name of this argument. Can be absent for function return argument.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_bigquery_routine#name GoogleBigqueryRoutine#name}
    */
    readonly name?: string;
}
export declare function googleBigqueryRoutineArgumentsToTerraform(struct?: GoogleBigqueryRoutineArguments | cdktf.IResolvable): any;
export declare class GoogleBigqueryRoutineArgumentsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleBigqueryRoutineArguments | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleBigqueryRoutineArguments | cdktf.IResolvable | undefined);
    private _argumentKind?;
    get argumentKind(): string;
    set argumentKind(value: string);
    resetArgumentKind(): void;
    get argumentKindInput(): string | undefined;
    private _dataType?;
    get dataType(): string;
    set dataType(value: string);
    resetDataType(): void;
    get dataTypeInput(): string | undefined;
    private _mode?;
    get mode(): string;
    set mode(value: string);
    resetMode(): void;
    get modeInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
}
export declare class GoogleBigqueryRoutineArgumentsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleBigqueryRoutineArguments[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleBigqueryRoutineArgumentsOutputReference;
}
export interface GoogleBigqueryRoutineTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_bigquery_routine#create GoogleBigqueryRoutine#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_bigquery_routine#delete GoogleBigqueryRoutine#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_bigquery_routine#update GoogleBigqueryRoutine#update}
    */
    readonly update?: string;
}
export declare function googleBigqueryRoutineTimeoutsToTerraform(struct?: GoogleBigqueryRoutineTimeoutsOutputReference | GoogleBigqueryRoutineTimeouts | cdktf.IResolvable): any;
export declare class GoogleBigqueryRoutineTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleBigqueryRoutineTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleBigqueryRoutineTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google-beta/r/google_bigquery_routine google_bigquery_routine}
*/
export declare class GoogleBigqueryRoutine extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_bigquery_routine";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google-beta/r/google_bigquery_routine google_bigquery_routine} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleBigqueryRoutineConfig
    */
    constructor(scope: Construct, id: string, config: GoogleBigqueryRoutineConfig);
    get creationTime(): number;
    private _datasetId?;
    get datasetId(): string;
    set datasetId(value: string);
    get datasetIdInput(): string | undefined;
    private _definitionBody?;
    get definitionBody(): string;
    set definitionBody(value: string);
    get definitionBodyInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _determinismLevel?;
    get determinismLevel(): string;
    set determinismLevel(value: string);
    resetDeterminismLevel(): void;
    get determinismLevelInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _importedLibraries?;
    get importedLibraries(): string[];
    set importedLibraries(value: string[]);
    resetImportedLibraries(): void;
    get importedLibrariesInput(): string[] | undefined;
    private _language?;
    get language(): string;
    set language(value: string);
    resetLanguage(): void;
    get languageInput(): string | undefined;
    get lastModifiedTime(): number;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _returnTableType?;
    get returnTableType(): string;
    set returnTableType(value: string);
    resetReturnTableType(): void;
    get returnTableTypeInput(): string | undefined;
    private _returnType?;
    get returnType(): string;
    set returnType(value: string);
    resetReturnType(): void;
    get returnTypeInput(): string | undefined;
    private _routineId?;
    get routineId(): string;
    set routineId(value: string);
    get routineIdInput(): string | undefined;
    private _routineType?;
    get routineType(): string;
    set routineType(value: string);
    resetRoutineType(): void;
    get routineTypeInput(): string | undefined;
    private _arguments;
    get arguments(): GoogleBigqueryRoutineArgumentsList;
    putArguments(value: GoogleBigqueryRoutineArguments[] | cdktf.IResolvable): void;
    resetArguments(): void;
    get argumentsInput(): cdktf.IResolvable | GoogleBigqueryRoutineArguments[] | undefined;
    private _timeouts;
    get timeouts(): GoogleBigqueryRoutineTimeoutsOutputReference;
    putTimeouts(value: GoogleBigqueryRoutineTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleBigqueryRoutineTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
