import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleBigtableInstanceConfig extends cdktf.TerraformMetaArguments {
    /**
    * Whether or not to allow Terraform to destroy the instance. Unless this field is set to false in Terraform state, a terraform destroy or terraform apply that would delete the instance will fail.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_bigtable_instance#deletion_protection GoogleBigtableInstance#deletion_protection}
    */
    readonly deletionProtection?: boolean | cdktf.IResolvable;
    /**
    * The human-readable display name of the Bigtable instance. Defaults to the instance name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_bigtable_instance#display_name GoogleBigtableInstance#display_name}
    */
    readonly displayName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_bigtable_instance#id GoogleBigtableInstance#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The instance type to create. One of "DEVELOPMENT" or "PRODUCTION". Defaults to "PRODUCTION".
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_bigtable_instance#instance_type GoogleBigtableInstance#instance_type}
    */
    readonly instanceType?: string;
    /**
    * A mapping of labels to assign to the resource.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_bigtable_instance#labels GoogleBigtableInstance#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * The name (also called Instance Id in the Cloud Console) of the Cloud Bigtable instance.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_bigtable_instance#name GoogleBigtableInstance#name}
    */
    readonly name: string;
    /**
    * The ID of the project in which the resource belongs. If it is not provided, the provider project is used.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_bigtable_instance#project GoogleBigtableInstance#project}
    */
    readonly project?: string;
    /**
    * cluster block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_bigtable_instance#cluster GoogleBigtableInstance#cluster}
    */
    readonly cluster?: GoogleBigtableInstanceCluster[] | cdktf.IResolvable;
}
export interface GoogleBigtableInstanceClusterAutoscalingConfig {
    /**
    * The target CPU utilization for autoscaling. Value must be between 10 and 80.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_bigtable_instance#cpu_target GoogleBigtableInstance#cpu_target}
    */
    readonly cpuTarget: number;
    /**
    * The maximum number of nodes for autoscaling.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_bigtable_instance#max_nodes GoogleBigtableInstance#max_nodes}
    */
    readonly maxNodes: number;
    /**
    * The minimum number of nodes for autoscaling.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_bigtable_instance#min_nodes GoogleBigtableInstance#min_nodes}
    */
    readonly minNodes: number;
    /**
    * The target storage utilization for autoscaling, in GB, for each node in a cluster. This number is limited between 2560 (2.5TiB) and 5120 (5TiB) for a SSD cluster and between 8192 (8TiB) and 16384 (16 TiB) for an HDD cluster. If not set, whatever is already set for the cluster will not change, or if the cluster is just being created, it will use the default value of 2560 for SSD clusters and 8192 for HDD clusters.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_bigtable_instance#storage_target GoogleBigtableInstance#storage_target}
    */
    readonly storageTarget?: number;
}
export declare function googleBigtableInstanceClusterAutoscalingConfigToTerraform(struct?: GoogleBigtableInstanceClusterAutoscalingConfigOutputReference | GoogleBigtableInstanceClusterAutoscalingConfig): any;
export declare class GoogleBigtableInstanceClusterAutoscalingConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleBigtableInstanceClusterAutoscalingConfig | undefined;
    set internalValue(value: GoogleBigtableInstanceClusterAutoscalingConfig | undefined);
    private _cpuTarget?;
    get cpuTarget(): number;
    set cpuTarget(value: number);
    get cpuTargetInput(): number | undefined;
    private _maxNodes?;
    get maxNodes(): number;
    set maxNodes(value: number);
    get maxNodesInput(): number | undefined;
    private _minNodes?;
    get minNodes(): number;
    set minNodes(value: number);
    get minNodesInput(): number | undefined;
    private _storageTarget?;
    get storageTarget(): number;
    set storageTarget(value: number);
    resetStorageTarget(): void;
    get storageTargetInput(): number | undefined;
}
export interface GoogleBigtableInstanceCluster {
    /**
    * The ID of the Cloud Bigtable cluster.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_bigtable_instance#cluster_id GoogleBigtableInstance#cluster_id}
    */
    readonly clusterId: string;
    /**
    * Describes the Cloud KMS encryption key that will be used to protect the destination Bigtable cluster. The requirements for this key are: 1) The Cloud Bigtable service account associated with the project that contains this cluster must be granted the cloudkms.cryptoKeyEncrypterDecrypter role on the CMEK key. 2) Only regional keys can be used and the region of the CMEK key must match the region of the cluster. 3) All clusters within an instance must use the same CMEK key. Values are of the form projects/{project}/locations/{location}/keyRings/{keyring}/cryptoKeys/{key}
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_bigtable_instance#kms_key_name GoogleBigtableInstance#kms_key_name}
    */
    readonly kmsKeyName?: string;
    /**
    * The number of nodes in your Cloud Bigtable cluster. Required, with a minimum of 1 for a PRODUCTION instance. Must be left unset for a DEVELOPMENT instance.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_bigtable_instance#num_nodes GoogleBigtableInstance#num_nodes}
    */
    readonly numNodes?: number;
    /**
    * The storage type to use. One of "SSD" or "HDD". Defaults to "SSD".
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_bigtable_instance#storage_type GoogleBigtableInstance#storage_type}
    */
    readonly storageType?: string;
    /**
    * The zone to create the Cloud Bigtable cluster in. Each cluster must have a different zone in the same region. Zones that support Bigtable instances are noted on the Cloud Bigtable locations page.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_bigtable_instance#zone GoogleBigtableInstance#zone}
    */
    readonly zone?: string;
    /**
    * autoscaling_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_bigtable_instance#autoscaling_config GoogleBigtableInstance#autoscaling_config}
    */
    readonly autoscalingConfig?: GoogleBigtableInstanceClusterAutoscalingConfig;
}
export declare function googleBigtableInstanceClusterToTerraform(struct?: GoogleBigtableInstanceCluster | cdktf.IResolvable): any;
export declare class GoogleBigtableInstanceClusterOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleBigtableInstanceCluster | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleBigtableInstanceCluster | cdktf.IResolvable | undefined);
    private _clusterId?;
    get clusterId(): string;
    set clusterId(value: string);
    get clusterIdInput(): string | undefined;
    private _kmsKeyName?;
    get kmsKeyName(): string;
    set kmsKeyName(value: string);
    resetKmsKeyName(): void;
    get kmsKeyNameInput(): string | undefined;
    private _numNodes?;
    get numNodes(): number;
    set numNodes(value: number);
    resetNumNodes(): void;
    get numNodesInput(): number | undefined;
    private _storageType?;
    get storageType(): string;
    set storageType(value: string);
    resetStorageType(): void;
    get storageTypeInput(): string | undefined;
    private _zone?;
    get zone(): string;
    set zone(value: string);
    resetZone(): void;
    get zoneInput(): string | undefined;
    private _autoscalingConfig;
    get autoscalingConfig(): GoogleBigtableInstanceClusterAutoscalingConfigOutputReference;
    putAutoscalingConfig(value: GoogleBigtableInstanceClusterAutoscalingConfig): void;
    resetAutoscalingConfig(): void;
    get autoscalingConfigInput(): GoogleBigtableInstanceClusterAutoscalingConfig | undefined;
}
export declare class GoogleBigtableInstanceClusterList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleBigtableInstanceCluster[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleBigtableInstanceClusterOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google-beta/r/google_bigtable_instance google_bigtable_instance}
*/
export declare class GoogleBigtableInstance extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_bigtable_instance";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google-beta/r/google_bigtable_instance google_bigtable_instance} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleBigtableInstanceConfig
    */
    constructor(scope: Construct, id: string, config: GoogleBigtableInstanceConfig);
    private _deletionProtection?;
    get deletionProtection(): boolean | cdktf.IResolvable;
    set deletionProtection(value: boolean | cdktf.IResolvable);
    resetDeletionProtection(): void;
    get deletionProtectionInput(): boolean | cdktf.IResolvable | undefined;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    resetDisplayName(): void;
    get displayNameInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _instanceType?;
    get instanceType(): string;
    set instanceType(value: string);
    resetInstanceType(): void;
    get instanceTypeInput(): string | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _cluster;
    get cluster(): GoogleBigtableInstanceClusterList;
    putCluster(value: GoogleBigtableInstanceCluster[] | cdktf.IResolvable): void;
    resetCluster(): void;
    get clusterInput(): cdktf.IResolvable | GoogleBigtableInstanceCluster[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
