import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleBigtableTableIamBindingConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_bigtable_table_iam_binding#id GoogleBigtableTableIamBinding#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_bigtable_table_iam_binding#instance GoogleBigtableTableIamBinding#instance}
    */
    readonly instance: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_bigtable_table_iam_binding#members GoogleBigtableTableIamBinding#members}
    */
    readonly members: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_bigtable_table_iam_binding#project GoogleBigtableTableIamBinding#project}
    */
    readonly project?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_bigtable_table_iam_binding#role GoogleBigtableTableIamBinding#role}
    */
    readonly role: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_bigtable_table_iam_binding#table GoogleBigtableTableIamBinding#table}
    */
    readonly table: string;
    /**
    * condition block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_bigtable_table_iam_binding#condition GoogleBigtableTableIamBinding#condition}
    */
    readonly condition?: GoogleBigtableTableIamBindingCondition;
}
export interface GoogleBigtableTableIamBindingCondition {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_bigtable_table_iam_binding#description GoogleBigtableTableIamBinding#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_bigtable_table_iam_binding#expression GoogleBigtableTableIamBinding#expression}
    */
    readonly expression: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_bigtable_table_iam_binding#title GoogleBigtableTableIamBinding#title}
    */
    readonly title: string;
}
export declare function googleBigtableTableIamBindingConditionToTerraform(struct?: GoogleBigtableTableIamBindingConditionOutputReference | GoogleBigtableTableIamBindingCondition): any;
export declare class GoogleBigtableTableIamBindingConditionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleBigtableTableIamBindingCondition | undefined;
    set internalValue(value: GoogleBigtableTableIamBindingCondition | undefined);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _expression?;
    get expression(): string;
    set expression(value: string);
    get expressionInput(): string | undefined;
    private _title?;
    get title(): string;
    set title(value: string);
    get titleInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google-beta/r/google_bigtable_table_iam_binding google_bigtable_table_iam_binding}
*/
export declare class GoogleBigtableTableIamBinding extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_bigtable_table_iam_binding";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google-beta/r/google_bigtable_table_iam_binding google_bigtable_table_iam_binding} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleBigtableTableIamBindingConfig
    */
    constructor(scope: Construct, id: string, config: GoogleBigtableTableIamBindingConfig);
    get etag(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _instance?;
    get instance(): string;
    set instance(value: string);
    get instanceInput(): string | undefined;
    private _members?;
    get members(): string[];
    set members(value: string[]);
    get membersInput(): string[] | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _role?;
    get role(): string;
    set role(value: string);
    get roleInput(): string | undefined;
    private _table?;
    get table(): string;
    set table(value: string);
    get tableInput(): string | undefined;
    private _condition;
    get condition(): GoogleBigtableTableIamBindingConditionOutputReference;
    putCondition(value: GoogleBigtableTableIamBindingCondition): void;
    resetCondition(): void;
    get conditionInput(): GoogleBigtableTableIamBindingCondition | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
