import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleCertificateManagerCertificateMapConfig extends cdktf.TerraformMetaArguments {
    /**
    * A human-readable description of the resource.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_certificate_manager_certificate_map#description GoogleCertificateManagerCertificateMap#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_certificate_manager_certificate_map#id GoogleCertificateManagerCertificateMap#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Set of labels associated with a Certificate Map resource.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_certificate_manager_certificate_map#labels GoogleCertificateManagerCertificateMap#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * A user-defined name of the Certificate Map. Certificate Map names must be unique
  globally and match the pattern 'projects/*\/locations/*\/certificateMaps/*'.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_certificate_manager_certificate_map#name GoogleCertificateManagerCertificateMap#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_certificate_manager_certificate_map#project GoogleCertificateManagerCertificateMap#project}
    */
    readonly project?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_certificate_manager_certificate_map#timeouts GoogleCertificateManagerCertificateMap#timeouts}
    */
    readonly timeouts?: GoogleCertificateManagerCertificateMapTimeouts;
}
export interface GoogleCertificateManagerCertificateMapGclbTargetsIpConfigs {
}
export declare function googleCertificateManagerCertificateMapGclbTargetsIpConfigsToTerraform(struct?: GoogleCertificateManagerCertificateMapGclbTargetsIpConfigs): any;
export declare class GoogleCertificateManagerCertificateMapGclbTargetsIpConfigsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleCertificateManagerCertificateMapGclbTargetsIpConfigs | undefined;
    set internalValue(value: GoogleCertificateManagerCertificateMapGclbTargetsIpConfigs | undefined);
    get ipAddress(): string;
    get ports(): number[];
}
export declare class GoogleCertificateManagerCertificateMapGclbTargetsIpConfigsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleCertificateManagerCertificateMapGclbTargetsIpConfigsOutputReference;
}
export interface GoogleCertificateManagerCertificateMapGclbTargets {
}
export declare function googleCertificateManagerCertificateMapGclbTargetsToTerraform(struct?: GoogleCertificateManagerCertificateMapGclbTargets): any;
export declare class GoogleCertificateManagerCertificateMapGclbTargetsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleCertificateManagerCertificateMapGclbTargets | undefined;
    set internalValue(value: GoogleCertificateManagerCertificateMapGclbTargets | undefined);
    private _ipConfigs;
    get ipConfigs(): GoogleCertificateManagerCertificateMapGclbTargetsIpConfigsList;
    get targetHttpsProxy(): string;
    get targetSslProxy(): string;
}
export declare class GoogleCertificateManagerCertificateMapGclbTargetsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleCertificateManagerCertificateMapGclbTargetsOutputReference;
}
export interface GoogleCertificateManagerCertificateMapTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_certificate_manager_certificate_map#create GoogleCertificateManagerCertificateMap#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_certificate_manager_certificate_map#delete GoogleCertificateManagerCertificateMap#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_certificate_manager_certificate_map#update GoogleCertificateManagerCertificateMap#update}
    */
    readonly update?: string;
}
export declare function googleCertificateManagerCertificateMapTimeoutsToTerraform(struct?: GoogleCertificateManagerCertificateMapTimeoutsOutputReference | GoogleCertificateManagerCertificateMapTimeouts | cdktf.IResolvable): any;
export declare class GoogleCertificateManagerCertificateMapTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleCertificateManagerCertificateMapTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleCertificateManagerCertificateMapTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google-beta/r/google_certificate_manager_certificate_map google_certificate_manager_certificate_map}
*/
export declare class GoogleCertificateManagerCertificateMap extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_certificate_manager_certificate_map";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google-beta/r/google_certificate_manager_certificate_map google_certificate_manager_certificate_map} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleCertificateManagerCertificateMapConfig
    */
    constructor(scope: Construct, id: string, config: GoogleCertificateManagerCertificateMapConfig);
    get createTime(): string;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _gclbTargets;
    get gclbTargets(): GoogleCertificateManagerCertificateMapGclbTargetsList;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    get updateTime(): string;
    private _timeouts;
    get timeouts(): GoogleCertificateManagerCertificateMapTimeoutsOutputReference;
    putTimeouts(value: GoogleCertificateManagerCertificateMapTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleCertificateManagerCertificateMapTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
