import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleCertificateManagerCertificateConfig extends cdktf.TerraformMetaArguments {
    /**
    * A human-readable description of the resource.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_certificate_manager_certificate#description GoogleCertificateManagerCertificate#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_certificate_manager_certificate#id GoogleCertificateManagerCertificate#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Set of label tags associated with the Certificate resource.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_certificate_manager_certificate#labels GoogleCertificateManagerCertificate#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * A user-defined name of the certificate. Certificate names must be unique
  The name must be 1-64 characters long, and match the regular expression [a-zA-Z][a-zA-Z0-9_-]* which means the first character must be a letter,
  and all following characters must be a dash, underscore, letter or digit.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_certificate_manager_certificate#name GoogleCertificateManagerCertificate#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_certificate_manager_certificate#project GoogleCertificateManagerCertificate#project}
    */
    readonly project?: string;
    /**
    * The scope of the certificate.
  
  DEFAULT: Certificates with default scope are served from core Google data centers.
  If unsure, choose this option.
  
  EDGE_CACHE: Certificates with scope EDGE_CACHE are special-purposed certificates,
  served from non-core Google data centers.
  Currently allowed only for managed certificates.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_certificate_manager_certificate#scope GoogleCertificateManagerCertificate#scope}
    */
    readonly scope?: string;
    /**
    * managed block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_certificate_manager_certificate#managed GoogleCertificateManagerCertificate#managed}
    */
    readonly managed?: GoogleCertificateManagerCertificateManaged;
    /**
    * self_managed block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_certificate_manager_certificate#self_managed GoogleCertificateManagerCertificate#self_managed}
    */
    readonly selfManaged?: GoogleCertificateManagerCertificateSelfManaged;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_certificate_manager_certificate#timeouts GoogleCertificateManagerCertificate#timeouts}
    */
    readonly timeouts?: GoogleCertificateManagerCertificateTimeouts;
}
export interface GoogleCertificateManagerCertificateManagedAuthorizationAttemptInfo {
}
export declare function googleCertificateManagerCertificateManagedAuthorizationAttemptInfoToTerraform(struct?: GoogleCertificateManagerCertificateManagedAuthorizationAttemptInfo): any;
export declare class GoogleCertificateManagerCertificateManagedAuthorizationAttemptInfoOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleCertificateManagerCertificateManagedAuthorizationAttemptInfo | undefined;
    set internalValue(value: GoogleCertificateManagerCertificateManagedAuthorizationAttemptInfo | undefined);
    get details(): string;
    get domain(): string;
    get failureReason(): string;
    get state(): string;
}
export declare class GoogleCertificateManagerCertificateManagedAuthorizationAttemptInfoList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleCertificateManagerCertificateManagedAuthorizationAttemptInfoOutputReference;
}
export interface GoogleCertificateManagerCertificateManagedProvisioningIssue {
}
export declare function googleCertificateManagerCertificateManagedProvisioningIssueToTerraform(struct?: GoogleCertificateManagerCertificateManagedProvisioningIssue): any;
export declare class GoogleCertificateManagerCertificateManagedProvisioningIssueOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleCertificateManagerCertificateManagedProvisioningIssue | undefined;
    set internalValue(value: GoogleCertificateManagerCertificateManagedProvisioningIssue | undefined);
    get details(): string;
    get reason(): string;
}
export declare class GoogleCertificateManagerCertificateManagedProvisioningIssueList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleCertificateManagerCertificateManagedProvisioningIssueOutputReference;
}
export interface GoogleCertificateManagerCertificateManaged {
    /**
    * Authorizations that will be used for performing domain authorization
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_certificate_manager_certificate#dns_authorizations GoogleCertificateManagerCertificate#dns_authorizations}
    */
    readonly dnsAuthorizations?: string[];
    /**
    * The domains for which a managed SSL certificate will be generated.
  Wildcard domains are only supported with DNS challenge resolution
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_certificate_manager_certificate#domains GoogleCertificateManagerCertificate#domains}
    */
    readonly domains?: string[];
}
export declare function googleCertificateManagerCertificateManagedToTerraform(struct?: GoogleCertificateManagerCertificateManagedOutputReference | GoogleCertificateManagerCertificateManaged): any;
export declare class GoogleCertificateManagerCertificateManagedOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleCertificateManagerCertificateManaged | undefined;
    set internalValue(value: GoogleCertificateManagerCertificateManaged | undefined);
    private _authorizationAttemptInfo;
    get authorizationAttemptInfo(): GoogleCertificateManagerCertificateManagedAuthorizationAttemptInfoList;
    private _dnsAuthorizations?;
    get dnsAuthorizations(): string[];
    set dnsAuthorizations(value: string[]);
    resetDnsAuthorizations(): void;
    get dnsAuthorizationsInput(): string[] | undefined;
    private _domains?;
    get domains(): string[];
    set domains(value: string[]);
    resetDomains(): void;
    get domainsInput(): string[] | undefined;
    private _provisioningIssue;
    get provisioningIssue(): GoogleCertificateManagerCertificateManagedProvisioningIssueList;
    get state(): string;
}
export interface GoogleCertificateManagerCertificateSelfManaged {
    /**
    * The certificate chain in PEM-encoded form.
  
  Leaf certificate comes first, followed by intermediate ones if any.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_certificate_manager_certificate#certificate_pem GoogleCertificateManagerCertificate#certificate_pem}
    */
    readonly certificatePem: string;
    /**
    * The private key of the leaf certificate in PEM-encoded form.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_certificate_manager_certificate#private_key_pem GoogleCertificateManagerCertificate#private_key_pem}
    */
    readonly privateKeyPem: string;
}
export declare function googleCertificateManagerCertificateSelfManagedToTerraform(struct?: GoogleCertificateManagerCertificateSelfManagedOutputReference | GoogleCertificateManagerCertificateSelfManaged): any;
export declare class GoogleCertificateManagerCertificateSelfManagedOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleCertificateManagerCertificateSelfManaged | undefined;
    set internalValue(value: GoogleCertificateManagerCertificateSelfManaged | undefined);
    private _certificatePem?;
    get certificatePem(): string;
    set certificatePem(value: string);
    get certificatePemInput(): string | undefined;
    private _privateKeyPem?;
    get privateKeyPem(): string;
    set privateKeyPem(value: string);
    get privateKeyPemInput(): string | undefined;
}
export interface GoogleCertificateManagerCertificateTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_certificate_manager_certificate#create GoogleCertificateManagerCertificate#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_certificate_manager_certificate#delete GoogleCertificateManagerCertificate#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_certificate_manager_certificate#update GoogleCertificateManagerCertificate#update}
    */
    readonly update?: string;
}
export declare function googleCertificateManagerCertificateTimeoutsToTerraform(struct?: GoogleCertificateManagerCertificateTimeoutsOutputReference | GoogleCertificateManagerCertificateTimeouts | cdktf.IResolvable): any;
export declare class GoogleCertificateManagerCertificateTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleCertificateManagerCertificateTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleCertificateManagerCertificateTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google-beta/r/google_certificate_manager_certificate google_certificate_manager_certificate}
*/
export declare class GoogleCertificateManagerCertificate extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_certificate_manager_certificate";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google-beta/r/google_certificate_manager_certificate google_certificate_manager_certificate} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleCertificateManagerCertificateConfig
    */
    constructor(scope: Construct, id: string, config: GoogleCertificateManagerCertificateConfig);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _scope?;
    get scope(): string;
    set scope(value: string);
    resetScope(): void;
    get scopeInput(): string | undefined;
    private _managed;
    get managed(): GoogleCertificateManagerCertificateManagedOutputReference;
    putManaged(value: GoogleCertificateManagerCertificateManaged): void;
    resetManaged(): void;
    get managedInput(): GoogleCertificateManagerCertificateManaged | undefined;
    private _selfManaged;
    get selfManaged(): GoogleCertificateManagerCertificateSelfManagedOutputReference;
    putSelfManaged(value: GoogleCertificateManagerCertificateSelfManaged): void;
    resetSelfManaged(): void;
    get selfManagedInput(): GoogleCertificateManagerCertificateSelfManaged | undefined;
    private _timeouts;
    get timeouts(): GoogleCertificateManagerCertificateTimeoutsOutputReference;
    putTimeouts(value: GoogleCertificateManagerCertificateTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleCertificateManagerCertificateTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
