import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleCloudAssetOrganizationFeedConfig extends cdktf.TerraformMetaArguments {
    /**
    * A list of the full names of the assets to receive updates. You must specify either or both of
  assetNames and assetTypes. Only asset updates matching specified assetNames and assetTypes are
  exported to the feed. For example: //compute.googleapis.com/projects/my_project_123/zones/zone1/instances/instance1.
  See https://cloud.google.com/apis/design/resourceNames#fullResourceName for more info.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_cloud_asset_organization_feed#asset_names GoogleCloudAssetOrganizationFeed#asset_names}
    */
    readonly assetNames?: string[];
    /**
    * A list of types of the assets to receive updates. You must specify either or both of assetNames
  and assetTypes. Only asset updates matching specified assetNames and assetTypes are exported to
  the feed. For example: "compute.googleapis.com/Disk"
  See https://cloud.google.com/asset-inventory/docs/supported-asset-types for a list of all
  supported asset types.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_cloud_asset_organization_feed#asset_types GoogleCloudAssetOrganizationFeed#asset_types}
    */
    readonly assetTypes?: string[];
    /**
    * The project whose identity will be used when sending messages to the
  destination pubsub topic. It also specifies the project for API
  enablement check, quota, and billing.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_cloud_asset_organization_feed#billing_project GoogleCloudAssetOrganizationFeed#billing_project}
    */
    readonly billingProject: string;
    /**
    * Asset content type. If not specified, no content but the asset name and type will be returned. Possible values: ["CONTENT_TYPE_UNSPECIFIED", "RESOURCE", "IAM_POLICY", "ORG_POLICY", "ACCESS_POLICY"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_cloud_asset_organization_feed#content_type GoogleCloudAssetOrganizationFeed#content_type}
    */
    readonly contentType?: string;
    /**
    * This is the client-assigned asset feed identifier and it needs to be unique under a specific parent.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_cloud_asset_organization_feed#feed_id GoogleCloudAssetOrganizationFeed#feed_id}
    */
    readonly feedId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_cloud_asset_organization_feed#id GoogleCloudAssetOrganizationFeed#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The organization this feed should be created in.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_cloud_asset_organization_feed#org_id GoogleCloudAssetOrganizationFeed#org_id}
    */
    readonly orgId: string;
    /**
    * condition block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_cloud_asset_organization_feed#condition GoogleCloudAssetOrganizationFeed#condition}
    */
    readonly condition?: GoogleCloudAssetOrganizationFeedCondition;
    /**
    * feed_output_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_cloud_asset_organization_feed#feed_output_config GoogleCloudAssetOrganizationFeed#feed_output_config}
    */
    readonly feedOutputConfig: GoogleCloudAssetOrganizationFeedFeedOutputConfig;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_cloud_asset_organization_feed#timeouts GoogleCloudAssetOrganizationFeed#timeouts}
    */
    readonly timeouts?: GoogleCloudAssetOrganizationFeedTimeouts;
}
export interface GoogleCloudAssetOrganizationFeedCondition {
    /**
    * Description of the expression. This is a longer text which describes the expression,
  e.g. when hovered over it in a UI.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_cloud_asset_organization_feed#description GoogleCloudAssetOrganizationFeed#description}
    */
    readonly description?: string;
    /**
    * Textual representation of an expression in Common Expression Language syntax.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_cloud_asset_organization_feed#expression GoogleCloudAssetOrganizationFeed#expression}
    */
    readonly expression: string;
    /**
    * String indicating the location of the expression for error reporting, e.g. a file
  name and a position in the file.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_cloud_asset_organization_feed#location GoogleCloudAssetOrganizationFeed#location}
    */
    readonly location?: string;
    /**
    * Title for the expression, i.e. a short string describing its purpose.
  This can be used e.g. in UIs which allow to enter the expression.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_cloud_asset_organization_feed#title GoogleCloudAssetOrganizationFeed#title}
    */
    readonly title?: string;
}
export declare function googleCloudAssetOrganizationFeedConditionToTerraform(struct?: GoogleCloudAssetOrganizationFeedConditionOutputReference | GoogleCloudAssetOrganizationFeedCondition): any;
export declare class GoogleCloudAssetOrganizationFeedConditionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleCloudAssetOrganizationFeedCondition | undefined;
    set internalValue(value: GoogleCloudAssetOrganizationFeedCondition | undefined);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _expression?;
    get expression(): string;
    set expression(value: string);
    get expressionInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    resetLocation(): void;
    get locationInput(): string | undefined;
    private _title?;
    get title(): string;
    set title(value: string);
    resetTitle(): void;
    get titleInput(): string | undefined;
}
export interface GoogleCloudAssetOrganizationFeedFeedOutputConfigPubsubDestination {
    /**
    * Destination on Cloud Pubsub topic.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_cloud_asset_organization_feed#topic GoogleCloudAssetOrganizationFeed#topic}
    */
    readonly topic: string;
}
export declare function googleCloudAssetOrganizationFeedFeedOutputConfigPubsubDestinationToTerraform(struct?: GoogleCloudAssetOrganizationFeedFeedOutputConfigPubsubDestinationOutputReference | GoogleCloudAssetOrganizationFeedFeedOutputConfigPubsubDestination): any;
export declare class GoogleCloudAssetOrganizationFeedFeedOutputConfigPubsubDestinationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleCloudAssetOrganizationFeedFeedOutputConfigPubsubDestination | undefined;
    set internalValue(value: GoogleCloudAssetOrganizationFeedFeedOutputConfigPubsubDestination | undefined);
    private _topic?;
    get topic(): string;
    set topic(value: string);
    get topicInput(): string | undefined;
}
export interface GoogleCloudAssetOrganizationFeedFeedOutputConfig {
    /**
    * pubsub_destination block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_cloud_asset_organization_feed#pubsub_destination GoogleCloudAssetOrganizationFeed#pubsub_destination}
    */
    readonly pubsubDestination: GoogleCloudAssetOrganizationFeedFeedOutputConfigPubsubDestination;
}
export declare function googleCloudAssetOrganizationFeedFeedOutputConfigToTerraform(struct?: GoogleCloudAssetOrganizationFeedFeedOutputConfigOutputReference | GoogleCloudAssetOrganizationFeedFeedOutputConfig): any;
export declare class GoogleCloudAssetOrganizationFeedFeedOutputConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleCloudAssetOrganizationFeedFeedOutputConfig | undefined;
    set internalValue(value: GoogleCloudAssetOrganizationFeedFeedOutputConfig | undefined);
    private _pubsubDestination;
    get pubsubDestination(): GoogleCloudAssetOrganizationFeedFeedOutputConfigPubsubDestinationOutputReference;
    putPubsubDestination(value: GoogleCloudAssetOrganizationFeedFeedOutputConfigPubsubDestination): void;
    get pubsubDestinationInput(): GoogleCloudAssetOrganizationFeedFeedOutputConfigPubsubDestination | undefined;
}
export interface GoogleCloudAssetOrganizationFeedTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_cloud_asset_organization_feed#create GoogleCloudAssetOrganizationFeed#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_cloud_asset_organization_feed#delete GoogleCloudAssetOrganizationFeed#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_cloud_asset_organization_feed#update GoogleCloudAssetOrganizationFeed#update}
    */
    readonly update?: string;
}
export declare function googleCloudAssetOrganizationFeedTimeoutsToTerraform(struct?: GoogleCloudAssetOrganizationFeedTimeoutsOutputReference | GoogleCloudAssetOrganizationFeedTimeouts | cdktf.IResolvable): any;
export declare class GoogleCloudAssetOrganizationFeedTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleCloudAssetOrganizationFeedTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleCloudAssetOrganizationFeedTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google-beta/r/google_cloud_asset_organization_feed google_cloud_asset_organization_feed}
*/
export declare class GoogleCloudAssetOrganizationFeed extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_cloud_asset_organization_feed";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google-beta/r/google_cloud_asset_organization_feed google_cloud_asset_organization_feed} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleCloudAssetOrganizationFeedConfig
    */
    constructor(scope: Construct, id: string, config: GoogleCloudAssetOrganizationFeedConfig);
    private _assetNames?;
    get assetNames(): string[];
    set assetNames(value: string[]);
    resetAssetNames(): void;
    get assetNamesInput(): string[] | undefined;
    private _assetTypes?;
    get assetTypes(): string[];
    set assetTypes(value: string[]);
    resetAssetTypes(): void;
    get assetTypesInput(): string[] | undefined;
    private _billingProject?;
    get billingProject(): string;
    set billingProject(value: string);
    get billingProjectInput(): string | undefined;
    private _contentType?;
    get contentType(): string;
    set contentType(value: string);
    resetContentType(): void;
    get contentTypeInput(): string | undefined;
    private _feedId?;
    get feedId(): string;
    set feedId(value: string);
    get feedIdInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get name(): string;
    private _orgId?;
    get orgId(): string;
    set orgId(value: string);
    get orgIdInput(): string | undefined;
    private _condition;
    get condition(): GoogleCloudAssetOrganizationFeedConditionOutputReference;
    putCondition(value: GoogleCloudAssetOrganizationFeedCondition): void;
    resetCondition(): void;
    get conditionInput(): GoogleCloudAssetOrganizationFeedCondition | undefined;
    private _feedOutputConfig;
    get feedOutputConfig(): GoogleCloudAssetOrganizationFeedFeedOutputConfigOutputReference;
    putFeedOutputConfig(value: GoogleCloudAssetOrganizationFeedFeedOutputConfig): void;
    get feedOutputConfigInput(): GoogleCloudAssetOrganizationFeedFeedOutputConfig | undefined;
    private _timeouts;
    get timeouts(): GoogleCloudAssetOrganizationFeedTimeoutsOutputReference;
    putTimeouts(value: GoogleCloudAssetOrganizationFeedTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleCloudAssetOrganizationFeedTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
