import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleCloudAssetProjectFeedConfig extends cdktf.TerraformMetaArguments {
    /**
    * A list of the full names of the assets to receive updates. You must specify either or both of
  assetNames and assetTypes. Only asset updates matching specified assetNames and assetTypes are
  exported to the feed. For example: //compute.googleapis.com/projects/my_project_123/zones/zone1/instances/instance1.
  See https://cloud.google.com/apis/design/resourceNames#fullResourceName for more info.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_cloud_asset_project_feed#asset_names GoogleCloudAssetProjectFeed#asset_names}
    */
    readonly assetNames?: string[];
    /**
    * A list of types of the assets to receive updates. You must specify either or both of assetNames
  and assetTypes. Only asset updates matching specified assetNames and assetTypes are exported to
  the feed. For example: "compute.googleapis.com/Disk"
  See https://cloud.google.com/asset-inventory/docs/supported-asset-types for a list of all
  supported asset types.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_cloud_asset_project_feed#asset_types GoogleCloudAssetProjectFeed#asset_types}
    */
    readonly assetTypes?: string[];
    /**
    * The project whose identity will be used when sending messages to the
  destination pubsub topic. It also specifies the project for API
  enablement check, quota, and billing. If not specified, the resource's
  project will be used.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_cloud_asset_project_feed#billing_project GoogleCloudAssetProjectFeed#billing_project}
    */
    readonly billingProject?: string;
    /**
    * Asset content type. If not specified, no content but the asset name and type will be returned. Possible values: ["CONTENT_TYPE_UNSPECIFIED", "RESOURCE", "IAM_POLICY", "ORG_POLICY", "ACCESS_POLICY"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_cloud_asset_project_feed#content_type GoogleCloudAssetProjectFeed#content_type}
    */
    readonly contentType?: string;
    /**
    * This is the client-assigned asset feed identifier and it needs to be unique under a specific parent.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_cloud_asset_project_feed#feed_id GoogleCloudAssetProjectFeed#feed_id}
    */
    readonly feedId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_cloud_asset_project_feed#id GoogleCloudAssetProjectFeed#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_cloud_asset_project_feed#project GoogleCloudAssetProjectFeed#project}
    */
    readonly project?: string;
    /**
    * condition block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_cloud_asset_project_feed#condition GoogleCloudAssetProjectFeed#condition}
    */
    readonly condition?: GoogleCloudAssetProjectFeedCondition;
    /**
    * feed_output_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_cloud_asset_project_feed#feed_output_config GoogleCloudAssetProjectFeed#feed_output_config}
    */
    readonly feedOutputConfig: GoogleCloudAssetProjectFeedFeedOutputConfig;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_cloud_asset_project_feed#timeouts GoogleCloudAssetProjectFeed#timeouts}
    */
    readonly timeouts?: GoogleCloudAssetProjectFeedTimeouts;
}
export interface GoogleCloudAssetProjectFeedCondition {
    /**
    * Description of the expression. This is a longer text which describes the expression,
  e.g. when hovered over it in a UI.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_cloud_asset_project_feed#description GoogleCloudAssetProjectFeed#description}
    */
    readonly description?: string;
    /**
    * Textual representation of an expression in Common Expression Language syntax.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_cloud_asset_project_feed#expression GoogleCloudAssetProjectFeed#expression}
    */
    readonly expression: string;
    /**
    * String indicating the location of the expression for error reporting, e.g. a file
  name and a position in the file.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_cloud_asset_project_feed#location GoogleCloudAssetProjectFeed#location}
    */
    readonly location?: string;
    /**
    * Title for the expression, i.e. a short string describing its purpose.
  This can be used e.g. in UIs which allow to enter the expression.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_cloud_asset_project_feed#title GoogleCloudAssetProjectFeed#title}
    */
    readonly title?: string;
}
export declare function googleCloudAssetProjectFeedConditionToTerraform(struct?: GoogleCloudAssetProjectFeedConditionOutputReference | GoogleCloudAssetProjectFeedCondition): any;
export declare class GoogleCloudAssetProjectFeedConditionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleCloudAssetProjectFeedCondition | undefined;
    set internalValue(value: GoogleCloudAssetProjectFeedCondition | undefined);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _expression?;
    get expression(): string;
    set expression(value: string);
    get expressionInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    resetLocation(): void;
    get locationInput(): string | undefined;
    private _title?;
    get title(): string;
    set title(value: string);
    resetTitle(): void;
    get titleInput(): string | undefined;
}
export interface GoogleCloudAssetProjectFeedFeedOutputConfigPubsubDestination {
    /**
    * Destination on Cloud Pubsub topic.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_cloud_asset_project_feed#topic GoogleCloudAssetProjectFeed#topic}
    */
    readonly topic: string;
}
export declare function googleCloudAssetProjectFeedFeedOutputConfigPubsubDestinationToTerraform(struct?: GoogleCloudAssetProjectFeedFeedOutputConfigPubsubDestinationOutputReference | GoogleCloudAssetProjectFeedFeedOutputConfigPubsubDestination): any;
export declare class GoogleCloudAssetProjectFeedFeedOutputConfigPubsubDestinationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleCloudAssetProjectFeedFeedOutputConfigPubsubDestination | undefined;
    set internalValue(value: GoogleCloudAssetProjectFeedFeedOutputConfigPubsubDestination | undefined);
    private _topic?;
    get topic(): string;
    set topic(value: string);
    get topicInput(): string | undefined;
}
export interface GoogleCloudAssetProjectFeedFeedOutputConfig {
    /**
    * pubsub_destination block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_cloud_asset_project_feed#pubsub_destination GoogleCloudAssetProjectFeed#pubsub_destination}
    */
    readonly pubsubDestination: GoogleCloudAssetProjectFeedFeedOutputConfigPubsubDestination;
}
export declare function googleCloudAssetProjectFeedFeedOutputConfigToTerraform(struct?: GoogleCloudAssetProjectFeedFeedOutputConfigOutputReference | GoogleCloudAssetProjectFeedFeedOutputConfig): any;
export declare class GoogleCloudAssetProjectFeedFeedOutputConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleCloudAssetProjectFeedFeedOutputConfig | undefined;
    set internalValue(value: GoogleCloudAssetProjectFeedFeedOutputConfig | undefined);
    private _pubsubDestination;
    get pubsubDestination(): GoogleCloudAssetProjectFeedFeedOutputConfigPubsubDestinationOutputReference;
    putPubsubDestination(value: GoogleCloudAssetProjectFeedFeedOutputConfigPubsubDestination): void;
    get pubsubDestinationInput(): GoogleCloudAssetProjectFeedFeedOutputConfigPubsubDestination | undefined;
}
export interface GoogleCloudAssetProjectFeedTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_cloud_asset_project_feed#create GoogleCloudAssetProjectFeed#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_cloud_asset_project_feed#delete GoogleCloudAssetProjectFeed#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_cloud_asset_project_feed#update GoogleCloudAssetProjectFeed#update}
    */
    readonly update?: string;
}
export declare function googleCloudAssetProjectFeedTimeoutsToTerraform(struct?: GoogleCloudAssetProjectFeedTimeoutsOutputReference | GoogleCloudAssetProjectFeedTimeouts | cdktf.IResolvable): any;
export declare class GoogleCloudAssetProjectFeedTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleCloudAssetProjectFeedTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleCloudAssetProjectFeedTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google-beta/r/google_cloud_asset_project_feed google_cloud_asset_project_feed}
*/
export declare class GoogleCloudAssetProjectFeed extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_cloud_asset_project_feed";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google-beta/r/google_cloud_asset_project_feed google_cloud_asset_project_feed} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleCloudAssetProjectFeedConfig
    */
    constructor(scope: Construct, id: string, config: GoogleCloudAssetProjectFeedConfig);
    private _assetNames?;
    get assetNames(): string[];
    set assetNames(value: string[]);
    resetAssetNames(): void;
    get assetNamesInput(): string[] | undefined;
    private _assetTypes?;
    get assetTypes(): string[];
    set assetTypes(value: string[]);
    resetAssetTypes(): void;
    get assetTypesInput(): string[] | undefined;
    private _billingProject?;
    get billingProject(): string;
    set billingProject(value: string);
    resetBillingProject(): void;
    get billingProjectInput(): string | undefined;
    private _contentType?;
    get contentType(): string;
    set contentType(value: string);
    resetContentType(): void;
    get contentTypeInput(): string | undefined;
    private _feedId?;
    get feedId(): string;
    set feedId(value: string);
    get feedIdInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get name(): string;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _condition;
    get condition(): GoogleCloudAssetProjectFeedConditionOutputReference;
    putCondition(value: GoogleCloudAssetProjectFeedCondition): void;
    resetCondition(): void;
    get conditionInput(): GoogleCloudAssetProjectFeedCondition | undefined;
    private _feedOutputConfig;
    get feedOutputConfig(): GoogleCloudAssetProjectFeedFeedOutputConfigOutputReference;
    putFeedOutputConfig(value: GoogleCloudAssetProjectFeedFeedOutputConfig): void;
    get feedOutputConfigInput(): GoogleCloudAssetProjectFeedFeedOutputConfig | undefined;
    private _timeouts;
    get timeouts(): GoogleCloudAssetProjectFeedTimeoutsOutputReference;
    putTimeouts(value: GoogleCloudAssetProjectFeedTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleCloudAssetProjectFeedTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
