import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleCloudTasksQueueConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_cloud_tasks_queue#id GoogleCloudTasksQueue#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The location of the queue
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_cloud_tasks_queue#location GoogleCloudTasksQueue#location}
    */
    readonly location: string;
    /**
    * The queue name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_cloud_tasks_queue#name GoogleCloudTasksQueue#name}
    */
    readonly name?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_cloud_tasks_queue#project GoogleCloudTasksQueue#project}
    */
    readonly project?: string;
    /**
    * app_engine_routing_override block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_cloud_tasks_queue#app_engine_routing_override GoogleCloudTasksQueue#app_engine_routing_override}
    */
    readonly appEngineRoutingOverride?: GoogleCloudTasksQueueAppEngineRoutingOverride;
    /**
    * rate_limits block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_cloud_tasks_queue#rate_limits GoogleCloudTasksQueue#rate_limits}
    */
    readonly rateLimits?: GoogleCloudTasksQueueRateLimits;
    /**
    * retry_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_cloud_tasks_queue#retry_config GoogleCloudTasksQueue#retry_config}
    */
    readonly retryConfig?: GoogleCloudTasksQueueRetryConfig;
    /**
    * stackdriver_logging_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_cloud_tasks_queue#stackdriver_logging_config GoogleCloudTasksQueue#stackdriver_logging_config}
    */
    readonly stackdriverLoggingConfig?: GoogleCloudTasksQueueStackdriverLoggingConfig;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_cloud_tasks_queue#timeouts GoogleCloudTasksQueue#timeouts}
    */
    readonly timeouts?: GoogleCloudTasksQueueTimeouts;
}
export interface GoogleCloudTasksQueueAppEngineRoutingOverride {
    /**
    * App instance.
  
  By default, the task is sent to an instance which is available when the task is attempted.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_cloud_tasks_queue#instance GoogleCloudTasksQueue#instance}
    */
    readonly instance?: string;
    /**
    * App service.
  
  By default, the task is sent to the service which is the default service when the task is attempted.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_cloud_tasks_queue#service GoogleCloudTasksQueue#service}
    */
    readonly service?: string;
    /**
    * App version.
  
  By default, the task is sent to the version which is the default version when the task is attempted.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_cloud_tasks_queue#version GoogleCloudTasksQueue#version}
    */
    readonly version?: string;
}
export declare function googleCloudTasksQueueAppEngineRoutingOverrideToTerraform(struct?: GoogleCloudTasksQueueAppEngineRoutingOverrideOutputReference | GoogleCloudTasksQueueAppEngineRoutingOverride): any;
export declare class GoogleCloudTasksQueueAppEngineRoutingOverrideOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleCloudTasksQueueAppEngineRoutingOverride | undefined;
    set internalValue(value: GoogleCloudTasksQueueAppEngineRoutingOverride | undefined);
    get host(): string;
    private _instance?;
    get instance(): string;
    set instance(value: string);
    resetInstance(): void;
    get instanceInput(): string | undefined;
    private _service?;
    get service(): string;
    set service(value: string);
    resetService(): void;
    get serviceInput(): string | undefined;
    private _version?;
    get version(): string;
    set version(value: string);
    resetVersion(): void;
    get versionInput(): string | undefined;
}
export interface GoogleCloudTasksQueueRateLimits {
    /**
    * The maximum number of concurrent tasks that Cloud Tasks allows to
  be dispatched for this queue. After this threshold has been
  reached, Cloud Tasks stops dispatching tasks until the number of
  concurrent requests decreases.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_cloud_tasks_queue#max_concurrent_dispatches GoogleCloudTasksQueue#max_concurrent_dispatches}
    */
    readonly maxConcurrentDispatches?: number;
    /**
    * The maximum rate at which tasks are dispatched from this queue.
  
  If unspecified when the queue is created, Cloud Tasks will pick the default.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_cloud_tasks_queue#max_dispatches_per_second GoogleCloudTasksQueue#max_dispatches_per_second}
    */
    readonly maxDispatchesPerSecond?: number;
}
export declare function googleCloudTasksQueueRateLimitsToTerraform(struct?: GoogleCloudTasksQueueRateLimitsOutputReference | GoogleCloudTasksQueueRateLimits): any;
export declare class GoogleCloudTasksQueueRateLimitsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleCloudTasksQueueRateLimits | undefined;
    set internalValue(value: GoogleCloudTasksQueueRateLimits | undefined);
    get maxBurstSize(): number;
    private _maxConcurrentDispatches?;
    get maxConcurrentDispatches(): number;
    set maxConcurrentDispatches(value: number);
    resetMaxConcurrentDispatches(): void;
    get maxConcurrentDispatchesInput(): number | undefined;
    private _maxDispatchesPerSecond?;
    get maxDispatchesPerSecond(): number;
    set maxDispatchesPerSecond(value: number);
    resetMaxDispatchesPerSecond(): void;
    get maxDispatchesPerSecondInput(): number | undefined;
}
export interface GoogleCloudTasksQueueRetryConfig {
    /**
    * Number of attempts per task.
  
  Cloud Tasks will attempt the task maxAttempts times (that is, if
  the first attempt fails, then there will be maxAttempts - 1
  retries). Must be >= -1.
  
  If unspecified when the queue is created, Cloud Tasks will pick
  the default.
  
  -1 indicates unlimited attempts.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_cloud_tasks_queue#max_attempts GoogleCloudTasksQueue#max_attempts}
    */
    readonly maxAttempts?: number;
    /**
    * A task will be scheduled for retry between minBackoff and
  maxBackoff duration after it fails, if the queue's RetryConfig
  specifies that the task should be retried.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_cloud_tasks_queue#max_backoff GoogleCloudTasksQueue#max_backoff}
    */
    readonly maxBackoff?: string;
    /**
    * The time between retries will double maxDoublings times.
  
  A task's retry interval starts at minBackoff, then doubles maxDoublings times,
  then increases linearly, and finally retries retries at intervals of maxBackoff
  up to maxAttempts times.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_cloud_tasks_queue#max_doublings GoogleCloudTasksQueue#max_doublings}
    */
    readonly maxDoublings?: number;
    /**
    * If positive, maxRetryDuration specifies the time limit for
  retrying a failed task, measured from when the task was first
  attempted. Once maxRetryDuration time has passed and the task has
  been attempted maxAttempts times, no further attempts will be
  made and the task will be deleted.
  
  If zero, then the task age is unlimited.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_cloud_tasks_queue#max_retry_duration GoogleCloudTasksQueue#max_retry_duration}
    */
    readonly maxRetryDuration?: string;
    /**
    * A task will be scheduled for retry between minBackoff and
  maxBackoff duration after it fails, if the queue's RetryConfig
  specifies that the task should be retried.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_cloud_tasks_queue#min_backoff GoogleCloudTasksQueue#min_backoff}
    */
    readonly minBackoff?: string;
}
export declare function googleCloudTasksQueueRetryConfigToTerraform(struct?: GoogleCloudTasksQueueRetryConfigOutputReference | GoogleCloudTasksQueueRetryConfig): any;
export declare class GoogleCloudTasksQueueRetryConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleCloudTasksQueueRetryConfig | undefined;
    set internalValue(value: GoogleCloudTasksQueueRetryConfig | undefined);
    private _maxAttempts?;
    get maxAttempts(): number;
    set maxAttempts(value: number);
    resetMaxAttempts(): void;
    get maxAttemptsInput(): number | undefined;
    private _maxBackoff?;
    get maxBackoff(): string;
    set maxBackoff(value: string);
    resetMaxBackoff(): void;
    get maxBackoffInput(): string | undefined;
    private _maxDoublings?;
    get maxDoublings(): number;
    set maxDoublings(value: number);
    resetMaxDoublings(): void;
    get maxDoublingsInput(): number | undefined;
    private _maxRetryDuration?;
    get maxRetryDuration(): string;
    set maxRetryDuration(value: string);
    resetMaxRetryDuration(): void;
    get maxRetryDurationInput(): string | undefined;
    private _minBackoff?;
    get minBackoff(): string;
    set minBackoff(value: string);
    resetMinBackoff(): void;
    get minBackoffInput(): string | undefined;
}
export interface GoogleCloudTasksQueueStackdriverLoggingConfig {
    /**
    * Specifies the fraction of operations to write to Stackdriver Logging.
  This field may contain any value between 0.0 and 1.0, inclusive. 0.0 is the
  default and means that no operations are logged.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_cloud_tasks_queue#sampling_ratio GoogleCloudTasksQueue#sampling_ratio}
    */
    readonly samplingRatio: number;
}
export declare function googleCloudTasksQueueStackdriverLoggingConfigToTerraform(struct?: GoogleCloudTasksQueueStackdriverLoggingConfigOutputReference | GoogleCloudTasksQueueStackdriverLoggingConfig): any;
export declare class GoogleCloudTasksQueueStackdriverLoggingConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleCloudTasksQueueStackdriverLoggingConfig | undefined;
    set internalValue(value: GoogleCloudTasksQueueStackdriverLoggingConfig | undefined);
    private _samplingRatio?;
    get samplingRatio(): number;
    set samplingRatio(value: number);
    get samplingRatioInput(): number | undefined;
}
export interface GoogleCloudTasksQueueTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_cloud_tasks_queue#create GoogleCloudTasksQueue#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_cloud_tasks_queue#delete GoogleCloudTasksQueue#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_cloud_tasks_queue#update GoogleCloudTasksQueue#update}
    */
    readonly update?: string;
}
export declare function googleCloudTasksQueueTimeoutsToTerraform(struct?: GoogleCloudTasksQueueTimeoutsOutputReference | GoogleCloudTasksQueueTimeouts | cdktf.IResolvable): any;
export declare class GoogleCloudTasksQueueTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleCloudTasksQueueTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleCloudTasksQueueTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google-beta/r/google_cloud_tasks_queue google_cloud_tasks_queue}
*/
export declare class GoogleCloudTasksQueue extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_cloud_tasks_queue";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google-beta/r/google_cloud_tasks_queue google_cloud_tasks_queue} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleCloudTasksQueueConfig
    */
    constructor(scope: Construct, id: string, config: GoogleCloudTasksQueueConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _appEngineRoutingOverride;
    get appEngineRoutingOverride(): GoogleCloudTasksQueueAppEngineRoutingOverrideOutputReference;
    putAppEngineRoutingOverride(value: GoogleCloudTasksQueueAppEngineRoutingOverride): void;
    resetAppEngineRoutingOverride(): void;
    get appEngineRoutingOverrideInput(): GoogleCloudTasksQueueAppEngineRoutingOverride | undefined;
    private _rateLimits;
    get rateLimits(): GoogleCloudTasksQueueRateLimitsOutputReference;
    putRateLimits(value: GoogleCloudTasksQueueRateLimits): void;
    resetRateLimits(): void;
    get rateLimitsInput(): GoogleCloudTasksQueueRateLimits | undefined;
    private _retryConfig;
    get retryConfig(): GoogleCloudTasksQueueRetryConfigOutputReference;
    putRetryConfig(value: GoogleCloudTasksQueueRetryConfig): void;
    resetRetryConfig(): void;
    get retryConfigInput(): GoogleCloudTasksQueueRetryConfig | undefined;
    private _stackdriverLoggingConfig;
    get stackdriverLoggingConfig(): GoogleCloudTasksQueueStackdriverLoggingConfigOutputReference;
    putStackdriverLoggingConfig(value: GoogleCloudTasksQueueStackdriverLoggingConfig): void;
    resetStackdriverLoggingConfig(): void;
    get stackdriverLoggingConfigInput(): GoogleCloudTasksQueueStackdriverLoggingConfig | undefined;
    private _timeouts;
    get timeouts(): GoogleCloudTasksQueueTimeoutsOutputReference;
    putTimeouts(value: GoogleCloudTasksQueueTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleCloudTasksQueueTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
