import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleCloudbuildTriggerConfig extends cdktf.TerraformMetaArguments {
    /**
    * Human-readable description of the trigger.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_cloudbuild_trigger#description GoogleCloudbuildTrigger#description}
    */
    readonly description?: string;
    /**
    * Whether the trigger is disabled or not. If true, the trigger will never result in a build.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_cloudbuild_trigger#disabled GoogleCloudbuildTrigger#disabled}
    */
    readonly disabled?: boolean | cdktf.IResolvable;
    /**
    * Path, from the source root, to a file whose contents is used for the template.
  Either a filename or build template must be provided. Set this only when using trigger_template or github.
  When using Pub/Sub, Webhook or Manual set the file name using git_file_source instead.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_cloudbuild_trigger#filename GoogleCloudbuildTrigger#filename}
    */
    readonly filename?: string;
    /**
    * A Common Expression Language string. Used only with Pub/Sub and Webhook.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_cloudbuild_trigger#filter GoogleCloudbuildTrigger#filter}
    */
    readonly filter?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_cloudbuild_trigger#id GoogleCloudbuildTrigger#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * ignoredFiles and includedFiles are file glob matches using https://golang.org/pkg/path/filepath/#Match
  extended with support for '**'.
  
  If ignoredFiles and changed files are both empty, then they are not
  used to determine whether or not to trigger a build.
  
  If ignoredFiles is not empty, then we ignore any files that match any
  of the ignored_file globs. If the change has no files that are outside
  of the ignoredFiles globs, then we do not trigger a build.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_cloudbuild_trigger#ignored_files GoogleCloudbuildTrigger#ignored_files}
    */
    readonly ignoredFiles?: string[];
    /**
    * Build logs will be sent back to GitHub as part of the checkrun
  result.  Values can be INCLUDE_BUILD_LOGS_UNSPECIFIED or
  INCLUDE_BUILD_LOGS_WITH_STATUS Possible values: ["INCLUDE_BUILD_LOGS_UNSPECIFIED", "INCLUDE_BUILD_LOGS_WITH_STATUS"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_cloudbuild_trigger#include_build_logs GoogleCloudbuildTrigger#include_build_logs}
    */
    readonly includeBuildLogs?: string;
    /**
    * ignoredFiles and includedFiles are file glob matches using https://golang.org/pkg/path/filepath/#Match
  extended with support for '**'.
  
  If any of the files altered in the commit pass the ignoredFiles filter
  and includedFiles is empty, then as far as this filter is concerned, we
  should trigger the build.
  
  If any of the files altered in the commit pass the ignoredFiles filter
  and includedFiles is not empty, then we make sure that at least one of
  those files matches a includedFiles glob. If not, then we do not trigger
  a build.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_cloudbuild_trigger#included_files GoogleCloudbuildTrigger#included_files}
    */
    readonly includedFiles?: string[];
    /**
    * The [Cloud Build location](https://cloud.google.com/build/docs/locations) for the trigger.
  If not specified, "global" is used.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_cloudbuild_trigger#location GoogleCloudbuildTrigger#location}
    */
    readonly location?: string;
    /**
    * Name of the trigger. Must be unique within the project.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_cloudbuild_trigger#name GoogleCloudbuildTrigger#name}
    */
    readonly name?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_cloudbuild_trigger#project GoogleCloudbuildTrigger#project}
    */
    readonly project?: string;
    /**
    * The service account used for all user-controlled operations including
  triggers.patch, triggers.run, builds.create, and builds.cancel.
  
  If no service account is set, then the standard Cloud Build service account
  ([PROJECT_NUM]@system.gserviceaccount.com) will be used instead.
  
  Format: projects/{PROJECT_ID}/serviceAccounts/{ACCOUNT_ID_OR_EMAIL}
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_cloudbuild_trigger#service_account GoogleCloudbuildTrigger#service_account}
    */
    readonly serviceAccount?: string;
    /**
    * Substitutions data for Build resource.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_cloudbuild_trigger#substitutions GoogleCloudbuildTrigger#substitutions}
    */
    readonly substitutions?: {
        [key: string]: string;
    };
    /**
    * Tags for annotation of a BuildTrigger
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_cloudbuild_trigger#tags GoogleCloudbuildTrigger#tags}
    */
    readonly tags?: string[];
    /**
    * approval_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_cloudbuild_trigger#approval_config GoogleCloudbuildTrigger#approval_config}
    */
    readonly approvalConfig?: GoogleCloudbuildTriggerApprovalConfig;
    /**
    * build block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_cloudbuild_trigger#build GoogleCloudbuildTrigger#build}
    */
    readonly buildAttribute?: GoogleCloudbuildTriggerBuild;
    /**
    * git_file_source block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_cloudbuild_trigger#git_file_source GoogleCloudbuildTrigger#git_file_source}
    */
    readonly gitFileSource?: GoogleCloudbuildTriggerGitFileSource;
    /**
    * github block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_cloudbuild_trigger#github GoogleCloudbuildTrigger#github}
    */
    readonly github?: GoogleCloudbuildTriggerGithub;
    /**
    * pubsub_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_cloudbuild_trigger#pubsub_config GoogleCloudbuildTrigger#pubsub_config}
    */
    readonly pubsubConfig?: GoogleCloudbuildTriggerPubsubConfig;
    /**
    * source_to_build block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_cloudbuild_trigger#source_to_build GoogleCloudbuildTrigger#source_to_build}
    */
    readonly sourceToBuild?: GoogleCloudbuildTriggerSourceToBuild;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_cloudbuild_trigger#timeouts GoogleCloudbuildTrigger#timeouts}
    */
    readonly timeouts?: GoogleCloudbuildTriggerTimeouts;
    /**
    * trigger_template block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_cloudbuild_trigger#trigger_template GoogleCloudbuildTrigger#trigger_template}
    */
    readonly triggerTemplate?: GoogleCloudbuildTriggerTriggerTemplate;
    /**
    * webhook_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_cloudbuild_trigger#webhook_config GoogleCloudbuildTrigger#webhook_config}
    */
    readonly webhookConfig?: GoogleCloudbuildTriggerWebhookConfig;
}
export interface GoogleCloudbuildTriggerApprovalConfig {
    /**
    * Whether or not approval is needed. If this is set on a build, it will become pending when run,
  and will need to be explicitly approved to start.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_cloudbuild_trigger#approval_required GoogleCloudbuildTrigger#approval_required}
    */
    readonly approvalRequired?: boolean | cdktf.IResolvable;
}
export declare function googleCloudbuildTriggerApprovalConfigToTerraform(struct?: GoogleCloudbuildTriggerApprovalConfigOutputReference | GoogleCloudbuildTriggerApprovalConfig): any;
export declare class GoogleCloudbuildTriggerApprovalConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleCloudbuildTriggerApprovalConfig | undefined;
    set internalValue(value: GoogleCloudbuildTriggerApprovalConfig | undefined);
    private _approvalRequired?;
    get approvalRequired(): boolean | cdktf.IResolvable;
    set approvalRequired(value: boolean | cdktf.IResolvable);
    resetApprovalRequired(): void;
    get approvalRequiredInput(): boolean | cdktf.IResolvable | undefined;
}
export interface GoogleCloudbuildTriggerBuildArtifactsObjectsTiming {
}
export declare function googleCloudbuildTriggerBuildArtifactsObjectsTimingToTerraform(struct?: GoogleCloudbuildTriggerBuildArtifactsObjectsTiming): any;
export declare class GoogleCloudbuildTriggerBuildArtifactsObjectsTimingOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleCloudbuildTriggerBuildArtifactsObjectsTiming | undefined;
    set internalValue(value: GoogleCloudbuildTriggerBuildArtifactsObjectsTiming | undefined);
    get endTime(): string;
    get startTime(): string;
}
export declare class GoogleCloudbuildTriggerBuildArtifactsObjectsTimingList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleCloudbuildTriggerBuildArtifactsObjectsTimingOutputReference;
}
export interface GoogleCloudbuildTriggerBuildArtifactsObjects {
    /**
    * Cloud Storage bucket and optional object path, in the form "gs://bucket/path/to/somewhere/".
  
  Files in the workspace matching any path pattern will be uploaded to Cloud Storage with
  this location as a prefix.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_cloudbuild_trigger#location GoogleCloudbuildTrigger#location}
    */
    readonly location?: string;
    /**
    * Path globs used to match files in the build's workspace.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_cloudbuild_trigger#paths GoogleCloudbuildTrigger#paths}
    */
    readonly paths?: string[];
}
export declare function googleCloudbuildTriggerBuildArtifactsObjectsToTerraform(struct?: GoogleCloudbuildTriggerBuildArtifactsObjectsOutputReference | GoogleCloudbuildTriggerBuildArtifactsObjects): any;
export declare class GoogleCloudbuildTriggerBuildArtifactsObjectsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleCloudbuildTriggerBuildArtifactsObjects | undefined;
    set internalValue(value: GoogleCloudbuildTriggerBuildArtifactsObjects | undefined);
    private _location?;
    get location(): string;
    set location(value: string);
    resetLocation(): void;
    get locationInput(): string | undefined;
    private _paths?;
    get paths(): string[];
    set paths(value: string[]);
    resetPaths(): void;
    get pathsInput(): string[] | undefined;
    private _timing;
    get timing(): GoogleCloudbuildTriggerBuildArtifactsObjectsTimingList;
}
export interface GoogleCloudbuildTriggerBuildArtifacts {
    /**
    * A list of images to be pushed upon the successful completion of all build steps.
  
  The images will be pushed using the builder service account's credentials.
  
  The digests of the pushed images will be stored in the Build resource's results field.
  
  If any of the images fail to be pushed, the build is marked FAILURE.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_cloudbuild_trigger#images GoogleCloudbuildTrigger#images}
    */
    readonly images?: string[];
    /**
    * objects block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_cloudbuild_trigger#objects GoogleCloudbuildTrigger#objects}
    */
    readonly objects?: GoogleCloudbuildTriggerBuildArtifactsObjects;
}
export declare function googleCloudbuildTriggerBuildArtifactsToTerraform(struct?: GoogleCloudbuildTriggerBuildArtifactsOutputReference | GoogleCloudbuildTriggerBuildArtifacts): any;
export declare class GoogleCloudbuildTriggerBuildArtifactsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleCloudbuildTriggerBuildArtifacts | undefined;
    set internalValue(value: GoogleCloudbuildTriggerBuildArtifacts | undefined);
    private _images?;
    get images(): string[];
    set images(value: string[]);
    resetImages(): void;
    get imagesInput(): string[] | undefined;
    private _objects;
    get objects(): GoogleCloudbuildTriggerBuildArtifactsObjectsOutputReference;
    putObjects(value: GoogleCloudbuildTriggerBuildArtifactsObjects): void;
    resetObjects(): void;
    get objectsInput(): GoogleCloudbuildTriggerBuildArtifactsObjects | undefined;
}
export interface GoogleCloudbuildTriggerBuildAvailableSecretsSecretManager {
    /**
    * Environment variable name to associate with the secret. Secret environment
  variables must be unique across all of a build's secrets, and must be used
  by at least one build step.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_cloudbuild_trigger#env GoogleCloudbuildTrigger#env}
    */
    readonly env: string;
    /**
    * Resource name of the SecretVersion. In format: projects/*\/secrets/*\/versions/*
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_cloudbuild_trigger#version_name GoogleCloudbuildTrigger#version_name}
    */
    readonly versionName: string;
}
export declare function googleCloudbuildTriggerBuildAvailableSecretsSecretManagerToTerraform(struct?: GoogleCloudbuildTriggerBuildAvailableSecretsSecretManager | cdktf.IResolvable): any;
export declare class GoogleCloudbuildTriggerBuildAvailableSecretsSecretManagerOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleCloudbuildTriggerBuildAvailableSecretsSecretManager | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleCloudbuildTriggerBuildAvailableSecretsSecretManager | cdktf.IResolvable | undefined);
    private _env?;
    get env(): string;
    set env(value: string);
    get envInput(): string | undefined;
    private _versionName?;
    get versionName(): string;
    set versionName(value: string);
    get versionNameInput(): string | undefined;
}
export declare class GoogleCloudbuildTriggerBuildAvailableSecretsSecretManagerList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleCloudbuildTriggerBuildAvailableSecretsSecretManager[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleCloudbuildTriggerBuildAvailableSecretsSecretManagerOutputReference;
}
export interface GoogleCloudbuildTriggerBuildAvailableSecrets {
    /**
    * secret_manager block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_cloudbuild_trigger#secret_manager GoogleCloudbuildTrigger#secret_manager}
    */
    readonly secretManager: GoogleCloudbuildTriggerBuildAvailableSecretsSecretManager[] | cdktf.IResolvable;
}
export declare function googleCloudbuildTriggerBuildAvailableSecretsToTerraform(struct?: GoogleCloudbuildTriggerBuildAvailableSecretsOutputReference | GoogleCloudbuildTriggerBuildAvailableSecrets): any;
export declare class GoogleCloudbuildTriggerBuildAvailableSecretsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleCloudbuildTriggerBuildAvailableSecrets | undefined;
    set internalValue(value: GoogleCloudbuildTriggerBuildAvailableSecrets | undefined);
    private _secretManager;
    get secretManager(): GoogleCloudbuildTriggerBuildAvailableSecretsSecretManagerList;
    putSecretManager(value: GoogleCloudbuildTriggerBuildAvailableSecretsSecretManager[] | cdktf.IResolvable): void;
    get secretManagerInput(): cdktf.IResolvable | GoogleCloudbuildTriggerBuildAvailableSecretsSecretManager[] | undefined;
}
export interface GoogleCloudbuildTriggerBuildOptionsVolumes {
    /**
    * Name of the volume to mount.
  
  Volume names must be unique per build step and must be valid names for Docker volumes.
  Each named volume must be used by at least two build steps.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_cloudbuild_trigger#name GoogleCloudbuildTrigger#name}
    */
    readonly name?: string;
    /**
    * Path at which to mount the volume.
  
  Paths must be absolute and cannot conflict with other volume paths on the same
  build step or with certain reserved volume paths.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_cloudbuild_trigger#path GoogleCloudbuildTrigger#path}
    */
    readonly path?: string;
}
export declare function googleCloudbuildTriggerBuildOptionsVolumesToTerraform(struct?: GoogleCloudbuildTriggerBuildOptionsVolumes | cdktf.IResolvable): any;
export declare class GoogleCloudbuildTriggerBuildOptionsVolumesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleCloudbuildTriggerBuildOptionsVolumes | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleCloudbuildTriggerBuildOptionsVolumes | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    resetPath(): void;
    get pathInput(): string | undefined;
}
export declare class GoogleCloudbuildTriggerBuildOptionsVolumesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleCloudbuildTriggerBuildOptionsVolumes[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleCloudbuildTriggerBuildOptionsVolumesOutputReference;
}
export interface GoogleCloudbuildTriggerBuildOptions {
    /**
    * Requested disk size for the VM that runs the build. Note that this is NOT "disk free";
  some of the space will be used by the operating system and build utilities.
  Also note that this is the minimum disk size that will be allocated for the build --
  the build may run with a larger disk than requested. At present, the maximum disk size
  is 1000GB; builds that request more than the maximum are rejected with an error.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_cloudbuild_trigger#disk_size_gb GoogleCloudbuildTrigger#disk_size_gb}
    */
    readonly diskSizeGb?: number;
    /**
    * Option to specify whether or not to apply bash style string operations to the substitutions.
  
  NOTE this is always enabled for triggered builds and cannot be overridden in the build configuration file.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_cloudbuild_trigger#dynamic_substitutions GoogleCloudbuildTrigger#dynamic_substitutions}
    */
    readonly dynamicSubstitutions?: boolean | cdktf.IResolvable;
    /**
    * A list of global environment variable definitions that will exist for all build steps
  in this build. If a variable is defined in both globally and in a build step,
  the variable will use the build step value.
  
  The elements are of the form "KEY=VALUE" for the environment variable "KEY" being given the value "VALUE".
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_cloudbuild_trigger#env GoogleCloudbuildTrigger#env}
    */
    readonly env?: string[];
    /**
    * Option to define build log streaming behavior to Google Cloud Storage. Possible values: ["STREAM_DEFAULT", "STREAM_ON", "STREAM_OFF"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_cloudbuild_trigger#log_streaming_option GoogleCloudbuildTrigger#log_streaming_option}
    */
    readonly logStreamingOption?: string;
    /**
    * Option to specify the logging mode, which determines if and where build logs are stored. Possible values: ["LOGGING_UNSPECIFIED", "LEGACY", "GCS_ONLY", "STACKDRIVER_ONLY", "CLOUD_LOGGING_ONLY", "NONE"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_cloudbuild_trigger#logging GoogleCloudbuildTrigger#logging}
    */
    readonly logging?: string;
    /**
    * Compute Engine machine type on which to run the build. Possible values: ["UNSPECIFIED", "N1_HIGHCPU_8", "N1_HIGHCPU_32", "E2_HIGHCPU_8", "E2_HIGHCPU_32"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_cloudbuild_trigger#machine_type GoogleCloudbuildTrigger#machine_type}
    */
    readonly machineType?: string;
    /**
    * Requested verifiability options. Possible values: ["NOT_VERIFIED", "VERIFIED"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_cloudbuild_trigger#requested_verify_option GoogleCloudbuildTrigger#requested_verify_option}
    */
    readonly requestedVerifyOption?: string;
    /**
    * A list of global environment variables, which are encrypted using a Cloud Key Management
  Service crypto key. These values must be specified in the build's Secret. These variables
  will be available to all build steps in this build.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_cloudbuild_trigger#secret_env GoogleCloudbuildTrigger#secret_env}
    */
    readonly secretEnv?: string[];
    /**
    * Requested hash for SourceProvenance. Possible values: ["NONE", "SHA256", "MD5"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_cloudbuild_trigger#source_provenance_hash GoogleCloudbuildTrigger#source_provenance_hash}
    */
    readonly sourceProvenanceHash?: string[];
    /**
    * Option to specify behavior when there is an error in the substitution checks.
  
  NOTE this is always set to ALLOW_LOOSE for triggered builds and cannot be overridden
  in the build configuration file. Possible values: ["MUST_MATCH", "ALLOW_LOOSE"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_cloudbuild_trigger#substitution_option GoogleCloudbuildTrigger#substitution_option}
    */
    readonly substitutionOption?: string;
    /**
    * Option to specify a WorkerPool for the build. Format projects/{project}/workerPools/{workerPool}
  
  This field is experimental.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_cloudbuild_trigger#worker_pool GoogleCloudbuildTrigger#worker_pool}
    */
    readonly workerPool?: string;
    /**
    * volumes block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_cloudbuild_trigger#volumes GoogleCloudbuildTrigger#volumes}
    */
    readonly volumes?: GoogleCloudbuildTriggerBuildOptionsVolumes[] | cdktf.IResolvable;
}
export declare function googleCloudbuildTriggerBuildOptionsToTerraform(struct?: GoogleCloudbuildTriggerBuildOptionsOutputReference | GoogleCloudbuildTriggerBuildOptions): any;
export declare class GoogleCloudbuildTriggerBuildOptionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleCloudbuildTriggerBuildOptions | undefined;
    set internalValue(value: GoogleCloudbuildTriggerBuildOptions | undefined);
    private _diskSizeGb?;
    get diskSizeGb(): number;
    set diskSizeGb(value: number);
    resetDiskSizeGb(): void;
    get diskSizeGbInput(): number | undefined;
    private _dynamicSubstitutions?;
    get dynamicSubstitutions(): boolean | cdktf.IResolvable;
    set dynamicSubstitutions(value: boolean | cdktf.IResolvable);
    resetDynamicSubstitutions(): void;
    get dynamicSubstitutionsInput(): boolean | cdktf.IResolvable | undefined;
    private _env?;
    get env(): string[];
    set env(value: string[]);
    resetEnv(): void;
    get envInput(): string[] | undefined;
    private _logStreamingOption?;
    get logStreamingOption(): string;
    set logStreamingOption(value: string);
    resetLogStreamingOption(): void;
    get logStreamingOptionInput(): string | undefined;
    private _logging?;
    get logging(): string;
    set logging(value: string);
    resetLogging(): void;
    get loggingInput(): string | undefined;
    private _machineType?;
    get machineType(): string;
    set machineType(value: string);
    resetMachineType(): void;
    get machineTypeInput(): string | undefined;
    private _requestedVerifyOption?;
    get requestedVerifyOption(): string;
    set requestedVerifyOption(value: string);
    resetRequestedVerifyOption(): void;
    get requestedVerifyOptionInput(): string | undefined;
    private _secretEnv?;
    get secretEnv(): string[];
    set secretEnv(value: string[]);
    resetSecretEnv(): void;
    get secretEnvInput(): string[] | undefined;
    private _sourceProvenanceHash?;
    get sourceProvenanceHash(): string[];
    set sourceProvenanceHash(value: string[]);
    resetSourceProvenanceHash(): void;
    get sourceProvenanceHashInput(): string[] | undefined;
    private _substitutionOption?;
    get substitutionOption(): string;
    set substitutionOption(value: string);
    resetSubstitutionOption(): void;
    get substitutionOptionInput(): string | undefined;
    private _workerPool?;
    get workerPool(): string;
    set workerPool(value: string);
    resetWorkerPool(): void;
    get workerPoolInput(): string | undefined;
    private _volumes;
    get volumes(): GoogleCloudbuildTriggerBuildOptionsVolumesList;
    putVolumes(value: GoogleCloudbuildTriggerBuildOptionsVolumes[] | cdktf.IResolvable): void;
    resetVolumes(): void;
    get volumesInput(): cdktf.IResolvable | GoogleCloudbuildTriggerBuildOptionsVolumes[] | undefined;
}
export interface GoogleCloudbuildTriggerBuildSecret {
    /**
    * Cloud KMS key name to use to decrypt these envs.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_cloudbuild_trigger#kms_key_name GoogleCloudbuildTrigger#kms_key_name}
    */
    readonly kmsKeyName: string;
    /**
    * Map of environment variable name to its encrypted value.
  Secret environment variables must be unique across all of a build's secrets,
  and must be used by at least one build step. Values can be at most 64 KB in size.
  There can be at most 100 secret values across all of a build's secrets.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_cloudbuild_trigger#secret_env GoogleCloudbuildTrigger#secret_env}
    */
    readonly secretEnv?: {
        [key: string]: string;
    };
}
export declare function googleCloudbuildTriggerBuildSecretToTerraform(struct?: GoogleCloudbuildTriggerBuildSecret | cdktf.IResolvable): any;
export declare class GoogleCloudbuildTriggerBuildSecretOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleCloudbuildTriggerBuildSecret | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleCloudbuildTriggerBuildSecret | cdktf.IResolvable | undefined);
    private _kmsKeyName?;
    get kmsKeyName(): string;
    set kmsKeyName(value: string);
    get kmsKeyNameInput(): string | undefined;
    private _secretEnv?;
    get secretEnv(): {
        [key: string]: string;
    };
    set secretEnv(value: {
        [key: string]: string;
    });
    resetSecretEnv(): void;
    get secretEnvInput(): {
        [key: string]: string;
    } | undefined;
}
export declare class GoogleCloudbuildTriggerBuildSecretList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleCloudbuildTriggerBuildSecret[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleCloudbuildTriggerBuildSecretOutputReference;
}
export interface GoogleCloudbuildTriggerBuildSourceRepoSource {
    /**
    * Regex matching branches to build. Exactly one a of branch name, tag, or commit SHA must be provided.
  The syntax of the regular expressions accepted is the syntax accepted by RE2 and
  described at https://github.com/google/re2/wiki/Syntax
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_cloudbuild_trigger#branch_name GoogleCloudbuildTrigger#branch_name}
    */
    readonly branchName?: string;
    /**
    * Explicit commit SHA to build. Exactly one a of branch name, tag, or commit SHA must be provided.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_cloudbuild_trigger#commit_sha GoogleCloudbuildTrigger#commit_sha}
    */
    readonly commitSha?: string;
    /**
    * Directory, relative to the source root, in which to run the build.
  This must be a relative path. If a step's dir is specified and is an absolute path,
  this value is ignored for that step's execution.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_cloudbuild_trigger#dir GoogleCloudbuildTrigger#dir}
    */
    readonly dir?: string;
    /**
    * Only trigger a build if the revision regex does NOT match the revision regex.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_cloudbuild_trigger#invert_regex GoogleCloudbuildTrigger#invert_regex}
    */
    readonly invertRegex?: boolean | cdktf.IResolvable;
    /**
    * ID of the project that owns the Cloud Source Repository.
  If omitted, the project ID requesting the build is assumed.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_cloudbuild_trigger#project_id GoogleCloudbuildTrigger#project_id}
    */
    readonly projectId?: string;
    /**
    * Name of the Cloud Source Repository.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_cloudbuild_trigger#repo_name GoogleCloudbuildTrigger#repo_name}
    */
    readonly repoName: string;
    /**
    * Substitutions to use in a triggered build. Should only be used with triggers.run
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_cloudbuild_trigger#substitutions GoogleCloudbuildTrigger#substitutions}
    */
    readonly substitutions?: {
        [key: string]: string;
    };
    /**
    * Regex matching tags to build. Exactly one a of branch name, tag, or commit SHA must be provided.
  The syntax of the regular expressions accepted is the syntax accepted by RE2 and
  described at https://github.com/google/re2/wiki/Syntax
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_cloudbuild_trigger#tag_name GoogleCloudbuildTrigger#tag_name}
    */
    readonly tagName?: string;
}
export declare function googleCloudbuildTriggerBuildSourceRepoSourceToTerraform(struct?: GoogleCloudbuildTriggerBuildSourceRepoSourceOutputReference | GoogleCloudbuildTriggerBuildSourceRepoSource): any;
export declare class GoogleCloudbuildTriggerBuildSourceRepoSourceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleCloudbuildTriggerBuildSourceRepoSource | undefined;
    set internalValue(value: GoogleCloudbuildTriggerBuildSourceRepoSource | undefined);
    private _branchName?;
    get branchName(): string;
    set branchName(value: string);
    resetBranchName(): void;
    get branchNameInput(): string | undefined;
    private _commitSha?;
    get commitSha(): string;
    set commitSha(value: string);
    resetCommitSha(): void;
    get commitShaInput(): string | undefined;
    private _dir?;
    get dir(): string;
    set dir(value: string);
    resetDir(): void;
    get dirInput(): string | undefined;
    private _invertRegex?;
    get invertRegex(): boolean | cdktf.IResolvable;
    set invertRegex(value: boolean | cdktf.IResolvable);
    resetInvertRegex(): void;
    get invertRegexInput(): boolean | cdktf.IResolvable | undefined;
    private _projectId?;
    get projectId(): string;
    set projectId(value: string);
    resetProjectId(): void;
    get projectIdInput(): string | undefined;
    private _repoName?;
    get repoName(): string;
    set repoName(value: string);
    get repoNameInput(): string | undefined;
    private _substitutions?;
    get substitutions(): {
        [key: string]: string;
    };
    set substitutions(value: {
        [key: string]: string;
    });
    resetSubstitutions(): void;
    get substitutionsInput(): {
        [key: string]: string;
    } | undefined;
    private _tagName?;
    get tagName(): string;
    set tagName(value: string);
    resetTagName(): void;
    get tagNameInput(): string | undefined;
}
export interface GoogleCloudbuildTriggerBuildSourceStorageSource {
    /**
    * Google Cloud Storage bucket containing the source.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_cloudbuild_trigger#bucket GoogleCloudbuildTrigger#bucket}
    */
    readonly bucket: string;
    /**
    * Google Cloud Storage generation for the object.
  If the generation is omitted, the latest generation will be used
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_cloudbuild_trigger#generation GoogleCloudbuildTrigger#generation}
    */
    readonly generation?: string;
    /**
    * Google Cloud Storage object containing the source.
  This object must be a gzipped archive file (.tar.gz) containing source to build.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_cloudbuild_trigger#object GoogleCloudbuildTrigger#object}
    */
    readonly object: string;
}
export declare function googleCloudbuildTriggerBuildSourceStorageSourceToTerraform(struct?: GoogleCloudbuildTriggerBuildSourceStorageSourceOutputReference | GoogleCloudbuildTriggerBuildSourceStorageSource): any;
export declare class GoogleCloudbuildTriggerBuildSourceStorageSourceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleCloudbuildTriggerBuildSourceStorageSource | undefined;
    set internalValue(value: GoogleCloudbuildTriggerBuildSourceStorageSource | undefined);
    private _bucket?;
    get bucket(): string;
    set bucket(value: string);
    get bucketInput(): string | undefined;
    private _generation?;
    get generation(): string;
    set generation(value: string);
    resetGeneration(): void;
    get generationInput(): string | undefined;
    private _object?;
    get object(): string;
    set object(value: string);
    get objectInput(): string | undefined;
}
export interface GoogleCloudbuildTriggerBuildSource {
    /**
    * repo_source block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_cloudbuild_trigger#repo_source GoogleCloudbuildTrigger#repo_source}
    */
    readonly repoSource?: GoogleCloudbuildTriggerBuildSourceRepoSource;
    /**
    * storage_source block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_cloudbuild_trigger#storage_source GoogleCloudbuildTrigger#storage_source}
    */
    readonly storageSource?: GoogleCloudbuildTriggerBuildSourceStorageSource;
}
export declare function googleCloudbuildTriggerBuildSourceToTerraform(struct?: GoogleCloudbuildTriggerBuildSourceOutputReference | GoogleCloudbuildTriggerBuildSource): any;
export declare class GoogleCloudbuildTriggerBuildSourceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleCloudbuildTriggerBuildSource | undefined;
    set internalValue(value: GoogleCloudbuildTriggerBuildSource | undefined);
    private _repoSource;
    get repoSource(): GoogleCloudbuildTriggerBuildSourceRepoSourceOutputReference;
    putRepoSource(value: GoogleCloudbuildTriggerBuildSourceRepoSource): void;
    resetRepoSource(): void;
    get repoSourceInput(): GoogleCloudbuildTriggerBuildSourceRepoSource | undefined;
    private _storageSource;
    get storageSource(): GoogleCloudbuildTriggerBuildSourceStorageSourceOutputReference;
    putStorageSource(value: GoogleCloudbuildTriggerBuildSourceStorageSource): void;
    resetStorageSource(): void;
    get storageSourceInput(): GoogleCloudbuildTriggerBuildSourceStorageSource | undefined;
}
export interface GoogleCloudbuildTriggerBuildStepVolumes {
    /**
    * Name of the volume to mount.
  
  Volume names must be unique per build step and must be valid names for
  Docker volumes. Each named volume must be used by at least two build steps.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_cloudbuild_trigger#name GoogleCloudbuildTrigger#name}
    */
    readonly name: string;
    /**
    * Path at which to mount the volume.
  
  Paths must be absolute and cannot conflict with other volume paths on
  the same build step or with certain reserved volume paths.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_cloudbuild_trigger#path GoogleCloudbuildTrigger#path}
    */
    readonly path: string;
}
export declare function googleCloudbuildTriggerBuildStepVolumesToTerraform(struct?: GoogleCloudbuildTriggerBuildStepVolumes | cdktf.IResolvable): any;
export declare class GoogleCloudbuildTriggerBuildStepVolumesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleCloudbuildTriggerBuildStepVolumes | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleCloudbuildTriggerBuildStepVolumes | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    get pathInput(): string | undefined;
}
export declare class GoogleCloudbuildTriggerBuildStepVolumesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleCloudbuildTriggerBuildStepVolumes[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleCloudbuildTriggerBuildStepVolumesOutputReference;
}
export interface GoogleCloudbuildTriggerBuildStep {
    /**
    * A list of arguments that will be presented to the step when it is started.
  
  If the image used to run the step's container has an entrypoint, the args
  are used as arguments to that entrypoint. If the image does not define an
  entrypoint, the first element in args is used as the entrypoint, and the
  remainder will be used as arguments.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_cloudbuild_trigger#args GoogleCloudbuildTrigger#args}
    */
    readonly args?: string[];
    /**
    * Working directory to use when running this step's container.
  
  If this value is a relative path, it is relative to the build's working
  directory. If this value is absolute, it may be outside the build's working
  directory, in which case the contents of the path may not be persisted
  across build step executions, unless a 'volume' for that path is specified.
  
  If the build specifies a 'RepoSource' with 'dir' and a step with a
  'dir',
  which specifies an absolute path, the 'RepoSource' 'dir' is ignored
  for the step's execution.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_cloudbuild_trigger#dir GoogleCloudbuildTrigger#dir}
    */
    readonly dir?: string;
    /**
    * Entrypoint to be used instead of the build step image's
  default entrypoint.
  If unset, the image's default entrypoint is used
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_cloudbuild_trigger#entrypoint GoogleCloudbuildTrigger#entrypoint}
    */
    readonly entrypoint?: string;
    /**
    * A list of environment variable definitions to be used when
  running a step.
  
  The elements are of the form "KEY=VALUE" for the environment variable
  "KEY" being given the value "VALUE".
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_cloudbuild_trigger#env GoogleCloudbuildTrigger#env}
    */
    readonly env?: string[];
    /**
    * Unique identifier for this build step, used in 'wait_for' to
  reference this build step as a dependency.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_cloudbuild_trigger#id GoogleCloudbuildTrigger#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The name of the container image that will run this particular build step.
  
  If the image is available in the host's Docker daemon's cache, it will be
  run directly. If not, the host will attempt to pull the image first, using
  the builder service account's credentials if necessary.
  
  The Docker daemon's cache will already have the latest versions of all of
  the officially supported build steps (see https://github.com/GoogleCloudPlatform/cloud-builders
  for images and examples).
  The Docker daemon will also have cached many of the layers for some popular
  images, like "ubuntu", "debian", but they will be refreshed at the time
  you attempt to use them.
  
  If you built an image in a previous build step, it will be stored in the
  host's Docker daemon's cache and is available to use as the name for a
  later build step.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_cloudbuild_trigger#name GoogleCloudbuildTrigger#name}
    */
    readonly name: string;
    /**
    * A list of environment variables which are encrypted using
  a Cloud Key
  Management Service crypto key. These values must be specified in
  the build's 'Secret'.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_cloudbuild_trigger#secret_env GoogleCloudbuildTrigger#secret_env}
    */
    readonly secretEnv?: string[];
    /**
    * Time limit for executing this build step. If not defined,
  the step has no
  time limit and will be allowed to continue to run until either it
  completes or the build itself times out.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_cloudbuild_trigger#timeout GoogleCloudbuildTrigger#timeout}
    */
    readonly timeout?: string;
    /**
    * Output only. Stores timing information for executing this
  build step.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_cloudbuild_trigger#timing GoogleCloudbuildTrigger#timing}
    */
    readonly timing?: string;
    /**
    * The ID(s) of the step(s) that this build step depends on.
  
  This build step will not start until all the build steps in 'wait_for'
  have completed successfully. If 'wait_for' is empty, this build step
  will start when all previous build steps in the 'Build.Steps' list
  have completed successfully.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_cloudbuild_trigger#wait_for GoogleCloudbuildTrigger#wait_for}
    */
    readonly waitFor?: string[];
    /**
    * volumes block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_cloudbuild_trigger#volumes GoogleCloudbuildTrigger#volumes}
    */
    readonly volumes?: GoogleCloudbuildTriggerBuildStepVolumes[] | cdktf.IResolvable;
}
export declare function googleCloudbuildTriggerBuildStepToTerraform(struct?: GoogleCloudbuildTriggerBuildStep | cdktf.IResolvable): any;
export declare class GoogleCloudbuildTriggerBuildStepOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleCloudbuildTriggerBuildStep | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleCloudbuildTriggerBuildStep | cdktf.IResolvable | undefined);
    private _args?;
    get args(): string[];
    set args(value: string[]);
    resetArgs(): void;
    get argsInput(): string[] | undefined;
    private _dir?;
    get dir(): string;
    set dir(value: string);
    resetDir(): void;
    get dirInput(): string | undefined;
    private _entrypoint?;
    get entrypoint(): string;
    set entrypoint(value: string);
    resetEntrypoint(): void;
    get entrypointInput(): string | undefined;
    private _env?;
    get env(): string[];
    set env(value: string[]);
    resetEnv(): void;
    get envInput(): string[] | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _secretEnv?;
    get secretEnv(): string[];
    set secretEnv(value: string[]);
    resetSecretEnv(): void;
    get secretEnvInput(): string[] | undefined;
    private _timeout?;
    get timeout(): string;
    set timeout(value: string);
    resetTimeout(): void;
    get timeoutInput(): string | undefined;
    private _timing?;
    get timing(): string;
    set timing(value: string);
    resetTiming(): void;
    get timingInput(): string | undefined;
    private _waitFor?;
    get waitFor(): string[];
    set waitFor(value: string[]);
    resetWaitFor(): void;
    get waitForInput(): string[] | undefined;
    private _volumes;
    get volumes(): GoogleCloudbuildTriggerBuildStepVolumesList;
    putVolumes(value: GoogleCloudbuildTriggerBuildStepVolumes[] | cdktf.IResolvable): void;
    resetVolumes(): void;
    get volumesInput(): cdktf.IResolvable | GoogleCloudbuildTriggerBuildStepVolumes[] | undefined;
}
export declare class GoogleCloudbuildTriggerBuildStepList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleCloudbuildTriggerBuildStep[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleCloudbuildTriggerBuildStepOutputReference;
}
export interface GoogleCloudbuildTriggerBuild {
    /**
    * A list of images to be pushed upon the successful completion of all build steps.
  The images are pushed using the builder service account's credentials.
  The digests of the pushed images will be stored in the Build resource's results field.
  If any of the images fail to be pushed, the build status is marked FAILURE.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_cloudbuild_trigger#images GoogleCloudbuildTrigger#images}
    */
    readonly images?: string[];
    /**
    * Google Cloud Storage bucket where logs should be written.
  Logs file names will be of the format ${logsBucket}/log-${build_id}.txt.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_cloudbuild_trigger#logs_bucket GoogleCloudbuildTrigger#logs_bucket}
    */
    readonly logsBucket?: string;
    /**
    * TTL in queue for this build. If provided and the build is enqueued longer than this value,
  the build will expire and the build status will be EXPIRED.
  The TTL starts ticking from createTime.
  A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s".
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_cloudbuild_trigger#queue_ttl GoogleCloudbuildTrigger#queue_ttl}
    */
    readonly queueTtl?: string;
    /**
    * Substitutions data for Build resource.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_cloudbuild_trigger#substitutions GoogleCloudbuildTrigger#substitutions}
    */
    readonly substitutions?: {
        [key: string]: string;
    };
    /**
    * Tags for annotation of a Build. These are not docker tags.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_cloudbuild_trigger#tags GoogleCloudbuildTrigger#tags}
    */
    readonly tags?: string[];
    /**
    * Amount of time that this build should be allowed to run, to second granularity.
  If this amount of time elapses, work on the build will cease and the build status will be TIMEOUT.
  This timeout must be equal to or greater than the sum of the timeouts for build steps within the build.
  The expected format is the number of seconds followed by s.
  Default time is ten minutes (600s).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_cloudbuild_trigger#timeout GoogleCloudbuildTrigger#timeout}
    */
    readonly timeout?: string;
    /**
    * artifacts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_cloudbuild_trigger#artifacts GoogleCloudbuildTrigger#artifacts}
    */
    readonly artifacts?: GoogleCloudbuildTriggerBuildArtifacts;
    /**
    * available_secrets block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_cloudbuild_trigger#available_secrets GoogleCloudbuildTrigger#available_secrets}
    */
    readonly availableSecrets?: GoogleCloudbuildTriggerBuildAvailableSecrets;
    /**
    * options block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_cloudbuild_trigger#options GoogleCloudbuildTrigger#options}
    */
    readonly options?: GoogleCloudbuildTriggerBuildOptions;
    /**
    * secret block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_cloudbuild_trigger#secret GoogleCloudbuildTrigger#secret}
    */
    readonly secret?: GoogleCloudbuildTriggerBuildSecret[] | cdktf.IResolvable;
    /**
    * source block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_cloudbuild_trigger#source GoogleCloudbuildTrigger#source}
    */
    readonly source?: GoogleCloudbuildTriggerBuildSource;
    /**
    * step block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_cloudbuild_trigger#step GoogleCloudbuildTrigger#step}
    */
    readonly step: GoogleCloudbuildTriggerBuildStep[] | cdktf.IResolvable;
}
export declare function googleCloudbuildTriggerBuildToTerraform(struct?: GoogleCloudbuildTriggerBuildOutputReference | GoogleCloudbuildTriggerBuild): any;
export declare class GoogleCloudbuildTriggerBuildOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleCloudbuildTriggerBuild | undefined;
    set internalValue(value: GoogleCloudbuildTriggerBuild | undefined);
    private _images?;
    get images(): string[];
    set images(value: string[]);
    resetImages(): void;
    get imagesInput(): string[] | undefined;
    private _logsBucket?;
    get logsBucket(): string;
    set logsBucket(value: string);
    resetLogsBucket(): void;
    get logsBucketInput(): string | undefined;
    private _queueTtl?;
    get queueTtl(): string;
    set queueTtl(value: string);
    resetQueueTtl(): void;
    get queueTtlInput(): string | undefined;
    private _substitutions?;
    get substitutions(): {
        [key: string]: string;
    };
    set substitutions(value: {
        [key: string]: string;
    });
    resetSubstitutions(): void;
    get substitutionsInput(): {
        [key: string]: string;
    } | undefined;
    private _tags?;
    get tags(): string[];
    set tags(value: string[]);
    resetTags(): void;
    get tagsInput(): string[] | undefined;
    private _timeout?;
    get timeout(): string;
    set timeout(value: string);
    resetTimeout(): void;
    get timeoutInput(): string | undefined;
    private _artifacts;
    get artifacts(): GoogleCloudbuildTriggerBuildArtifactsOutputReference;
    putArtifacts(value: GoogleCloudbuildTriggerBuildArtifacts): void;
    resetArtifacts(): void;
    get artifactsInput(): GoogleCloudbuildTriggerBuildArtifacts | undefined;
    private _availableSecrets;
    get availableSecrets(): GoogleCloudbuildTriggerBuildAvailableSecretsOutputReference;
    putAvailableSecrets(value: GoogleCloudbuildTriggerBuildAvailableSecrets): void;
    resetAvailableSecrets(): void;
    get availableSecretsInput(): GoogleCloudbuildTriggerBuildAvailableSecrets | undefined;
    private _options;
    get options(): GoogleCloudbuildTriggerBuildOptionsOutputReference;
    putOptions(value: GoogleCloudbuildTriggerBuildOptions): void;
    resetOptions(): void;
    get optionsInput(): GoogleCloudbuildTriggerBuildOptions | undefined;
    private _secret;
    get secret(): GoogleCloudbuildTriggerBuildSecretList;
    putSecret(value: GoogleCloudbuildTriggerBuildSecret[] | cdktf.IResolvable): void;
    resetSecret(): void;
    get secretInput(): cdktf.IResolvable | GoogleCloudbuildTriggerBuildSecret[] | undefined;
    private _source;
    get source(): GoogleCloudbuildTriggerBuildSourceOutputReference;
    putSource(value: GoogleCloudbuildTriggerBuildSource): void;
    resetSource(): void;
    get sourceInput(): GoogleCloudbuildTriggerBuildSource | undefined;
    private _step;
    get step(): GoogleCloudbuildTriggerBuildStepList;
    putStep(value: GoogleCloudbuildTriggerBuildStep[] | cdktf.IResolvable): void;
    get stepInput(): cdktf.IResolvable | GoogleCloudbuildTriggerBuildStep[] | undefined;
}
export interface GoogleCloudbuildTriggerGitFileSource {
    /**
    * The path of the file, with the repo root as the root of the path.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_cloudbuild_trigger#path GoogleCloudbuildTrigger#path}
    */
    readonly path: string;
    /**
    * The type of the repo, since it may not be explicit from the repo field (e.g from a URL).
  Values can be UNKNOWN, CLOUD_SOURCE_REPOSITORIES, GITHUB, BITBUCKET Possible values: ["UNKNOWN", "CLOUD_SOURCE_REPOSITORIES", "GITHUB", "BITBUCKET"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_cloudbuild_trigger#repo_type GoogleCloudbuildTrigger#repo_type}
    */
    readonly repoType: string;
    /**
    * The branch, tag, arbitrary ref, or SHA version of the repo to use when resolving the
  filename (optional). This field respects the same syntax/resolution as described here: https://git-scm.com/docs/gitrevisions
  If unspecified, the revision from which the trigger invocation originated is assumed to be the revision from which to read the specified path.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_cloudbuild_trigger#revision GoogleCloudbuildTrigger#revision}
    */
    readonly revision?: string;
    /**
    * The URI of the repo (optional). If unspecified, the repo from which the trigger
  invocation originated is assumed to be the repo from which to read the specified path.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_cloudbuild_trigger#uri GoogleCloudbuildTrigger#uri}
    */
    readonly uri?: string;
}
export declare function googleCloudbuildTriggerGitFileSourceToTerraform(struct?: GoogleCloudbuildTriggerGitFileSourceOutputReference | GoogleCloudbuildTriggerGitFileSource): any;
export declare class GoogleCloudbuildTriggerGitFileSourceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleCloudbuildTriggerGitFileSource | undefined;
    set internalValue(value: GoogleCloudbuildTriggerGitFileSource | undefined);
    private _path?;
    get path(): string;
    set path(value: string);
    get pathInput(): string | undefined;
    private _repoType?;
    get repoType(): string;
    set repoType(value: string);
    get repoTypeInput(): string | undefined;
    private _revision?;
    get revision(): string;
    set revision(value: string);
    resetRevision(): void;
    get revisionInput(): string | undefined;
    private _uri?;
    get uri(): string;
    set uri(value: string);
    resetUri(): void;
    get uriInput(): string | undefined;
}
export interface GoogleCloudbuildTriggerGithubPullRequest {
    /**
    * Regex of branches to match.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_cloudbuild_trigger#branch GoogleCloudbuildTrigger#branch}
    */
    readonly branch: string;
    /**
    * Whether to block builds on a "/gcbrun" comment from a repository owner or collaborator. Possible values: ["COMMENTS_DISABLED", "COMMENTS_ENABLED", "COMMENTS_ENABLED_FOR_EXTERNAL_CONTRIBUTORS_ONLY"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_cloudbuild_trigger#comment_control GoogleCloudbuildTrigger#comment_control}
    */
    readonly commentControl?: string;
    /**
    * If true, branches that do NOT match the git_ref will trigger a build.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_cloudbuild_trigger#invert_regex GoogleCloudbuildTrigger#invert_regex}
    */
    readonly invertRegex?: boolean | cdktf.IResolvable;
}
export declare function googleCloudbuildTriggerGithubPullRequestToTerraform(struct?: GoogleCloudbuildTriggerGithubPullRequestOutputReference | GoogleCloudbuildTriggerGithubPullRequest): any;
export declare class GoogleCloudbuildTriggerGithubPullRequestOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleCloudbuildTriggerGithubPullRequest | undefined;
    set internalValue(value: GoogleCloudbuildTriggerGithubPullRequest | undefined);
    private _branch?;
    get branch(): string;
    set branch(value: string);
    get branchInput(): string | undefined;
    private _commentControl?;
    get commentControl(): string;
    set commentControl(value: string);
    resetCommentControl(): void;
    get commentControlInput(): string | undefined;
    private _invertRegex?;
    get invertRegex(): boolean | cdktf.IResolvable;
    set invertRegex(value: boolean | cdktf.IResolvable);
    resetInvertRegex(): void;
    get invertRegexInput(): boolean | cdktf.IResolvable | undefined;
}
export interface GoogleCloudbuildTriggerGithubPush {
    /**
    * Regex of branches to match.  Specify only one of branch or tag.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_cloudbuild_trigger#branch GoogleCloudbuildTrigger#branch}
    */
    readonly branch?: string;
    /**
    * When true, only trigger a build if the revision regex does NOT match the git_ref regex.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_cloudbuild_trigger#invert_regex GoogleCloudbuildTrigger#invert_regex}
    */
    readonly invertRegex?: boolean | cdktf.IResolvable;
    /**
    * Regex of tags to match.  Specify only one of branch or tag.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_cloudbuild_trigger#tag GoogleCloudbuildTrigger#tag}
    */
    readonly tag?: string;
}
export declare function googleCloudbuildTriggerGithubPushToTerraform(struct?: GoogleCloudbuildTriggerGithubPushOutputReference | GoogleCloudbuildTriggerGithubPush): any;
export declare class GoogleCloudbuildTriggerGithubPushOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleCloudbuildTriggerGithubPush | undefined;
    set internalValue(value: GoogleCloudbuildTriggerGithubPush | undefined);
    private _branch?;
    get branch(): string;
    set branch(value: string);
    resetBranch(): void;
    get branchInput(): string | undefined;
    private _invertRegex?;
    get invertRegex(): boolean | cdktf.IResolvable;
    set invertRegex(value: boolean | cdktf.IResolvable);
    resetInvertRegex(): void;
    get invertRegexInput(): boolean | cdktf.IResolvable | undefined;
    private _tag?;
    get tag(): string;
    set tag(value: string);
    resetTag(): void;
    get tagInput(): string | undefined;
}
export interface GoogleCloudbuildTriggerGithub {
    /**
    * Name of the repository. For example: The name for
  https://github.com/googlecloudplatform/cloud-builders is "cloud-builders".
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_cloudbuild_trigger#name GoogleCloudbuildTrigger#name}
    */
    readonly name?: string;
    /**
    * Owner of the repository. For example: The owner for
  https://github.com/googlecloudplatform/cloud-builders is "googlecloudplatform".
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_cloudbuild_trigger#owner GoogleCloudbuildTrigger#owner}
    */
    readonly owner?: string;
    /**
    * pull_request block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_cloudbuild_trigger#pull_request GoogleCloudbuildTrigger#pull_request}
    */
    readonly pullRequest?: GoogleCloudbuildTriggerGithubPullRequest;
    /**
    * push block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_cloudbuild_trigger#push GoogleCloudbuildTrigger#push}
    */
    readonly push?: GoogleCloudbuildTriggerGithubPush;
}
export declare function googleCloudbuildTriggerGithubToTerraform(struct?: GoogleCloudbuildTriggerGithubOutputReference | GoogleCloudbuildTriggerGithub): any;
export declare class GoogleCloudbuildTriggerGithubOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleCloudbuildTriggerGithub | undefined;
    set internalValue(value: GoogleCloudbuildTriggerGithub | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _owner?;
    get owner(): string;
    set owner(value: string);
    resetOwner(): void;
    get ownerInput(): string | undefined;
    private _pullRequest;
    get pullRequest(): GoogleCloudbuildTriggerGithubPullRequestOutputReference;
    putPullRequest(value: GoogleCloudbuildTriggerGithubPullRequest): void;
    resetPullRequest(): void;
    get pullRequestInput(): GoogleCloudbuildTriggerGithubPullRequest | undefined;
    private _push;
    get push(): GoogleCloudbuildTriggerGithubPushOutputReference;
    putPush(value: GoogleCloudbuildTriggerGithubPush): void;
    resetPush(): void;
    get pushInput(): GoogleCloudbuildTriggerGithubPush | undefined;
}
export interface GoogleCloudbuildTriggerPubsubConfig {
    /**
    * Service account that will make the push request.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_cloudbuild_trigger#service_account_email GoogleCloudbuildTrigger#service_account_email}
    */
    readonly serviceAccountEmail?: string;
    /**
    * The name of the topic from which this subscription is receiving messages.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_cloudbuild_trigger#topic GoogleCloudbuildTrigger#topic}
    */
    readonly topic: string;
}
export declare function googleCloudbuildTriggerPubsubConfigToTerraform(struct?: GoogleCloudbuildTriggerPubsubConfigOutputReference | GoogleCloudbuildTriggerPubsubConfig): any;
export declare class GoogleCloudbuildTriggerPubsubConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleCloudbuildTriggerPubsubConfig | undefined;
    set internalValue(value: GoogleCloudbuildTriggerPubsubConfig | undefined);
    private _serviceAccountEmail?;
    get serviceAccountEmail(): string;
    set serviceAccountEmail(value: string);
    resetServiceAccountEmail(): void;
    get serviceAccountEmailInput(): string | undefined;
    get state(): string;
    get subscription(): string;
    private _topic?;
    get topic(): string;
    set topic(value: string);
    get topicInput(): string | undefined;
}
export interface GoogleCloudbuildTriggerSourceToBuild {
    /**
    * The branch or tag to use. Must start with "refs/" (required).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_cloudbuild_trigger#ref GoogleCloudbuildTrigger#ref}
    */
    readonly ref: string;
    /**
    * The type of the repo, since it may not be explicit from the repo field (e.g from a URL).
  Values can be UNKNOWN, CLOUD_SOURCE_REPOSITORIES, GITHUB, BITBUCKET Possible values: ["UNKNOWN", "CLOUD_SOURCE_REPOSITORIES", "GITHUB", "BITBUCKET"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_cloudbuild_trigger#repo_type GoogleCloudbuildTrigger#repo_type}
    */
    readonly repoType: string;
    /**
    * The URI of the repo (required).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_cloudbuild_trigger#uri GoogleCloudbuildTrigger#uri}
    */
    readonly uri: string;
}
export declare function googleCloudbuildTriggerSourceToBuildToTerraform(struct?: GoogleCloudbuildTriggerSourceToBuildOutputReference | GoogleCloudbuildTriggerSourceToBuild): any;
export declare class GoogleCloudbuildTriggerSourceToBuildOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleCloudbuildTriggerSourceToBuild | undefined;
    set internalValue(value: GoogleCloudbuildTriggerSourceToBuild | undefined);
    private _ref?;
    get ref(): string;
    set ref(value: string);
    get refInput(): string | undefined;
    private _repoType?;
    get repoType(): string;
    set repoType(value: string);
    get repoTypeInput(): string | undefined;
    private _uri?;
    get uri(): string;
    set uri(value: string);
    get uriInput(): string | undefined;
}
export interface GoogleCloudbuildTriggerTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_cloudbuild_trigger#create GoogleCloudbuildTrigger#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_cloudbuild_trigger#delete GoogleCloudbuildTrigger#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_cloudbuild_trigger#update GoogleCloudbuildTrigger#update}
    */
    readonly update?: string;
}
export declare function googleCloudbuildTriggerTimeoutsToTerraform(struct?: GoogleCloudbuildTriggerTimeoutsOutputReference | GoogleCloudbuildTriggerTimeouts | cdktf.IResolvable): any;
export declare class GoogleCloudbuildTriggerTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleCloudbuildTriggerTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleCloudbuildTriggerTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
export interface GoogleCloudbuildTriggerTriggerTemplate {
    /**
    * Name of the branch to build. Exactly one a of branch name, tag, or commit SHA must be provided.
  This field is a regular expression.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_cloudbuild_trigger#branch_name GoogleCloudbuildTrigger#branch_name}
    */
    readonly branchName?: string;
    /**
    * Explicit commit SHA to build. Exactly one of a branch name, tag, or commit SHA must be provided.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_cloudbuild_trigger#commit_sha GoogleCloudbuildTrigger#commit_sha}
    */
    readonly commitSha?: string;
    /**
    * Directory, relative to the source root, in which to run the build.
  
  This must be a relative path. If a step's dir is specified and
  is an absolute path, this value is ignored for that step's
  execution.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_cloudbuild_trigger#dir GoogleCloudbuildTrigger#dir}
    */
    readonly dir?: string;
    /**
    * Only trigger a build if the revision regex does NOT match the revision regex.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_cloudbuild_trigger#invert_regex GoogleCloudbuildTrigger#invert_regex}
    */
    readonly invertRegex?: boolean | cdktf.IResolvable;
    /**
    * ID of the project that owns the Cloud Source Repository. If
  omitted, the project ID requesting the build is assumed.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_cloudbuild_trigger#project_id GoogleCloudbuildTrigger#project_id}
    */
    readonly projectId?: string;
    /**
    * Name of the Cloud Source Repository. If omitted, the name "default" is assumed.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_cloudbuild_trigger#repo_name GoogleCloudbuildTrigger#repo_name}
    */
    readonly repoName?: string;
    /**
    * Name of the tag to build. Exactly one of a branch name, tag, or commit SHA must be provided.
  This field is a regular expression.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_cloudbuild_trigger#tag_name GoogleCloudbuildTrigger#tag_name}
    */
    readonly tagName?: string;
}
export declare function googleCloudbuildTriggerTriggerTemplateToTerraform(struct?: GoogleCloudbuildTriggerTriggerTemplateOutputReference | GoogleCloudbuildTriggerTriggerTemplate): any;
export declare class GoogleCloudbuildTriggerTriggerTemplateOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleCloudbuildTriggerTriggerTemplate | undefined;
    set internalValue(value: GoogleCloudbuildTriggerTriggerTemplate | undefined);
    private _branchName?;
    get branchName(): string;
    set branchName(value: string);
    resetBranchName(): void;
    get branchNameInput(): string | undefined;
    private _commitSha?;
    get commitSha(): string;
    set commitSha(value: string);
    resetCommitSha(): void;
    get commitShaInput(): string | undefined;
    private _dir?;
    get dir(): string;
    set dir(value: string);
    resetDir(): void;
    get dirInput(): string | undefined;
    private _invertRegex?;
    get invertRegex(): boolean | cdktf.IResolvable;
    set invertRegex(value: boolean | cdktf.IResolvable);
    resetInvertRegex(): void;
    get invertRegexInput(): boolean | cdktf.IResolvable | undefined;
    private _projectId?;
    get projectId(): string;
    set projectId(value: string);
    resetProjectId(): void;
    get projectIdInput(): string | undefined;
    private _repoName?;
    get repoName(): string;
    set repoName(value: string);
    resetRepoName(): void;
    get repoNameInput(): string | undefined;
    private _tagName?;
    get tagName(): string;
    set tagName(value: string);
    resetTagName(): void;
    get tagNameInput(): string | undefined;
}
export interface GoogleCloudbuildTriggerWebhookConfig {
    /**
    * Resource name for the secret required as a URL parameter.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_cloudbuild_trigger#secret GoogleCloudbuildTrigger#secret}
    */
    readonly secret: string;
}
export declare function googleCloudbuildTriggerWebhookConfigToTerraform(struct?: GoogleCloudbuildTriggerWebhookConfigOutputReference | GoogleCloudbuildTriggerWebhookConfig): any;
export declare class GoogleCloudbuildTriggerWebhookConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleCloudbuildTriggerWebhookConfig | undefined;
    set internalValue(value: GoogleCloudbuildTriggerWebhookConfig | undefined);
    private _secret?;
    get secret(): string;
    set secret(value: string);
    get secretInput(): string | undefined;
    get state(): string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google-beta/r/google_cloudbuild_trigger google_cloudbuild_trigger}
*/
export declare class GoogleCloudbuildTrigger extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_cloudbuild_trigger";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google-beta/r/google_cloudbuild_trigger google_cloudbuild_trigger} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleCloudbuildTriggerConfig = {}
    */
    constructor(scope: Construct, id: string, config?: GoogleCloudbuildTriggerConfig);
    get createTime(): string;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _disabled?;
    get disabled(): boolean | cdktf.IResolvable;
    set disabled(value: boolean | cdktf.IResolvable);
    resetDisabled(): void;
    get disabledInput(): boolean | cdktf.IResolvable | undefined;
    private _filename?;
    get filename(): string;
    set filename(value: string);
    resetFilename(): void;
    get filenameInput(): string | undefined;
    private _filter?;
    get filter(): string;
    set filter(value: string);
    resetFilter(): void;
    get filterInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _ignoredFiles?;
    get ignoredFiles(): string[];
    set ignoredFiles(value: string[]);
    resetIgnoredFiles(): void;
    get ignoredFilesInput(): string[] | undefined;
    private _includeBuildLogs?;
    get includeBuildLogs(): string;
    set includeBuildLogs(value: string);
    resetIncludeBuildLogs(): void;
    get includeBuildLogsInput(): string | undefined;
    private _includedFiles?;
    get includedFiles(): string[];
    set includedFiles(value: string[]);
    resetIncludedFiles(): void;
    get includedFilesInput(): string[] | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    resetLocation(): void;
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _serviceAccount?;
    get serviceAccount(): string;
    set serviceAccount(value: string);
    resetServiceAccount(): void;
    get serviceAccountInput(): string | undefined;
    private _substitutions?;
    get substitutions(): {
        [key: string]: string;
    };
    set substitutions(value: {
        [key: string]: string;
    });
    resetSubstitutions(): void;
    get substitutionsInput(): {
        [key: string]: string;
    } | undefined;
    private _tags?;
    get tags(): string[];
    set tags(value: string[]);
    resetTags(): void;
    get tagsInput(): string[] | undefined;
    get triggerId(): string;
    private _approvalConfig;
    get approvalConfig(): GoogleCloudbuildTriggerApprovalConfigOutputReference;
    putApprovalConfig(value: GoogleCloudbuildTriggerApprovalConfig): void;
    resetApprovalConfig(): void;
    get approvalConfigInput(): GoogleCloudbuildTriggerApprovalConfig | undefined;
    private _build;
    get buildAttribute(): GoogleCloudbuildTriggerBuildOutputReference;
    putBuildAttribute(value: GoogleCloudbuildTriggerBuild): void;
    resetBuildAttribute(): void;
    get buildAttributeInput(): GoogleCloudbuildTriggerBuild | undefined;
    private _gitFileSource;
    get gitFileSource(): GoogleCloudbuildTriggerGitFileSourceOutputReference;
    putGitFileSource(value: GoogleCloudbuildTriggerGitFileSource): void;
    resetGitFileSource(): void;
    get gitFileSourceInput(): GoogleCloudbuildTriggerGitFileSource | undefined;
    private _github;
    get github(): GoogleCloudbuildTriggerGithubOutputReference;
    putGithub(value: GoogleCloudbuildTriggerGithub): void;
    resetGithub(): void;
    get githubInput(): GoogleCloudbuildTriggerGithub | undefined;
    private _pubsubConfig;
    get pubsubConfig(): GoogleCloudbuildTriggerPubsubConfigOutputReference;
    putPubsubConfig(value: GoogleCloudbuildTriggerPubsubConfig): void;
    resetPubsubConfig(): void;
    get pubsubConfigInput(): GoogleCloudbuildTriggerPubsubConfig | undefined;
    private _sourceToBuild;
    get sourceToBuild(): GoogleCloudbuildTriggerSourceToBuildOutputReference;
    putSourceToBuild(value: GoogleCloudbuildTriggerSourceToBuild): void;
    resetSourceToBuild(): void;
    get sourceToBuildInput(): GoogleCloudbuildTriggerSourceToBuild | undefined;
    private _timeouts;
    get timeouts(): GoogleCloudbuildTriggerTimeoutsOutputReference;
    putTimeouts(value: GoogleCloudbuildTriggerTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleCloudbuildTriggerTimeouts | undefined;
    private _triggerTemplate;
    get triggerTemplate(): GoogleCloudbuildTriggerTriggerTemplateOutputReference;
    putTriggerTemplate(value: GoogleCloudbuildTriggerTriggerTemplate): void;
    resetTriggerTemplate(): void;
    get triggerTemplateInput(): GoogleCloudbuildTriggerTriggerTemplate | undefined;
    private _webhookConfig;
    get webhookConfig(): GoogleCloudbuildTriggerWebhookConfigOutputReference;
    putWebhookConfig(value: GoogleCloudbuildTriggerWebhookConfig): void;
    resetWebhookConfig(): void;
    get webhookConfigInput(): GoogleCloudbuildTriggerWebhookConfig | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
