import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleComputeExternalVpnGatewayConfig extends cdktf.TerraformMetaArguments {
    /**
    * An optional description of this resource.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_external_vpn_gateway#description GoogleComputeExternalVpnGateway#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_external_vpn_gateway#id GoogleComputeExternalVpnGateway#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Name of the resource. Provided by the client when the resource is
  created. The name must be 1-63 characters long, and comply with
  RFC1035.  Specifically, the name must be 1-63 characters long and
  match the regular expression '[a-z]([-a-z0-9]*[a-z0-9])?' which means
  the first character must be a lowercase letter, and all following
  characters must be a dash, lowercase letter, or digit, except the last
  character, which cannot be a dash.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_external_vpn_gateway#name GoogleComputeExternalVpnGateway#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_external_vpn_gateway#project GoogleComputeExternalVpnGateway#project}
    */
    readonly project?: string;
    /**
    * Indicates the redundancy type of this external VPN gateway Possible values: ["FOUR_IPS_REDUNDANCY", "SINGLE_IP_INTERNALLY_REDUNDANT", "TWO_IPS_REDUNDANCY"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_external_vpn_gateway#redundancy_type GoogleComputeExternalVpnGateway#redundancy_type}
    */
    readonly redundancyType?: string;
    /**
    * interface block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_external_vpn_gateway#interface GoogleComputeExternalVpnGateway#interface}
    */
    readonly interface?: GoogleComputeExternalVpnGatewayInterface[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_external_vpn_gateway#timeouts GoogleComputeExternalVpnGateway#timeouts}
    */
    readonly timeouts?: GoogleComputeExternalVpnGatewayTimeouts;
}
export interface GoogleComputeExternalVpnGatewayInterface {
    /**
    * The numeric ID for this interface. Allowed values are based on the redundancy type
  of this external VPN gateway
  * '0 - SINGLE_IP_INTERNALLY_REDUNDANT'
  * '0, 1 - TWO_IPS_REDUNDANCY'
  * '0, 1, 2, 3 - FOUR_IPS_REDUNDANCY'
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_external_vpn_gateway#id GoogleComputeExternalVpnGateway#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: number;
    /**
    * IP address of the interface in the external VPN gateway.
  Only IPv4 is supported. This IP address can be either from
  your on-premise gateway or another Cloud provider's VPN gateway,
  it cannot be an IP address from Google Compute Engine.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_external_vpn_gateway#ip_address GoogleComputeExternalVpnGateway#ip_address}
    */
    readonly ipAddress?: string;
}
export declare function googleComputeExternalVpnGatewayInterfaceToTerraform(struct?: GoogleComputeExternalVpnGatewayInterface | cdktf.IResolvable): any;
export declare class GoogleComputeExternalVpnGatewayInterfaceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleComputeExternalVpnGatewayInterface | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleComputeExternalVpnGatewayInterface | cdktf.IResolvable | undefined);
    private _id?;
    get id(): number;
    set id(value: number);
    resetId(): void;
    get idInput(): number | undefined;
    private _ipAddress?;
    get ipAddress(): string;
    set ipAddress(value: string);
    resetIpAddress(): void;
    get ipAddressInput(): string | undefined;
}
export declare class GoogleComputeExternalVpnGatewayInterfaceList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleComputeExternalVpnGatewayInterface[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleComputeExternalVpnGatewayInterfaceOutputReference;
}
export interface GoogleComputeExternalVpnGatewayTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_external_vpn_gateway#create GoogleComputeExternalVpnGateway#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_external_vpn_gateway#delete GoogleComputeExternalVpnGateway#delete}
    */
    readonly delete?: string;
}
export declare function googleComputeExternalVpnGatewayTimeoutsToTerraform(struct?: GoogleComputeExternalVpnGatewayTimeoutsOutputReference | GoogleComputeExternalVpnGatewayTimeouts | cdktf.IResolvable): any;
export declare class GoogleComputeExternalVpnGatewayTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeExternalVpnGatewayTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleComputeExternalVpnGatewayTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_external_vpn_gateway google_compute_external_vpn_gateway}
*/
export declare class GoogleComputeExternalVpnGateway extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_compute_external_vpn_gateway";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_external_vpn_gateway google_compute_external_vpn_gateway} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleComputeExternalVpnGatewayConfig
    */
    constructor(scope: Construct, id: string, config: GoogleComputeExternalVpnGatewayConfig);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _redundancyType?;
    get redundancyType(): string;
    set redundancyType(value: string);
    resetRedundancyType(): void;
    get redundancyTypeInput(): string | undefined;
    get selfLink(): string;
    private _interface;
    get interface(): GoogleComputeExternalVpnGatewayInterfaceList;
    putInterface(value: GoogleComputeExternalVpnGatewayInterface[] | cdktf.IResolvable): void;
    resetInterface(): void;
    get interfaceInput(): cdktf.IResolvable | GoogleComputeExternalVpnGatewayInterface[] | undefined;
    private _timeouts;
    get timeouts(): GoogleComputeExternalVpnGatewayTimeoutsOutputReference;
    putTimeouts(value: GoogleComputeExternalVpnGatewayTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleComputeExternalVpnGatewayTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
