import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleComputeFirewallConfig extends cdktf.TerraformMetaArguments {
    /**
    * An optional description of this resource. Provide this property when
  you create the resource.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_firewall#description GoogleComputeFirewall#description}
    */
    readonly description?: string;
    /**
    * If destination ranges are specified, the firewall will apply only to
  traffic that has destination IP address in these ranges. These ranges
  must be expressed in CIDR format. Only IPv4 is supported.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_firewall#destination_ranges GoogleComputeFirewall#destination_ranges}
    */
    readonly destinationRanges?: string[];
    /**
    * Direction of traffic to which this firewall applies; default is
  INGRESS. Note: For INGRESS traffic, it is NOT supported to specify
  destinationRanges; For EGRESS traffic, it is NOT supported to specify
  'source_ranges' OR 'source_tags'. For INGRESS traffic, one of 'source_ranges',
  'source_tags' or 'source_service_accounts' is required. Possible values: ["INGRESS", "EGRESS"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_firewall#direction GoogleComputeFirewall#direction}
    */
    readonly direction?: string;
    /**
    * Denotes whether the firewall rule is disabled, i.e not applied to the
  network it is associated with. When set to true, the firewall rule is
  not enforced and the network behaves as if it did not exist. If this
  is unspecified, the firewall rule will be enabled.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_firewall#disabled GoogleComputeFirewall#disabled}
    */
    readonly disabled?: boolean | cdktf.IResolvable;
    /**
    * This field denotes whether to enable logging for a particular firewall rule. If logging is enabled, logs will be exported to Stackdriver.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_firewall#enable_logging GoogleComputeFirewall#enable_logging}
    */
    readonly enableLogging?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_firewall#id GoogleComputeFirewall#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Name of the resource. Provided by the client when the resource is
  created. The name must be 1-63 characters long, and comply with
  RFC1035. Specifically, the name must be 1-63 characters long and match
  the regular expression '[a-z]([-a-z0-9]*[a-z0-9])?' which means the
  first character must be a lowercase letter, and all following
  characters must be a dash, lowercase letter, or digit, except the last
  character, which cannot be a dash.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_firewall#name GoogleComputeFirewall#name}
    */
    readonly name: string;
    /**
    * The name or self_link of the network to attach this firewall to.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_firewall#network GoogleComputeFirewall#network}
    */
    readonly network: string;
    /**
    * Priority for this rule. This is an integer between 0 and 65535, both
  inclusive. When not specified, the value assumed is 1000. Relative
  priorities determine precedence of conflicting rules. Lower value of
  priority implies higher precedence (eg, a rule with priority 0 has
  higher precedence than a rule with priority 1). DENY rules take
  precedence over ALLOW rules having equal priority.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_firewall#priority GoogleComputeFirewall#priority}
    */
    readonly priority?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_firewall#project GoogleComputeFirewall#project}
    */
    readonly project?: string;
    /**
    * If source ranges are specified, the firewall will apply only to
  traffic that has source IP address in these ranges. These ranges must
  be expressed in CIDR format. One or both of sourceRanges and
  sourceTags may be set. If both properties are set, the firewall will
  apply to traffic that has source IP address within sourceRanges OR the
  source IP that belongs to a tag listed in the sourceTags property. The
  connection does not need to match both properties for the firewall to
  apply. Only IPv4 is supported. For INGRESS traffic, one of 'source_ranges',
  'source_tags' or 'source_service_accounts' is required.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_firewall#source_ranges GoogleComputeFirewall#source_ranges}
    */
    readonly sourceRanges?: string[];
    /**
    * If source service accounts are specified, the firewall will apply only
  to traffic originating from an instance with a service account in this
  list. Source service accounts cannot be used to control traffic to an
  instance's external IP address because service accounts are associated
  with an instance, not an IP address. sourceRanges can be set at the
  same time as sourceServiceAccounts. If both are set, the firewall will
  apply to traffic that has source IP address within sourceRanges OR the
  source IP belongs to an instance with service account listed in
  sourceServiceAccount. The connection does not need to match both
  properties for the firewall to apply. sourceServiceAccounts cannot be
  used at the same time as sourceTags or targetTags. For INGRESS traffic,
  one of 'source_ranges', 'source_tags' or 'source_service_accounts' is required.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_firewall#source_service_accounts GoogleComputeFirewall#source_service_accounts}
    */
    readonly sourceServiceAccounts?: string[];
    /**
    * If source tags are specified, the firewall will apply only to traffic
  with source IP that belongs to a tag listed in source tags. Source
  tags cannot be used to control traffic to an instance's external IP
  address. Because tags are associated with an instance, not an IP
  address. One or both of sourceRanges and sourceTags may be set. If
  both properties are set, the firewall will apply to traffic that has
  source IP address within sourceRanges OR the source IP that belongs to
  a tag listed in the sourceTags property. The connection does not need
  to match both properties for the firewall to apply. For INGRESS traffic,
  one of 'source_ranges', 'source_tags' or 'source_service_accounts' is required.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_firewall#source_tags GoogleComputeFirewall#source_tags}
    */
    readonly sourceTags?: string[];
    /**
    * A list of service accounts indicating sets of instances located in the
  network that may make network connections as specified in allowed[].
  targetServiceAccounts cannot be used at the same time as targetTags or
  sourceTags. If neither targetServiceAccounts nor targetTags are
  specified, the firewall rule applies to all instances on the specified
  network.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_firewall#target_service_accounts GoogleComputeFirewall#target_service_accounts}
    */
    readonly targetServiceAccounts?: string[];
    /**
    * A list of instance tags indicating sets of instances located in the
  network that may make network connections as specified in allowed[].
  If no targetTags are specified, the firewall rule applies to all
  instances on the specified network.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_firewall#target_tags GoogleComputeFirewall#target_tags}
    */
    readonly targetTags?: string[];
    /**
    * allow block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_firewall#allow GoogleComputeFirewall#allow}
    */
    readonly allow?: GoogleComputeFirewallAllow[] | cdktf.IResolvable;
    /**
    * deny block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_firewall#deny GoogleComputeFirewall#deny}
    */
    readonly deny?: GoogleComputeFirewallDeny[] | cdktf.IResolvable;
    /**
    * log_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_firewall#log_config GoogleComputeFirewall#log_config}
    */
    readonly logConfig?: GoogleComputeFirewallLogConfig;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_firewall#timeouts GoogleComputeFirewall#timeouts}
    */
    readonly timeouts?: GoogleComputeFirewallTimeouts;
}
export interface GoogleComputeFirewallAllow {
    /**
    * An optional list of ports to which this rule applies. This field
  is only applicable for UDP or TCP protocol. Each entry must be
  either an integer or a range. If not specified, this rule
  applies to connections through any port.
  
  Example inputs include: ["22"], ["80","443"], and
  ["12345-12349"].
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_firewall#ports GoogleComputeFirewall#ports}
    */
    readonly ports?: string[];
    /**
    * The IP protocol to which this rule applies. The protocol type is
  required when creating a firewall rule. This value can either be
  one of the following well known protocol strings (tcp, udp,
  icmp, esp, ah, sctp, ipip, all), or the IP protocol number.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_firewall#protocol GoogleComputeFirewall#protocol}
    */
    readonly protocol: string;
}
export declare function googleComputeFirewallAllowToTerraform(struct?: GoogleComputeFirewallAllow | cdktf.IResolvable): any;
export declare class GoogleComputeFirewallAllowOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleComputeFirewallAllow | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleComputeFirewallAllow | cdktf.IResolvable | undefined);
    private _ports?;
    get ports(): string[];
    set ports(value: string[]);
    resetPorts(): void;
    get portsInput(): string[] | undefined;
    private _protocol?;
    get protocol(): string;
    set protocol(value: string);
    get protocolInput(): string | undefined;
}
export declare class GoogleComputeFirewallAllowList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleComputeFirewallAllow[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleComputeFirewallAllowOutputReference;
}
export interface GoogleComputeFirewallDeny {
    /**
    * An optional list of ports to which this rule applies. This field
  is only applicable for UDP or TCP protocol. Each entry must be
  either an integer or a range. If not specified, this rule
  applies to connections through any port.
  
  Example inputs include: ["22"], ["80","443"], and
  ["12345-12349"].
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_firewall#ports GoogleComputeFirewall#ports}
    */
    readonly ports?: string[];
    /**
    * The IP protocol to which this rule applies. The protocol type is
  required when creating a firewall rule. This value can either be
  one of the following well known protocol strings (tcp, udp,
  icmp, esp, ah, sctp, ipip, all), or the IP protocol number.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_firewall#protocol GoogleComputeFirewall#protocol}
    */
    readonly protocol: string;
}
export declare function googleComputeFirewallDenyToTerraform(struct?: GoogleComputeFirewallDeny | cdktf.IResolvable): any;
export declare class GoogleComputeFirewallDenyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleComputeFirewallDeny | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleComputeFirewallDeny | cdktf.IResolvable | undefined);
    private _ports?;
    get ports(): string[];
    set ports(value: string[]);
    resetPorts(): void;
    get portsInput(): string[] | undefined;
    private _protocol?;
    get protocol(): string;
    set protocol(value: string);
    get protocolInput(): string | undefined;
}
export declare class GoogleComputeFirewallDenyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleComputeFirewallDeny[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleComputeFirewallDenyOutputReference;
}
export interface GoogleComputeFirewallLogConfig {
    /**
    * This field denotes whether to include or exclude metadata for firewall logs. Possible values: ["EXCLUDE_ALL_METADATA", "INCLUDE_ALL_METADATA"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_firewall#metadata GoogleComputeFirewall#metadata}
    */
    readonly metadata: string;
}
export declare function googleComputeFirewallLogConfigToTerraform(struct?: GoogleComputeFirewallLogConfigOutputReference | GoogleComputeFirewallLogConfig): any;
export declare class GoogleComputeFirewallLogConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeFirewallLogConfig | undefined;
    set internalValue(value: GoogleComputeFirewallLogConfig | undefined);
    private _metadata?;
    get metadata(): string;
    set metadata(value: string);
    get metadataInput(): string | undefined;
}
export interface GoogleComputeFirewallTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_firewall#create GoogleComputeFirewall#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_firewall#delete GoogleComputeFirewall#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_firewall#update GoogleComputeFirewall#update}
    */
    readonly update?: string;
}
export declare function googleComputeFirewallTimeoutsToTerraform(struct?: GoogleComputeFirewallTimeoutsOutputReference | GoogleComputeFirewallTimeouts | cdktf.IResolvable): any;
export declare class GoogleComputeFirewallTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeFirewallTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleComputeFirewallTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_firewall google_compute_firewall}
*/
export declare class GoogleComputeFirewall extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_compute_firewall";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_firewall google_compute_firewall} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleComputeFirewallConfig
    */
    constructor(scope: Construct, id: string, config: GoogleComputeFirewallConfig);
    get creationTimestamp(): string;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _destinationRanges?;
    get destinationRanges(): string[];
    set destinationRanges(value: string[]);
    resetDestinationRanges(): void;
    get destinationRangesInput(): string[] | undefined;
    private _direction?;
    get direction(): string;
    set direction(value: string);
    resetDirection(): void;
    get directionInput(): string | undefined;
    private _disabled?;
    get disabled(): boolean | cdktf.IResolvable;
    set disabled(value: boolean | cdktf.IResolvable);
    resetDisabled(): void;
    get disabledInput(): boolean | cdktf.IResolvable | undefined;
    private _enableLogging?;
    get enableLogging(): boolean | cdktf.IResolvable;
    set enableLogging(value: boolean | cdktf.IResolvable);
    resetEnableLogging(): void;
    get enableLoggingInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _network?;
    get network(): string;
    set network(value: string);
    get networkInput(): string | undefined;
    private _priority?;
    get priority(): number;
    set priority(value: number);
    resetPriority(): void;
    get priorityInput(): number | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    get selfLink(): string;
    private _sourceRanges?;
    get sourceRanges(): string[];
    set sourceRanges(value: string[]);
    resetSourceRanges(): void;
    get sourceRangesInput(): string[] | undefined;
    private _sourceServiceAccounts?;
    get sourceServiceAccounts(): string[];
    set sourceServiceAccounts(value: string[]);
    resetSourceServiceAccounts(): void;
    get sourceServiceAccountsInput(): string[] | undefined;
    private _sourceTags?;
    get sourceTags(): string[];
    set sourceTags(value: string[]);
    resetSourceTags(): void;
    get sourceTagsInput(): string[] | undefined;
    private _targetServiceAccounts?;
    get targetServiceAccounts(): string[];
    set targetServiceAccounts(value: string[]);
    resetTargetServiceAccounts(): void;
    get targetServiceAccountsInput(): string[] | undefined;
    private _targetTags?;
    get targetTags(): string[];
    set targetTags(value: string[]);
    resetTargetTags(): void;
    get targetTagsInput(): string[] | undefined;
    private _allow;
    get allow(): GoogleComputeFirewallAllowList;
    putAllow(value: GoogleComputeFirewallAllow[] | cdktf.IResolvable): void;
    resetAllow(): void;
    get allowInput(): cdktf.IResolvable | GoogleComputeFirewallAllow[] | undefined;
    private _deny;
    get deny(): GoogleComputeFirewallDenyList;
    putDeny(value: GoogleComputeFirewallDeny[] | cdktf.IResolvable): void;
    resetDeny(): void;
    get denyInput(): cdktf.IResolvable | GoogleComputeFirewallDeny[] | undefined;
    private _logConfig;
    get logConfig(): GoogleComputeFirewallLogConfigOutputReference;
    putLogConfig(value: GoogleComputeFirewallLogConfig): void;
    resetLogConfig(): void;
    get logConfigInput(): GoogleComputeFirewallLogConfig | undefined;
    private _timeouts;
    get timeouts(): GoogleComputeFirewallTimeoutsOutputReference;
    putTimeouts(value: GoogleComputeFirewallTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleComputeFirewallTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
