import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleComputeGlobalAddressConfig extends cdktf.TerraformMetaArguments {
    /**
    * The IP address or beginning of the address range represented by this
  resource. This can be supplied as an input to reserve a specific
  address or omitted to allow GCP to choose a valid one for you.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_global_address#address GoogleComputeGlobalAddress#address}
    */
    readonly address?: string;
    /**
    * The type of the address to reserve.
  
  * EXTERNAL indicates public/external single IP address.
  * INTERNAL indicates internal IP ranges belonging to some network. Default value: "EXTERNAL" Possible values: ["EXTERNAL", "INTERNAL"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_global_address#address_type GoogleComputeGlobalAddress#address_type}
    */
    readonly addressType?: string;
    /**
    * An optional description of this resource.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_global_address#description GoogleComputeGlobalAddress#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_global_address#id GoogleComputeGlobalAddress#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The IP Version that will be used by this address. The default value is 'IPV4'. Possible values: ["IPV4", "IPV6"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_global_address#ip_version GoogleComputeGlobalAddress#ip_version}
    */
    readonly ipVersion?: string;
    /**
    * Labels to apply to this address.  A list of key->value pairs.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_global_address#labels GoogleComputeGlobalAddress#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * Name of the resource. Provided by the client when the resource is
  created. The name must be 1-63 characters long, and comply with
  RFC1035.  Specifically, the name must be 1-63 characters long and
  match the regular expression '[a-z]([-a-z0-9]*[a-z0-9])?' which means
  the first character must be a lowercase letter, and all following
  characters must be a dash, lowercase letter, or digit, except the last
  character, which cannot be a dash.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_global_address#name GoogleComputeGlobalAddress#name}
    */
    readonly name: string;
    /**
    * The URL of the network in which to reserve the IP range. The IP range
  must be in RFC1918 space. The network cannot be deleted if there are
  any reserved IP ranges referring to it.
  
  This should only be set when using an Internal address.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_global_address#network GoogleComputeGlobalAddress#network}
    */
    readonly network?: string;
    /**
    * The prefix length of the IP range. If not present, it means the
  address field is a single IP address.
  
  This field is not applicable to addresses with addressType=EXTERNAL,
  or addressType=INTERNAL when purpose=PRIVATE_SERVICE_CONNECT
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_global_address#prefix_length GoogleComputeGlobalAddress#prefix_length}
    */
    readonly prefixLength?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_global_address#project GoogleComputeGlobalAddress#project}
    */
    readonly project?: string;
    /**
    * The purpose of the resource. Possible values include:
  
  * VPC_PEERING - for peer networks
  
  * PRIVATE_SERVICE_CONNECT - for ([Beta](https://terraform.io/docs/providers/google/guides/provider_versions.html) only) Private Service Connect networks
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_global_address#purpose GoogleComputeGlobalAddress#purpose}
    */
    readonly purpose?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_global_address#timeouts GoogleComputeGlobalAddress#timeouts}
    */
    readonly timeouts?: GoogleComputeGlobalAddressTimeouts;
}
export interface GoogleComputeGlobalAddressTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_global_address#create GoogleComputeGlobalAddress#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_global_address#delete GoogleComputeGlobalAddress#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_global_address#update GoogleComputeGlobalAddress#update}
    */
    readonly update?: string;
}
export declare function googleComputeGlobalAddressTimeoutsToTerraform(struct?: GoogleComputeGlobalAddressTimeoutsOutputReference | GoogleComputeGlobalAddressTimeouts | cdktf.IResolvable): any;
export declare class GoogleComputeGlobalAddressTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeGlobalAddressTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleComputeGlobalAddressTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_global_address google_compute_global_address}
*/
export declare class GoogleComputeGlobalAddress extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_compute_global_address";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_global_address google_compute_global_address} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleComputeGlobalAddressConfig
    */
    constructor(scope: Construct, id: string, config: GoogleComputeGlobalAddressConfig);
    private _address?;
    get address(): string;
    set address(value: string);
    resetAddress(): void;
    get addressInput(): string | undefined;
    private _addressType?;
    get addressType(): string;
    set addressType(value: string);
    resetAddressType(): void;
    get addressTypeInput(): string | undefined;
    get creationTimestamp(): string;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _ipVersion?;
    get ipVersion(): string;
    set ipVersion(value: string);
    resetIpVersion(): void;
    get ipVersionInput(): string | undefined;
    get labelFingerprint(): string;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _network?;
    get network(): string;
    set network(value: string);
    resetNetwork(): void;
    get networkInput(): string | undefined;
    private _prefixLength?;
    get prefixLength(): number;
    set prefixLength(value: number);
    resetPrefixLength(): void;
    get prefixLengthInput(): number | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _purpose?;
    get purpose(): string;
    set purpose(value: string);
    resetPurpose(): void;
    get purposeInput(): string | undefined;
    get selfLink(): string;
    private _timeouts;
    get timeouts(): GoogleComputeGlobalAddressTimeoutsOutputReference;
    putTimeouts(value: GoogleComputeGlobalAddressTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleComputeGlobalAddressTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
