import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleComputeGlobalForwardingRuleConfig extends cdktf.TerraformMetaArguments {
    /**
    * An optional description of this resource. Provide this property when you create the resource.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_global_forwarding_rule#description GoogleComputeGlobalForwardingRule#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_global_forwarding_rule#id GoogleComputeGlobalForwardingRule#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * IP address that this forwarding rule serves. When a client sends traffic to this IP address, the forwarding rule directs the traffic to the target that you specify in the forwarding rule. If you don't specify a reserved IP address, an ephemeral IP address is assigned. Methods for specifying an IP address: * IPv4 dotted decimal, as in `100.1.2.3` * Full URL, as in `https://www.googleapis.com/compute/v1/projects/project_id/regions/region/addresses/address-name` * Partial URL or by name, as in: * `projects/project_id/regions/region/addresses/address-name` * `regions/region/addresses/address-name` * `global/addresses/address-name` * `address-name` The loadBalancingScheme and the forwarding rule's target determine the type of IP address that you can use. For detailed information, refer to [IP address specifications](/load-balancing/docs/forwarding-rule-concepts#ip_address_specifications).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_global_forwarding_rule#ip_address GoogleComputeGlobalForwardingRule#ip_address}
    */
    readonly ipAddress?: string;
    /**
    * The IP protocol to which this rule applies. For protocol forwarding, valid options are `TCP`, `UDP`, `ESP`, `AH`, `SCTP` or `ICMP`. For Internal TCP/UDP Load Balancing, the load balancing scheme is `INTERNAL`, and one of `TCP` or `UDP` are valid. For Traffic Director, the load balancing scheme is `INTERNAL_SELF_MANAGED`, and only `TCP`is valid. For Internal HTTP(S) Load Balancing, the load balancing scheme is `INTERNAL_MANAGED`, and only `TCP` is valid. For HTTP(S), SSL Proxy, and TCP Proxy Load Balancing, the load balancing scheme is `EXTERNAL` and only `TCP` is valid. For Network TCP/UDP Load Balancing, the load balancing scheme is `EXTERNAL`, and one of `TCP` or `UDP` is valid.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_global_forwarding_rule#ip_protocol GoogleComputeGlobalForwardingRule#ip_protocol}
    */
    readonly ipProtocol?: string;
    /**
    * The IP Version that will be used by this forwarding rule. Valid options are `IPV4` or `IPV6`. This can only be specified for an external global forwarding rule. Possible values: UNSPECIFIED_VERSION, IPV4, IPV6
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_global_forwarding_rule#ip_version GoogleComputeGlobalForwardingRule#ip_version}
    */
    readonly ipVersion?: string;
    /**
    * Labels to apply to this rule.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_global_forwarding_rule#labels GoogleComputeGlobalForwardingRule#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * Specifies the forwarding rule type.
  
  *   `EXTERNAL` is used for:
      *   Classic Cloud VPN gateways
      *   Protocol forwarding to VMs from an external IP address
      *   The following load balancers: HTTP(S), SSL Proxy, TCP Proxy, and Network TCP/UDP
  *   `INTERNAL` is used for:
      *   Protocol forwarding to VMs from an internal IP address
      *   Internal TCP/UDP load balancers
  *   `INTERNAL_MANAGED` is used for:
      *   Internal HTTP(S) load balancers
  *   `INTERNAL_SELF_MANAGED` is used for:
      *   Traffic Director
  *   `EXTERNAL_MANAGED` is used for:
      *   Global external HTTP(S) load balancers
  
  For more information about forwarding rules, refer to [Forwarding rule concepts](/load-balancing/docs/forwarding-rule-concepts). Possible values: INVALID, INTERNAL, INTERNAL_MANAGED, INTERNAL_SELF_MANAGED, EXTERNAL, EXTERNAL_MANAGED
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_global_forwarding_rule#load_balancing_scheme GoogleComputeGlobalForwardingRule#load_balancing_scheme}
    */
    readonly loadBalancingScheme?: string;
    /**
    * Name of the resource; provided by the client when the resource is created. The name must be 1-63 characters long, and comply with [RFC1035](https://www.ietf.org/rfc/rfc1035.txt). Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_global_forwarding_rule#name GoogleComputeGlobalForwardingRule#name}
    */
    readonly name: string;
    /**
    * This field is not used for external load balancing. For `INTERNAL` and `INTERNAL_SELF_MANAGED` load balancing, this field identifies the network that the load balanced IP should belong to for this Forwarding Rule. If this field is not specified, the default network will be used.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_global_forwarding_rule#network GoogleComputeGlobalForwardingRule#network}
    */
    readonly network?: string;
    /**
    * When the load balancing scheme is `EXTERNAL`, `INTERNAL_SELF_MANAGED` and `INTERNAL_MANAGED`, you can specify a `port_range`. Use with a forwarding rule that points to a target proxy or a target pool. Do not use with a forwarding rule that points to a backend service. This field is used along with the `target` field for TargetHttpProxy, TargetHttpsProxy, TargetSslProxy, TargetTcpProxy, TargetVpnGateway, TargetPool, TargetInstance. Applicable only when `IPProtocol` is `TCP`, `UDP`, or `SCTP`, only packets addressed to ports in the specified range will be forwarded to `target`. Forwarding rules with the same `[IPAddress, IPProtocol]` pair must have disjoint port ranges. Some types of forwarding target have constraints on the acceptable ports:
  
  *   TargetHttpProxy: 80, 8080
  *   TargetHttpsProxy: 443
  *   TargetTcpProxy: 25, 43, 110, 143, 195, 443, 465, 587, 700, 993, 995, 1688, 1883, 5222
  *   TargetSslProxy: 25, 43, 110, 143, 195, 443, 465, 587, 700, 993, 995, 1688, 1883, 5222
  *   TargetVpnGateway: 500, 4500
  
  @pattern: d+(?:-d+)?
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_global_forwarding_rule#port_range GoogleComputeGlobalForwardingRule#port_range}
    */
    readonly portRange?: string;
    /**
    * The project this resource belongs in.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_global_forwarding_rule#project GoogleComputeGlobalForwardingRule#project}
    */
    readonly project?: string;
    /**
    * The URL of the target resource to receive the matched traffic. For regional forwarding rules, this target must live in the same region as the forwarding rule. For global forwarding rules, this target must be a global load balancing resource. The forwarded traffic must be of a type appropriate to the target object. For `INTERNAL_SELF_MANAGED` load balancing, only `targetHttpProxy` is valid, not `targetHttpsProxy`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_global_forwarding_rule#target GoogleComputeGlobalForwardingRule#target}
    */
    readonly target: string;
    /**
    * metadata_filters block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_global_forwarding_rule#metadata_filters GoogleComputeGlobalForwardingRule#metadata_filters}
    */
    readonly metadataFilters?: GoogleComputeGlobalForwardingRuleMetadataFilters[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_global_forwarding_rule#timeouts GoogleComputeGlobalForwardingRule#timeouts}
    */
    readonly timeouts?: GoogleComputeGlobalForwardingRuleTimeouts;
}
export interface GoogleComputeGlobalForwardingRuleMetadataFiltersFilterLabels {
    /**
    * Name of metadata label.
  
  The name can have a maximum length of 1024 characters and must be at least 1 character long.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_global_forwarding_rule#name GoogleComputeGlobalForwardingRule#name}
    */
    readonly name: string;
    /**
    * The value of the label must match the specified value.
  
  value can have a maximum length of 1024 characters.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_global_forwarding_rule#value GoogleComputeGlobalForwardingRule#value}
    */
    readonly value: string;
}
export declare function googleComputeGlobalForwardingRuleMetadataFiltersFilterLabelsToTerraform(struct?: GoogleComputeGlobalForwardingRuleMetadataFiltersFilterLabels | cdktf.IResolvable): any;
export declare class GoogleComputeGlobalForwardingRuleMetadataFiltersFilterLabelsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleComputeGlobalForwardingRuleMetadataFiltersFilterLabels | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleComputeGlobalForwardingRuleMetadataFiltersFilterLabels | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    get valueInput(): string | undefined;
}
export declare class GoogleComputeGlobalForwardingRuleMetadataFiltersFilterLabelsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleComputeGlobalForwardingRuleMetadataFiltersFilterLabels[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleComputeGlobalForwardingRuleMetadataFiltersFilterLabelsOutputReference;
}
export interface GoogleComputeGlobalForwardingRuleMetadataFilters {
    /**
    * Specifies how individual `filterLabel` matches within the list of `filterLabel`s contribute towards the overall `metadataFilter` match.
  
  Supported values are:
  
  *   MATCH_ANY: At least one of the `filterLabels` must have a matching label in the provided metadata.
  *   MATCH_ALL: All `filterLabels` must have matching labels in the provided metadata. Possible values: NOT_SET, MATCH_ALL, MATCH_ANY
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_global_forwarding_rule#filter_match_criteria GoogleComputeGlobalForwardingRule#filter_match_criteria}
    */
    readonly filterMatchCriteria: string;
    /**
    * filter_labels block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_global_forwarding_rule#filter_labels GoogleComputeGlobalForwardingRule#filter_labels}
    */
    readonly filterLabels: GoogleComputeGlobalForwardingRuleMetadataFiltersFilterLabels[] | cdktf.IResolvable;
}
export declare function googleComputeGlobalForwardingRuleMetadataFiltersToTerraform(struct?: GoogleComputeGlobalForwardingRuleMetadataFilters | cdktf.IResolvable): any;
export declare class GoogleComputeGlobalForwardingRuleMetadataFiltersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleComputeGlobalForwardingRuleMetadataFilters | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleComputeGlobalForwardingRuleMetadataFilters | cdktf.IResolvable | undefined);
    private _filterMatchCriteria?;
    get filterMatchCriteria(): string;
    set filterMatchCriteria(value: string);
    get filterMatchCriteriaInput(): string | undefined;
    private _filterLabels;
    get filterLabels(): GoogleComputeGlobalForwardingRuleMetadataFiltersFilterLabelsList;
    putFilterLabels(value: GoogleComputeGlobalForwardingRuleMetadataFiltersFilterLabels[] | cdktf.IResolvable): void;
    get filterLabelsInput(): cdktf.IResolvable | GoogleComputeGlobalForwardingRuleMetadataFiltersFilterLabels[] | undefined;
}
export declare class GoogleComputeGlobalForwardingRuleMetadataFiltersList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleComputeGlobalForwardingRuleMetadataFilters[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleComputeGlobalForwardingRuleMetadataFiltersOutputReference;
}
export interface GoogleComputeGlobalForwardingRuleTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_global_forwarding_rule#create GoogleComputeGlobalForwardingRule#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_global_forwarding_rule#delete GoogleComputeGlobalForwardingRule#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_global_forwarding_rule#update GoogleComputeGlobalForwardingRule#update}
    */
    readonly update?: string;
}
export declare function googleComputeGlobalForwardingRuleTimeoutsToTerraform(struct?: GoogleComputeGlobalForwardingRuleTimeoutsOutputReference | GoogleComputeGlobalForwardingRuleTimeouts | cdktf.IResolvable): any;
export declare class GoogleComputeGlobalForwardingRuleTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeGlobalForwardingRuleTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleComputeGlobalForwardingRuleTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_global_forwarding_rule google_compute_global_forwarding_rule}
*/
export declare class GoogleComputeGlobalForwardingRule extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_compute_global_forwarding_rule";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_global_forwarding_rule google_compute_global_forwarding_rule} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleComputeGlobalForwardingRuleConfig
    */
    constructor(scope: Construct, id: string, config: GoogleComputeGlobalForwardingRuleConfig);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _ipAddress?;
    get ipAddress(): string;
    set ipAddress(value: string);
    resetIpAddress(): void;
    get ipAddressInput(): string | undefined;
    private _ipProtocol?;
    get ipProtocol(): string;
    set ipProtocol(value: string);
    resetIpProtocol(): void;
    get ipProtocolInput(): string | undefined;
    private _ipVersion?;
    get ipVersion(): string;
    set ipVersion(value: string);
    resetIpVersion(): void;
    get ipVersionInput(): string | undefined;
    get labelFingerprint(): string;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _loadBalancingScheme?;
    get loadBalancingScheme(): string;
    set loadBalancingScheme(value: string);
    resetLoadBalancingScheme(): void;
    get loadBalancingSchemeInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _network?;
    get network(): string;
    set network(value: string);
    resetNetwork(): void;
    get networkInput(): string | undefined;
    private _portRange?;
    get portRange(): string;
    set portRange(value: string);
    resetPortRange(): void;
    get portRangeInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    get pscConnectionId(): string;
    get pscConnectionStatus(): string;
    get selfLink(): string;
    private _target?;
    get target(): string;
    set target(value: string);
    get targetInput(): string | undefined;
    private _metadataFilters;
    get metadataFilters(): GoogleComputeGlobalForwardingRuleMetadataFiltersList;
    putMetadataFilters(value: GoogleComputeGlobalForwardingRuleMetadataFilters[] | cdktf.IResolvable): void;
    resetMetadataFilters(): void;
    get metadataFiltersInput(): cdktf.IResolvable | GoogleComputeGlobalForwardingRuleMetadataFilters[] | undefined;
    private _timeouts;
    get timeouts(): GoogleComputeGlobalForwardingRuleTimeoutsOutputReference;
    putTimeouts(value: GoogleComputeGlobalForwardingRuleTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleComputeGlobalForwardingRuleTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
