import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleComputeHaVpnGatewayConfig extends cdktf.TerraformMetaArguments {
    /**
    * An optional description of this resource.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_ha_vpn_gateway#description GoogleComputeHaVpnGateway#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_ha_vpn_gateway#id GoogleComputeHaVpnGateway#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Name of the resource. Provided by the client when the resource is
  created. The name must be 1-63 characters long, and comply with
  RFC1035.  Specifically, the name must be 1-63 characters long and
  match the regular expression '[a-z]([-a-z0-9]*[a-z0-9])?' which means
  the first character must be a lowercase letter, and all following
  characters must be a dash, lowercase letter, or digit, except the last
  character, which cannot be a dash.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_ha_vpn_gateway#name GoogleComputeHaVpnGateway#name}
    */
    readonly name: string;
    /**
    * The network this VPN gateway is accepting traffic for.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_ha_vpn_gateway#network GoogleComputeHaVpnGateway#network}
    */
    readonly network: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_ha_vpn_gateway#project GoogleComputeHaVpnGateway#project}
    */
    readonly project?: string;
    /**
    * The region this gateway should sit in.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_ha_vpn_gateway#region GoogleComputeHaVpnGateway#region}
    */
    readonly region?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_ha_vpn_gateway#timeouts GoogleComputeHaVpnGateway#timeouts}
    */
    readonly timeouts?: GoogleComputeHaVpnGatewayTimeouts;
    /**
    * vpn_interfaces block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_ha_vpn_gateway#vpn_interfaces GoogleComputeHaVpnGateway#vpn_interfaces}
    */
    readonly vpnInterfaces?: GoogleComputeHaVpnGatewayVpnInterfaces[] | cdktf.IResolvable;
}
export interface GoogleComputeHaVpnGatewayTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_ha_vpn_gateway#create GoogleComputeHaVpnGateway#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_ha_vpn_gateway#delete GoogleComputeHaVpnGateway#delete}
    */
    readonly delete?: string;
}
export declare function googleComputeHaVpnGatewayTimeoutsToTerraform(struct?: GoogleComputeHaVpnGatewayTimeoutsOutputReference | GoogleComputeHaVpnGatewayTimeouts | cdktf.IResolvable): any;
export declare class GoogleComputeHaVpnGatewayTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeHaVpnGatewayTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleComputeHaVpnGatewayTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
export interface GoogleComputeHaVpnGatewayVpnInterfaces {
    /**
    * The numeric ID of this VPN gateway interface.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_ha_vpn_gateway#id GoogleComputeHaVpnGateway#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: number;
    /**
    * URL of the interconnect attachment resource. When the value
  of this field is present, the VPN Gateway will be used for
  IPsec-encrypted Cloud Interconnect; all Egress or Ingress
  traffic for this VPN Gateway interface will go through the
  specified interconnect attachment resource.
  
  Not currently available publicly.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_ha_vpn_gateway#interconnect_attachment GoogleComputeHaVpnGateway#interconnect_attachment}
    */
    readonly interconnectAttachment?: string;
}
export declare function googleComputeHaVpnGatewayVpnInterfacesToTerraform(struct?: GoogleComputeHaVpnGatewayVpnInterfaces | cdktf.IResolvable): any;
export declare class GoogleComputeHaVpnGatewayVpnInterfacesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleComputeHaVpnGatewayVpnInterfaces | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleComputeHaVpnGatewayVpnInterfaces | cdktf.IResolvable | undefined);
    private _id?;
    get id(): number;
    set id(value: number);
    resetId(): void;
    get idInput(): number | undefined;
    private _interconnectAttachment?;
    get interconnectAttachment(): string;
    set interconnectAttachment(value: string);
    resetInterconnectAttachment(): void;
    get interconnectAttachmentInput(): string | undefined;
    get ipAddress(): string;
}
export declare class GoogleComputeHaVpnGatewayVpnInterfacesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleComputeHaVpnGatewayVpnInterfaces[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleComputeHaVpnGatewayVpnInterfacesOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_ha_vpn_gateway google_compute_ha_vpn_gateway}
*/
export declare class GoogleComputeHaVpnGateway extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_compute_ha_vpn_gateway";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_ha_vpn_gateway google_compute_ha_vpn_gateway} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleComputeHaVpnGatewayConfig
    */
    constructor(scope: Construct, id: string, config: GoogleComputeHaVpnGatewayConfig);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _network?;
    get network(): string;
    set network(value: string);
    get networkInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    get selfLink(): string;
    private _timeouts;
    get timeouts(): GoogleComputeHaVpnGatewayTimeoutsOutputReference;
    putTimeouts(value: GoogleComputeHaVpnGatewayTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleComputeHaVpnGatewayTimeouts | undefined;
    private _vpnInterfaces;
    get vpnInterfaces(): GoogleComputeHaVpnGatewayVpnInterfacesList;
    putVpnInterfaces(value: GoogleComputeHaVpnGatewayVpnInterfaces[] | cdktf.IResolvable): void;
    resetVpnInterfaces(): void;
    get vpnInterfacesInput(): cdktf.IResolvable | GoogleComputeHaVpnGatewayVpnInterfaces[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
