import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleComputeHealthCheckConfig extends cdktf.TerraformMetaArguments {
    /**
    * How often (in seconds) to send a health check. The default value is 5
  seconds.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_health_check#check_interval_sec GoogleComputeHealthCheck#check_interval_sec}
    */
    readonly checkIntervalSec?: number;
    /**
    * An optional description of this resource. Provide this property when
  you create the resource.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_health_check#description GoogleComputeHealthCheck#description}
    */
    readonly description?: string;
    /**
    * A so-far unhealthy instance will be marked healthy after this many
  consecutive successes. The default value is 2.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_health_check#healthy_threshold GoogleComputeHealthCheck#healthy_threshold}
    */
    readonly healthyThreshold?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_health_check#id GoogleComputeHealthCheck#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Name of the resource. Provided by the client when the resource is
  created. The name must be 1-63 characters long, and comply with
  RFC1035.  Specifically, the name must be 1-63 characters long and
  match the regular expression '[a-z]([-a-z0-9]*[a-z0-9])?' which means
  the first character must be a lowercase letter, and all following
  characters must be a dash, lowercase letter, or digit, except the
  last character, which cannot be a dash.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_health_check#name GoogleComputeHealthCheck#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_health_check#project GoogleComputeHealthCheck#project}
    */
    readonly project?: string;
    /**
    * How long (in seconds) to wait before claiming failure.
  The default value is 5 seconds.  It is invalid for timeoutSec to have
  greater value than checkIntervalSec.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_health_check#timeout_sec GoogleComputeHealthCheck#timeout_sec}
    */
    readonly timeoutSec?: number;
    /**
    * A so-far healthy instance will be marked unhealthy after this many
  consecutive failures. The default value is 2.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_health_check#unhealthy_threshold GoogleComputeHealthCheck#unhealthy_threshold}
    */
    readonly unhealthyThreshold?: number;
    /**
    * grpc_health_check block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_health_check#grpc_health_check GoogleComputeHealthCheck#grpc_health_check}
    */
    readonly grpcHealthCheck?: GoogleComputeHealthCheckGrpcHealthCheck;
    /**
    * http2_health_check block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_health_check#http2_health_check GoogleComputeHealthCheck#http2_health_check}
    */
    readonly http2HealthCheck?: GoogleComputeHealthCheckHttp2HealthCheck;
    /**
    * http_health_check block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_health_check#http_health_check GoogleComputeHealthCheck#http_health_check}
    */
    readonly httpHealthCheck?: GoogleComputeHealthCheckHttpHealthCheck;
    /**
    * https_health_check block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_health_check#https_health_check GoogleComputeHealthCheck#https_health_check}
    */
    readonly httpsHealthCheck?: GoogleComputeHealthCheckHttpsHealthCheck;
    /**
    * log_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_health_check#log_config GoogleComputeHealthCheck#log_config}
    */
    readonly logConfig?: GoogleComputeHealthCheckLogConfig;
    /**
    * ssl_health_check block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_health_check#ssl_health_check GoogleComputeHealthCheck#ssl_health_check}
    */
    readonly sslHealthCheck?: GoogleComputeHealthCheckSslHealthCheck;
    /**
    * tcp_health_check block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_health_check#tcp_health_check GoogleComputeHealthCheck#tcp_health_check}
    */
    readonly tcpHealthCheck?: GoogleComputeHealthCheckTcpHealthCheck;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_health_check#timeouts GoogleComputeHealthCheck#timeouts}
    */
    readonly timeouts?: GoogleComputeHealthCheckTimeouts;
}
export interface GoogleComputeHealthCheckGrpcHealthCheck {
    /**
    * The gRPC service name for the health check.
  The value of grpcServiceName has the following meanings by convention:
    - Empty serviceName means the overall status of all services at the backend.
    - Non-empty serviceName means the health of that gRPC service, as defined by the owner of the service.
  The grpcServiceName can only be ASCII.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_health_check#grpc_service_name GoogleComputeHealthCheck#grpc_service_name}
    */
    readonly grpcServiceName?: string;
    /**
    * The port number for the health check request.
  Must be specified if portName and portSpecification are not set
  or if port_specification is USE_FIXED_PORT. Valid values are 1 through 65535.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_health_check#port GoogleComputeHealthCheck#port}
    */
    readonly port?: number;
    /**
    * Port name as defined in InstanceGroup#NamedPort#name. If both port and
  port_name are defined, port takes precedence.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_health_check#port_name GoogleComputeHealthCheck#port_name}
    */
    readonly portName?: string;
    /**
    * Specifies how port is selected for health checking, can be one of the
  following values:
  
    * 'USE_FIXED_PORT': The port number in 'port' is used for health checking.
  
    * 'USE_NAMED_PORT': The 'portName' is used for health checking.
  
    * 'USE_SERVING_PORT': For NetworkEndpointGroup, the port specified for each
    network endpoint is used for health checking. For other backends, the
    port or named port specified in the Backend Service is used for health
    checking.
  
  If not specified, gRPC health check follows behavior specified in 'port' and
  'portName' fields. Possible values: ["USE_FIXED_PORT", "USE_NAMED_PORT", "USE_SERVING_PORT"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_health_check#port_specification GoogleComputeHealthCheck#port_specification}
    */
    readonly portSpecification?: string;
}
export declare function googleComputeHealthCheckGrpcHealthCheckToTerraform(struct?: GoogleComputeHealthCheckGrpcHealthCheckOutputReference | GoogleComputeHealthCheckGrpcHealthCheck): any;
export declare class GoogleComputeHealthCheckGrpcHealthCheckOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeHealthCheckGrpcHealthCheck | undefined;
    set internalValue(value: GoogleComputeHealthCheckGrpcHealthCheck | undefined);
    private _grpcServiceName?;
    get grpcServiceName(): string;
    set grpcServiceName(value: string);
    resetGrpcServiceName(): void;
    get grpcServiceNameInput(): string | undefined;
    private _port?;
    get port(): number;
    set port(value: number);
    resetPort(): void;
    get portInput(): number | undefined;
    private _portName?;
    get portName(): string;
    set portName(value: string);
    resetPortName(): void;
    get portNameInput(): string | undefined;
    private _portSpecification?;
    get portSpecification(): string;
    set portSpecification(value: string);
    resetPortSpecification(): void;
    get portSpecificationInput(): string | undefined;
}
export interface GoogleComputeHealthCheckHttp2HealthCheck {
    /**
    * The value of the host header in the HTTP2 health check request.
  If left empty (default value), the public IP on behalf of which this health
  check is performed will be used.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_health_check#host GoogleComputeHealthCheck#host}
    */
    readonly host?: string;
    /**
    * The TCP port number for the HTTP2 health check request.
  The default value is 443.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_health_check#port GoogleComputeHealthCheck#port}
    */
    readonly port?: number;
    /**
    * Port name as defined in InstanceGroup#NamedPort#name. If both port and
  port_name are defined, port takes precedence.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_health_check#port_name GoogleComputeHealthCheck#port_name}
    */
    readonly portName?: string;
    /**
    * Specifies how port is selected for health checking, can be one of the
  following values:
  
    * 'USE_FIXED_PORT': The port number in 'port' is used for health checking.
  
    * 'USE_NAMED_PORT': The 'portName' is used for health checking.
  
    * 'USE_SERVING_PORT': For NetworkEndpointGroup, the port specified for each
    network endpoint is used for health checking. For other backends, the
    port or named port specified in the Backend Service is used for health
    checking.
  
  If not specified, HTTP2 health check follows behavior specified in 'port' and
  'portName' fields. Possible values: ["USE_FIXED_PORT", "USE_NAMED_PORT", "USE_SERVING_PORT"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_health_check#port_specification GoogleComputeHealthCheck#port_specification}
    */
    readonly portSpecification?: string;
    /**
    * Specifies the type of proxy header to append before sending data to the
  backend. Default value: "NONE" Possible values: ["NONE", "PROXY_V1"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_health_check#proxy_header GoogleComputeHealthCheck#proxy_header}
    */
    readonly proxyHeader?: string;
    /**
    * The request path of the HTTP2 health check request.
  The default value is /.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_health_check#request_path GoogleComputeHealthCheck#request_path}
    */
    readonly requestPath?: string;
    /**
    * The bytes to match against the beginning of the response data. If left empty
  (the default value), any response will indicate health. The response data
  can only be ASCII.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_health_check#response GoogleComputeHealthCheck#response}
    */
    readonly response?: string;
}
export declare function googleComputeHealthCheckHttp2HealthCheckToTerraform(struct?: GoogleComputeHealthCheckHttp2HealthCheckOutputReference | GoogleComputeHealthCheckHttp2HealthCheck): any;
export declare class GoogleComputeHealthCheckHttp2HealthCheckOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeHealthCheckHttp2HealthCheck | undefined;
    set internalValue(value: GoogleComputeHealthCheckHttp2HealthCheck | undefined);
    private _host?;
    get host(): string;
    set host(value: string);
    resetHost(): void;
    get hostInput(): string | undefined;
    private _port?;
    get port(): number;
    set port(value: number);
    resetPort(): void;
    get portInput(): number | undefined;
    private _portName?;
    get portName(): string;
    set portName(value: string);
    resetPortName(): void;
    get portNameInput(): string | undefined;
    private _portSpecification?;
    get portSpecification(): string;
    set portSpecification(value: string);
    resetPortSpecification(): void;
    get portSpecificationInput(): string | undefined;
    private _proxyHeader?;
    get proxyHeader(): string;
    set proxyHeader(value: string);
    resetProxyHeader(): void;
    get proxyHeaderInput(): string | undefined;
    private _requestPath?;
    get requestPath(): string;
    set requestPath(value: string);
    resetRequestPath(): void;
    get requestPathInput(): string | undefined;
    private _response?;
    get response(): string;
    set response(value: string);
    resetResponse(): void;
    get responseInput(): string | undefined;
}
export interface GoogleComputeHealthCheckHttpHealthCheck {
    /**
    * The value of the host header in the HTTP health check request.
  If left empty (default value), the public IP on behalf of which this health
  check is performed will be used.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_health_check#host GoogleComputeHealthCheck#host}
    */
    readonly host?: string;
    /**
    * The TCP port number for the HTTP health check request.
  The default value is 80.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_health_check#port GoogleComputeHealthCheck#port}
    */
    readonly port?: number;
    /**
    * Port name as defined in InstanceGroup#NamedPort#name. If both port and
  port_name are defined, port takes precedence.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_health_check#port_name GoogleComputeHealthCheck#port_name}
    */
    readonly portName?: string;
    /**
    * Specifies how port is selected for health checking, can be one of the
  following values:
  
    * 'USE_FIXED_PORT': The port number in 'port' is used for health checking.
  
    * 'USE_NAMED_PORT': The 'portName' is used for health checking.
  
    * 'USE_SERVING_PORT': For NetworkEndpointGroup, the port specified for each
    network endpoint is used for health checking. For other backends, the
    port or named port specified in the Backend Service is used for health
    checking.
  
  If not specified, HTTP health check follows behavior specified in 'port' and
  'portName' fields. Possible values: ["USE_FIXED_PORT", "USE_NAMED_PORT", "USE_SERVING_PORT"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_health_check#port_specification GoogleComputeHealthCheck#port_specification}
    */
    readonly portSpecification?: string;
    /**
    * Specifies the type of proxy header to append before sending data to the
  backend. Default value: "NONE" Possible values: ["NONE", "PROXY_V1"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_health_check#proxy_header GoogleComputeHealthCheck#proxy_header}
    */
    readonly proxyHeader?: string;
    /**
    * The request path of the HTTP health check request.
  The default value is /.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_health_check#request_path GoogleComputeHealthCheck#request_path}
    */
    readonly requestPath?: string;
    /**
    * The bytes to match against the beginning of the response data. If left empty
  (the default value), any response will indicate health. The response data
  can only be ASCII.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_health_check#response GoogleComputeHealthCheck#response}
    */
    readonly response?: string;
}
export declare function googleComputeHealthCheckHttpHealthCheckToTerraform(struct?: GoogleComputeHealthCheckHttpHealthCheckOutputReference | GoogleComputeHealthCheckHttpHealthCheck): any;
export declare class GoogleComputeHealthCheckHttpHealthCheckOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeHealthCheckHttpHealthCheck | undefined;
    set internalValue(value: GoogleComputeHealthCheckHttpHealthCheck | undefined);
    private _host?;
    get host(): string;
    set host(value: string);
    resetHost(): void;
    get hostInput(): string | undefined;
    private _port?;
    get port(): number;
    set port(value: number);
    resetPort(): void;
    get portInput(): number | undefined;
    private _portName?;
    get portName(): string;
    set portName(value: string);
    resetPortName(): void;
    get portNameInput(): string | undefined;
    private _portSpecification?;
    get portSpecification(): string;
    set portSpecification(value: string);
    resetPortSpecification(): void;
    get portSpecificationInput(): string | undefined;
    private _proxyHeader?;
    get proxyHeader(): string;
    set proxyHeader(value: string);
    resetProxyHeader(): void;
    get proxyHeaderInput(): string | undefined;
    private _requestPath?;
    get requestPath(): string;
    set requestPath(value: string);
    resetRequestPath(): void;
    get requestPathInput(): string | undefined;
    private _response?;
    get response(): string;
    set response(value: string);
    resetResponse(): void;
    get responseInput(): string | undefined;
}
export interface GoogleComputeHealthCheckHttpsHealthCheck {
    /**
    * The value of the host header in the HTTPS health check request.
  If left empty (default value), the public IP on behalf of which this health
  check is performed will be used.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_health_check#host GoogleComputeHealthCheck#host}
    */
    readonly host?: string;
    /**
    * The TCP port number for the HTTPS health check request.
  The default value is 443.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_health_check#port GoogleComputeHealthCheck#port}
    */
    readonly port?: number;
    /**
    * Port name as defined in InstanceGroup#NamedPort#name. If both port and
  port_name are defined, port takes precedence.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_health_check#port_name GoogleComputeHealthCheck#port_name}
    */
    readonly portName?: string;
    /**
    * Specifies how port is selected for health checking, can be one of the
  following values:
  
    * 'USE_FIXED_PORT': The port number in 'port' is used for health checking.
  
    * 'USE_NAMED_PORT': The 'portName' is used for health checking.
  
    * 'USE_SERVING_PORT': For NetworkEndpointGroup, the port specified for each
    network endpoint is used for health checking. For other backends, the
    port or named port specified in the Backend Service is used for health
    checking.
  
  If not specified, HTTPS health check follows behavior specified in 'port' and
  'portName' fields. Possible values: ["USE_FIXED_PORT", "USE_NAMED_PORT", "USE_SERVING_PORT"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_health_check#port_specification GoogleComputeHealthCheck#port_specification}
    */
    readonly portSpecification?: string;
    /**
    * Specifies the type of proxy header to append before sending data to the
  backend. Default value: "NONE" Possible values: ["NONE", "PROXY_V1"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_health_check#proxy_header GoogleComputeHealthCheck#proxy_header}
    */
    readonly proxyHeader?: string;
    /**
    * The request path of the HTTPS health check request.
  The default value is /.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_health_check#request_path GoogleComputeHealthCheck#request_path}
    */
    readonly requestPath?: string;
    /**
    * The bytes to match against the beginning of the response data. If left empty
  (the default value), any response will indicate health. The response data
  can only be ASCII.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_health_check#response GoogleComputeHealthCheck#response}
    */
    readonly response?: string;
}
export declare function googleComputeHealthCheckHttpsHealthCheckToTerraform(struct?: GoogleComputeHealthCheckHttpsHealthCheckOutputReference | GoogleComputeHealthCheckHttpsHealthCheck): any;
export declare class GoogleComputeHealthCheckHttpsHealthCheckOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeHealthCheckHttpsHealthCheck | undefined;
    set internalValue(value: GoogleComputeHealthCheckHttpsHealthCheck | undefined);
    private _host?;
    get host(): string;
    set host(value: string);
    resetHost(): void;
    get hostInput(): string | undefined;
    private _port?;
    get port(): number;
    set port(value: number);
    resetPort(): void;
    get portInput(): number | undefined;
    private _portName?;
    get portName(): string;
    set portName(value: string);
    resetPortName(): void;
    get portNameInput(): string | undefined;
    private _portSpecification?;
    get portSpecification(): string;
    set portSpecification(value: string);
    resetPortSpecification(): void;
    get portSpecificationInput(): string | undefined;
    private _proxyHeader?;
    get proxyHeader(): string;
    set proxyHeader(value: string);
    resetProxyHeader(): void;
    get proxyHeaderInput(): string | undefined;
    private _requestPath?;
    get requestPath(): string;
    set requestPath(value: string);
    resetRequestPath(): void;
    get requestPathInput(): string | undefined;
    private _response?;
    get response(): string;
    set response(value: string);
    resetResponse(): void;
    get responseInput(): string | undefined;
}
export interface GoogleComputeHealthCheckLogConfig {
    /**
    * Indicates whether or not to export logs. This is false by default,
  which means no health check logging will be done.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_health_check#enable GoogleComputeHealthCheck#enable}
    */
    readonly enable?: boolean | cdktf.IResolvable;
}
export declare function googleComputeHealthCheckLogConfigToTerraform(struct?: GoogleComputeHealthCheckLogConfigOutputReference | GoogleComputeHealthCheckLogConfig): any;
export declare class GoogleComputeHealthCheckLogConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeHealthCheckLogConfig | undefined;
    set internalValue(value: GoogleComputeHealthCheckLogConfig | undefined);
    private _enable?;
    get enable(): boolean | cdktf.IResolvable;
    set enable(value: boolean | cdktf.IResolvable);
    resetEnable(): void;
    get enableInput(): boolean | cdktf.IResolvable | undefined;
}
export interface GoogleComputeHealthCheckSslHealthCheck {
    /**
    * The TCP port number for the SSL health check request.
  The default value is 443.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_health_check#port GoogleComputeHealthCheck#port}
    */
    readonly port?: number;
    /**
    * Port name as defined in InstanceGroup#NamedPort#name. If both port and
  port_name are defined, port takes precedence.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_health_check#port_name GoogleComputeHealthCheck#port_name}
    */
    readonly portName?: string;
    /**
    * Specifies how port is selected for health checking, can be one of the
  following values:
  
    * 'USE_FIXED_PORT': The port number in 'port' is used for health checking.
  
    * 'USE_NAMED_PORT': The 'portName' is used for health checking.
  
    * 'USE_SERVING_PORT': For NetworkEndpointGroup, the port specified for each
    network endpoint is used for health checking. For other backends, the
    port or named port specified in the Backend Service is used for health
    checking.
  
  If not specified, SSL health check follows behavior specified in 'port' and
  'portName' fields. Possible values: ["USE_FIXED_PORT", "USE_NAMED_PORT", "USE_SERVING_PORT"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_health_check#port_specification GoogleComputeHealthCheck#port_specification}
    */
    readonly portSpecification?: string;
    /**
    * Specifies the type of proxy header to append before sending data to the
  backend. Default value: "NONE" Possible values: ["NONE", "PROXY_V1"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_health_check#proxy_header GoogleComputeHealthCheck#proxy_header}
    */
    readonly proxyHeader?: string;
    /**
    * The application data to send once the SSL connection has been
  established (default value is empty). If both request and response are
  empty, the connection establishment alone will indicate health. The request
  data can only be ASCII.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_health_check#request GoogleComputeHealthCheck#request}
    */
    readonly request?: string;
    /**
    * The bytes to match against the beginning of the response data. If left empty
  (the default value), any response will indicate health. The response data
  can only be ASCII.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_health_check#response GoogleComputeHealthCheck#response}
    */
    readonly response?: string;
}
export declare function googleComputeHealthCheckSslHealthCheckToTerraform(struct?: GoogleComputeHealthCheckSslHealthCheckOutputReference | GoogleComputeHealthCheckSslHealthCheck): any;
export declare class GoogleComputeHealthCheckSslHealthCheckOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeHealthCheckSslHealthCheck | undefined;
    set internalValue(value: GoogleComputeHealthCheckSslHealthCheck | undefined);
    private _port?;
    get port(): number;
    set port(value: number);
    resetPort(): void;
    get portInput(): number | undefined;
    private _portName?;
    get portName(): string;
    set portName(value: string);
    resetPortName(): void;
    get portNameInput(): string | undefined;
    private _portSpecification?;
    get portSpecification(): string;
    set portSpecification(value: string);
    resetPortSpecification(): void;
    get portSpecificationInput(): string | undefined;
    private _proxyHeader?;
    get proxyHeader(): string;
    set proxyHeader(value: string);
    resetProxyHeader(): void;
    get proxyHeaderInput(): string | undefined;
    private _request?;
    get request(): string;
    set request(value: string);
    resetRequest(): void;
    get requestInput(): string | undefined;
    private _response?;
    get response(): string;
    set response(value: string);
    resetResponse(): void;
    get responseInput(): string | undefined;
}
export interface GoogleComputeHealthCheckTcpHealthCheck {
    /**
    * The TCP port number for the TCP health check request.
  The default value is 443.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_health_check#port GoogleComputeHealthCheck#port}
    */
    readonly port?: number;
    /**
    * Port name as defined in InstanceGroup#NamedPort#name. If both port and
  port_name are defined, port takes precedence.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_health_check#port_name GoogleComputeHealthCheck#port_name}
    */
    readonly portName?: string;
    /**
    * Specifies how port is selected for health checking, can be one of the
  following values:
  
    * 'USE_FIXED_PORT': The port number in 'port' is used for health checking.
  
    * 'USE_NAMED_PORT': The 'portName' is used for health checking.
  
    * 'USE_SERVING_PORT': For NetworkEndpointGroup, the port specified for each
    network endpoint is used for health checking. For other backends, the
    port or named port specified in the Backend Service is used for health
    checking.
  
  If not specified, TCP health check follows behavior specified in 'port' and
  'portName' fields. Possible values: ["USE_FIXED_PORT", "USE_NAMED_PORT", "USE_SERVING_PORT"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_health_check#port_specification GoogleComputeHealthCheck#port_specification}
    */
    readonly portSpecification?: string;
    /**
    * Specifies the type of proxy header to append before sending data to the
  backend. Default value: "NONE" Possible values: ["NONE", "PROXY_V1"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_health_check#proxy_header GoogleComputeHealthCheck#proxy_header}
    */
    readonly proxyHeader?: string;
    /**
    * The application data to send once the TCP connection has been
  established (default value is empty). If both request and response are
  empty, the connection establishment alone will indicate health. The request
  data can only be ASCII.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_health_check#request GoogleComputeHealthCheck#request}
    */
    readonly request?: string;
    /**
    * The bytes to match against the beginning of the response data. If left empty
  (the default value), any response will indicate health. The response data
  can only be ASCII.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_health_check#response GoogleComputeHealthCheck#response}
    */
    readonly response?: string;
}
export declare function googleComputeHealthCheckTcpHealthCheckToTerraform(struct?: GoogleComputeHealthCheckTcpHealthCheckOutputReference | GoogleComputeHealthCheckTcpHealthCheck): any;
export declare class GoogleComputeHealthCheckTcpHealthCheckOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeHealthCheckTcpHealthCheck | undefined;
    set internalValue(value: GoogleComputeHealthCheckTcpHealthCheck | undefined);
    private _port?;
    get port(): number;
    set port(value: number);
    resetPort(): void;
    get portInput(): number | undefined;
    private _portName?;
    get portName(): string;
    set portName(value: string);
    resetPortName(): void;
    get portNameInput(): string | undefined;
    private _portSpecification?;
    get portSpecification(): string;
    set portSpecification(value: string);
    resetPortSpecification(): void;
    get portSpecificationInput(): string | undefined;
    private _proxyHeader?;
    get proxyHeader(): string;
    set proxyHeader(value: string);
    resetProxyHeader(): void;
    get proxyHeaderInput(): string | undefined;
    private _request?;
    get request(): string;
    set request(value: string);
    resetRequest(): void;
    get requestInput(): string | undefined;
    private _response?;
    get response(): string;
    set response(value: string);
    resetResponse(): void;
    get responseInput(): string | undefined;
}
export interface GoogleComputeHealthCheckTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_health_check#create GoogleComputeHealthCheck#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_health_check#delete GoogleComputeHealthCheck#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_health_check#update GoogleComputeHealthCheck#update}
    */
    readonly update?: string;
}
export declare function googleComputeHealthCheckTimeoutsToTerraform(struct?: GoogleComputeHealthCheckTimeoutsOutputReference | GoogleComputeHealthCheckTimeouts | cdktf.IResolvable): any;
export declare class GoogleComputeHealthCheckTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeHealthCheckTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleComputeHealthCheckTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_health_check google_compute_health_check}
*/
export declare class GoogleComputeHealthCheck extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_compute_health_check";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_health_check google_compute_health_check} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleComputeHealthCheckConfig
    */
    constructor(scope: Construct, id: string, config: GoogleComputeHealthCheckConfig);
    private _checkIntervalSec?;
    get checkIntervalSec(): number;
    set checkIntervalSec(value: number);
    resetCheckIntervalSec(): void;
    get checkIntervalSecInput(): number | undefined;
    get creationTimestamp(): string;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _healthyThreshold?;
    get healthyThreshold(): number;
    set healthyThreshold(value: number);
    resetHealthyThreshold(): void;
    get healthyThresholdInput(): number | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    get selfLink(): string;
    private _timeoutSec?;
    get timeoutSec(): number;
    set timeoutSec(value: number);
    resetTimeoutSec(): void;
    get timeoutSecInput(): number | undefined;
    get type(): string;
    private _unhealthyThreshold?;
    get unhealthyThreshold(): number;
    set unhealthyThreshold(value: number);
    resetUnhealthyThreshold(): void;
    get unhealthyThresholdInput(): number | undefined;
    private _grpcHealthCheck;
    get grpcHealthCheck(): GoogleComputeHealthCheckGrpcHealthCheckOutputReference;
    putGrpcHealthCheck(value: GoogleComputeHealthCheckGrpcHealthCheck): void;
    resetGrpcHealthCheck(): void;
    get grpcHealthCheckInput(): GoogleComputeHealthCheckGrpcHealthCheck | undefined;
    private _http2HealthCheck;
    get http2HealthCheck(): GoogleComputeHealthCheckHttp2HealthCheckOutputReference;
    putHttp2HealthCheck(value: GoogleComputeHealthCheckHttp2HealthCheck): void;
    resetHttp2HealthCheck(): void;
    get http2HealthCheckInput(): GoogleComputeHealthCheckHttp2HealthCheck | undefined;
    private _httpHealthCheck;
    get httpHealthCheck(): GoogleComputeHealthCheckHttpHealthCheckOutputReference;
    putHttpHealthCheck(value: GoogleComputeHealthCheckHttpHealthCheck): void;
    resetHttpHealthCheck(): void;
    get httpHealthCheckInput(): GoogleComputeHealthCheckHttpHealthCheck | undefined;
    private _httpsHealthCheck;
    get httpsHealthCheck(): GoogleComputeHealthCheckHttpsHealthCheckOutputReference;
    putHttpsHealthCheck(value: GoogleComputeHealthCheckHttpsHealthCheck): void;
    resetHttpsHealthCheck(): void;
    get httpsHealthCheckInput(): GoogleComputeHealthCheckHttpsHealthCheck | undefined;
    private _logConfig;
    get logConfig(): GoogleComputeHealthCheckLogConfigOutputReference;
    putLogConfig(value: GoogleComputeHealthCheckLogConfig): void;
    resetLogConfig(): void;
    get logConfigInput(): GoogleComputeHealthCheckLogConfig | undefined;
    private _sslHealthCheck;
    get sslHealthCheck(): GoogleComputeHealthCheckSslHealthCheckOutputReference;
    putSslHealthCheck(value: GoogleComputeHealthCheckSslHealthCheck): void;
    resetSslHealthCheck(): void;
    get sslHealthCheckInput(): GoogleComputeHealthCheckSslHealthCheck | undefined;
    private _tcpHealthCheck;
    get tcpHealthCheck(): GoogleComputeHealthCheckTcpHealthCheckOutputReference;
    putTcpHealthCheck(value: GoogleComputeHealthCheckTcpHealthCheck): void;
    resetTcpHealthCheck(): void;
    get tcpHealthCheckInput(): GoogleComputeHealthCheckTcpHealthCheck | undefined;
    private _timeouts;
    get timeouts(): GoogleComputeHealthCheckTimeoutsOutputReference;
    putTimeouts(value: GoogleComputeHealthCheckTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleComputeHealthCheckTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
