import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleComputeImageConfig extends cdktf.TerraformMetaArguments {
    /**
    * An optional description of this resource. Provide this property when
  you create the resource.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_image#description GoogleComputeImage#description}
    */
    readonly description?: string;
    /**
    * Size of the image when restored onto a persistent disk (in GB).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_image#disk_size_gb GoogleComputeImage#disk_size_gb}
    */
    readonly diskSizeGb?: number;
    /**
    * The name of the image family to which this image belongs. You can
  create disks by specifying an image family instead of a specific
  image name. The image family always returns its latest image that is
  not deprecated. The name of the image family must comply with
  RFC1035.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_image#family GoogleComputeImage#family}
    */
    readonly family?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_image#id GoogleComputeImage#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Labels to apply to this Image.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_image#labels GoogleComputeImage#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * Any applicable license URI.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_image#licenses GoogleComputeImage#licenses}
    */
    readonly licenses?: string[];
    /**
    * Name of the resource; provided by the client when the resource is
  created. The name must be 1-63 characters long, and comply with
  RFC1035. Specifically, the name must be 1-63 characters long and
  match the regular expression '[a-z]([-a-z0-9]*[a-z0-9])?' which means
  the first character must be a lowercase letter, and all following
  characters must be a dash, lowercase letter, or digit, except the
  last character, which cannot be a dash.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_image#name GoogleComputeImage#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_image#project GoogleComputeImage#project}
    */
    readonly project?: string;
    /**
    * The source disk to create this image based on.
  You must provide either this property or the
  rawDisk.source property but not both to create an image.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_image#source_disk GoogleComputeImage#source_disk}
    */
    readonly sourceDisk?: string;
    /**
    * URL of the source image used to create this image. In order to create an image, you must provide the full or partial
  URL of one of the following:
  
  * The selfLink URL
  * This property
  * The rawDisk.source URL
  * The sourceDisk URL
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_image#source_image GoogleComputeImage#source_image}
    */
    readonly sourceImage?: string;
    /**
    * URL of the source snapshot used to create this image.
  
  In order to create an image, you must provide the full or partial URL of one of the following:
  
  * The selfLink URL
  * This property
  * The sourceImage URL
  * The rawDisk.source URL
  * The sourceDisk URL
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_image#source_snapshot GoogleComputeImage#source_snapshot}
    */
    readonly sourceSnapshot?: string;
    /**
    * guest_os_features block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_image#guest_os_features GoogleComputeImage#guest_os_features}
    */
    readonly guestOsFeatures?: GoogleComputeImageGuestOsFeatures[] | cdktf.IResolvable;
    /**
    * raw_disk block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_image#raw_disk GoogleComputeImage#raw_disk}
    */
    readonly rawDisk?: GoogleComputeImageRawDisk;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_image#timeouts GoogleComputeImage#timeouts}
    */
    readonly timeouts?: GoogleComputeImageTimeouts;
}
export interface GoogleComputeImageGuestOsFeatures {
    /**
    * The type of supported feature. Read [Enabling guest operating system features](https://cloud.google.com/compute/docs/images/create-delete-deprecate-private-images#guest-os-features) to see a list of available options. Possible values: ["MULTI_IP_SUBNET", "SECURE_BOOT", "SEV_CAPABLE", "UEFI_COMPATIBLE", "VIRTIO_SCSI_MULTIQUEUE", "WINDOWS", "GVNIC"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_image#type GoogleComputeImage#type}
    */
    readonly type: string;
}
export declare function googleComputeImageGuestOsFeaturesToTerraform(struct?: GoogleComputeImageGuestOsFeatures | cdktf.IResolvable): any;
export declare class GoogleComputeImageGuestOsFeaturesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleComputeImageGuestOsFeatures | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleComputeImageGuestOsFeatures | cdktf.IResolvable | undefined);
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export declare class GoogleComputeImageGuestOsFeaturesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleComputeImageGuestOsFeatures[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleComputeImageGuestOsFeaturesOutputReference;
}
export interface GoogleComputeImageRawDisk {
    /**
    * The format used to encode and transmit the block device, which
  should be TAR. This is just a container and transmission format
  and not a runtime format. Provided by the client when the disk
  image is created. Default value: "TAR" Possible values: ["TAR"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_image#container_type GoogleComputeImage#container_type}
    */
    readonly containerType?: string;
    /**
    * An optional SHA1 checksum of the disk image before unpackaging.
  This is provided by the client when the disk image is created.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_image#sha1 GoogleComputeImage#sha1}
    */
    readonly sha1?: string;
    /**
    * The full Google Cloud Storage URL where disk storage is stored
  You must provide either this property or the sourceDisk property
  but not both.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_image#source GoogleComputeImage#source}
    */
    readonly source: string;
}
export declare function googleComputeImageRawDiskToTerraform(struct?: GoogleComputeImageRawDiskOutputReference | GoogleComputeImageRawDisk): any;
export declare class GoogleComputeImageRawDiskOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeImageRawDisk | undefined;
    set internalValue(value: GoogleComputeImageRawDisk | undefined);
    private _containerType?;
    get containerType(): string;
    set containerType(value: string);
    resetContainerType(): void;
    get containerTypeInput(): string | undefined;
    private _sha1?;
    get sha1(): string;
    set sha1(value: string);
    resetSha1(): void;
    get sha1Input(): string | undefined;
    private _source?;
    get source(): string;
    set source(value: string);
    get sourceInput(): string | undefined;
}
export interface GoogleComputeImageTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_image#create GoogleComputeImage#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_image#delete GoogleComputeImage#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_image#update GoogleComputeImage#update}
    */
    readonly update?: string;
}
export declare function googleComputeImageTimeoutsToTerraform(struct?: GoogleComputeImageTimeoutsOutputReference | GoogleComputeImageTimeouts | cdktf.IResolvable): any;
export declare class GoogleComputeImageTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeImageTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleComputeImageTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_image google_compute_image}
*/
export declare class GoogleComputeImage extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_compute_image";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_image google_compute_image} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleComputeImageConfig
    */
    constructor(scope: Construct, id: string, config: GoogleComputeImageConfig);
    get archiveSizeBytes(): number;
    get creationTimestamp(): string;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _diskSizeGb?;
    get diskSizeGb(): number;
    set diskSizeGb(value: number);
    resetDiskSizeGb(): void;
    get diskSizeGbInput(): number | undefined;
    private _family?;
    get family(): string;
    set family(value: string);
    resetFamily(): void;
    get familyInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get labelFingerprint(): string;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _licenses?;
    get licenses(): string[];
    set licenses(value: string[]);
    resetLicenses(): void;
    get licensesInput(): string[] | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    get selfLink(): string;
    private _sourceDisk?;
    get sourceDisk(): string;
    set sourceDisk(value: string);
    resetSourceDisk(): void;
    get sourceDiskInput(): string | undefined;
    private _sourceImage?;
    get sourceImage(): string;
    set sourceImage(value: string);
    resetSourceImage(): void;
    get sourceImageInput(): string | undefined;
    private _sourceSnapshot?;
    get sourceSnapshot(): string;
    set sourceSnapshot(value: string);
    resetSourceSnapshot(): void;
    get sourceSnapshotInput(): string | undefined;
    private _guestOsFeatures;
    get guestOsFeatures(): GoogleComputeImageGuestOsFeaturesList;
    putGuestOsFeatures(value: GoogleComputeImageGuestOsFeatures[] | cdktf.IResolvable): void;
    resetGuestOsFeatures(): void;
    get guestOsFeaturesInput(): cdktf.IResolvable | GoogleComputeImageGuestOsFeatures[] | undefined;
    private _rawDisk;
    get rawDisk(): GoogleComputeImageRawDiskOutputReference;
    putRawDisk(value: GoogleComputeImageRawDisk): void;
    resetRawDisk(): void;
    get rawDiskInput(): GoogleComputeImageRawDisk | undefined;
    private _timeouts;
    get timeouts(): GoogleComputeImageTimeoutsOutputReference;
    putTimeouts(value: GoogleComputeImageTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleComputeImageTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
