import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleComputeInstanceGroupNamedPortAConfig extends cdktf.TerraformMetaArguments {
    /**
    * The name of the instance group.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_instance_group_named_port#group GoogleComputeInstanceGroupNamedPortA#group}
    */
    readonly group: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_instance_group_named_port#id GoogleComputeInstanceGroupNamedPortA#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The name for this named port. The name must be 1-63 characters
  long, and comply with RFC1035.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_instance_group_named_port#name GoogleComputeInstanceGroupNamedPortA#name}
    */
    readonly name: string;
    /**
    * The port number, which can be a value between 1 and 65535.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_instance_group_named_port#port GoogleComputeInstanceGroupNamedPortA#port}
    */
    readonly port: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_instance_group_named_port#project GoogleComputeInstanceGroupNamedPortA#project}
    */
    readonly project?: string;
    /**
    * The zone of the instance group.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_instance_group_named_port#zone GoogleComputeInstanceGroupNamedPortA#zone}
    */
    readonly zone?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_instance_group_named_port#timeouts GoogleComputeInstanceGroupNamedPortA#timeouts}
    */
    readonly timeouts?: GoogleComputeInstanceGroupNamedPortTimeouts;
}
export interface GoogleComputeInstanceGroupNamedPortTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_instance_group_named_port#create GoogleComputeInstanceGroupNamedPortA#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_instance_group_named_port#delete GoogleComputeInstanceGroupNamedPortA#delete}
    */
    readonly delete?: string;
}
export declare function googleComputeInstanceGroupNamedPortTimeoutsToTerraform(struct?: GoogleComputeInstanceGroupNamedPortTimeoutsOutputReference | GoogleComputeInstanceGroupNamedPortTimeouts | cdktf.IResolvable): any;
export declare class GoogleComputeInstanceGroupNamedPortTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeInstanceGroupNamedPortTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleComputeInstanceGroupNamedPortTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_instance_group_named_port google_compute_instance_group_named_port}
*/
export declare class GoogleComputeInstanceGroupNamedPortA extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_compute_instance_group_named_port";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_instance_group_named_port google_compute_instance_group_named_port} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleComputeInstanceGroupNamedPortAConfig
    */
    constructor(scope: Construct, id: string, config: GoogleComputeInstanceGroupNamedPortAConfig);
    private _group?;
    get group(): string;
    set group(value: string);
    get groupInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _port?;
    get port(): number;
    set port(value: number);
    get portInput(): number | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _zone?;
    get zone(): string;
    set zone(value: string);
    resetZone(): void;
    get zoneInput(): string | undefined;
    private _timeouts;
    get timeouts(): GoogleComputeInstanceGroupNamedPortTimeoutsOutputReference;
    putTimeouts(value: GoogleComputeInstanceGroupNamedPortTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleComputeInstanceGroupNamedPortTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
