"use strict";
var _a, _b, _c, _d;
Object.defineProperty(exports, "__esModule", { value: true });
exports.GoogleComputeInterconnectAttachment = exports.GoogleComputeInterconnectAttachmentTimeoutsOutputReference = exports.googleComputeInterconnectAttachmentTimeoutsToTerraform = exports.GoogleComputeInterconnectAttachmentPrivateInterconnectInfoList = exports.GoogleComputeInterconnectAttachmentPrivateInterconnectInfoOutputReference = exports.googleComputeInterconnectAttachmentPrivateInterconnectInfoToTerraform = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
function googleComputeInterconnectAttachmentPrivateInterconnectInfoToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {};
}
exports.googleComputeInterconnectAttachmentPrivateInterconnectInfoToTerraform = googleComputeInterconnectAttachmentPrivateInterconnectInfoToTerraform;
class GoogleComputeInterconnectAttachmentPrivateInterconnectInfoOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource, terraformAttribute, complexObjectIndex, complexObjectIsFromSet) {
        super(terraformResource, terraformAttribute, complexObjectIsFromSet, complexObjectIndex);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
        }
    }
    // tag8021q - computed: true, optional: false, required: false
    get tag8021Q() {
        return this.getNumberAttribute('tag8021q');
    }
}
exports.GoogleComputeInterconnectAttachmentPrivateInterconnectInfoOutputReference = GoogleComputeInterconnectAttachmentPrivateInterconnectInfoOutputReference;
_a = JSII_RTTI_SYMBOL_1;
GoogleComputeInterconnectAttachmentPrivateInterconnectInfoOutputReference[_a] = { fqn: "@cdktf/provider-google-beta.googleComputeInterconnectAttachment.GoogleComputeInterconnectAttachmentPrivateInterconnectInfoOutputReference", version: "3.0.1" };
class GoogleComputeInterconnectAttachmentPrivateInterconnectInfoList extends cdktf.ComplexList {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource, terraformAttribute, wrapsSet) {
        super(terraformResource, terraformAttribute, wrapsSet);
        this.terraformResource = terraformResource;
        this.terraformAttribute = terraformAttribute;
        this.wrapsSet = wrapsSet;
    }
    /**
    * @param index the index of the item to return
    */
    get(index) {
        return new GoogleComputeInterconnectAttachmentPrivateInterconnectInfoOutputReference(this.terraformResource, this.terraformAttribute, index, this.wrapsSet);
    }
}
exports.GoogleComputeInterconnectAttachmentPrivateInterconnectInfoList = GoogleComputeInterconnectAttachmentPrivateInterconnectInfoList;
_b = JSII_RTTI_SYMBOL_1;
GoogleComputeInterconnectAttachmentPrivateInterconnectInfoList[_b] = { fqn: "@cdktf/provider-google-beta.googleComputeInterconnectAttachment.GoogleComputeInterconnectAttachmentPrivateInterconnectInfoList", version: "3.0.1" };
function googleComputeInterconnectAttachmentTimeoutsToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        create: cdktf.stringToTerraform(struct.create),
        delete: cdktf.stringToTerraform(struct.delete),
        update: cdktf.stringToTerraform(struct.update),
    };
}
exports.googleComputeInterconnectAttachmentTimeoutsToTerraform = googleComputeInterconnectAttachmentTimeoutsToTerraform;
class GoogleComputeInterconnectAttachmentTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
    }
    get internalValue() {
        if (this.resolvableValue) {
            return this.resolvableValue;
        }
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._create !== undefined) {
            hasAnyValues = true;
            internalValueResult.create = this._create;
        }
        if (this._delete !== undefined) {
            hasAnyValues = true;
            internalValueResult.delete = this._delete;
        }
        if (this._update !== undefined) {
            hasAnyValues = true;
            internalValueResult.update = this._update;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this.resolvableValue = undefined;
            this._create = undefined;
            this._delete = undefined;
            this._update = undefined;
        }
        else if (cdktf.Tokenization.isResolvable(value)) {
            this.isEmptyObject = false;
            this.resolvableValue = value;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this.resolvableValue = undefined;
            this._create = value.create;
            this._delete = value.delete;
            this._update = value.update;
        }
    }
    get create() {
        return this.getStringAttribute('create');
    }
    set create(value) {
        this._create = value;
    }
    resetCreate() {
        this._create = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get createInput() {
        return this._create;
    }
    get delete() {
        return this.getStringAttribute('delete');
    }
    set delete(value) {
        this._delete = value;
    }
    resetDelete() {
        this._delete = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get deleteInput() {
        return this._delete;
    }
    get update() {
        return this.getStringAttribute('update');
    }
    set update(value) {
        this._update = value;
    }
    resetUpdate() {
        this._update = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get updateInput() {
        return this._update;
    }
}
exports.GoogleComputeInterconnectAttachmentTimeoutsOutputReference = GoogleComputeInterconnectAttachmentTimeoutsOutputReference;
_c = JSII_RTTI_SYMBOL_1;
GoogleComputeInterconnectAttachmentTimeoutsOutputReference[_c] = { fqn: "@cdktf/provider-google-beta.googleComputeInterconnectAttachment.GoogleComputeInterconnectAttachmentTimeoutsOutputReference", version: "3.0.1" };
/**
* Represents a {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_interconnect_attachment google_compute_interconnect_attachment}
*/
class GoogleComputeInterconnectAttachment extends cdktf.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_interconnect_attachment google_compute_interconnect_attachment} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleComputeInterconnectAttachmentConfig
    */
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'google_compute_interconnect_attachment',
            terraformGeneratorMetadata: {
                providerName: 'google-beta',
                providerVersion: '4.38.0',
                providerVersionConstraint: '~> 4.17'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle,
            provisioners: config.provisioners,
            connection: config.connection,
            forEach: config.forEach
        });
        // private_interconnect_info - computed: true, optional: false, required: false
        this._privateInterconnectInfo = new GoogleComputeInterconnectAttachmentPrivateInterconnectInfoList(this, "private_interconnect_info", false);
        // timeouts - computed: false, optional: true, required: false
        this._timeouts = new GoogleComputeInterconnectAttachmentTimeoutsOutputReference(this, "timeouts");
        this._adminEnabled = config.adminEnabled;
        this._bandwidth = config.bandwidth;
        this._candidateSubnets = config.candidateSubnets;
        this._description = config.description;
        this._edgeAvailabilityDomain = config.edgeAvailabilityDomain;
        this._encryption = config.encryption;
        this._id = config.id;
        this._interconnect = config.interconnect;
        this._ipsecInternalAddresses = config.ipsecInternalAddresses;
        this._mtu = config.mtu;
        this._name = config.name;
        this._project = config.project;
        this._region = config.region;
        this._router = config.router;
        this._type = config.type;
        this._vlanTag8021Q = config.vlanTag8021Q;
        this._timeouts.internalValue = config.timeouts;
    }
    get adminEnabled() {
        return this.getBooleanAttribute('admin_enabled');
    }
    set adminEnabled(value) {
        this._adminEnabled = value;
    }
    resetAdminEnabled() {
        this._adminEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get adminEnabledInput() {
        return this._adminEnabled;
    }
    get bandwidth() {
        return this.getStringAttribute('bandwidth');
    }
    set bandwidth(value) {
        this._bandwidth = value;
    }
    resetBandwidth() {
        this._bandwidth = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get bandwidthInput() {
        return this._bandwidth;
    }
    get candidateSubnets() {
        return this.getListAttribute('candidate_subnets');
    }
    set candidateSubnets(value) {
        this._candidateSubnets = value;
    }
    resetCandidateSubnets() {
        this._candidateSubnets = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get candidateSubnetsInput() {
        return this._candidateSubnets;
    }
    // cloud_router_ip_address - computed: true, optional: false, required: false
    get cloudRouterIpAddress() {
        return this.getStringAttribute('cloud_router_ip_address');
    }
    // creation_timestamp - computed: true, optional: false, required: false
    get creationTimestamp() {
        return this.getStringAttribute('creation_timestamp');
    }
    // customer_router_ip_address - computed: true, optional: false, required: false
    get customerRouterIpAddress() {
        return this.getStringAttribute('customer_router_ip_address');
    }
    get description() {
        return this.getStringAttribute('description');
    }
    set description(value) {
        this._description = value;
    }
    resetDescription() {
        this._description = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get descriptionInput() {
        return this._description;
    }
    get edgeAvailabilityDomain() {
        return this.getStringAttribute('edge_availability_domain');
    }
    set edgeAvailabilityDomain(value) {
        this._edgeAvailabilityDomain = value;
    }
    resetEdgeAvailabilityDomain() {
        this._edgeAvailabilityDomain = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get edgeAvailabilityDomainInput() {
        return this._edgeAvailabilityDomain;
    }
    get encryption() {
        return this.getStringAttribute('encryption');
    }
    set encryption(value) {
        this._encryption = value;
    }
    resetEncryption() {
        this._encryption = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get encryptionInput() {
        return this._encryption;
    }
    // google_reference_id - computed: true, optional: false, required: false
    get googleReferenceId() {
        return this.getStringAttribute('google_reference_id');
    }
    get id() {
        return this.getStringAttribute('id');
    }
    set id(value) {
        this._id = value;
    }
    resetId() {
        this._id = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get idInput() {
        return this._id;
    }
    get interconnect() {
        return this.getStringAttribute('interconnect');
    }
    set interconnect(value) {
        this._interconnect = value;
    }
    resetInterconnect() {
        this._interconnect = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get interconnectInput() {
        return this._interconnect;
    }
    get ipsecInternalAddresses() {
        return this.getListAttribute('ipsec_internal_addresses');
    }
    set ipsecInternalAddresses(value) {
        this._ipsecInternalAddresses = value;
    }
    resetIpsecInternalAddresses() {
        this._ipsecInternalAddresses = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get ipsecInternalAddressesInput() {
        return this._ipsecInternalAddresses;
    }
    get mtu() {
        return this.getStringAttribute('mtu');
    }
    set mtu(value) {
        this._mtu = value;
    }
    resetMtu() {
        this._mtu = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get mtuInput() {
        return this._mtu;
    }
    get name() {
        return this.getStringAttribute('name');
    }
    set name(value) {
        this._name = value;
    }
    // Temporarily expose input value. Use with caution.
    get nameInput() {
        return this._name;
    }
    // pairing_key - computed: true, optional: false, required: false
    get pairingKey() {
        return this.getStringAttribute('pairing_key');
    }
    // partner_asn - computed: true, optional: false, required: false
    get partnerAsn() {
        return this.getStringAttribute('partner_asn');
    }
    get privateInterconnectInfo() {
        return this._privateInterconnectInfo;
    }
    get project() {
        return this.getStringAttribute('project');
    }
    set project(value) {
        this._project = value;
    }
    resetProject() {
        this._project = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get projectInput() {
        return this._project;
    }
    get region() {
        return this.getStringAttribute('region');
    }
    set region(value) {
        this._region = value;
    }
    resetRegion() {
        this._region = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get regionInput() {
        return this._region;
    }
    get router() {
        return this.getStringAttribute('router');
    }
    set router(value) {
        this._router = value;
    }
    // Temporarily expose input value. Use with caution.
    get routerInput() {
        return this._router;
    }
    // self_link - computed: true, optional: false, required: false
    get selfLink() {
        return this.getStringAttribute('self_link');
    }
    // state - computed: true, optional: false, required: false
    get state() {
        return this.getStringAttribute('state');
    }
    get type() {
        return this.getStringAttribute('type');
    }
    set type(value) {
        this._type = value;
    }
    resetType() {
        this._type = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get typeInput() {
        return this._type;
    }
    get vlanTag8021Q() {
        return this.getNumberAttribute('vlan_tag8021q');
    }
    set vlanTag8021Q(value) {
        this._vlanTag8021Q = value;
    }
    resetVlanTag8021Q() {
        this._vlanTag8021Q = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get vlanTag8021QInput() {
        return this._vlanTag8021Q;
    }
    get timeouts() {
        return this._timeouts;
    }
    putTimeouts(value) {
        this._timeouts.internalValue = value;
    }
    resetTimeouts() {
        this._timeouts.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get timeoutsInput() {
        return this._timeouts.internalValue;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            admin_enabled: cdktf.booleanToTerraform(this._adminEnabled),
            bandwidth: cdktf.stringToTerraform(this._bandwidth),
            candidate_subnets: cdktf.listMapper(cdktf.stringToTerraform, false)(this._candidateSubnets),
            description: cdktf.stringToTerraform(this._description),
            edge_availability_domain: cdktf.stringToTerraform(this._edgeAvailabilityDomain),
            encryption: cdktf.stringToTerraform(this._encryption),
            id: cdktf.stringToTerraform(this._id),
            interconnect: cdktf.stringToTerraform(this._interconnect),
            ipsec_internal_addresses: cdktf.listMapper(cdktf.stringToTerraform, false)(this._ipsecInternalAddresses),
            mtu: cdktf.stringToTerraform(this._mtu),
            name: cdktf.stringToTerraform(this._name),
            project: cdktf.stringToTerraform(this._project),
            region: cdktf.stringToTerraform(this._region),
            router: cdktf.stringToTerraform(this._router),
            type: cdktf.stringToTerraform(this._type),
            vlan_tag8021q: cdktf.numberToTerraform(this._vlanTag8021Q),
            timeouts: googleComputeInterconnectAttachmentTimeoutsToTerraform(this._timeouts.internalValue),
        };
    }
}
exports.GoogleComputeInterconnectAttachment = GoogleComputeInterconnectAttachment;
_d = JSII_RTTI_SYMBOL_1;
GoogleComputeInterconnectAttachment[_d] = { fqn: "@cdktf/provider-google-beta.googleComputeInterconnectAttachment.GoogleComputeInterconnectAttachment", version: "3.0.1" };
// =================
// STATIC PROPERTIES
// =================
GoogleComputeInterconnectAttachment.tfResourceType = "google_compute_interconnect_attachment";
//# sourceMappingURL=data:application/json;base64,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