import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleComputeMachineImageIamBindingConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_machine_image_iam_binding#id GoogleComputeMachineImageIamBinding#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_machine_image_iam_binding#machine_image GoogleComputeMachineImageIamBinding#machine_image}
    */
    readonly machineImage: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_machine_image_iam_binding#members GoogleComputeMachineImageIamBinding#members}
    */
    readonly members: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_machine_image_iam_binding#project GoogleComputeMachineImageIamBinding#project}
    */
    readonly project?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_machine_image_iam_binding#role GoogleComputeMachineImageIamBinding#role}
    */
    readonly role: string;
    /**
    * condition block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_machine_image_iam_binding#condition GoogleComputeMachineImageIamBinding#condition}
    */
    readonly condition?: GoogleComputeMachineImageIamBindingCondition;
}
export interface GoogleComputeMachineImageIamBindingCondition {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_machine_image_iam_binding#description GoogleComputeMachineImageIamBinding#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_machine_image_iam_binding#expression GoogleComputeMachineImageIamBinding#expression}
    */
    readonly expression: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_machine_image_iam_binding#title GoogleComputeMachineImageIamBinding#title}
    */
    readonly title: string;
}
export declare function googleComputeMachineImageIamBindingConditionToTerraform(struct?: GoogleComputeMachineImageIamBindingConditionOutputReference | GoogleComputeMachineImageIamBindingCondition): any;
export declare class GoogleComputeMachineImageIamBindingConditionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeMachineImageIamBindingCondition | undefined;
    set internalValue(value: GoogleComputeMachineImageIamBindingCondition | undefined);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _expression?;
    get expression(): string;
    set expression(value: string);
    get expressionInput(): string | undefined;
    private _title?;
    get title(): string;
    set title(value: string);
    get titleInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_machine_image_iam_binding google_compute_machine_image_iam_binding}
*/
export declare class GoogleComputeMachineImageIamBinding extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_compute_machine_image_iam_binding";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_machine_image_iam_binding google_compute_machine_image_iam_binding} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleComputeMachineImageIamBindingConfig
    */
    constructor(scope: Construct, id: string, config: GoogleComputeMachineImageIamBindingConfig);
    get etag(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _machineImage?;
    get machineImage(): string;
    set machineImage(value: string);
    get machineImageInput(): string | undefined;
    private _members?;
    get members(): string[];
    set members(value: string[]);
    get membersInput(): string[] | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _role?;
    get role(): string;
    set role(value: string);
    get roleInput(): string | undefined;
    private _condition;
    get condition(): GoogleComputeMachineImageIamBindingConditionOutputReference;
    putCondition(value: GoogleComputeMachineImageIamBindingCondition): void;
    resetCondition(): void;
    get conditionInput(): GoogleComputeMachineImageIamBindingCondition | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
