import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleComputeManagedSslCertificateConfig extends cdktf.TerraformMetaArguments {
    /**
    * The unique identifier for the resource.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_managed_ssl_certificate#certificate_id GoogleComputeManagedSslCertificate#certificate_id}
    */
    readonly certificateId?: number;
    /**
    * An optional description of this resource.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_managed_ssl_certificate#description GoogleComputeManagedSslCertificate#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_managed_ssl_certificate#id GoogleComputeManagedSslCertificate#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Name of the resource. Provided by the client when the resource is
  created. The name must be 1-63 characters long, and comply with
  RFC1035. Specifically, the name must be 1-63 characters long and match
  the regular expression '[a-z]([-a-z0-9]*[a-z0-9])?' which means the
  first character must be a lowercase letter, and all following
  characters must be a dash, lowercase letter, or digit, except the last
  character, which cannot be a dash.
  
  
  These are in the same namespace as the managed SSL certificates.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_managed_ssl_certificate#name GoogleComputeManagedSslCertificate#name}
    */
    readonly name?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_managed_ssl_certificate#project GoogleComputeManagedSslCertificate#project}
    */
    readonly project?: string;
    /**
    * Enum field whose value is always 'MANAGED' - used to signal to the API
  which type this is. Default value: "MANAGED" Possible values: ["MANAGED"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_managed_ssl_certificate#type GoogleComputeManagedSslCertificate#type}
    */
    readonly type?: string;
    /**
    * managed block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_managed_ssl_certificate#managed GoogleComputeManagedSslCertificate#managed}
    */
    readonly managed?: GoogleComputeManagedSslCertificateManaged;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_managed_ssl_certificate#timeouts GoogleComputeManagedSslCertificate#timeouts}
    */
    readonly timeouts?: GoogleComputeManagedSslCertificateTimeouts;
}
export interface GoogleComputeManagedSslCertificateManaged {
    /**
    * Domains for which a managed SSL certificate will be valid.  Currently,
  there can be up to 100 domains in this list.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_managed_ssl_certificate#domains GoogleComputeManagedSslCertificate#domains}
    */
    readonly domains: string[];
}
export declare function googleComputeManagedSslCertificateManagedToTerraform(struct?: GoogleComputeManagedSslCertificateManagedOutputReference | GoogleComputeManagedSslCertificateManaged): any;
export declare class GoogleComputeManagedSslCertificateManagedOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeManagedSslCertificateManaged | undefined;
    set internalValue(value: GoogleComputeManagedSslCertificateManaged | undefined);
    private _domains?;
    get domains(): string[];
    set domains(value: string[]);
    get domainsInput(): string[] | undefined;
}
export interface GoogleComputeManagedSslCertificateTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_managed_ssl_certificate#create GoogleComputeManagedSslCertificate#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_managed_ssl_certificate#delete GoogleComputeManagedSslCertificate#delete}
    */
    readonly delete?: string;
}
export declare function googleComputeManagedSslCertificateTimeoutsToTerraform(struct?: GoogleComputeManagedSslCertificateTimeoutsOutputReference | GoogleComputeManagedSslCertificateTimeouts | cdktf.IResolvable): any;
export declare class GoogleComputeManagedSslCertificateTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeManagedSslCertificateTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleComputeManagedSslCertificateTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_managed_ssl_certificate google_compute_managed_ssl_certificate}
*/
export declare class GoogleComputeManagedSslCertificate extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_compute_managed_ssl_certificate";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_managed_ssl_certificate google_compute_managed_ssl_certificate} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleComputeManagedSslCertificateConfig = {}
    */
    constructor(scope: Construct, id: string, config?: GoogleComputeManagedSslCertificateConfig);
    private _certificateId?;
    get certificateId(): number;
    set certificateId(value: number);
    resetCertificateId(): void;
    get certificateIdInput(): number | undefined;
    get creationTimestamp(): string;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    get expireTime(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    get selfLink(): string;
    get subjectAlternativeNames(): string[];
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
    private _managed;
    get managed(): GoogleComputeManagedSslCertificateManagedOutputReference;
    putManaged(value: GoogleComputeManagedSslCertificateManaged): void;
    resetManaged(): void;
    get managedInput(): GoogleComputeManagedSslCertificateManaged | undefined;
    private _timeouts;
    get timeouts(): GoogleComputeManagedSslCertificateTimeoutsOutputReference;
    putTimeouts(value: GoogleComputeManagedSslCertificateTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleComputeManagedSslCertificateTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
