import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleComputeNetworkEndpointConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_network_endpoint#id GoogleComputeNetworkEndpoint#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The name for a specific VM instance that the IP address belongs to.
  This is required for network endpoints of type GCE_VM_IP_PORT.
  The instance must be in the same zone of network endpoint group.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_network_endpoint#instance GoogleComputeNetworkEndpoint#instance}
    */
    readonly instance?: string;
    /**
    * IPv4 address of network endpoint. The IP address must belong
  to a VM in GCE (either the primary IP or as part of an aliased IP
  range).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_network_endpoint#ip_address GoogleComputeNetworkEndpoint#ip_address}
    */
    readonly ipAddress: string;
    /**
    * The network endpoint group this endpoint is part of.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_network_endpoint#network_endpoint_group GoogleComputeNetworkEndpoint#network_endpoint_group}
    */
    readonly networkEndpointGroup: string;
    /**
    * Port number of network endpoint.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_network_endpoint#port GoogleComputeNetworkEndpoint#port}
    */
    readonly port?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_network_endpoint#project GoogleComputeNetworkEndpoint#project}
    */
    readonly project?: string;
    /**
    * Zone where the containing network endpoint group is located.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_network_endpoint#zone GoogleComputeNetworkEndpoint#zone}
    */
    readonly zone?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_network_endpoint#timeouts GoogleComputeNetworkEndpoint#timeouts}
    */
    readonly timeouts?: GoogleComputeNetworkEndpointTimeouts;
}
export interface GoogleComputeNetworkEndpointTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_network_endpoint#create GoogleComputeNetworkEndpoint#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_network_endpoint#delete GoogleComputeNetworkEndpoint#delete}
    */
    readonly delete?: string;
}
export declare function googleComputeNetworkEndpointTimeoutsToTerraform(struct?: GoogleComputeNetworkEndpointTimeoutsOutputReference | GoogleComputeNetworkEndpointTimeouts | cdktf.IResolvable): any;
export declare class GoogleComputeNetworkEndpointTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeNetworkEndpointTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleComputeNetworkEndpointTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_network_endpoint google_compute_network_endpoint}
*/
export declare class GoogleComputeNetworkEndpoint extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_compute_network_endpoint";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_network_endpoint google_compute_network_endpoint} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleComputeNetworkEndpointConfig
    */
    constructor(scope: Construct, id: string, config: GoogleComputeNetworkEndpointConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _instance?;
    get instance(): string;
    set instance(value: string);
    resetInstance(): void;
    get instanceInput(): string | undefined;
    private _ipAddress?;
    get ipAddress(): string;
    set ipAddress(value: string);
    get ipAddressInput(): string | undefined;
    private _networkEndpointGroup?;
    get networkEndpointGroup(): string;
    set networkEndpointGroup(value: string);
    get networkEndpointGroupInput(): string | undefined;
    private _port?;
    get port(): number;
    set port(value: number);
    resetPort(): void;
    get portInput(): number | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _zone?;
    get zone(): string;
    set zone(value: string);
    resetZone(): void;
    get zoneInput(): string | undefined;
    private _timeouts;
    get timeouts(): GoogleComputeNetworkEndpointTimeoutsOutputReference;
    putTimeouts(value: GoogleComputeNetworkEndpointTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleComputeNetworkEndpointTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
