import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleComputeOrganizationSecurityPolicyRuleConfig extends cdktf.TerraformMetaArguments {
    /**
    * The Action to perform when the client connection triggers the rule. Can currently be either
  "allow", "deny" or "goto_next".
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_organization_security_policy_rule#action GoogleComputeOrganizationSecurityPolicyRule#action}
    */
    readonly action: string;
    /**
    * A description of the rule.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_organization_security_policy_rule#description GoogleComputeOrganizationSecurityPolicyRule#description}
    */
    readonly description?: string;
    /**
    * The direction in which this rule applies. If unspecified an INGRESS rule is created. Possible values: ["INGRESS", "EGRESS"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_organization_security_policy_rule#direction GoogleComputeOrganizationSecurityPolicyRule#direction}
    */
    readonly direction?: string;
    /**
    * Denotes whether to enable logging for a particular rule.
  If logging is enabled, logs will be exported to the
  configured export destination in Stackdriver.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_organization_security_policy_rule#enable_logging GoogleComputeOrganizationSecurityPolicyRule#enable_logging}
    */
    readonly enableLogging?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_organization_security_policy_rule#id GoogleComputeOrganizationSecurityPolicyRule#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The ID of the OrganizationSecurityPolicy this rule applies to.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_organization_security_policy_rule#policy_id GoogleComputeOrganizationSecurityPolicyRule#policy_id}
    */
    readonly policyId: string;
    /**
    * If set to true, the specified action is not enforced.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_organization_security_policy_rule#preview GoogleComputeOrganizationSecurityPolicyRule#preview}
    */
    readonly preview?: boolean | cdktf.IResolvable;
    /**
    * An integer indicating the priority of a rule in the list. The priority must be a value
  between 0 and 2147483647. Rules are evaluated from highest to lowest priority where 0 is the
  highest priority and 2147483647 is the lowest prority.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_organization_security_policy_rule#priority GoogleComputeOrganizationSecurityPolicyRule#priority}
    */
    readonly priority: number;
    /**
    * A list of network resource URLs to which this rule applies.
  This field allows you to control which network's VMs get
  this rule. If this field is left blank, all VMs
  within the organization will receive the rule.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_organization_security_policy_rule#target_resources GoogleComputeOrganizationSecurityPolicyRule#target_resources}
    */
    readonly targetResources?: string[];
    /**
    * A list of service accounts indicating the sets of
  instances that are applied with this rule.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_organization_security_policy_rule#target_service_accounts GoogleComputeOrganizationSecurityPolicyRule#target_service_accounts}
    */
    readonly targetServiceAccounts?: string[];
    /**
    * match block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_organization_security_policy_rule#match GoogleComputeOrganizationSecurityPolicyRule#match}
    */
    readonly match: GoogleComputeOrganizationSecurityPolicyRuleMatch;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_organization_security_policy_rule#timeouts GoogleComputeOrganizationSecurityPolicyRule#timeouts}
    */
    readonly timeouts?: GoogleComputeOrganizationSecurityPolicyRuleTimeouts;
}
export interface GoogleComputeOrganizationSecurityPolicyRuleMatchConfigLayer4Config {
    /**
    * The IP protocol to which this rule applies. The protocol
  type is required when creating a firewall rule.
  This value can either be one of the following well
  known protocol strings (tcp, udp, icmp, esp, ah, ipip, sctp),
  or the IP protocol number.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_organization_security_policy_rule#ip_protocol GoogleComputeOrganizationSecurityPolicyRule#ip_protocol}
    */
    readonly ipProtocol: string;
    /**
    * An optional list of ports to which this rule applies. This field
  is only applicable for UDP or TCP protocol. Each entry must be
  either an integer or a range. If not specified, this rule
  applies to connections through any port.
  
  Example inputs include: ["22"], ["80","443"], and
  ["12345-12349"].
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_organization_security_policy_rule#ports GoogleComputeOrganizationSecurityPolicyRule#ports}
    */
    readonly ports?: string[];
}
export declare function googleComputeOrganizationSecurityPolicyRuleMatchConfigLayer4ConfigToTerraform(struct?: GoogleComputeOrganizationSecurityPolicyRuleMatchConfigLayer4Config | cdktf.IResolvable): any;
export declare class GoogleComputeOrganizationSecurityPolicyRuleMatchConfigLayer4ConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleComputeOrganizationSecurityPolicyRuleMatchConfigLayer4Config | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleComputeOrganizationSecurityPolicyRuleMatchConfigLayer4Config | cdktf.IResolvable | undefined);
    private _ipProtocol?;
    get ipProtocol(): string;
    set ipProtocol(value: string);
    get ipProtocolInput(): string | undefined;
    private _ports?;
    get ports(): string[];
    set ports(value: string[]);
    resetPorts(): void;
    get portsInput(): string[] | undefined;
}
export declare class GoogleComputeOrganizationSecurityPolicyRuleMatchConfigLayer4ConfigList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleComputeOrganizationSecurityPolicyRuleMatchConfigLayer4Config[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleComputeOrganizationSecurityPolicyRuleMatchConfigLayer4ConfigOutputReference;
}
export interface GoogleComputeOrganizationSecurityPolicyRuleMatchConfig {
    /**
    * Destination IP address range in CIDR format. Required for
  EGRESS rules.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_organization_security_policy_rule#dest_ip_ranges GoogleComputeOrganizationSecurityPolicyRule#dest_ip_ranges}
    */
    readonly destIpRanges?: string[];
    /**
    * Source IP address range in CIDR format. Required for
  INGRESS rules.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_organization_security_policy_rule#src_ip_ranges GoogleComputeOrganizationSecurityPolicyRule#src_ip_ranges}
    */
    readonly srcIpRanges?: string[];
    /**
    * layer4_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_organization_security_policy_rule#layer4_config GoogleComputeOrganizationSecurityPolicyRule#layer4_config}
    */
    readonly layer4Config: GoogleComputeOrganizationSecurityPolicyRuleMatchConfigLayer4Config[] | cdktf.IResolvable;
}
export declare function googleComputeOrganizationSecurityPolicyRuleMatchConfigToTerraform(struct?: GoogleComputeOrganizationSecurityPolicyRuleMatchConfigOutputReference | GoogleComputeOrganizationSecurityPolicyRuleMatchConfig): any;
export declare class GoogleComputeOrganizationSecurityPolicyRuleMatchConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeOrganizationSecurityPolicyRuleMatchConfig | undefined;
    set internalValue(value: GoogleComputeOrganizationSecurityPolicyRuleMatchConfig | undefined);
    private _destIpRanges?;
    get destIpRanges(): string[];
    set destIpRanges(value: string[]);
    resetDestIpRanges(): void;
    get destIpRangesInput(): string[] | undefined;
    private _srcIpRanges?;
    get srcIpRanges(): string[];
    set srcIpRanges(value: string[]);
    resetSrcIpRanges(): void;
    get srcIpRangesInput(): string[] | undefined;
    private _layer4Config;
    get layer4Config(): GoogleComputeOrganizationSecurityPolicyRuleMatchConfigLayer4ConfigList;
    putLayer4Config(value: GoogleComputeOrganizationSecurityPolicyRuleMatchConfigLayer4Config[] | cdktf.IResolvable): void;
    get layer4ConfigInput(): cdktf.IResolvable | GoogleComputeOrganizationSecurityPolicyRuleMatchConfigLayer4Config[] | undefined;
}
export interface GoogleComputeOrganizationSecurityPolicyRuleMatch {
    /**
    * A description of the rule.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_organization_security_policy_rule#description GoogleComputeOrganizationSecurityPolicyRule#description}
    */
    readonly description?: string;
    /**
    * Preconfigured versioned expression. For organization security policy rules,
  the only supported type is "FIREWALL". Default value: "FIREWALL" Possible values: ["FIREWALL"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_organization_security_policy_rule#versioned_expr GoogleComputeOrganizationSecurityPolicyRule#versioned_expr}
    */
    readonly versionedExpr?: string;
    /**
    * config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_organization_security_policy_rule#config GoogleComputeOrganizationSecurityPolicyRule#config}
    */
    readonly config: GoogleComputeOrganizationSecurityPolicyRuleMatchConfig;
}
export declare function googleComputeOrganizationSecurityPolicyRuleMatchToTerraform(struct?: GoogleComputeOrganizationSecurityPolicyRuleMatchOutputReference | GoogleComputeOrganizationSecurityPolicyRuleMatch): any;
export declare class GoogleComputeOrganizationSecurityPolicyRuleMatchOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeOrganizationSecurityPolicyRuleMatch | undefined;
    set internalValue(value: GoogleComputeOrganizationSecurityPolicyRuleMatch | undefined);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _versionedExpr?;
    get versionedExpr(): string;
    set versionedExpr(value: string);
    resetVersionedExpr(): void;
    get versionedExprInput(): string | undefined;
    private _config;
    get config(): GoogleComputeOrganizationSecurityPolicyRuleMatchConfigOutputReference;
    putConfig(value: GoogleComputeOrganizationSecurityPolicyRuleMatchConfig): void;
    get configInput(): GoogleComputeOrganizationSecurityPolicyRuleMatchConfig | undefined;
}
export interface GoogleComputeOrganizationSecurityPolicyRuleTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_organization_security_policy_rule#create GoogleComputeOrganizationSecurityPolicyRule#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_organization_security_policy_rule#delete GoogleComputeOrganizationSecurityPolicyRule#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_organization_security_policy_rule#update GoogleComputeOrganizationSecurityPolicyRule#update}
    */
    readonly update?: string;
}
export declare function googleComputeOrganizationSecurityPolicyRuleTimeoutsToTerraform(struct?: GoogleComputeOrganizationSecurityPolicyRuleTimeoutsOutputReference | GoogleComputeOrganizationSecurityPolicyRuleTimeouts | cdktf.IResolvable): any;
export declare class GoogleComputeOrganizationSecurityPolicyRuleTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeOrganizationSecurityPolicyRuleTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleComputeOrganizationSecurityPolicyRuleTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_organization_security_policy_rule google_compute_organization_security_policy_rule}
*/
export declare class GoogleComputeOrganizationSecurityPolicyRule extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_compute_organization_security_policy_rule";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_organization_security_policy_rule google_compute_organization_security_policy_rule} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleComputeOrganizationSecurityPolicyRuleConfig
    */
    constructor(scope: Construct, id: string, config: GoogleComputeOrganizationSecurityPolicyRuleConfig);
    private _action?;
    get action(): string;
    set action(value: string);
    get actionInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _direction?;
    get direction(): string;
    set direction(value: string);
    resetDirection(): void;
    get directionInput(): string | undefined;
    private _enableLogging?;
    get enableLogging(): boolean | cdktf.IResolvable;
    set enableLogging(value: boolean | cdktf.IResolvable);
    resetEnableLogging(): void;
    get enableLoggingInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _policyId?;
    get policyId(): string;
    set policyId(value: string);
    get policyIdInput(): string | undefined;
    private _preview?;
    get preview(): boolean | cdktf.IResolvable;
    set preview(value: boolean | cdktf.IResolvable);
    resetPreview(): void;
    get previewInput(): boolean | cdktf.IResolvable | undefined;
    private _priority?;
    get priority(): number;
    set priority(value: number);
    get priorityInput(): number | undefined;
    private _targetResources?;
    get targetResources(): string[];
    set targetResources(value: string[]);
    resetTargetResources(): void;
    get targetResourcesInput(): string[] | undefined;
    private _targetServiceAccounts?;
    get targetServiceAccounts(): string[];
    set targetServiceAccounts(value: string[]);
    resetTargetServiceAccounts(): void;
    get targetServiceAccountsInput(): string[] | undefined;
    private _match;
    get match(): GoogleComputeOrganizationSecurityPolicyRuleMatchOutputReference;
    putMatch(value: GoogleComputeOrganizationSecurityPolicyRuleMatch): void;
    get matchInput(): GoogleComputeOrganizationSecurityPolicyRuleMatch | undefined;
    private _timeouts;
    get timeouts(): GoogleComputeOrganizationSecurityPolicyRuleTimeoutsOutputReference;
    putTimeouts(value: GoogleComputeOrganizationSecurityPolicyRuleTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleComputeOrganizationSecurityPolicyRuleTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
