import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleComputePacketMirroringConfig extends cdktf.TerraformMetaArguments {
    /**
    * A human-readable description of the rule.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_packet_mirroring#description GoogleComputePacketMirroring#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_packet_mirroring#id GoogleComputePacketMirroring#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The name of the packet mirroring rule
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_packet_mirroring#name GoogleComputePacketMirroring#name}
    */
    readonly name: string;
    /**
    * Since only one rule can be active at a time, priority is
  used to break ties in the case of two rules that apply to
  the same instances.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_packet_mirroring#priority GoogleComputePacketMirroring#priority}
    */
    readonly priority?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_packet_mirroring#project GoogleComputePacketMirroring#project}
    */
    readonly project?: string;
    /**
    * The Region in which the created address should reside.
  If it is not provided, the provider region is used.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_packet_mirroring#region GoogleComputePacketMirroring#region}
    */
    readonly region?: string;
    /**
    * collector_ilb block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_packet_mirroring#collector_ilb GoogleComputePacketMirroring#collector_ilb}
    */
    readonly collectorIlb: GoogleComputePacketMirroringCollectorIlb;
    /**
    * filter block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_packet_mirroring#filter GoogleComputePacketMirroring#filter}
    */
    readonly filter?: GoogleComputePacketMirroringFilter;
    /**
    * mirrored_resources block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_packet_mirroring#mirrored_resources GoogleComputePacketMirroring#mirrored_resources}
    */
    readonly mirroredResources: GoogleComputePacketMirroringMirroredResources;
    /**
    * network block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_packet_mirroring#network GoogleComputePacketMirroring#network}
    */
    readonly network: GoogleComputePacketMirroringNetwork;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_packet_mirroring#timeouts GoogleComputePacketMirroring#timeouts}
    */
    readonly timeouts?: GoogleComputePacketMirroringTimeouts;
}
export interface GoogleComputePacketMirroringCollectorIlb {
    /**
    * The URL of the forwarding rule.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_packet_mirroring#url GoogleComputePacketMirroring#url}
    */
    readonly url: string;
}
export declare function googleComputePacketMirroringCollectorIlbToTerraform(struct?: GoogleComputePacketMirroringCollectorIlbOutputReference | GoogleComputePacketMirroringCollectorIlb): any;
export declare class GoogleComputePacketMirroringCollectorIlbOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputePacketMirroringCollectorIlb | undefined;
    set internalValue(value: GoogleComputePacketMirroringCollectorIlb | undefined);
    private _url?;
    get url(): string;
    set url(value: string);
    get urlInput(): string | undefined;
}
export interface GoogleComputePacketMirroringFilter {
    /**
    * IP CIDR ranges that apply as a filter on the source (ingress) or
  destination (egress) IP in the IP header. Only IPv4 is supported.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_packet_mirroring#cidr_ranges GoogleComputePacketMirroring#cidr_ranges}
    */
    readonly cidrRanges?: string[];
    /**
    * Direction of traffic to mirror. Default value: "BOTH" Possible values: ["INGRESS", "EGRESS", "BOTH"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_packet_mirroring#direction GoogleComputePacketMirroring#direction}
    */
    readonly direction?: string;
    /**
    * Possible IP protocols including tcp, udp, icmp and esp
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_packet_mirroring#ip_protocols GoogleComputePacketMirroring#ip_protocols}
    */
    readonly ipProtocols?: string[];
}
export declare function googleComputePacketMirroringFilterToTerraform(struct?: GoogleComputePacketMirroringFilterOutputReference | GoogleComputePacketMirroringFilter): any;
export declare class GoogleComputePacketMirroringFilterOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputePacketMirroringFilter | undefined;
    set internalValue(value: GoogleComputePacketMirroringFilter | undefined);
    private _cidrRanges?;
    get cidrRanges(): string[];
    set cidrRanges(value: string[]);
    resetCidrRanges(): void;
    get cidrRangesInput(): string[] | undefined;
    private _direction?;
    get direction(): string;
    set direction(value: string);
    resetDirection(): void;
    get directionInput(): string | undefined;
    private _ipProtocols?;
    get ipProtocols(): string[];
    set ipProtocols(value: string[]);
    resetIpProtocols(): void;
    get ipProtocolsInput(): string[] | undefined;
}
export interface GoogleComputePacketMirroringMirroredResourcesInstances {
    /**
    * The URL of the instances where this rule should be active.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_packet_mirroring#url GoogleComputePacketMirroring#url}
    */
    readonly url: string;
}
export declare function googleComputePacketMirroringMirroredResourcesInstancesToTerraform(struct?: GoogleComputePacketMirroringMirroredResourcesInstances | cdktf.IResolvable): any;
export declare class GoogleComputePacketMirroringMirroredResourcesInstancesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleComputePacketMirroringMirroredResourcesInstances | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleComputePacketMirroringMirroredResourcesInstances | cdktf.IResolvable | undefined);
    private _url?;
    get url(): string;
    set url(value: string);
    get urlInput(): string | undefined;
}
export declare class GoogleComputePacketMirroringMirroredResourcesInstancesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleComputePacketMirroringMirroredResourcesInstances[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleComputePacketMirroringMirroredResourcesInstancesOutputReference;
}
export interface GoogleComputePacketMirroringMirroredResourcesSubnetworks {
    /**
    * The URL of the subnetwork where this rule should be active.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_packet_mirroring#url GoogleComputePacketMirroring#url}
    */
    readonly url: string;
}
export declare function googleComputePacketMirroringMirroredResourcesSubnetworksToTerraform(struct?: GoogleComputePacketMirroringMirroredResourcesSubnetworks | cdktf.IResolvable): any;
export declare class GoogleComputePacketMirroringMirroredResourcesSubnetworksOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleComputePacketMirroringMirroredResourcesSubnetworks | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleComputePacketMirroringMirroredResourcesSubnetworks | cdktf.IResolvable | undefined);
    private _url?;
    get url(): string;
    set url(value: string);
    get urlInput(): string | undefined;
}
export declare class GoogleComputePacketMirroringMirroredResourcesSubnetworksList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleComputePacketMirroringMirroredResourcesSubnetworks[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleComputePacketMirroringMirroredResourcesSubnetworksOutputReference;
}
export interface GoogleComputePacketMirroringMirroredResources {
    /**
    * All instances with these tags will be mirrored.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_packet_mirroring#tags GoogleComputePacketMirroring#tags}
    */
    readonly tags?: string[];
    /**
    * instances block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_packet_mirroring#instances GoogleComputePacketMirroring#instances}
    */
    readonly instances?: GoogleComputePacketMirroringMirroredResourcesInstances[] | cdktf.IResolvable;
    /**
    * subnetworks block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_packet_mirroring#subnetworks GoogleComputePacketMirroring#subnetworks}
    */
    readonly subnetworks?: GoogleComputePacketMirroringMirroredResourcesSubnetworks[] | cdktf.IResolvable;
}
export declare function googleComputePacketMirroringMirroredResourcesToTerraform(struct?: GoogleComputePacketMirroringMirroredResourcesOutputReference | GoogleComputePacketMirroringMirroredResources): any;
export declare class GoogleComputePacketMirroringMirroredResourcesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputePacketMirroringMirroredResources | undefined;
    set internalValue(value: GoogleComputePacketMirroringMirroredResources | undefined);
    private _tags?;
    get tags(): string[];
    set tags(value: string[]);
    resetTags(): void;
    get tagsInput(): string[] | undefined;
    private _instances;
    get instances(): GoogleComputePacketMirroringMirroredResourcesInstancesList;
    putInstances(value: GoogleComputePacketMirroringMirroredResourcesInstances[] | cdktf.IResolvable): void;
    resetInstances(): void;
    get instancesInput(): cdktf.IResolvable | GoogleComputePacketMirroringMirroredResourcesInstances[] | undefined;
    private _subnetworks;
    get subnetworks(): GoogleComputePacketMirroringMirroredResourcesSubnetworksList;
    putSubnetworks(value: GoogleComputePacketMirroringMirroredResourcesSubnetworks[] | cdktf.IResolvable): void;
    resetSubnetworks(): void;
    get subnetworksInput(): cdktf.IResolvable | GoogleComputePacketMirroringMirroredResourcesSubnetworks[] | undefined;
}
export interface GoogleComputePacketMirroringNetwork {
    /**
    * The full self_link URL of the network where this rule is active.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_packet_mirroring#url GoogleComputePacketMirroring#url}
    */
    readonly url: string;
}
export declare function googleComputePacketMirroringNetworkToTerraform(struct?: GoogleComputePacketMirroringNetworkOutputReference | GoogleComputePacketMirroringNetwork): any;
export declare class GoogleComputePacketMirroringNetworkOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputePacketMirroringNetwork | undefined;
    set internalValue(value: GoogleComputePacketMirroringNetwork | undefined);
    private _url?;
    get url(): string;
    set url(value: string);
    get urlInput(): string | undefined;
}
export interface GoogleComputePacketMirroringTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_packet_mirroring#create GoogleComputePacketMirroring#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_packet_mirroring#delete GoogleComputePacketMirroring#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_packet_mirroring#update GoogleComputePacketMirroring#update}
    */
    readonly update?: string;
}
export declare function googleComputePacketMirroringTimeoutsToTerraform(struct?: GoogleComputePacketMirroringTimeoutsOutputReference | GoogleComputePacketMirroringTimeouts | cdktf.IResolvable): any;
export declare class GoogleComputePacketMirroringTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputePacketMirroringTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleComputePacketMirroringTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_packet_mirroring google_compute_packet_mirroring}
*/
export declare class GoogleComputePacketMirroring extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_compute_packet_mirroring";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_packet_mirroring google_compute_packet_mirroring} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleComputePacketMirroringConfig
    */
    constructor(scope: Construct, id: string, config: GoogleComputePacketMirroringConfig);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _priority?;
    get priority(): number;
    set priority(value: number);
    resetPriority(): void;
    get priorityInput(): number | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    private _collectorIlb;
    get collectorIlb(): GoogleComputePacketMirroringCollectorIlbOutputReference;
    putCollectorIlb(value: GoogleComputePacketMirroringCollectorIlb): void;
    get collectorIlbInput(): GoogleComputePacketMirroringCollectorIlb | undefined;
    private _filter;
    get filter(): GoogleComputePacketMirroringFilterOutputReference;
    putFilter(value: GoogleComputePacketMirroringFilter): void;
    resetFilter(): void;
    get filterInput(): GoogleComputePacketMirroringFilter | undefined;
    private _mirroredResources;
    get mirroredResources(): GoogleComputePacketMirroringMirroredResourcesOutputReference;
    putMirroredResources(value: GoogleComputePacketMirroringMirroredResources): void;
    get mirroredResourcesInput(): GoogleComputePacketMirroringMirroredResources | undefined;
    private _network;
    get network(): GoogleComputePacketMirroringNetworkOutputReference;
    putNetwork(value: GoogleComputePacketMirroringNetwork): void;
    get networkInput(): GoogleComputePacketMirroringNetwork | undefined;
    private _timeouts;
    get timeouts(): GoogleComputePacketMirroringTimeoutsOutputReference;
    putTimeouts(value: GoogleComputePacketMirroringTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleComputePacketMirroringTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
