import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleComputeProjectDefaultNetworkTierConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_project_default_network_tier#id GoogleComputeProjectDefaultNetworkTier#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The default network tier to be configured for the project. This field can take the following values: PREMIUM or STANDARD.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_project_default_network_tier#network_tier GoogleComputeProjectDefaultNetworkTier#network_tier}
    */
    readonly networkTier: string;
    /**
    * The ID of the project in which the resource belongs. If it is not provided, the provider project is used.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_project_default_network_tier#project GoogleComputeProjectDefaultNetworkTier#project}
    */
    readonly project?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_project_default_network_tier#timeouts GoogleComputeProjectDefaultNetworkTier#timeouts}
    */
    readonly timeouts?: GoogleComputeProjectDefaultNetworkTierTimeouts;
}
export interface GoogleComputeProjectDefaultNetworkTierTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_project_default_network_tier#create GoogleComputeProjectDefaultNetworkTier#create}
    */
    readonly create?: string;
}
export declare function googleComputeProjectDefaultNetworkTierTimeoutsToTerraform(struct?: GoogleComputeProjectDefaultNetworkTierTimeoutsOutputReference | GoogleComputeProjectDefaultNetworkTierTimeouts | cdktf.IResolvable): any;
export declare class GoogleComputeProjectDefaultNetworkTierTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeProjectDefaultNetworkTierTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleComputeProjectDefaultNetworkTierTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_project_default_network_tier google_compute_project_default_network_tier}
*/
export declare class GoogleComputeProjectDefaultNetworkTier extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_compute_project_default_network_tier";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_project_default_network_tier google_compute_project_default_network_tier} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleComputeProjectDefaultNetworkTierConfig
    */
    constructor(scope: Construct, id: string, config: GoogleComputeProjectDefaultNetworkTierConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _networkTier?;
    get networkTier(): string;
    set networkTier(value: string);
    get networkTierInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _timeouts;
    get timeouts(): GoogleComputeProjectDefaultNetworkTierTimeoutsOutputReference;
    putTimeouts(value: GoogleComputeProjectDefaultNetworkTierTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleComputeProjectDefaultNetworkTierTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
