import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleComputeProjectMetadataItemConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_project_metadata_item#id GoogleComputeProjectMetadataItem#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The metadata key to set.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_project_metadata_item#key GoogleComputeProjectMetadataItem#key}
    */
    readonly key: string;
    /**
    * The ID of the project in which the resource belongs. If it is not provided, the provider project is used.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_project_metadata_item#project GoogleComputeProjectMetadataItem#project}
    */
    readonly project?: string;
    /**
    * The value to set for the given metadata key.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_project_metadata_item#value GoogleComputeProjectMetadataItem#value}
    */
    readonly value: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_project_metadata_item#timeouts GoogleComputeProjectMetadataItem#timeouts}
    */
    readonly timeouts?: GoogleComputeProjectMetadataItemTimeouts;
}
export interface GoogleComputeProjectMetadataItemTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_project_metadata_item#create GoogleComputeProjectMetadataItem#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_project_metadata_item#delete GoogleComputeProjectMetadataItem#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_project_metadata_item#update GoogleComputeProjectMetadataItem#update}
    */
    readonly update?: string;
}
export declare function googleComputeProjectMetadataItemTimeoutsToTerraform(struct?: GoogleComputeProjectMetadataItemTimeoutsOutputReference | GoogleComputeProjectMetadataItemTimeouts | cdktf.IResolvable): any;
export declare class GoogleComputeProjectMetadataItemTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeProjectMetadataItemTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleComputeProjectMetadataItemTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_project_metadata_item google_compute_project_metadata_item}
*/
export declare class GoogleComputeProjectMetadataItem extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_compute_project_metadata_item";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_project_metadata_item google_compute_project_metadata_item} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleComputeProjectMetadataItemConfig
    */
    constructor(scope: Construct, id: string, config: GoogleComputeProjectMetadataItemConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _key?;
    get key(): string;
    set key(value: string);
    get keyInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    get valueInput(): string | undefined;
    private _timeouts;
    get timeouts(): GoogleComputeProjectMetadataItemTimeoutsOutputReference;
    putTimeouts(value: GoogleComputeProjectMetadataItemTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleComputeProjectMetadataItemTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
