import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleComputeProjectMetadataConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_project_metadata#id GoogleComputeProjectMetadata#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * A series of key value pairs.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_project_metadata#metadata GoogleComputeProjectMetadata#metadata}
    */
    readonly metadata: {
        [key: string]: string;
    };
    /**
    * The ID of the project in which the resource belongs. If it is not provided, the provider project is used.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_project_metadata#project GoogleComputeProjectMetadata#project}
    */
    readonly project?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_project_metadata#timeouts GoogleComputeProjectMetadata#timeouts}
    */
    readonly timeouts?: GoogleComputeProjectMetadataTimeouts;
}
export interface GoogleComputeProjectMetadataTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_project_metadata#create GoogleComputeProjectMetadata#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_project_metadata#delete GoogleComputeProjectMetadata#delete}
    */
    readonly delete?: string;
}
export declare function googleComputeProjectMetadataTimeoutsToTerraform(struct?: GoogleComputeProjectMetadataTimeoutsOutputReference | GoogleComputeProjectMetadataTimeouts | cdktf.IResolvable): any;
export declare class GoogleComputeProjectMetadataTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeProjectMetadataTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleComputeProjectMetadataTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_project_metadata google_compute_project_metadata}
*/
export declare class GoogleComputeProjectMetadata extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_compute_project_metadata";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_project_metadata google_compute_project_metadata} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleComputeProjectMetadataConfig
    */
    constructor(scope: Construct, id: string, config: GoogleComputeProjectMetadataConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _metadata?;
    get metadata(): {
        [key: string]: string;
    };
    set metadata(value: {
        [key: string]: string;
    });
    get metadataInput(): {
        [key: string]: string;
    } | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _timeouts;
    get timeouts(): GoogleComputeProjectMetadataTimeoutsOutputReference;
    putTimeouts(value: GoogleComputeProjectMetadataTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleComputeProjectMetadataTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
