import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleComputeRegionAutoscalerConfig extends cdktf.TerraformMetaArguments {
    /**
    * An optional description of this resource.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_autoscaler#description GoogleComputeRegionAutoscaler#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_autoscaler#id GoogleComputeRegionAutoscaler#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Name of the resource. The name must be 1-63 characters long and match
  the regular expression '[a-z]([-a-z0-9]*[a-z0-9])?' which means the
  first character must be a lowercase letter, and all following
  characters must be a dash, lowercase letter, or digit, except the last
  character, which cannot be a dash.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_autoscaler#name GoogleComputeRegionAutoscaler#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_autoscaler#project GoogleComputeRegionAutoscaler#project}
    */
    readonly project?: string;
    /**
    * URL of the region where the instance group resides.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_autoscaler#region GoogleComputeRegionAutoscaler#region}
    */
    readonly region?: string;
    /**
    * URL of the managed instance group that this autoscaler will scale.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_autoscaler#target GoogleComputeRegionAutoscaler#target}
    */
    readonly target: string;
    /**
    * autoscaling_policy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_autoscaler#autoscaling_policy GoogleComputeRegionAutoscaler#autoscaling_policy}
    */
    readonly autoscalingPolicy: GoogleComputeRegionAutoscalerAutoscalingPolicy;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_autoscaler#timeouts GoogleComputeRegionAutoscaler#timeouts}
    */
    readonly timeouts?: GoogleComputeRegionAutoscalerTimeouts;
}
export interface GoogleComputeRegionAutoscalerAutoscalingPolicyCpuUtilization {
    /**
    * Indicates whether predictive autoscaling based on CPU metric is enabled. Valid values are:
  
  - NONE (default). No predictive method is used. The autoscaler scales the group to meet current demand based on real-time metrics.
  
  - OPTIMIZE_AVAILABILITY. Predictive autoscaling improves availability by monitoring daily and weekly load patterns and scaling out ahead of anticipated demand.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_autoscaler#predictive_method GoogleComputeRegionAutoscaler#predictive_method}
    */
    readonly predictiveMethod?: string;
    /**
    * The target CPU utilization that the autoscaler should maintain.
  Must be a float value in the range (0, 1]. If not specified, the
  default is 0.6.
  
  If the CPU level is below the target utilization, the autoscaler
  scales down the number of instances until it reaches the minimum
  number of instances you specified or until the average CPU of
  your instances reaches the target utilization.
  
  If the average CPU is above the target utilization, the autoscaler
  scales up until it reaches the maximum number of instances you
  specified or until the average utilization reaches the target
  utilization.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_autoscaler#target GoogleComputeRegionAutoscaler#target}
    */
    readonly target: number;
}
export declare function googleComputeRegionAutoscalerAutoscalingPolicyCpuUtilizationToTerraform(struct?: GoogleComputeRegionAutoscalerAutoscalingPolicyCpuUtilizationOutputReference | GoogleComputeRegionAutoscalerAutoscalingPolicyCpuUtilization): any;
export declare class GoogleComputeRegionAutoscalerAutoscalingPolicyCpuUtilizationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeRegionAutoscalerAutoscalingPolicyCpuUtilization | undefined;
    set internalValue(value: GoogleComputeRegionAutoscalerAutoscalingPolicyCpuUtilization | undefined);
    private _predictiveMethod?;
    get predictiveMethod(): string;
    set predictiveMethod(value: string);
    resetPredictiveMethod(): void;
    get predictiveMethodInput(): string | undefined;
    private _target?;
    get target(): number;
    set target(value: number);
    get targetInput(): number | undefined;
}
export interface GoogleComputeRegionAutoscalerAutoscalingPolicyLoadBalancingUtilization {
    /**
    * Fraction of backend capacity utilization (set in HTTP(s) load
  balancing configuration) that autoscaler should maintain. Must
  be a positive float value. If not defined, the default is 0.8.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_autoscaler#target GoogleComputeRegionAutoscaler#target}
    */
    readonly target: number;
}
export declare function googleComputeRegionAutoscalerAutoscalingPolicyLoadBalancingUtilizationToTerraform(struct?: GoogleComputeRegionAutoscalerAutoscalingPolicyLoadBalancingUtilizationOutputReference | GoogleComputeRegionAutoscalerAutoscalingPolicyLoadBalancingUtilization): any;
export declare class GoogleComputeRegionAutoscalerAutoscalingPolicyLoadBalancingUtilizationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeRegionAutoscalerAutoscalingPolicyLoadBalancingUtilization | undefined;
    set internalValue(value: GoogleComputeRegionAutoscalerAutoscalingPolicyLoadBalancingUtilization | undefined);
    private _target?;
    get target(): number;
    set target(value: number);
    get targetInput(): number | undefined;
}
export interface GoogleComputeRegionAutoscalerAutoscalingPolicyMetric {
    /**
    * A filter string to be used as the filter string for
  a Stackdriver Monitoring TimeSeries.list API call.
  This filter is used to select a specific TimeSeries for
  the purpose of autoscaling and to determine whether the metric
  is exporting per-instance or per-group data.
  
  You can only use the AND operator for joining selectors.
  You can only use direct equality comparison operator (=) without
  any functions for each selector.
  You can specify the metric in both the filter string and in the
  metric field. However, if specified in both places, the metric must
  be identical.
  
  The monitored resource type determines what kind of values are
  expected for the metric. If it is a gce_instance, the autoscaler
  expects the metric to include a separate TimeSeries for each
  instance in a group. In such a case, you cannot filter on resource
  labels.
  
  If the resource type is any other value, the autoscaler expects
  this metric to contain values that apply to the entire autoscaled
  instance group and resource label filtering can be performed to
  point autoscaler at the correct TimeSeries to scale upon.
  This is called a per-group metric for the purpose of autoscaling.
  
  If not specified, the type defaults to gce_instance.
  
  You should provide a filter that is selective enough to pick just
  one TimeSeries for the autoscaled group or for each of the instances
  (if you are using gce_instance resource type). If multiple
  TimeSeries are returned upon the query execution, the autoscaler
  will sum their respective values to obtain its scaling value.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_autoscaler#filter GoogleComputeRegionAutoscaler#filter}
    */
    readonly filter?: string;
    /**
    * The identifier (type) of the Stackdriver Monitoring metric.
  The metric cannot have negative values.
  
  The metric must have a value type of INT64 or DOUBLE.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_autoscaler#name GoogleComputeRegionAutoscaler#name}
    */
    readonly name: string;
    /**
    * If scaling is based on a per-group metric value that represents the
  total amount of work to be done or resource usage, set this value to
  an amount assigned for a single instance of the scaled group.
  The autoscaler will keep the number of instances proportional to the
  value of this metric, the metric itself should not change value due
  to group resizing.
  
  For example, a good metric to use with the target is
  'pubsub.googleapis.com/subscription/num_undelivered_messages'
  or a custom metric exporting the total number of requests coming to
  your instances.
  
  A bad example would be a metric exporting an average or median
  latency, since this value can't include a chunk assignable to a
  single instance, it could be better used with utilization_target
  instead.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_autoscaler#single_instance_assignment GoogleComputeRegionAutoscaler#single_instance_assignment}
    */
    readonly singleInstanceAssignment?: number;
    /**
    * The target value of the metric that autoscaler should
  maintain. This must be a positive value. A utilization
  metric scales number of virtual machines handling requests
  to increase or decrease proportionally to the metric.
  
  For example, a good metric to use as a utilizationTarget is
  www.googleapis.com/compute/instance/network/received_bytes_count.
  The autoscaler will work to keep this value constant for each
  of the instances.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_autoscaler#target GoogleComputeRegionAutoscaler#target}
    */
    readonly target?: number;
    /**
    * Defines how target utilization value is expressed for a
  Stackdriver Monitoring metric. Possible values: ["GAUGE", "DELTA_PER_SECOND", "DELTA_PER_MINUTE"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_autoscaler#type GoogleComputeRegionAutoscaler#type}
    */
    readonly type?: string;
}
export declare function googleComputeRegionAutoscalerAutoscalingPolicyMetricToTerraform(struct?: GoogleComputeRegionAutoscalerAutoscalingPolicyMetric | cdktf.IResolvable): any;
export declare class GoogleComputeRegionAutoscalerAutoscalingPolicyMetricOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleComputeRegionAutoscalerAutoscalingPolicyMetric | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleComputeRegionAutoscalerAutoscalingPolicyMetric | cdktf.IResolvable | undefined);
    private _filter?;
    get filter(): string;
    set filter(value: string);
    resetFilter(): void;
    get filterInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _singleInstanceAssignment?;
    get singleInstanceAssignment(): number;
    set singleInstanceAssignment(value: number);
    resetSingleInstanceAssignment(): void;
    get singleInstanceAssignmentInput(): number | undefined;
    private _target?;
    get target(): number;
    set target(value: number);
    resetTarget(): void;
    get targetInput(): number | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
}
export declare class GoogleComputeRegionAutoscalerAutoscalingPolicyMetricList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleComputeRegionAutoscalerAutoscalingPolicyMetric[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleComputeRegionAutoscalerAutoscalingPolicyMetricOutputReference;
}
export interface GoogleComputeRegionAutoscalerAutoscalingPolicyScaleDownControlMaxScaledDownReplicas {
    /**
    * Specifies a fixed number of VM instances. This must be a positive
  integer.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_autoscaler#fixed GoogleComputeRegionAutoscaler#fixed}
    */
    readonly fixed?: number;
    /**
    * Specifies a percentage of instances between 0 to 100%, inclusive.
  For example, specify 80 for 80%.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_autoscaler#percent GoogleComputeRegionAutoscaler#percent}
    */
    readonly percent?: number;
}
export declare function googleComputeRegionAutoscalerAutoscalingPolicyScaleDownControlMaxScaledDownReplicasToTerraform(struct?: GoogleComputeRegionAutoscalerAutoscalingPolicyScaleDownControlMaxScaledDownReplicasOutputReference | GoogleComputeRegionAutoscalerAutoscalingPolicyScaleDownControlMaxScaledDownReplicas): any;
export declare class GoogleComputeRegionAutoscalerAutoscalingPolicyScaleDownControlMaxScaledDownReplicasOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeRegionAutoscalerAutoscalingPolicyScaleDownControlMaxScaledDownReplicas | undefined;
    set internalValue(value: GoogleComputeRegionAutoscalerAutoscalingPolicyScaleDownControlMaxScaledDownReplicas | undefined);
    private _fixed?;
    get fixed(): number;
    set fixed(value: number);
    resetFixed(): void;
    get fixedInput(): number | undefined;
    private _percent?;
    get percent(): number;
    set percent(value: number);
    resetPercent(): void;
    get percentInput(): number | undefined;
}
export interface GoogleComputeRegionAutoscalerAutoscalingPolicyScaleDownControl {
    /**
    * How long back autoscaling should look when computing recommendations
  to include directives regarding slower scale down, as described above.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_autoscaler#time_window_sec GoogleComputeRegionAutoscaler#time_window_sec}
    */
    readonly timeWindowSec?: number;
    /**
    * max_scaled_down_replicas block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_autoscaler#max_scaled_down_replicas GoogleComputeRegionAutoscaler#max_scaled_down_replicas}
    */
    readonly maxScaledDownReplicas?: GoogleComputeRegionAutoscalerAutoscalingPolicyScaleDownControlMaxScaledDownReplicas;
}
export declare function googleComputeRegionAutoscalerAutoscalingPolicyScaleDownControlToTerraform(struct?: GoogleComputeRegionAutoscalerAutoscalingPolicyScaleDownControlOutputReference | GoogleComputeRegionAutoscalerAutoscalingPolicyScaleDownControl): any;
export declare class GoogleComputeRegionAutoscalerAutoscalingPolicyScaleDownControlOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeRegionAutoscalerAutoscalingPolicyScaleDownControl | undefined;
    set internalValue(value: GoogleComputeRegionAutoscalerAutoscalingPolicyScaleDownControl | undefined);
    private _timeWindowSec?;
    get timeWindowSec(): number;
    set timeWindowSec(value: number);
    resetTimeWindowSec(): void;
    get timeWindowSecInput(): number | undefined;
    private _maxScaledDownReplicas;
    get maxScaledDownReplicas(): GoogleComputeRegionAutoscalerAutoscalingPolicyScaleDownControlMaxScaledDownReplicasOutputReference;
    putMaxScaledDownReplicas(value: GoogleComputeRegionAutoscalerAutoscalingPolicyScaleDownControlMaxScaledDownReplicas): void;
    resetMaxScaledDownReplicas(): void;
    get maxScaledDownReplicasInput(): GoogleComputeRegionAutoscalerAutoscalingPolicyScaleDownControlMaxScaledDownReplicas | undefined;
}
export interface GoogleComputeRegionAutoscalerAutoscalingPolicyScaleInControlMaxScaledInReplicas {
    /**
    * Specifies a fixed number of VM instances. This must be a positive
  integer.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_autoscaler#fixed GoogleComputeRegionAutoscaler#fixed}
    */
    readonly fixed?: number;
    /**
    * Specifies a percentage of instances between 0 to 100%, inclusive.
  For example, specify 80 for 80%.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_autoscaler#percent GoogleComputeRegionAutoscaler#percent}
    */
    readonly percent?: number;
}
export declare function googleComputeRegionAutoscalerAutoscalingPolicyScaleInControlMaxScaledInReplicasToTerraform(struct?: GoogleComputeRegionAutoscalerAutoscalingPolicyScaleInControlMaxScaledInReplicasOutputReference | GoogleComputeRegionAutoscalerAutoscalingPolicyScaleInControlMaxScaledInReplicas): any;
export declare class GoogleComputeRegionAutoscalerAutoscalingPolicyScaleInControlMaxScaledInReplicasOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeRegionAutoscalerAutoscalingPolicyScaleInControlMaxScaledInReplicas | undefined;
    set internalValue(value: GoogleComputeRegionAutoscalerAutoscalingPolicyScaleInControlMaxScaledInReplicas | undefined);
    private _fixed?;
    get fixed(): number;
    set fixed(value: number);
    resetFixed(): void;
    get fixedInput(): number | undefined;
    private _percent?;
    get percent(): number;
    set percent(value: number);
    resetPercent(): void;
    get percentInput(): number | undefined;
}
export interface GoogleComputeRegionAutoscalerAutoscalingPolicyScaleInControl {
    /**
    * How long back autoscaling should look when computing recommendations
  to include directives regarding slower scale down, as described above.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_autoscaler#time_window_sec GoogleComputeRegionAutoscaler#time_window_sec}
    */
    readonly timeWindowSec?: number;
    /**
    * max_scaled_in_replicas block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_autoscaler#max_scaled_in_replicas GoogleComputeRegionAutoscaler#max_scaled_in_replicas}
    */
    readonly maxScaledInReplicas?: GoogleComputeRegionAutoscalerAutoscalingPolicyScaleInControlMaxScaledInReplicas;
}
export declare function googleComputeRegionAutoscalerAutoscalingPolicyScaleInControlToTerraform(struct?: GoogleComputeRegionAutoscalerAutoscalingPolicyScaleInControlOutputReference | GoogleComputeRegionAutoscalerAutoscalingPolicyScaleInControl): any;
export declare class GoogleComputeRegionAutoscalerAutoscalingPolicyScaleInControlOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeRegionAutoscalerAutoscalingPolicyScaleInControl | undefined;
    set internalValue(value: GoogleComputeRegionAutoscalerAutoscalingPolicyScaleInControl | undefined);
    private _timeWindowSec?;
    get timeWindowSec(): number;
    set timeWindowSec(value: number);
    resetTimeWindowSec(): void;
    get timeWindowSecInput(): number | undefined;
    private _maxScaledInReplicas;
    get maxScaledInReplicas(): GoogleComputeRegionAutoscalerAutoscalingPolicyScaleInControlMaxScaledInReplicasOutputReference;
    putMaxScaledInReplicas(value: GoogleComputeRegionAutoscalerAutoscalingPolicyScaleInControlMaxScaledInReplicas): void;
    resetMaxScaledInReplicas(): void;
    get maxScaledInReplicasInput(): GoogleComputeRegionAutoscalerAutoscalingPolicyScaleInControlMaxScaledInReplicas | undefined;
}
export interface GoogleComputeRegionAutoscalerAutoscalingPolicyScalingSchedules {
    /**
    * A description of a scaling schedule.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_autoscaler#description GoogleComputeRegionAutoscaler#description}
    */
    readonly description?: string;
    /**
    * A boolean value that specifies if a scaling schedule can influence autoscaler recommendations. If set to true, then a scaling schedule has no effect.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_autoscaler#disabled GoogleComputeRegionAutoscaler#disabled}
    */
    readonly disabled?: boolean | cdktf.IResolvable;
    /**
    * The duration of time intervals (in seconds) for which this scaling schedule will be running. The minimum allowed value is 300.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_autoscaler#duration_sec GoogleComputeRegionAutoscaler#duration_sec}
    */
    readonly durationSec: number;
    /**
    * Minimum number of VM instances that autoscaler will recommend in time intervals starting according to schedule.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_autoscaler#min_required_replicas GoogleComputeRegionAutoscaler#min_required_replicas}
    */
    readonly minRequiredReplicas: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_autoscaler#name GoogleComputeRegionAutoscaler#name}
    */
    readonly name: string;
    /**
    * The start timestamps of time intervals when this scaling schedule should provide a scaling signal. This field uses the extended cron format (with an optional year field).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_autoscaler#schedule GoogleComputeRegionAutoscaler#schedule}
    */
    readonly schedule: string;
    /**
    * The time zone to be used when interpreting the schedule. The value of this field must be a time zone name from the tz database: http://en.wikipedia.org/wiki/Tz_database.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_autoscaler#time_zone GoogleComputeRegionAutoscaler#time_zone}
    */
    readonly timeZone?: string;
}
export declare function googleComputeRegionAutoscalerAutoscalingPolicyScalingSchedulesToTerraform(struct?: GoogleComputeRegionAutoscalerAutoscalingPolicyScalingSchedules | cdktf.IResolvable): any;
export declare class GoogleComputeRegionAutoscalerAutoscalingPolicyScalingSchedulesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleComputeRegionAutoscalerAutoscalingPolicyScalingSchedules | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleComputeRegionAutoscalerAutoscalingPolicyScalingSchedules | cdktf.IResolvable | undefined);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _disabled?;
    get disabled(): boolean | cdktf.IResolvable;
    set disabled(value: boolean | cdktf.IResolvable);
    resetDisabled(): void;
    get disabledInput(): boolean | cdktf.IResolvable | undefined;
    private _durationSec?;
    get durationSec(): number;
    set durationSec(value: number);
    get durationSecInput(): number | undefined;
    private _minRequiredReplicas?;
    get minRequiredReplicas(): number;
    set minRequiredReplicas(value: number);
    get minRequiredReplicasInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _schedule?;
    get schedule(): string;
    set schedule(value: string);
    get scheduleInput(): string | undefined;
    private _timeZone?;
    get timeZone(): string;
    set timeZone(value: string);
    resetTimeZone(): void;
    get timeZoneInput(): string | undefined;
}
export declare class GoogleComputeRegionAutoscalerAutoscalingPolicyScalingSchedulesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleComputeRegionAutoscalerAutoscalingPolicyScalingSchedules[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleComputeRegionAutoscalerAutoscalingPolicyScalingSchedulesOutputReference;
}
export interface GoogleComputeRegionAutoscalerAutoscalingPolicy {
    /**
    * The number of seconds that the autoscaler should wait before it
  starts collecting information from a new instance. This prevents
  the autoscaler from collecting information when the instance is
  initializing, during which the collected usage would not be
  reliable. The default time autoscaler waits is 60 seconds.
  
  Virtual machine initialization times might vary because of
  numerous factors. We recommend that you test how long an
  instance may take to initialize. To do this, create an instance
  and time the startup process.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_autoscaler#cooldown_period GoogleComputeRegionAutoscaler#cooldown_period}
    */
    readonly cooldownPeriod?: number;
    /**
    * The maximum number of instances that the autoscaler can scale up
  to. This is required when creating or updating an autoscaler. The
  maximum number of replicas should not be lower than minimal number
  of replicas.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_autoscaler#max_replicas GoogleComputeRegionAutoscaler#max_replicas}
    */
    readonly maxReplicas: number;
    /**
    * The minimum number of replicas that the autoscaler can scale down
  to. This cannot be less than 0. If not provided, autoscaler will
  choose a default value depending on maximum number of instances
  allowed.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_autoscaler#min_replicas GoogleComputeRegionAutoscaler#min_replicas}
    */
    readonly minReplicas: number;
    /**
    * Defines operating mode for this policy. Default value: "ON" Possible values: ["OFF", "ONLY_UP", "ON"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_autoscaler#mode GoogleComputeRegionAutoscaler#mode}
    */
    readonly mode?: string;
    /**
    * cpu_utilization block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_autoscaler#cpu_utilization GoogleComputeRegionAutoscaler#cpu_utilization}
    */
    readonly cpuUtilization?: GoogleComputeRegionAutoscalerAutoscalingPolicyCpuUtilization;
    /**
    * load_balancing_utilization block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_autoscaler#load_balancing_utilization GoogleComputeRegionAutoscaler#load_balancing_utilization}
    */
    readonly loadBalancingUtilization?: GoogleComputeRegionAutoscalerAutoscalingPolicyLoadBalancingUtilization;
    /**
    * metric block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_autoscaler#metric GoogleComputeRegionAutoscaler#metric}
    */
    readonly metric?: GoogleComputeRegionAutoscalerAutoscalingPolicyMetric[] | cdktf.IResolvable;
    /**
    * scale_down_control block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_autoscaler#scale_down_control GoogleComputeRegionAutoscaler#scale_down_control}
    */
    readonly scaleDownControl?: GoogleComputeRegionAutoscalerAutoscalingPolicyScaleDownControl;
    /**
    * scale_in_control block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_autoscaler#scale_in_control GoogleComputeRegionAutoscaler#scale_in_control}
    */
    readonly scaleInControl?: GoogleComputeRegionAutoscalerAutoscalingPolicyScaleInControl;
    /**
    * scaling_schedules block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_autoscaler#scaling_schedules GoogleComputeRegionAutoscaler#scaling_schedules}
    */
    readonly scalingSchedules?: GoogleComputeRegionAutoscalerAutoscalingPolicyScalingSchedules[] | cdktf.IResolvable;
}
export declare function googleComputeRegionAutoscalerAutoscalingPolicyToTerraform(struct?: GoogleComputeRegionAutoscalerAutoscalingPolicyOutputReference | GoogleComputeRegionAutoscalerAutoscalingPolicy): any;
export declare class GoogleComputeRegionAutoscalerAutoscalingPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeRegionAutoscalerAutoscalingPolicy | undefined;
    set internalValue(value: GoogleComputeRegionAutoscalerAutoscalingPolicy | undefined);
    private _cooldownPeriod?;
    get cooldownPeriod(): number;
    set cooldownPeriod(value: number);
    resetCooldownPeriod(): void;
    get cooldownPeriodInput(): number | undefined;
    private _maxReplicas?;
    get maxReplicas(): number;
    set maxReplicas(value: number);
    get maxReplicasInput(): number | undefined;
    private _minReplicas?;
    get minReplicas(): number;
    set minReplicas(value: number);
    get minReplicasInput(): number | undefined;
    private _mode?;
    get mode(): string;
    set mode(value: string);
    resetMode(): void;
    get modeInput(): string | undefined;
    private _cpuUtilization;
    get cpuUtilization(): GoogleComputeRegionAutoscalerAutoscalingPolicyCpuUtilizationOutputReference;
    putCpuUtilization(value: GoogleComputeRegionAutoscalerAutoscalingPolicyCpuUtilization): void;
    resetCpuUtilization(): void;
    get cpuUtilizationInput(): GoogleComputeRegionAutoscalerAutoscalingPolicyCpuUtilization | undefined;
    private _loadBalancingUtilization;
    get loadBalancingUtilization(): GoogleComputeRegionAutoscalerAutoscalingPolicyLoadBalancingUtilizationOutputReference;
    putLoadBalancingUtilization(value: GoogleComputeRegionAutoscalerAutoscalingPolicyLoadBalancingUtilization): void;
    resetLoadBalancingUtilization(): void;
    get loadBalancingUtilizationInput(): GoogleComputeRegionAutoscalerAutoscalingPolicyLoadBalancingUtilization | undefined;
    private _metric;
    get metric(): GoogleComputeRegionAutoscalerAutoscalingPolicyMetricList;
    putMetric(value: GoogleComputeRegionAutoscalerAutoscalingPolicyMetric[] | cdktf.IResolvable): void;
    resetMetric(): void;
    get metricInput(): cdktf.IResolvable | GoogleComputeRegionAutoscalerAutoscalingPolicyMetric[] | undefined;
    private _scaleDownControl;
    get scaleDownControl(): GoogleComputeRegionAutoscalerAutoscalingPolicyScaleDownControlOutputReference;
    putScaleDownControl(value: GoogleComputeRegionAutoscalerAutoscalingPolicyScaleDownControl): void;
    resetScaleDownControl(): void;
    get scaleDownControlInput(): GoogleComputeRegionAutoscalerAutoscalingPolicyScaleDownControl | undefined;
    private _scaleInControl;
    get scaleInControl(): GoogleComputeRegionAutoscalerAutoscalingPolicyScaleInControlOutputReference;
    putScaleInControl(value: GoogleComputeRegionAutoscalerAutoscalingPolicyScaleInControl): void;
    resetScaleInControl(): void;
    get scaleInControlInput(): GoogleComputeRegionAutoscalerAutoscalingPolicyScaleInControl | undefined;
    private _scalingSchedules;
    get scalingSchedules(): GoogleComputeRegionAutoscalerAutoscalingPolicyScalingSchedulesList;
    putScalingSchedules(value: GoogleComputeRegionAutoscalerAutoscalingPolicyScalingSchedules[] | cdktf.IResolvable): void;
    resetScalingSchedules(): void;
    get scalingSchedulesInput(): cdktf.IResolvable | GoogleComputeRegionAutoscalerAutoscalingPolicyScalingSchedules[] | undefined;
}
export interface GoogleComputeRegionAutoscalerTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_autoscaler#create GoogleComputeRegionAutoscaler#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_autoscaler#delete GoogleComputeRegionAutoscaler#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_autoscaler#update GoogleComputeRegionAutoscaler#update}
    */
    readonly update?: string;
}
export declare function googleComputeRegionAutoscalerTimeoutsToTerraform(struct?: GoogleComputeRegionAutoscalerTimeoutsOutputReference | GoogleComputeRegionAutoscalerTimeouts | cdktf.IResolvable): any;
export declare class GoogleComputeRegionAutoscalerTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeRegionAutoscalerTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleComputeRegionAutoscalerTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_autoscaler google_compute_region_autoscaler}
*/
export declare class GoogleComputeRegionAutoscaler extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_compute_region_autoscaler";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_autoscaler google_compute_region_autoscaler} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleComputeRegionAutoscalerConfig
    */
    constructor(scope: Construct, id: string, config: GoogleComputeRegionAutoscalerConfig);
    get creationTimestamp(): string;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    get selfLink(): string;
    private _target?;
    get target(): string;
    set target(value: string);
    get targetInput(): string | undefined;
    private _autoscalingPolicy;
    get autoscalingPolicy(): GoogleComputeRegionAutoscalerAutoscalingPolicyOutputReference;
    putAutoscalingPolicy(value: GoogleComputeRegionAutoscalerAutoscalingPolicy): void;
    get autoscalingPolicyInput(): GoogleComputeRegionAutoscalerAutoscalingPolicy | undefined;
    private _timeouts;
    get timeouts(): GoogleComputeRegionAutoscalerTimeoutsOutputReference;
    putTimeouts(value: GoogleComputeRegionAutoscalerTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleComputeRegionAutoscalerTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
