import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleComputeRegionDiskResourcePolicyAttachmentConfig extends cdktf.TerraformMetaArguments {
    /**
    * The name of the regional disk in which the resource policies are attached to.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_disk_resource_policy_attachment#disk GoogleComputeRegionDiskResourcePolicyAttachment#disk}
    */
    readonly disk: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_disk_resource_policy_attachment#id GoogleComputeRegionDiskResourcePolicyAttachment#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The resource policy to be attached to the disk for scheduling snapshot
  creation. Do not specify the self link.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_disk_resource_policy_attachment#name GoogleComputeRegionDiskResourcePolicyAttachment#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_disk_resource_policy_attachment#project GoogleComputeRegionDiskResourcePolicyAttachment#project}
    */
    readonly project?: string;
    /**
    * A reference to the region where the disk resides.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_disk_resource_policy_attachment#region GoogleComputeRegionDiskResourcePolicyAttachment#region}
    */
    readonly region?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_disk_resource_policy_attachment#timeouts GoogleComputeRegionDiskResourcePolicyAttachment#timeouts}
    */
    readonly timeouts?: GoogleComputeRegionDiskResourcePolicyAttachmentTimeouts;
}
export interface GoogleComputeRegionDiskResourcePolicyAttachmentTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_disk_resource_policy_attachment#create GoogleComputeRegionDiskResourcePolicyAttachment#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_disk_resource_policy_attachment#delete GoogleComputeRegionDiskResourcePolicyAttachment#delete}
    */
    readonly delete?: string;
}
export declare function googleComputeRegionDiskResourcePolicyAttachmentTimeoutsToTerraform(struct?: GoogleComputeRegionDiskResourcePolicyAttachmentTimeoutsOutputReference | GoogleComputeRegionDiskResourcePolicyAttachmentTimeouts | cdktf.IResolvable): any;
export declare class GoogleComputeRegionDiskResourcePolicyAttachmentTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeRegionDiskResourcePolicyAttachmentTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleComputeRegionDiskResourcePolicyAttachmentTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_disk_resource_policy_attachment google_compute_region_disk_resource_policy_attachment}
*/
export declare class GoogleComputeRegionDiskResourcePolicyAttachment extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_compute_region_disk_resource_policy_attachment";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_disk_resource_policy_attachment google_compute_region_disk_resource_policy_attachment} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleComputeRegionDiskResourcePolicyAttachmentConfig
    */
    constructor(scope: Construct, id: string, config: GoogleComputeRegionDiskResourcePolicyAttachmentConfig);
    private _disk?;
    get disk(): string;
    set disk(value: string);
    get diskInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    private _timeouts;
    get timeouts(): GoogleComputeRegionDiskResourcePolicyAttachmentTimeoutsOutputReference;
    putTimeouts(value: GoogleComputeRegionDiskResourcePolicyAttachmentTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleComputeRegionDiskResourcePolicyAttachmentTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
