import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleComputeRegionInstanceGroupManagerConfig extends cdktf.TerraformMetaArguments {
    /**
    * The base instance name to use for instances in this group. The value must be a valid RFC1035 name. Supported characters are lowercase letters, numbers, and hyphens (-). Instances are named by appending a hyphen and a random four-character string to the base instance name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_instance_group_manager#base_instance_name GoogleComputeRegionInstanceGroupManager#base_instance_name}
    */
    readonly baseInstanceName: string;
    /**
    * An optional textual description of the instance group manager.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_instance_group_manager#description GoogleComputeRegionInstanceGroupManager#description}
    */
    readonly description?: string;
    /**
    * The shape to which the group converges either proactively or on resize events (depending on the value set in updatePolicy.instanceRedistributionType).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_instance_group_manager#distribution_policy_target_shape GoogleComputeRegionInstanceGroupManager#distribution_policy_target_shape}
    */
    readonly distributionPolicyTargetShape?: string;
    /**
    * The distribution policy for this managed instance group. You can specify one or more values.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_instance_group_manager#distribution_policy_zones GoogleComputeRegionInstanceGroupManager#distribution_policy_zones}
    */
    readonly distributionPolicyZones?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_instance_group_manager#id GoogleComputeRegionInstanceGroupManager#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The name of the instance group manager. Must be 1-63 characters long and comply with RFC1035. Supported characters include lowercase letters, numbers, and hyphens.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_instance_group_manager#name GoogleComputeRegionInstanceGroupManager#name}
    */
    readonly name: string;
    /**
    * The ID of the project in which the resource belongs. If it is not provided, the provider project is used.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_instance_group_manager#project GoogleComputeRegionInstanceGroupManager#project}
    */
    readonly project?: string;
    /**
    * The region where the managed instance group resides.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_instance_group_manager#region GoogleComputeRegionInstanceGroupManager#region}
    */
    readonly region?: string;
    /**
    * The full URL of all target pools to which new instances in the group are added. Updating the target pools attribute does not affect existing instances.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_instance_group_manager#target_pools GoogleComputeRegionInstanceGroupManager#target_pools}
    */
    readonly targetPools?: string[];
    /**
    * The target number of running instances for this managed instance group. This value should always be explicitly set unless this resource is attached to an autoscaler, in which case it should never be set. Defaults to 0.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_instance_group_manager#target_size GoogleComputeRegionInstanceGroupManager#target_size}
    */
    readonly targetSize?: number;
    /**
    * Whether to wait for all instances to be created/updated before returning. Note that if this is set to true and the operation does not succeed, Terraform will continue trying until it times out.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_instance_group_manager#wait_for_instances GoogleComputeRegionInstanceGroupManager#wait_for_instances}
    */
    readonly waitForInstances?: boolean | cdktf.IResolvable;
    /**
    * When used with wait_for_instances specifies the status to wait for. When STABLE is specified this resource will wait until the instances are stable before returning. When UPDATED is set, it will wait for the version target to be reached and any per instance configs to be effective and all instances configs to be effective as well as all instances to be stable before returning.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_instance_group_manager#wait_for_instances_status GoogleComputeRegionInstanceGroupManager#wait_for_instances_status}
    */
    readonly waitForInstancesStatus?: string;
    /**
    * all_instances_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_instance_group_manager#all_instances_config GoogleComputeRegionInstanceGroupManager#all_instances_config}
    */
    readonly allInstancesConfig?: GoogleComputeRegionInstanceGroupManagerAllInstancesConfig;
    /**
    * auto_healing_policies block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_instance_group_manager#auto_healing_policies GoogleComputeRegionInstanceGroupManager#auto_healing_policies}
    */
    readonly autoHealingPolicies?: GoogleComputeRegionInstanceGroupManagerAutoHealingPolicies;
    /**
    * named_port block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_instance_group_manager#named_port GoogleComputeRegionInstanceGroupManager#named_port}
    */
    readonly namedPort?: GoogleComputeRegionInstanceGroupManagerNamedPort[] | cdktf.IResolvable;
    /**
    * stateful_disk block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_instance_group_manager#stateful_disk GoogleComputeRegionInstanceGroupManager#stateful_disk}
    */
    readonly statefulDisk?: GoogleComputeRegionInstanceGroupManagerStatefulDisk[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_instance_group_manager#timeouts GoogleComputeRegionInstanceGroupManager#timeouts}
    */
    readonly timeouts?: GoogleComputeRegionInstanceGroupManagerTimeouts;
    /**
    * update_policy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_instance_group_manager#update_policy GoogleComputeRegionInstanceGroupManager#update_policy}
    */
    readonly updatePolicy?: GoogleComputeRegionInstanceGroupManagerUpdatePolicy;
    /**
    * version block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_instance_group_manager#version GoogleComputeRegionInstanceGroupManager#version}
    */
    readonly version: GoogleComputeRegionInstanceGroupManagerVersion[] | cdktf.IResolvable;
}
export interface GoogleComputeRegionInstanceGroupManagerStatusAllInstancesConfig {
}
export declare function googleComputeRegionInstanceGroupManagerStatusAllInstancesConfigToTerraform(struct?: GoogleComputeRegionInstanceGroupManagerStatusAllInstancesConfig): any;
export declare class GoogleComputeRegionInstanceGroupManagerStatusAllInstancesConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleComputeRegionInstanceGroupManagerStatusAllInstancesConfig | undefined;
    set internalValue(value: GoogleComputeRegionInstanceGroupManagerStatusAllInstancesConfig | undefined);
    get effective(): cdktf.IResolvable;
}
export declare class GoogleComputeRegionInstanceGroupManagerStatusAllInstancesConfigList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleComputeRegionInstanceGroupManagerStatusAllInstancesConfigOutputReference;
}
export interface GoogleComputeRegionInstanceGroupManagerStatusStatefulPerInstanceConfigs {
}
export declare function googleComputeRegionInstanceGroupManagerStatusStatefulPerInstanceConfigsToTerraform(struct?: GoogleComputeRegionInstanceGroupManagerStatusStatefulPerInstanceConfigs): any;
export declare class GoogleComputeRegionInstanceGroupManagerStatusStatefulPerInstanceConfigsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleComputeRegionInstanceGroupManagerStatusStatefulPerInstanceConfigs | undefined;
    set internalValue(value: GoogleComputeRegionInstanceGroupManagerStatusStatefulPerInstanceConfigs | undefined);
    get allEffective(): cdktf.IResolvable;
}
export declare class GoogleComputeRegionInstanceGroupManagerStatusStatefulPerInstanceConfigsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleComputeRegionInstanceGroupManagerStatusStatefulPerInstanceConfigsOutputReference;
}
export interface GoogleComputeRegionInstanceGroupManagerStatusStateful {
}
export declare function googleComputeRegionInstanceGroupManagerStatusStatefulToTerraform(struct?: GoogleComputeRegionInstanceGroupManagerStatusStateful): any;
export declare class GoogleComputeRegionInstanceGroupManagerStatusStatefulOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleComputeRegionInstanceGroupManagerStatusStateful | undefined;
    set internalValue(value: GoogleComputeRegionInstanceGroupManagerStatusStateful | undefined);
    get hasStatefulConfig(): cdktf.IResolvable;
    private _perInstanceConfigs;
    get perInstanceConfigs(): GoogleComputeRegionInstanceGroupManagerStatusStatefulPerInstanceConfigsList;
}
export declare class GoogleComputeRegionInstanceGroupManagerStatusStatefulList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleComputeRegionInstanceGroupManagerStatusStatefulOutputReference;
}
export interface GoogleComputeRegionInstanceGroupManagerStatusVersionTarget {
}
export declare function googleComputeRegionInstanceGroupManagerStatusVersionTargetToTerraform(struct?: GoogleComputeRegionInstanceGroupManagerStatusVersionTarget): any;
export declare class GoogleComputeRegionInstanceGroupManagerStatusVersionTargetOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleComputeRegionInstanceGroupManagerStatusVersionTarget | undefined;
    set internalValue(value: GoogleComputeRegionInstanceGroupManagerStatusVersionTarget | undefined);
    get isReached(): cdktf.IResolvable;
}
export declare class GoogleComputeRegionInstanceGroupManagerStatusVersionTargetList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleComputeRegionInstanceGroupManagerStatusVersionTargetOutputReference;
}
export interface GoogleComputeRegionInstanceGroupManagerStatus {
}
export declare function googleComputeRegionInstanceGroupManagerStatusToTerraform(struct?: GoogleComputeRegionInstanceGroupManagerStatus): any;
export declare class GoogleComputeRegionInstanceGroupManagerStatusOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleComputeRegionInstanceGroupManagerStatus | undefined;
    set internalValue(value: GoogleComputeRegionInstanceGroupManagerStatus | undefined);
    private _allInstancesConfig;
    get allInstancesConfig(): GoogleComputeRegionInstanceGroupManagerStatusAllInstancesConfigList;
    get isStable(): cdktf.IResolvable;
    private _stateful;
    get stateful(): GoogleComputeRegionInstanceGroupManagerStatusStatefulList;
    private _versionTarget;
    get versionTarget(): GoogleComputeRegionInstanceGroupManagerStatusVersionTargetList;
}
export declare class GoogleComputeRegionInstanceGroupManagerStatusList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleComputeRegionInstanceGroupManagerStatusOutputReference;
}
export interface GoogleComputeRegionInstanceGroupManagerAllInstancesConfig {
    /**
    * The label key-value pairs that you want to patch onto the instance,
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_instance_group_manager#labels GoogleComputeRegionInstanceGroupManager#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * The metadata key-value pairs that you want to patch onto the instance. For more information, see Project and instance metadata,
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_instance_group_manager#metadata GoogleComputeRegionInstanceGroupManager#metadata}
    */
    readonly metadata?: {
        [key: string]: string;
    };
}
export declare function googleComputeRegionInstanceGroupManagerAllInstancesConfigToTerraform(struct?: GoogleComputeRegionInstanceGroupManagerAllInstancesConfigOutputReference | GoogleComputeRegionInstanceGroupManagerAllInstancesConfig): any;
export declare class GoogleComputeRegionInstanceGroupManagerAllInstancesConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeRegionInstanceGroupManagerAllInstancesConfig | undefined;
    set internalValue(value: GoogleComputeRegionInstanceGroupManagerAllInstancesConfig | undefined);
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _metadata?;
    get metadata(): {
        [key: string]: string;
    };
    set metadata(value: {
        [key: string]: string;
    });
    resetMetadata(): void;
    get metadataInput(): {
        [key: string]: string;
    } | undefined;
}
export interface GoogleComputeRegionInstanceGroupManagerAutoHealingPolicies {
    /**
    * The health check resource that signals autohealing.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_instance_group_manager#health_check GoogleComputeRegionInstanceGroupManager#health_check}
    */
    readonly healthCheck: string;
    /**
    * The number of seconds that the managed instance group waits before it applies autohealing policies to new instances or recently recreated instances. Between 0 and 3600.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_instance_group_manager#initial_delay_sec GoogleComputeRegionInstanceGroupManager#initial_delay_sec}
    */
    readonly initialDelaySec: number;
}
export declare function googleComputeRegionInstanceGroupManagerAutoHealingPoliciesToTerraform(struct?: GoogleComputeRegionInstanceGroupManagerAutoHealingPoliciesOutputReference | GoogleComputeRegionInstanceGroupManagerAutoHealingPolicies): any;
export declare class GoogleComputeRegionInstanceGroupManagerAutoHealingPoliciesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeRegionInstanceGroupManagerAutoHealingPolicies | undefined;
    set internalValue(value: GoogleComputeRegionInstanceGroupManagerAutoHealingPolicies | undefined);
    private _healthCheck?;
    get healthCheck(): string;
    set healthCheck(value: string);
    get healthCheckInput(): string | undefined;
    private _initialDelaySec?;
    get initialDelaySec(): number;
    set initialDelaySec(value: number);
    get initialDelaySecInput(): number | undefined;
}
export interface GoogleComputeRegionInstanceGroupManagerNamedPort {
    /**
    * The name of the port.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_instance_group_manager#name GoogleComputeRegionInstanceGroupManager#name}
    */
    readonly name: string;
    /**
    * The port number.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_instance_group_manager#port GoogleComputeRegionInstanceGroupManager#port}
    */
    readonly port: number;
}
export declare function googleComputeRegionInstanceGroupManagerNamedPortToTerraform(struct?: GoogleComputeRegionInstanceGroupManagerNamedPort | cdktf.IResolvable): any;
export declare class GoogleComputeRegionInstanceGroupManagerNamedPortOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleComputeRegionInstanceGroupManagerNamedPort | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleComputeRegionInstanceGroupManagerNamedPort | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _port?;
    get port(): number;
    set port(value: number);
    get portInput(): number | undefined;
}
export declare class GoogleComputeRegionInstanceGroupManagerNamedPortList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleComputeRegionInstanceGroupManagerNamedPort[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleComputeRegionInstanceGroupManagerNamedPortOutputReference;
}
export interface GoogleComputeRegionInstanceGroupManagerStatefulDisk {
    /**
    * A value that prescribes what should happen to the stateful disk when the VM instance is deleted. The available options are NEVER and ON_PERMANENT_INSTANCE_DELETION. NEVER - detach the disk when the VM is deleted, but do not delete the disk. ON_PERMANENT_INSTANCE_DELETION will delete the stateful disk when the VM is permanently deleted from the instance group. The default is NEVER.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_instance_group_manager#delete_rule GoogleComputeRegionInstanceGroupManager#delete_rule}
    */
    readonly deleteRule?: string;
    /**
    * The device name of the disk to be attached.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_instance_group_manager#device_name GoogleComputeRegionInstanceGroupManager#device_name}
    */
    readonly deviceName: string;
}
export declare function googleComputeRegionInstanceGroupManagerStatefulDiskToTerraform(struct?: GoogleComputeRegionInstanceGroupManagerStatefulDisk | cdktf.IResolvable): any;
export declare class GoogleComputeRegionInstanceGroupManagerStatefulDiskOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleComputeRegionInstanceGroupManagerStatefulDisk | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleComputeRegionInstanceGroupManagerStatefulDisk | cdktf.IResolvable | undefined);
    private _deleteRule?;
    get deleteRule(): string;
    set deleteRule(value: string);
    resetDeleteRule(): void;
    get deleteRuleInput(): string | undefined;
    private _deviceName?;
    get deviceName(): string;
    set deviceName(value: string);
    get deviceNameInput(): string | undefined;
}
export declare class GoogleComputeRegionInstanceGroupManagerStatefulDiskList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleComputeRegionInstanceGroupManagerStatefulDisk[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleComputeRegionInstanceGroupManagerStatefulDiskOutputReference;
}
export interface GoogleComputeRegionInstanceGroupManagerTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_instance_group_manager#create GoogleComputeRegionInstanceGroupManager#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_instance_group_manager#delete GoogleComputeRegionInstanceGroupManager#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_instance_group_manager#update GoogleComputeRegionInstanceGroupManager#update}
    */
    readonly update?: string;
}
export declare function googleComputeRegionInstanceGroupManagerTimeoutsToTerraform(struct?: GoogleComputeRegionInstanceGroupManagerTimeoutsOutputReference | GoogleComputeRegionInstanceGroupManagerTimeouts | cdktf.IResolvable): any;
export declare class GoogleComputeRegionInstanceGroupManagerTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeRegionInstanceGroupManagerTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleComputeRegionInstanceGroupManagerTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
export interface GoogleComputeRegionInstanceGroupManagerUpdatePolicy {
    /**
    * The instance redistribution policy for regional managed instance groups. Valid values are: "PROACTIVE", "NONE". If PROACTIVE (default), the group attempts to maintain an even distribution of VM instances across zones in the region. If NONE, proactive redistribution is disabled.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_instance_group_manager#instance_redistribution_type GoogleComputeRegionInstanceGroupManager#instance_redistribution_type}
    */
    readonly instanceRedistributionType?: string;
    /**
    * The maximum number of instances that can be created above the specified targetSize during the update process. Conflicts with max_surge_percent. It has to be either 0 or at least equal to the number of zones. If fixed values are used, at least one of max_unavailable_fixed or max_surge_fixed must be greater than 0.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_instance_group_manager#max_surge_fixed GoogleComputeRegionInstanceGroupManager#max_surge_fixed}
    */
    readonly maxSurgeFixed?: number;
    /**
    * The maximum number of instances(calculated as percentage) that can be created above the specified targetSize during the update process. Conflicts with max_surge_fixed. Percent value is only allowed for regional managed instance groups with size at least 10.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_instance_group_manager#max_surge_percent GoogleComputeRegionInstanceGroupManager#max_surge_percent}
    */
    readonly maxSurgePercent?: number;
    /**
    * The maximum number of instances that can be unavailable during the update process. Conflicts with max_unavailable_percent. It has to be either 0 or at least equal to the number of zones. If fixed values are used, at least one of max_unavailable_fixed or max_surge_fixed must be greater than 0.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_instance_group_manager#max_unavailable_fixed GoogleComputeRegionInstanceGroupManager#max_unavailable_fixed}
    */
    readonly maxUnavailableFixed?: number;
    /**
    * The maximum number of instances(calculated as percentage) that can be unavailable during the update process. Conflicts with max_unavailable_fixed. Percent value is only allowed for regional managed instance groups with size at least 10.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_instance_group_manager#max_unavailable_percent GoogleComputeRegionInstanceGroupManager#max_unavailable_percent}
    */
    readonly maxUnavailablePercent?: number;
    /**
    * Minimum number of seconds to wait for after a newly created instance becomes available. This value must be from range [0, 3600].
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_instance_group_manager#min_ready_sec GoogleComputeRegionInstanceGroupManager#min_ready_sec}
    */
    readonly minReadySec?: number;
    /**
    * Minimal action to be taken on an instance. You can specify either REFRESH to update without stopping instances, RESTART to restart existing instances or REPLACE to delete and create new instances from the target template. If you specify a REFRESH, the Updater will attempt to perform that action only. However, if the Updater determines that the minimal action you specify is not enough to perform the update, it might perform a more disruptive action.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_instance_group_manager#minimal_action GoogleComputeRegionInstanceGroupManager#minimal_action}
    */
    readonly minimalAction: string;
    /**
    * Most disruptive action that is allowed to be taken on an instance. You can specify either NONE to forbid any actions, REFRESH to allow actions that do not need instance restart, RESTART to allow actions that can be applied without instance replacing or REPLACE to allow all possible actions. If the Updater determines that the minimal update action needed is more disruptive than most disruptive allowed action you specify it will not perform the update at all.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_instance_group_manager#most_disruptive_allowed_action GoogleComputeRegionInstanceGroupManager#most_disruptive_allowed_action}
    */
    readonly mostDisruptiveAllowedAction?: string;
    /**
    * The instance replacement method for regional managed instance groups. Valid values are: "RECREATE", "SUBSTITUTE". If SUBSTITUTE (default), the group replaces VM instances with new instances that have randomly generated names. If RECREATE, instance names are preserved.  You must also set max_unavailable_fixed or max_unavailable_percent to be greater than 0.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_instance_group_manager#replacement_method GoogleComputeRegionInstanceGroupManager#replacement_method}
    */
    readonly replacementMethod?: string;
    /**
    * The type of update process. You can specify either PROACTIVE so that the instance group manager proactively executes actions in order to bring instances to their target versions or OPPORTUNISTIC so that no action is proactively executed but the update will be performed as part of other actions (for example, resizes or recreateInstances calls).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_instance_group_manager#type GoogleComputeRegionInstanceGroupManager#type}
    */
    readonly type: string;
}
export declare function googleComputeRegionInstanceGroupManagerUpdatePolicyToTerraform(struct?: GoogleComputeRegionInstanceGroupManagerUpdatePolicyOutputReference | GoogleComputeRegionInstanceGroupManagerUpdatePolicy): any;
export declare class GoogleComputeRegionInstanceGroupManagerUpdatePolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeRegionInstanceGroupManagerUpdatePolicy | undefined;
    set internalValue(value: GoogleComputeRegionInstanceGroupManagerUpdatePolicy | undefined);
    private _instanceRedistributionType?;
    get instanceRedistributionType(): string;
    set instanceRedistributionType(value: string);
    resetInstanceRedistributionType(): void;
    get instanceRedistributionTypeInput(): string | undefined;
    private _maxSurgeFixed?;
    get maxSurgeFixed(): number;
    set maxSurgeFixed(value: number);
    resetMaxSurgeFixed(): void;
    get maxSurgeFixedInput(): number | undefined;
    private _maxSurgePercent?;
    get maxSurgePercent(): number;
    set maxSurgePercent(value: number);
    resetMaxSurgePercent(): void;
    get maxSurgePercentInput(): number | undefined;
    private _maxUnavailableFixed?;
    get maxUnavailableFixed(): number;
    set maxUnavailableFixed(value: number);
    resetMaxUnavailableFixed(): void;
    get maxUnavailableFixedInput(): number | undefined;
    private _maxUnavailablePercent?;
    get maxUnavailablePercent(): number;
    set maxUnavailablePercent(value: number);
    resetMaxUnavailablePercent(): void;
    get maxUnavailablePercentInput(): number | undefined;
    private _minReadySec?;
    get minReadySec(): number;
    set minReadySec(value: number);
    resetMinReadySec(): void;
    get minReadySecInput(): number | undefined;
    private _minimalAction?;
    get minimalAction(): string;
    set minimalAction(value: string);
    get minimalActionInput(): string | undefined;
    private _mostDisruptiveAllowedAction?;
    get mostDisruptiveAllowedAction(): string;
    set mostDisruptiveAllowedAction(value: string);
    resetMostDisruptiveAllowedAction(): void;
    get mostDisruptiveAllowedActionInput(): string | undefined;
    private _replacementMethod?;
    get replacementMethod(): string;
    set replacementMethod(value: string);
    resetReplacementMethod(): void;
    get replacementMethodInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export interface GoogleComputeRegionInstanceGroupManagerVersionTargetSize {
    /**
    * The number of instances which are managed for this version. Conflicts with percent.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_instance_group_manager#fixed GoogleComputeRegionInstanceGroupManager#fixed}
    */
    readonly fixed?: number;
    /**
    * The number of instances (calculated as percentage) which are managed for this version. Conflicts with fixed. Note that when using percent, rounding will be in favor of explicitly set target_size values; a managed instance group with 2 instances and 2 versions, one of which has a target_size.percent of 60 will create 2 instances of that version.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_instance_group_manager#percent GoogleComputeRegionInstanceGroupManager#percent}
    */
    readonly percent?: number;
}
export declare function googleComputeRegionInstanceGroupManagerVersionTargetSizeToTerraform(struct?: GoogleComputeRegionInstanceGroupManagerVersionTargetSizeOutputReference | GoogleComputeRegionInstanceGroupManagerVersionTargetSize): any;
export declare class GoogleComputeRegionInstanceGroupManagerVersionTargetSizeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeRegionInstanceGroupManagerVersionTargetSize | undefined;
    set internalValue(value: GoogleComputeRegionInstanceGroupManagerVersionTargetSize | undefined);
    private _fixed?;
    get fixed(): number;
    set fixed(value: number);
    resetFixed(): void;
    get fixedInput(): number | undefined;
    private _percent?;
    get percent(): number;
    set percent(value: number);
    resetPercent(): void;
    get percentInput(): number | undefined;
}
export interface GoogleComputeRegionInstanceGroupManagerVersion {
    /**
    * The full URL to an instance template from which all new instances of this version will be created.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_instance_group_manager#instance_template GoogleComputeRegionInstanceGroupManager#instance_template}
    */
    readonly instanceTemplate: string;
    /**
    * Version name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_instance_group_manager#name GoogleComputeRegionInstanceGroupManager#name}
    */
    readonly name?: string;
    /**
    * target_size block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_instance_group_manager#target_size GoogleComputeRegionInstanceGroupManager#target_size}
    */
    readonly targetSize?: GoogleComputeRegionInstanceGroupManagerVersionTargetSize;
}
export declare function googleComputeRegionInstanceGroupManagerVersionToTerraform(struct?: GoogleComputeRegionInstanceGroupManagerVersion | cdktf.IResolvable): any;
export declare class GoogleComputeRegionInstanceGroupManagerVersionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleComputeRegionInstanceGroupManagerVersion | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleComputeRegionInstanceGroupManagerVersion | cdktf.IResolvable | undefined);
    private _instanceTemplate?;
    get instanceTemplate(): string;
    set instanceTemplate(value: string);
    get instanceTemplateInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _targetSize;
    get targetSize(): GoogleComputeRegionInstanceGroupManagerVersionTargetSizeOutputReference;
    putTargetSize(value: GoogleComputeRegionInstanceGroupManagerVersionTargetSize): void;
    resetTargetSize(): void;
    get targetSizeInput(): GoogleComputeRegionInstanceGroupManagerVersionTargetSize | undefined;
}
export declare class GoogleComputeRegionInstanceGroupManagerVersionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleComputeRegionInstanceGroupManagerVersion[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleComputeRegionInstanceGroupManagerVersionOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_instance_group_manager google_compute_region_instance_group_manager}
*/
export declare class GoogleComputeRegionInstanceGroupManager extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_compute_region_instance_group_manager";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_instance_group_manager google_compute_region_instance_group_manager} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleComputeRegionInstanceGroupManagerConfig
    */
    constructor(scope: Construct, id: string, config: GoogleComputeRegionInstanceGroupManagerConfig);
    private _baseInstanceName?;
    get baseInstanceName(): string;
    set baseInstanceName(value: string);
    get baseInstanceNameInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _distributionPolicyTargetShape?;
    get distributionPolicyTargetShape(): string;
    set distributionPolicyTargetShape(value: string);
    resetDistributionPolicyTargetShape(): void;
    get distributionPolicyTargetShapeInput(): string | undefined;
    private _distributionPolicyZones?;
    get distributionPolicyZones(): string[];
    set distributionPolicyZones(value: string[]);
    resetDistributionPolicyZones(): void;
    get distributionPolicyZonesInput(): string[] | undefined;
    get fingerprint(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get instanceGroup(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    get selfLink(): string;
    private _status;
    get status(): GoogleComputeRegionInstanceGroupManagerStatusList;
    private _targetPools?;
    get targetPools(): string[];
    set targetPools(value: string[]);
    resetTargetPools(): void;
    get targetPoolsInput(): string[] | undefined;
    private _targetSize?;
    get targetSize(): number;
    set targetSize(value: number);
    resetTargetSize(): void;
    get targetSizeInput(): number | undefined;
    private _waitForInstances?;
    get waitForInstances(): boolean | cdktf.IResolvable;
    set waitForInstances(value: boolean | cdktf.IResolvable);
    resetWaitForInstances(): void;
    get waitForInstancesInput(): boolean | cdktf.IResolvable | undefined;
    private _waitForInstancesStatus?;
    get waitForInstancesStatus(): string;
    set waitForInstancesStatus(value: string);
    resetWaitForInstancesStatus(): void;
    get waitForInstancesStatusInput(): string | undefined;
    private _allInstancesConfig;
    get allInstancesConfig(): GoogleComputeRegionInstanceGroupManagerAllInstancesConfigOutputReference;
    putAllInstancesConfig(value: GoogleComputeRegionInstanceGroupManagerAllInstancesConfig): void;
    resetAllInstancesConfig(): void;
    get allInstancesConfigInput(): GoogleComputeRegionInstanceGroupManagerAllInstancesConfig | undefined;
    private _autoHealingPolicies;
    get autoHealingPolicies(): GoogleComputeRegionInstanceGroupManagerAutoHealingPoliciesOutputReference;
    putAutoHealingPolicies(value: GoogleComputeRegionInstanceGroupManagerAutoHealingPolicies): void;
    resetAutoHealingPolicies(): void;
    get autoHealingPoliciesInput(): GoogleComputeRegionInstanceGroupManagerAutoHealingPolicies | undefined;
    private _namedPort;
    get namedPort(): GoogleComputeRegionInstanceGroupManagerNamedPortList;
    putNamedPort(value: GoogleComputeRegionInstanceGroupManagerNamedPort[] | cdktf.IResolvable): void;
    resetNamedPort(): void;
    get namedPortInput(): cdktf.IResolvable | GoogleComputeRegionInstanceGroupManagerNamedPort[] | undefined;
    private _statefulDisk;
    get statefulDisk(): GoogleComputeRegionInstanceGroupManagerStatefulDiskList;
    putStatefulDisk(value: GoogleComputeRegionInstanceGroupManagerStatefulDisk[] | cdktf.IResolvable): void;
    resetStatefulDisk(): void;
    get statefulDiskInput(): cdktf.IResolvable | GoogleComputeRegionInstanceGroupManagerStatefulDisk[] | undefined;
    private _timeouts;
    get timeouts(): GoogleComputeRegionInstanceGroupManagerTimeoutsOutputReference;
    putTimeouts(value: GoogleComputeRegionInstanceGroupManagerTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleComputeRegionInstanceGroupManagerTimeouts | undefined;
    private _updatePolicy;
    get updatePolicy(): GoogleComputeRegionInstanceGroupManagerUpdatePolicyOutputReference;
    putUpdatePolicy(value: GoogleComputeRegionInstanceGroupManagerUpdatePolicy): void;
    resetUpdatePolicy(): void;
    get updatePolicyInput(): GoogleComputeRegionInstanceGroupManagerUpdatePolicy | undefined;
    private _version;
    get version(): GoogleComputeRegionInstanceGroupManagerVersionList;
    putVersion(value: GoogleComputeRegionInstanceGroupManagerVersion[] | cdktf.IResolvable): void;
    get versionInput(): cdktf.IResolvable | GoogleComputeRegionInstanceGroupManagerVersion[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
