import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleComputeRegionTargetHttpProxyConfig extends cdktf.TerraformMetaArguments {
    /**
    * An optional description of this resource.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_target_http_proxy#description GoogleComputeRegionTargetHttpProxy#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_target_http_proxy#id GoogleComputeRegionTargetHttpProxy#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Name of the resource. Provided by the client when the resource is
  created. The name must be 1-63 characters long, and comply with
  RFC1035. Specifically, the name must be 1-63 characters long and match
  the regular expression '[a-z]([-a-z0-9]*[a-z0-9])?' which means the
  first character must be a lowercase letter, and all following
  characters must be a dash, lowercase letter, or digit, except the last
  character, which cannot be a dash.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_target_http_proxy#name GoogleComputeRegionTargetHttpProxy#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_target_http_proxy#project GoogleComputeRegionTargetHttpProxy#project}
    */
    readonly project?: string;
    /**
    * The Region in which the created target https proxy should reside.
  If it is not provided, the provider region is used.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_target_http_proxy#region GoogleComputeRegionTargetHttpProxy#region}
    */
    readonly region?: string;
    /**
    * A reference to the RegionUrlMap resource that defines the mapping from URL
  to the BackendService.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_target_http_proxy#url_map GoogleComputeRegionTargetHttpProxy#url_map}
    */
    readonly urlMap: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_target_http_proxy#timeouts GoogleComputeRegionTargetHttpProxy#timeouts}
    */
    readonly timeouts?: GoogleComputeRegionTargetHttpProxyTimeouts;
}
export interface GoogleComputeRegionTargetHttpProxyTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_target_http_proxy#create GoogleComputeRegionTargetHttpProxy#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_target_http_proxy#delete GoogleComputeRegionTargetHttpProxy#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_target_http_proxy#update GoogleComputeRegionTargetHttpProxy#update}
    */
    readonly update?: string;
}
export declare function googleComputeRegionTargetHttpProxyTimeoutsToTerraform(struct?: GoogleComputeRegionTargetHttpProxyTimeoutsOutputReference | GoogleComputeRegionTargetHttpProxyTimeouts | cdktf.IResolvable): any;
export declare class GoogleComputeRegionTargetHttpProxyTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleComputeRegionTargetHttpProxyTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleComputeRegionTargetHttpProxyTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_target_http_proxy google_compute_region_target_http_proxy}
*/
export declare class GoogleComputeRegionTargetHttpProxy extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_compute_region_target_http_proxy";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google-beta/r/google_compute_region_target_http_proxy google_compute_region_target_http_proxy} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleComputeRegionTargetHttpProxyConfig
    */
    constructor(scope: Construct, id: string, config: GoogleComputeRegionTargetHttpProxyConfig);
    get creationTimestamp(): string;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    get proxyId(): number;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    get selfLink(): string;
    private _urlMap?;
    get urlMap(): string;
    set urlMap(value: string);
    get urlMapInput(): string | undefined;
    private _timeouts;
    get timeouts(): GoogleComputeRegionTargetHttpProxyTimeoutsOutputReference;
    putTimeouts(value: GoogleComputeRegionTargetHttpProxyTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleComputeRegionTargetHttpProxyTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
